// Standard Priority Calculator

var jqcalculator_display1 = {
    operation: "",
    evaluation: "",
    answer: ""
};

// default flag values
var flag = {
    ansAllowed: false, // Initially do not allow the use of Ans button
    /*
    decimalPointAllowed: true,
    pctAllowed: false,
    ansAllowed: false,
    digitAllowed: true
    */
};

// default display values
$('#jqcalculator_jqcalculator_display1').val("");
$('#jqcalculator_display2').val("");

// Set default theme (light)
$(".container").addClass("container-light");
$("form").addClass("form-light");
$("form input").addClass("form-input-light");
$(".operand-group").addClass("operand-group-light");
$(".operator-group").addClass("operator-group-light");
$("#jqcalculator_equal").addClass("equal-light");
$("#jqcalculator_require").addClass("require-light");
$("#jqcalculator_clear").addClass("clear-light");
$("#jqcalculator_backspace").addClass("backspace-light");

/*
try {
    myroutine(); // may throw three types of exceptions
} catch (e) {
    if (e instanceof TypeError) {
        // statements to handle TypeError exceptions
    } else if (e instanceof RangeError) {
        // statements to handle RangeError exceptions
    } else if (e instanceof EvalError) {
        // statements to handle EvalError exceptions
    } else {
       // statements to handle any unspecified exceptions
       logMyErrors(e); // pass exception object to error handler
    }
}
function isValidJSON(text) {
    try {
        JSON.parse(text);
        return true;
    } catch {
        return false;
    }
}
*/
function evaluate() {
    try {
        math.eval(jqcalculator_display1.operation);
        jqcalculator_display1.evaluation = math.eval(jqcalculator_display1.operation);
        return true; // no exception occured
    } catch (e) {
        if (e instanceof SyntaxError) { // Syntax error exception
            jqcalculator_display1.evaluation = "E";
            return false; // exception occured
        }
        else {// Unspecified exceptions
            jqcalculator_display1.evaluation = "UE";
            return false; // exception occured
        }
    }
}

// Digits
$('#jqcalculator_zero').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "0";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0030');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_one').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "1";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0031');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_two').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "2";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0032');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_three').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "3";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0033');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_four').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "4";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0034');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_five').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "5";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0035');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_six').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "6";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0036');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_seven').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "7";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0037');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_eight').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "8";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0038');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_nine').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "9";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0039');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})
              
$('#jqcalculator_decimal').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + ".";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u002e');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

// Operators
$('#jqcalculator_left-parenthesis').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "(";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0028');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_right-parenthesis').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + ")";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0029');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_add').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "+";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u002b');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_subtract').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "-";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u2212');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_multiply').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "*";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u00d7');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_divide').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "/";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u00f7');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_square-root').on('click', function () {
    
    var count = 0;
    var index = -1;
    var radicand = "";
    var result = "";
    
    // radicand is a complex expression
    if (jqcalculator_display1.operation.endsWith(')')) 
    {
        // Find the position of matching parenthesis
        // For example if operation="2+(3-(3+4))", then the index of the 
        // matching '(' would be 2 and the radicand would be (3-(3+4))
        for (i = jqcalculator_display1.operation.length - 2; i > -1; i--) 
        {
            if (jqcalculator_display1.operation.charAt(i) === '(') 
            {
                if (count === 0) 
                {
                    index = i;
                    break;
                } 
                else 
                {
                    count -= 1;
                    continue;
                }
            } 
            else if (jqcalculator_display1.operation.charAt(i) === ')') 
            {
                count += 1;
            } 
            else 
            {
                continue;
            }
        }
        if (index === -1) 
        {
            //alert("Malformed expression");
            $('#jqcalculator_display2').val("Malformed expression");
            return;
        }
    } 
    // radicand is a single number
    else if (jqcalculator_display1.operation.endsWith('0') || jqcalculator_display1.operation.endsWith('1') || 
               jqcalculator_display1.operation.endsWith('2') || jqcalculator_display1.operation.endsWith('3') || 
               jqcalculator_display1.operation.endsWith('4') || jqcalculator_display1.operation.endsWith('5') ||
               jqcalculator_display1.operation.endsWith('6') || jqcalculator_display1.operation.endsWith('7') || 
               jqcalculator_display1.operation.endsWith('8') || jqcalculator_display1.operation.endsWith('9') ||
               jqcalculator_display1.operation.endsWith('.'))
    {
        index = jqcalculator_display1.operation.length - 1;
        for (i = jqcalculator_display1.operation.length - 2; i > -1; i--) 
        {
            if (jqcalculator_display1.operation.charAt(i) === '0' || jqcalculator_display1.operation.charAt(i) === '1' ||
                jqcalculator_display1.operation.charAt(i) === '2' || jqcalculator_display1.operation.charAt(i) === '3' ||
                jqcalculator_display1.operation.charAt(i) === '4' || jqcalculator_display1.operation.charAt(i) === '5' ||
                jqcalculator_display1.operation.charAt(i) === '6' || jqcalculator_display1.operation.charAt(i) === '7' ||
                jqcalculator_display1.operation.charAt(i) === '8' || jqcalculator_display1.operation.charAt(i) === '9' ||
                jqcalculator_display1.operation.charAt(i) === '.' || jqcalculator_display1.operation.charAt(i) === '^')
            {
                index = i;
            }
            else 
            {
                break;
            }
        }
    }
    else 
    {
        return;
    }
    
    // Get the radicand
    radicand = jqcalculator_display1.operation.substring(index, jqcalculator_display1.operation.length);
    
    // Update operation with sqrt(radicand)
    jqcalculator_display1.operation = jqcalculator_display1.operation.substring(0, index) + "sqrt(" + radicand + ")";
    
    // Replace '^2' with superscript two (don't forget to escape '^' with '\')
    radicand = radicand.replace(/\^2/g, "\u00b2");
    
    // Find the last occurence of radicand
    index = $('#jqcalculator_display1').val().lastIndexOf(radicand);
    
    radicand = $('#jqcalculator_display1').val().substring(index, $('#jqcalculator_display1').val().length);
    
    // Update #jqcalculator_display1
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val().substring(0, index) + '\u221a' + radicand);
    
    // Evaluate
    evaluate();
    
    // Display current evaluation
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
});
        
$('#jqcalculator_square').on('click', function () {
    jqcalculator_display1.operation = jqcalculator_display1.operation + "^2";
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u00b2');
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_percentage').on('click', function () {
    /*
    // Only one % is allowed for the entire operation.
    // The last % indicates the end of the entire operation and triggers the equal button.
    if (jqcalculator_display1.numOfPct < 1 && flag.pctAllowed) {
        //Num
        if (jqcalculator_display1.numOfOperands === 0) {
            jqcalculator_display1.operand = eval(jqcalculator_display1.operand + "/" + "100").toString();
            $('#jqcalculator_display1').val(jqcalculator_display1.operand);
            $('#jqcalculator_display2').val(jqcalculator_display1.operand);
        }
        else {
            $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + '\u0025');
            jqcalculator_display1.numOfPct ++;
            switch (jqcalculator_display1.operator) {
                // a*b%
                case "*":
                    // a*b/100
                    jqcalculator_display1.operand = eval(jqcalculator_display1.evaluation + "*" + jqcalculator_display1.operand + "/" + "100").toString();
                    jqcalculator_display1.operation = "1";
                    // result = 1 * (a*b/100)
                    $('#jqcalculator_display2').val(eval(jqcalculator_display1.operation + jqcalculator_display1.operator + jqcalculator_display1.operand).toString());
                    if (jqcalculator_display1.numOfOperands)
                    break;

                // a/b%
                case "/":
                    // a/b*100
                    jqcalculator_display1.operand = eval(jqcalculator_display1.evaluation + "/" + jqcalculator_display1.operand + "*" + "100").toString();
                    jqcalculator_display1.operation = "1";
                    jqcalculator_display1.operator = "*";
                    // result = 1 * (a/b*100)
                    $('#jqcalculator_display2').val(eval(jqcalculator_display1.operation + jqcalculator_display1.operator + jqcalculator_display1.operand).toString());
                    break;

                // a+b%, a-b%
                default:
                    // a*b/100
                    jqcalculator_display1.operand = eval(jqcalculator_display1.evaluation + "*" + jqcalculator_display1.operand + "/" + "100").toString();
                    // result = a + (a*b/100), result = a - (a*b/100)
                    $('#jqcalculator_display2').val(eval(jqcalculator_display1.operation + jqcalculator_display1.operator + jqcalculator_display1.operand).toString());
                    break;
            }
            // Execute the handler attached to the $("#jqcalculator_equal") element for the 'click' event type.
            $("#jqcalculator_equal").trigger("click");
        }
    }
    */
})

// Clear
$('#jqcalculator_clear').on('click', function () {
    jqcalculator_display1.operation = "",
    jqcalculator_display1.evaluation = "",
    $('#jqcalculator_display1').val("");
    $('#jqcalculator_display2').val("");
})

// Equal
$('#jqcalculator_equal').on('click', function () {
    jqcalculator_display1.answer = jqcalculator_display1.evaluation; // Store the answer (Ans button)
    $('#jqcalculator_display1').val(jqcalculator_display1.answer); // Update jqcalculator_display1
    $('#jqcalculator_display2').val(""); // Update jqcalculator_display2
    jqcalculator_display1.operation = jqcalculator_display1.answer; // Current operation equals the answer
    flag.ansAllowed = true; // Allow the use of Ans button
})

$('#jqcalculator_ans').on('click', function () {    
    
    // Allow 'Ans' when its flag is enabled
    if (flag.ansAllowed) {
        if (flag.squareRoot) {
            jqcalculator_display1.operation = jqcalculator_display1.operation.substring(0, jqcalculator_display1.operation.length-1) + jqcalculator_display1.answer + ")";
        }
        else {
            jqcalculator_display1.operation = jqcalculator_display1.operation + jqcalculator_display1.answer;
        }
        $('#jqcalculator_display1').val($('#jqcalculator_display1').val() + 'Ans');
        evaluate();
        $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
    }
})

// Backspace
$('#jqcalculator_backspace').on('click', function () {    
    jqcalculator_display1.operation = jqcalculator_display1.operation.slice(0, jqcalculator_display1.operation.length-1);
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val().slice(0, $('#jqcalculator_display1').val().length-1));
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

$('#jqcalculator_backspace2').on('click', function () {    
    jqcalculator_display1.operation = jqcalculator_display1.operation.slice(0, jqcalculator_display1.operation.length-1);
    $('#jqcalculator_display1').val($('#jqcalculator_display1').val().slice(0, $('#jqcalculator_display1').val().length-1));
    evaluate();
    $('#jqcalculator_display2').val(jqcalculator_display1.evaluation);
})

// Theme system
$("input[type='checkbox']").change(function () {
    // dark theme
    if (this.checked) {
        //alert("dark");
        $(".container").removeClass("container-light");
        $(".container").addClass("container-dark");
        $("form").removeClass("form-light");
        $("form").addClass("form-dark");
        $("form input").removeClass("form-input-light");
        $("form input").addClass("form-input-dark");
        $(".operand-group").removeClass("operand-group-light");
        $(".operand-group").addClass("operand-group-dark");
        $(".operator-group").removeClass("operator-group-light");
        $(".operator-group").addClass("operator-group-dark");
        $("#jqcalculator_equal").removeClass("equal-light");
        $("#jqcalculator_equal").addClass("equal-dark");

        $("#jqcalculator_require").removeClass("require-light");
        $("#jqcalculator_require").addClass("require-dark");

        $("#jqcalculator_clear").removeClass("clear-light");
        $("#jqcalculator_clear").addClass("clear-dark");
        $("#jqcalculator_backspace").removeClass("backspace-light");
        $("#jqcalculator_backspace").addClass("backspace-dark");
    }
    // light theme (default)
    else {
        //alert("light");
        $(".container").removeClass("container-dark");
        $(".container").addClass("container-light");
        $("form").removeClass("form-dark");
        $("form").addClass("form-light");
        $("form input").removeClass("form-input-dark");
        $("form input").addClass("form-input-light");
        $(".operand-group").removeClass("operand-group-dark");
        $(".operand-group").addClass("operand-group-light");
        $(".operator-group").removeClass("operator-group-dark");
        $(".operator-group").addClass("operator-group-light");
        $("#jqcalculator_equal").removeClass("equal-dark");
        $("#jqcalculator_equal").addClass("equal-light");

        $("#jqcalculator_require").removeClass("require-dark");
        $("#jqcalculator_require").addClass("require-light");

        $("#jqcalculator_clear").removeClass("clear-dark");
        $("#jqcalculator_clear").addClass("clear-light");
        $("#jqcalculator_backspace").removeClass("backspace-dark");
        $("#jqcalculator_backspace").addClass("backspace-light");
    }
})