/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.MultiOrganizeImportAction;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.MultiElementListSelectionDialog;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class OrganizeImportsAction
extends SelectionDispatchAction {
    private static final OrganizeImportComparator ORGANIZE_IMPORT_COMPARATOR = new OrganizeImportComparator();
    private JavaEditor fEditor;
    private boolean fIsQueryShowing = false;
    private final MultiOrganizeImportAction fCleanUpDelegate;

    public OrganizeImportsAction(IWorkbenchSite site) {
        super(site);
        this.fCleanUpDelegate = new MultiOrganizeImportAction(site);
        this.setText(ActionMessages.OrganizeImportsAction_label);
        this.setToolTipText(ActionMessages.OrganizeImportsAction_tooltip);
        this.setDescription(ActionMessages.OrganizeImportsAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.organize_imports_action_context");
    }

    public OrganizeImportsAction(JavaEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.fCleanUpDelegate = new MultiOrganizeImportAction(editor);
        this.setText(ActionMessages.OrganizeImportsAction_label);
        this.setToolTipText(ActionMessages.OrganizeImportsAction_tooltip);
        this.setDescription(ActionMessages.OrganizeImportsAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.organize_imports_action_context");
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.fCleanUpDelegate.selectionChanged(selection);
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.fCleanUpDelegate.selectionChanged(selection);
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    @Override
    public void run(ITextSelection selection) {
        ICompilationUnit cu = OrganizeImportsAction.getCompilationUnit(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        IJavaElement element = JavaUI.getEditorInputJavaElement(editor.getEditorInput());
        if (!(element instanceof ICompilationUnit)) {
            return null;
        }
        return (ICompilationUnit)element;
    }

    @Override
    public void run(IStructuredSelection selection) {
        ICompilationUnit[] cus = this.fCleanUpDelegate.getCompilationUnits(selection);
        if (cus.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_EmptySelection_title, (String)ActionMessages.OrganizeImportsAction_EmptySelection_description);
        } else if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.fCleanUpDelegate.run(selection);
        }
    }

    public void runOnMultiple(ICompilationUnit[] cus) {
        if (cus.length == 0) {
            return;
        }
        this.fCleanUpDelegate.run((IStructuredSelection)new StructuredSelection((Object[])cus));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(ICompilationUnit cu) {
        JavaEditor editor = null;
        if (this.fEditor != null) {
            editor = this.fEditor;
            if (!ElementValidator.check((IJavaElement)cu, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, true)) {
                return;
            }
        } else {
            IEditorPart openEditor = EditorUtility.isOpenInEditor(cu);
            if (!(openEditor instanceof JavaEditor)) {
                this.fCleanUpDelegate.run((IStructuredSelection)new StructuredSelection((Object)cu));
                return;
            }
            editor = (JavaEditor)openEditor;
            if (!ElementValidator.check((IJavaElement)cu, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, false)) {
                return;
            }
        }
        Assert.isNotNull((Object)editor);
        if (!ActionUtil.isEditable(editor, this.getShell(), (IJavaElement)cu)) {
            return;
        }
        CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)cu, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaProject());
        OrganizeImportsOperation op = new OrganizeImportsOperation(cu, astRoot, settings.importIgnoreLowercase, !cu.isWorkingCopy(), true, this.createChooseImportQuery(editor));
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        IWorkbenchWindow context = this.getSite().getWorkbenchWindow();
        if (context == null) {
            context = progressService;
        }
        IEditingSupport helper = this.createViewerHelper();
        try {
            try {
                this.registerHelper(helper, editor);
                progressService.runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                IProblem parseError = op.getParseError();
                if (parseError != null) {
                    String message = Messages.format(ActionMessages.OrganizeImportsAction_single_error_parse, parseError.getMessage());
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_error_title, (String)message);
                    if (parseError.getSourceStart() == -1) return;
                    editor.selectAndReveal(parseError.getSourceStart(), parseError.getSourceEnd() - parseError.getSourceStart() + 1);
                    return;
                } else {
                    this.setStatusBarMessage(this.getOrganizeInfo(op), editor);
                }
                return;
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, ActionMessages.OrganizeImportsAction_error_message);
                this.deregisterHelper(helper, editor);
                if (target == null) return;
                target.endCompoundChange();
                return;
            }
            catch (InterruptedException interruptedException) {
                this.deregisterHelper(helper, editor);
                if (target == null) return;
                target.endCompoundChange();
                return;
            }
        }
        finally {
            this.deregisterHelper(helper, editor);
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    private String getOrganizeInfo(OrganizeImportsOperation op) {
        int nImportsAdded = op.getNumberOfImportsAdded();
        if (nImportsAdded >= 0) {
            if (nImportsAdded == 1) {
                return ActionMessages.OrganizeImportsAction_summary_added_singular;
            }
            return Messages.format(ActionMessages.OrganizeImportsAction_summary_added_plural, String.valueOf(nImportsAdded));
        }
        if (nImportsAdded == -1) {
            return ActionMessages.OrganizeImportsAction_summary_removed_singular;
        }
        return Messages.format(ActionMessages.OrganizeImportsAction_summary_removed_plural, String.valueOf(-nImportsAdded));
    }

    private OrganizeImportsOperation.IChooseImportQuery createChooseImportQuery(final JavaEditor editor) {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            @Override
            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                return OrganizeImportsAction.this.doChooseImports(openChoices, ranges, editor);
            }
        };
    }

    private TypeNameMatch[] doChooseImports(TypeNameMatch[][] openChoices, final ISourceRange[] ranges, final JavaEditor editor) {
        ISelection sel = editor.getSelectionProvider().getSelection();
        TypeNameMatch[] result = null;
        TypeNameMatchLabelProvider labelProvider = new TypeNameMatchLabelProvider(1);
        MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                OrganizeImportsAction.this.doListSelectionChanged(this.getCurrentPage(), ranges, editor);
            }
        };
        this.fIsQueryShowing = true;
        dialog.setTitle(ActionMessages.OrganizeImportsAction_selectiondialog_title);
        dialog.setMessage(ActionMessages.OrganizeImportsAction_selectiondialog_message);
        dialog.setElements(openChoices);
        dialog.setComparator(ORGANIZE_IMPORT_COMPARATOR);
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            result = new TypeNameMatch[res.length];
            int i = 0;
            while (i < res.length) {
                Object[] array = (Object[])res[i];
                if (array.length > 0) {
                    result[i] = (TypeNameMatch)array[0];
                    QualifiedTypeNameHistory.remember(result[i].getFullyQualifiedName());
                }
                ++i;
            }
        }
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            editor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
        this.fIsQueryShowing = false;
        return result;
    }

    private void doListSelectionChanged(int page, ISourceRange[] ranges, JavaEditor editor) {
        if (ranges != null && page >= 0 && page < ranges.length) {
            ISourceRange range = ranges[page];
            editor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    private void setStatusBarMessage(String message, JavaEditor editor) {
        IStatusLineManager manager = editor.getEditorSite().getActionBars().getStatusLineManager();
        manager.setMessage(message);
    }

    private IEditingSupport createViewerHelper() {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
                return true;
            }

            public boolean ownsFocusShell() {
                return OrganizeImportsAction.this.fIsQueryShowing;
            }
        };
    }

    private void registerHelper(IEditingSupport helper, JavaEditor editor) {
        ISourceViewer viewer = editor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.register(helper);
        }
    }

    private void deregisterHelper(IEditingSupport helper, JavaEditor editor) {
        ISourceViewer viewer = editor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister(helper);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private OrganizeImportsAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new OrganizeImportsAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }

    private static final class OrganizeImportComparator
    implements Comparator<String> {
        private OrganizeImportComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int pos2;
            if (o1.equals(o2)) {
                return 0;
            }
            QualifiedTypeNameHistory history = QualifiedTypeNameHistory.getDefault();
            int pos1 = history.getPosition(o1);
            if (pos1 == (pos2 = history.getPosition(o2))) {
                return Collator.getInstance().compare(o1, o2);
            }
            if (pos1 > pos2) {
                return -1;
            }
            return 1;
        }
    }
}

