/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

abstract class GenerateMethodAbstractAction
extends SelectionDispatchAction {
    CompilationUnitEditor fEditor;
    CompilationUnit fUnit;
    ITypeBinding fTypeBinding;

    protected GenerateMethodAbstractAction(IWorkbenchSite site) {
        super(site);
    }

    static RefactoringStatusContext createRefactoringStatusContext(IJavaElement element) {
        if (element instanceof IMember) {
            return JavaStatusContext.create((IMember)element);
        }
        if (element instanceof ISourceReference) {
            IOpenable openable = element.getOpenable();
            try {
                if (openable instanceof ICompilationUnit) {
                    return JavaStatusContext.create((ITypeRoot)((ICompilationUnit)openable), ((ISourceReference)element).getSourceRange());
                }
                if (openable instanceof IClassFile) {
                    return JavaStatusContext.create((ITypeRoot)((IClassFile)openable), ((ISourceReference)element).getSourceRange());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IType) {
                IType type = (IType)element;
                return type.getCompilationUnit() != null && type.isClass();
            }
            if (element instanceof ICompilationUnit) {
                return true;
            }
        }
        return false;
    }

    IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        ICompilationUnit unit;
        IType type;
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type2 = (IType)selection.getFirstElement();
            if (type2.getCompilationUnit() != null && type2.isClass()) {
                return type2;
            }
        } else if (selection.getFirstElement() instanceof ICompilationUnit && (type = (unit = (ICompilationUnit)selection.getFirstElement()).findPrimaryType()) != null && type.isClass()) {
            return type;
        }
        return null;
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            this.checkAndRun(this.getSelectedType(selection));
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, this.getShell(), this.getErrorCaption(), ActionMessages.GenerateMethodAbstractAction_error_cannot_create);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            this.checkAndRun(SelectionConverter.getTypeAtOffset(this.fEditor));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getErrorCaption(), ActionMessages.GenerateMethodAbstractAction_error_cannot_create);
        }
    }

    void checkAndRun(IType type) throws CoreException {
        if (type == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getErrorCaption(), (String)ActionMessages.GenerateMethodAbstractAction_error_not_applicable);
            this.notifyResult(false);
        }
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), this.getErrorCaption(), false) || !ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)type)) {
            this.notifyResult(false);
            return;
        }
        if (type == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.getErrorCaption(), (String)ActionMessages.GenerateMethodAbstractAction_error_removed_type);
            this.notifyResult(false);
            return;
        }
        if (type.isAnnotation()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getErrorCaption(), (String)ActionMessages.GenerateMethodAbstractAction_annotation_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.isInterface()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getErrorCaption(), (String)ActionMessages.GenerateMethodAbstractAction_interface_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.isEnum()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getErrorCaption(), (String)ActionMessages.GenerateMethodAbstractAction_enum_not_applicable);
            this.notifyResult(false);
            return;
        }
        if (type.isAnonymous()) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.getErrorCaption(), (String)ActionMessages.GenerateMethodAbstractAction_anonymous_type_not_applicable);
            this.notifyResult(false);
            return;
        }
        this.run(this.getShell(), type);
    }

    void run(Shell shell, IType type) throws CoreException {
        int dialogResult;
        block18: {
            this.initialize(type);
            boolean regenerate = false;
            if (this.isMethodAlreadyImplemented(this.fTypeBinding) && !(regenerate = MessageDialog.openQuestion((Shell)this.getShell(), (String)this.getErrorCaption(), (String)Messages.format(ActionMessages.GenerateMethodAbstractAction_already_has_this_method_error, new String[]{BasicElementLabels.getJavaElementName(this.fTypeBinding.getQualifiedName()), this.getAlreadyImplementedErrorMethodName()})))) {
                this.notifyResult(false);
                return;
            }
            if (!this.generateCandidates()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getErrorCaption(), (String)this.getNoMembersError());
                this.notifyResult(false);
                return;
            }
            SourceActionDialog dialog = this.createDialog(shell, type);
            dialogResult = dialog.open();
            if (dialogResult == 0) {
                IRewriteTarget target;
                Dialog d;
                Object[] selected = dialog.getResult();
                if (selected == null) {
                    this.notifyResult(false);
                    return;
                }
                CodeGenerationSettings settings = this.createSettings(type, dialog);
                IWorkspaceRunnable operation = this.createOperation(selected, settings, regenerate, (IJavaElement)type, dialog.getElementPosition());
                ITypeBinding superclass = this.fTypeBinding.getSuperclass();
                RefactoringStatus status = new RefactoringStatus();
                status.merge(this.checkGeneralConditions(type, settings, selected));
                if (!"java.lang.Object".equals(superclass.getQualifiedName())) {
                    status.merge(this.checkSuperClass(superclass));
                }
                int i = 0;
                while (i < selected.length) {
                    status.merge(this.checkMember(selected[i]));
                    ++i;
                }
                if (status.hasEntries() && (d = RefactoringUI.createLightWeightStatusDialog((RefactoringStatus)status, (Shell)this.getShell(), (String)this.getErrorCaption())).open() != 0) {
                    this.notifyResult(false);
                    return;
                }
                IEditorPart editor = JavaUI.openInEditor((IJavaElement)type.getCompilationUnit());
                IRewriteTarget iRewriteTarget = target = editor != null ? (IRewriteTarget)editor.getAdapter(IRewriteTarget.class) : null;
                if (target != null) {
                    target.beginCompoundChange();
                }
                try {
                    Object context = JavaPlugin.getActiveWorkbenchWindow();
                    if (context == null) {
                        context = new BusyIndicatorRunnableContext();
                    }
                    IWorkspaceRoot schedulingRule = ResourcesPlugin.getWorkspace().getRoot();
                    PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, (ISchedulingRule)schedulingRule), (ISchedulingRule)schedulingRule);
                }
                catch (InvocationTargetException exception) {
                    ExceptionHandler.handle(exception, shell, this.getErrorCaption(), null);
                    if (target != null) {
                        target.endCompoundChange();
                    }
                    break block18;
                }
                catch (InterruptedException interruptedException) {
                    try {
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (target != null) {
                            target.endCompoundChange();
                        }
                    }
                }
                if (target == null) break block18;
                target.endCompoundChange();
            }
        }
        this.notifyResult(dialogResult == 0);
    }

    CodeGenerationSettings createSettings(IType type, SourceActionDialog dialog) {
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject());
        settings.createComments = dialog.getGenerateComment();
        return settings;
    }

    abstract String getNoMembersError();

    abstract String getErrorCaption();

    abstract IWorkspaceRunnable createOperation(Object[] var1, CodeGenerationSettings var2, boolean var3, IJavaElement var4, IJavaElement var5);

    abstract RefactoringStatus checkGeneralConditions(IType var1, CodeGenerationSettings var2, Object[] var3);

    abstract RefactoringStatus checkMember(Object var1);

    abstract RefactoringStatus checkSuperClass(ITypeBinding var1);

    abstract SourceActionDialog createDialog(Shell var1, IType var2) throws JavaModelException;

    abstract boolean generateCandidates() throws JavaModelException;

    abstract String getAlreadyImplementedErrorMethodName();

    abstract boolean isMethodAlreadyImplemented(ITypeBinding var1);

    boolean useBlocks(IJavaProject project) {
        if ("true".equals(PreferenceConstants.getPreference("cleanup.use_blocks", project))) {
            return "true".equals(PreferenceConstants.getPreference("cleanup.always_use_blocks", project)) || "true".equals(PreferenceConstants.getPreference("cleanup.use_blocks_only_for_return_and_throw", project));
        }
        return false;
    }

    void initialize(IType type) throws JavaModelException {
        RefactoringASTParser parser = new RefactoringASTParser(4);
        this.fUnit = parser.parse((ITypeRoot)type.getCompilationUnit(), true);
        this.fTypeBinding = null;
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(NodeFinder.perform((ASTNode)this.fUnit, (ISourceRange)type.getNameRange()), AbstractTypeDeclaration.class);
        if (declaration != null) {
            this.fTypeBinding = declaration.resolveBinding();
        }
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException exception) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)exception))) {
                JavaPlugin.log(exception);
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }
}

