/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyLabelProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyViewerSorter;
import org.eclipse.jdt.internal.ui.typehierarchy.SuperTypeHierarchyViewer;
import org.eclipse.jdt.internal.ui.typehierarchy.TraditionalHierarchyViewer;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public class HierarchyInformationControl
extends AbstractInformationControl {
    private TypeHierarchyLifeCycle fLifeCycle;
    private HierarchyLabelProvider fLabelProvider;
    private KeyAdapter fKeyAdapter;
    private Object[] fOtherExpandedElements = null;
    private TypeHierarchyContentProvider fOtherContentProvider;
    private IMethod fFocus;
    private boolean fDoFilter = true;
    private MethodOverrideTester fMethodOverrideTester = null;

    public HierarchyInformationControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle, "org.eclipse.jdt.ui.edit.text.java.open.hierarchy", true);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    KeySequence[] sequences = HierarchyInformationControl.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            HierarchyInformationControl.this.toggleHierarchy();
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    @Override
    protected boolean hasHeader() {
        return true;
    }

    @Override
    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IType;
            }
        });
        this.fLifeCycle = new TypeHierarchyLifeCycle(false);
        treeViewer.setComparator((ViewerComparator)new HierarchyViewerSorter(this.fLifeCycle));
        treeViewer.setAutoExpandLevel(-1);
        this.fLabelProvider = new HierarchyLabelProvider(this.fLifeCycle);
        this.fLabelProvider.setFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return HierarchyInformationControl.this.hasFocusMethod((IType)element);
            }
        });
        this.fLabelProvider.setTextFlags(JavaElementLabels.ALL_DEFAULT | 0x100000L | 0x2000000000L);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        treeViewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider(this.fLabelProvider));
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    protected boolean hasFocusMethod(IType type) {
        if (this.fFocus == null) {
            return true;
        }
        if (type.equals(this.fFocus.getDeclaringType())) {
            return true;
        }
        try {
            IPackageFragment pack;
            IMethod method = this.findMethod(this.fFocus, type);
            if (method != null && JavaModelUtil.isVisibleInHierarchy((IMember)method, pack = (IPackageFragment)this.fFocus.getAncestor(4))) {
                return true;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private IMethod findMethod(IMethod filterMethod, IType typeToFindIn) throws JavaModelException {
        IType focusType;
        IType filterType = filterMethod.getDeclaringType();
        if (filterType.equals(typeToFindIn)) {
            return filterMethod;
        }
        ITypeHierarchy hierarchy = this.fLifeCycle.getHierarchy();
        boolean filterOverrides = JavaModelUtil.isSuperType(hierarchy, typeToFindIn, filterType);
        IType iType = focusType = filterOverrides ? filterType : typeToFindIn;
        if (this.fMethodOverrideTester == null || !this.fMethodOverrideTester.getFocusType().equals(focusType)) {
            this.fMethodOverrideTester = new MethodOverrideTester(focusType, hierarchy);
        }
        if (filterOverrides) {
            return this.fMethodOverrideTester.findOverriddenMethodInType(typeToFindIn, filterMethod);
        }
        return this.fMethodOverrideTester.findOverridingMethodInType(typeToFindIn, filterMethod);
    }

    @Override
    public void setInput(Object information) {
        IMember[] iMemberArray;
        if (!(information instanceof IJavaElement)) {
            this.inputChanged(null, null);
            return;
        }
        IJavaElement input = null;
        IJavaElement locked = null;
        try {
            IJavaElement elem = (IJavaElement)information;
            switch (elem.getElementType()) {
                case 14: 
                case 15: {
                    elem = elem.getParent();
                }
            }
            switch (elem.getElementType()) {
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    input = elem;
                    break;
                }
                case 5: {
                    input = ((ICompilationUnit)elem).findPrimaryType();
                    break;
                }
                case 6: {
                    input = ((IClassFile)elem).getType();
                    break;
                }
                case 9: {
                    IMethod method = (IMethod)elem;
                    if (!method.isConstructor()) {
                        locked = method;
                    }
                    input = method.getDeclaringType();
                    break;
                }
                case 8: 
                case 10: {
                    input = ((IMember)elem).getDeclaringType();
                    break;
                }
                case 11: {
                    input = elem.getParent().getParent();
                    break;
                }
                case 13: {
                    IImportDeclaration decl = (IImportDeclaration)elem;
                    if (decl.isOnDemand()) {
                        input = JavaModelUtil.findTypeContainer(decl.getJavaProject(), Signature.getQualifier((String)decl.getElementName()));
                        break;
                    }
                    input = decl.getJavaProject().findType(decl.getElementName());
                    break;
                }
                default: {
                    JavaPlugin.logErrorMessage("Element unsupported by the hierarchy: " + elem.getClass());
                    break;
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        super.setTitleText(this.getHeaderLabel(locked == null ? input : locked));
        try {
            this.fLifeCycle.ensureRefreshedTypeHierarchy(input, (IRunnableContext)JavaPlugin.getActiveWorkbenchWindow());
        }
        catch (InvocationTargetException invocationTargetException) {
            input = null;
        }
        catch (InterruptedException interruptedException) {
            this.dispose();
            return;
        }
        if (locked != null) {
            IMember[] iMemberArray2 = new IMember[1];
            iMemberArray = iMemberArray2;
            iMemberArray2[0] = locked;
        } else {
            iMemberArray = null;
        }
        IMember[] memberFilter = iMemberArray;
        TraditionalHierarchyViewer.TraditionalHierarchyContentProvider contentProvider = new TraditionalHierarchyViewer.TraditionalHierarchyContentProvider(this.fLifeCycle);
        contentProvider.setMemberFilter(memberFilter);
        this.getTreeViewer().setContentProvider((IContentProvider)contentProvider);
        this.fOtherContentProvider = new SuperTypeHierarchyViewer.SuperTypeHierarchyContentProvider(this.fLifeCycle);
        this.fOtherContentProvider.setMemberFilter(memberFilter);
        this.fFocus = locked;
        Object[] topLevelObjects = contentProvider.getElements(this.fLifeCycle);
        if (topLevelObjects.length > 0 && contentProvider.getChildren(topLevelObjects[0]).length > 40) {
            this.fDoFilter = false;
        } else {
            this.getTreeViewer().addFilter((ViewerFilter)new AbstractInformationControl.NamePatternFilter());
        }
        Object selection = null;
        if (input instanceof IMember) {
            selection = input;
        } else if (topLevelObjects.length > 0) {
            selection = topLevelObjects[0];
        }
        this.inputChanged(this.fLifeCycle, selection);
    }

    @Override
    protected void stringMatcherUpdated() {
        if (this.fDoFilter) {
            super.stringMatcherUpdated();
        } else {
            this.selectFirstMatch();
        }
    }

    protected void toggleHierarchy() {
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.getTree().setRedraw(false);
        Object[] expandedElements = treeViewer.getExpandedElements();
        TypeHierarchyContentProvider contentProvider = (TypeHierarchyContentProvider)treeViewer.getContentProvider();
        treeViewer.setContentProvider((IContentProvider)this.fOtherContentProvider);
        treeViewer.refresh();
        if (this.fOtherExpandedElements != null) {
            treeViewer.setExpandedElements(this.fOtherExpandedElements);
        } else {
            treeViewer.expandAll();
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            this.getTreeViewer().reveal(selectedElement);
        } else {
            this.selectFirstMatch();
        }
        treeViewer.getTree().setRedraw(true);
        this.fOtherContentProvider = contentProvider;
        this.fOtherExpandedElements = expandedElements;
        this.updateStatusFieldText();
    }

    private String getHeaderLabel(IJavaElement input) {
        if (input instanceof IMethod) {
            Object[] args = new String[]{JavaElementLabels.getElementLabel(input.getParent(), JavaElementLabels.ALL_DEFAULT), JavaElementLabels.getElementLabel(input, JavaElementLabels.ALL_DEFAULT)};
            return Messages.format(TypeHierarchyMessages.HierarchyInformationControl_methodhierarchy_label, args);
        }
        if (input != null) {
            String arg = JavaElementLabels.getElementLabel(input, JavaElementLabels.DEFAULT_QUALIFIED);
            return Messages.format(TypeHierarchyMessages.HierarchyInformationControl_hierarchy_label, arg);
        }
        return "";
    }

    @Override
    protected String getStatusFieldText() {
        KeySequence[] sequences = this.getInvokingCommandKeySequences();
        String keyName = "";
        if (sequences != null && sequences.length > 0) {
            keyName = sequences[0].format();
        }
        if (this.fOtherContentProvider instanceof TraditionalHierarchyViewer.TraditionalHierarchyContentProvider) {
            return Messages.format(TypeHierarchyMessages.HierarchyInformationControl_toggle_traditionalhierarchy_label, keyName);
        }
        return Messages.format(TypeHierarchyMessages.HierarchyInformationControl_toggle_superhierarchy_label, keyName);
    }

    @Override
    protected String getId() {
        return "org.eclipse.jdt.internal.ui.typehierarchy.QuickHierarchy";
    }

    @Override
    protected Object getSelectedElement() {
        Object selectedElement = super.getSelectedElement();
        if (selectedElement instanceof IType && this.fFocus != null) {
            IType type = (IType)selectedElement;
            try {
                IMethod method = this.findMethod(this.fFocus, type);
                if (method != null) {
                    return method;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return selectedElement;
    }
}

