/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAssistInvocationContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.FileEditorInput;

public class HTMLTagCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final String[] fgHTMLProposals = new String[IHtmlTagConstants.HTML_GENERAL_TAGS.length * 2];
    private IDocument fDocument;
    private int fCurrentPos;
    private int fCurrentLength;
    private String fErrorMessage;
    private List<ICompletionProposal> fResult;
    private boolean fRestrictToMatchingCase;

    public HTMLTagCompletionProposalComputer() {
        String tag = null;
        int index = 0;
        int offset = 0;
        while (index < fgHTMLProposals.length) {
            tag = IHtmlTagConstants.HTML_GENERAL_TAGS[offset];
            HTMLTagCompletionProposalComputer.fgHTMLProposals[index++] = String.valueOf('<') + tag + '>';
            HTMLTagCompletionProposalComputer.fgHTMLProposals[index++] = "</" + tag + '>';
            ++offset;
        }
    }

    private static boolean isWordPart(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '#' || ch == '.' || ch == '/';
    }

    private static int findCharBeforeWord(IDocument doc, int lineBeginPos, int pos) {
        int currPos = pos - 1;
        if (currPos > lineBeginPos) {
            try {
                while (currPos > lineBeginPos && HTMLTagCompletionProposalComputer.isWordPart(doc.getChar(currPos))) {
                    --currPos;
                }
                return currPos;
            }
            catch (BadLocationException badLocationException) {}
        }
        return pos;
    }

    private static int findClosingCharacter(IDocument doc, int pos, int end, char endChar) throws BadLocationException {
        int curr = pos;
        while (curr < end && doc.getChar(curr) != endChar) {
            ++curr;
        }
        if (curr < end) {
            return curr + 1;
        }
        return pos;
    }

    private static int findReplaceEndPos(IDocument doc, String newText, String oldText, int pos) {
        if (oldText.length() == 0 || oldText.equals(newText)) {
            return pos;
        }
        try {
            IRegion lineInfo = doc.getLineInformationOfOffset(pos);
            int end = lineInfo.getOffset() + lineInfo.getLength();
            return HTMLTagCompletionProposalComputer.findClosingCharacter(doc, pos, end, '>');
        }
        catch (BadLocationException badLocationException) {
            return pos;
        }
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavadocContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        JavadocContentAssistInvocationContext docContext = (JavadocContentAssistInvocationContext)context;
        int flags = docContext.getFlags();
        this.fCurrentPos = docContext.getInvocationOffset();
        this.fCurrentLength = docContext.getSelectionLength();
        this.fRestrictToMatchingCase = (flags & 1) != 0;
        ICompilationUnit cu = docContext.getCompilationUnit();
        if (cu == null) {
            return Collections.emptyList();
        }
        FileEditorInput editorInput = new FileEditorInput((IFile)cu.getResource());
        this.fDocument = JavaUI.getDocumentProvider().getDocument((Object)editorInput);
        if (this.fDocument == null) {
            return null;
        }
        try {
            this.fResult = new ArrayList<ICompletionProposal>(100);
            this.evalProposals();
            List<ICompletionProposal> list = this.fResult;
            return list;
        }
        catch (JavaModelException e) {
            this.fErrorMessage = e.getLocalizedMessage();
        }
        finally {
            this.fResult = null;
        }
        return null;
    }

    private void evalProposals() throws JavaModelException {
        try {
            IRegion info = this.fDocument.getLineInformationOfOffset(this.fCurrentPos);
            int lineBeginPos = info.getOffset();
            int word1Begin = HTMLTagCompletionProposalComputer.findCharBeforeWord(this.fDocument, lineBeginPos, this.fCurrentPos);
            if (word1Begin == this.fCurrentPos) {
                return;
            }
            char firstChar = this.fDocument.getChar(word1Begin);
            if (firstChar == '<') {
                String prefix = this.fDocument.get(word1Begin, this.fCurrentPos - word1Begin);
                this.addProposals(prefix, fgHTMLProposals, "org.eclipse.jdt.ui.html_tag_obj.gif");
                return;
            }
            if (!Character.isWhitespace(firstChar)) {
                return;
            }
            String prefix = this.fDocument.get(word1Begin + 1, this.fCurrentPos - word1Begin - 1);
            this.addAllTags(prefix);
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean prefixMatches(String prefix, String proposal) {
        if (this.fRestrictToMatchingCase) {
            return proposal.startsWith(prefix);
        }
        if (proposal.length() >= prefix.length()) {
            return prefix.equalsIgnoreCase(proposal.substring(0, prefix.length()));
        }
        return false;
    }

    private void addAllTags(String prefix) {
        String htmlPrefix = "<" + prefix;
        int i = 0;
        while (i < fgHTMLProposals.length) {
            String curr = fgHTMLProposals[i];
            if (this.prefixMatches(htmlPrefix, curr)) {
                this.fResult.add(this.createCompletion(curr, prefix, new StyledString(curr), JavaPluginImages.get("org.eclipse.jdt.ui.html_tag_obj.gif"), 0));
            }
            ++i;
        }
    }

    private void addProposals(String prefix, String[] choices, String imageName) {
        int i = 0;
        while (i < choices.length) {
            String curr = choices[i];
            if (this.prefixMatches(prefix, curr)) {
                this.fResult.add(this.createCompletion(curr, prefix, new StyledString(curr), JavaPluginImages.get(imageName), 0));
            }
            ++i;
        }
    }

    private JavaCompletionProposal createCompletion(String newText, String oldText, StyledString labelText, Image image, int severity) {
        int offset = this.fCurrentPos - oldText.length();
        int length = this.fCurrentLength + oldText.length();
        if (this.fCurrentLength == 0) {
            length = HTMLTagCompletionProposalComputer.findReplaceEndPos(this.fDocument, newText, oldText, this.fCurrentPos) - offset;
        }
        if (!newText.startsWith("</")) {
            ++severity;
        }
        JavaCompletionProposal proposal = new JavaCompletionProposal(newText, offset, length, image, labelText, severity, true);
        proposal.setTriggerCharacters(new char[]{'>'});
        return proposal;
    }

    @Override
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    @Override
    public void sessionStarted() {
        this.fErrorMessage = null;
    }
}

