/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.preferences.JavadocProblemsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.ProblemSeveritiesConfigurationBlock;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractAnnotationHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemHover
extends AbstractAnnotationHover {
    public ProblemHover() {
        super(false);
    }

    @Override
    protected AbstractAnnotationHover.AnnotationInfo createAnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
        return new ProblemInfo(annotation, position, textViewer);
    }

    private static final class ConfigureProblemSeverityAction
    extends Action {
        private static final String CONFIGURE_PROBLEM_SEVERITY_DIALOG_ID = "configure_problem_severity_dialog_id";
        private final IJavaProject fProject;
        private final String fOptionId;
        private final boolean fIsJavadocOption;
        private final IInformationControl fInfoControl;

        public ConfigureProblemSeverityAction(IJavaProject project, String optionId, boolean isJavadocOption, IInformationControl infoControl) {
            this.fProject = project;
            this.fOptionId = optionId;
            this.fIsJavadocOption = isJavadocOption;
            this.fInfoControl = infoControl;
            this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_PROBLEM_SEVERITIES);
            this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_PROBLEM_SEVERITIES);
            this.setToolTipText(JavaHoverMessages.ProblemHover_action_configureProblemSeverity);
        }

        public void run() {
            String pageId;
            boolean showPropertyPage;
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (!this.hasProjectSpecificOptions()) {
                String[] buttons;
                String message = Messages.format(JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_message, new Object[]{JavaElementLabels.getElementLabel((IJavaElement)this.fProject, JavaElementLabels.ALL_DEFAULT)});
                int result = OptionalMessageDialog.open(CONFIGURE_PROBLEM_SEVERITY_DIALOG_ID, shell, JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_title, null, message, 3, buttons = new String[]{JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_button_project, JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_button_workspace, IDialogConstants.CANCEL_LABEL}, 0, JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_checkBox_dontShowAgain);
                if (result == 1025) {
                    showPropertyPage = false;
                } else {
                    if (result == 2 || result == -1) {
                        return;
                    }
                    showPropertyPage = result == 0;
                }
            } else {
                showPropertyPage = true;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (this.fIsJavadocOption) {
                if (showPropertyPage) {
                    pageId = "org.eclipse.jdt.ui.propertyPages.JavadocProblemsPreferencePage";
                    data.put("use_project_specific_key", Boolean.TRUE);
                } else {
                    pageId = "org.eclipse.jdt.ui.preferences.JavadocProblemsPreferencePage";
                }
                data.put("select_option_key", this.fOptionId);
                data.put("select_option_qualifier", "org.eclipse.jdt.core");
            } else {
                if (showPropertyPage) {
                    pageId = "org.eclipse.jdt.ui.propertyPages.ProblemSeveritiesPreferencePage";
                    data.put("use_project_specific_key", Boolean.TRUE);
                } else {
                    pageId = "org.eclipse.jdt.ui.preferences.ProblemSeveritiesPreferencePage";
                }
                data.put("select_option_key", this.fOptionId);
                data.put("select_option_qualifier", "org.eclipse.jdt.core");
            }
            this.fInfoControl.dispose();
            if (showPropertyPage) {
                PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)this.fProject, (String)pageId, null, data).open();
            } else {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageId, null, data).open();
            }
        }

        private boolean hasProjectSpecificOptions() {
            OptionsConfigurationBlock.Key[] keys = this.fIsJavadocOption ? JavadocProblemsConfigurationBlock.getKeys() : ProblemSeveritiesConfigurationBlock.getKeys();
            return OptionsConfigurationBlock.hasProjectSpecificOptions(this.fProject.getProject(), keys, null);
        }
    }

    protected static class ProblemInfo
    extends AbstractAnnotationHover.AnnotationInfo {
        private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];

        public ProblemInfo(Annotation annotation, Position position, ITextViewer textViewer) {
            super(annotation, position, textViewer);
        }

        @Override
        public ICompletionProposal[] getCompletionProposals() {
            ICompletionProposal[] result;
            if (this.annotation instanceof IJavaAnnotation && (result = this.getJavaAnnotationFixes((IJavaAnnotation)this.annotation)).length > 0) {
                return result;
            }
            if (this.annotation instanceof MarkerAnnotation) {
                return this.getMarkerAnnotationFixes((MarkerAnnotation)this.annotation);
            }
            return NO_PROPOSALS;
        }

        private ICompletionProposal[] getJavaAnnotationFixes(IJavaAnnotation javaAnnotation) {
            ProblemLocation location = new ProblemLocation(this.position.getOffset(), this.position.getLength(), javaAnnotation);
            ICompilationUnit cu = javaAnnotation.getCompilationUnit();
            if (cu == null) {
                return NO_PROPOSALS;
            }
            ISourceViewer sourceViewer = null;
            if (this.viewer instanceof ISourceViewer) {
                sourceViewer = (ISourceViewer)this.viewer;
            }
            AssistContext context = new AssistContext(cu, sourceViewer, location.getOffset(), location.getLength(), SharedASTProvider.WAIT_ACTIVE_ONLY);
            if (!"org.eclipse.ui.workbench.texteditor.spelling".equals(javaAnnotation.getType()) && !ProblemInfo.hasProblem(context.getASTRoot().getProblems(), location)) {
                return NO_PROPOSALS;
            }
            ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
            JavaCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
            Collections.sort(proposals, new CompletionProposalComparator());
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private static boolean hasProblem(IProblem[] problems, IProblemLocation location) {
            int i = 0;
            while (i < problems.length) {
                IProblem problem = problems[i];
                if (problem.getID() == location.getProblemId() && problem.getSourceStart() == location.getOffset()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private ICompletionProposal[] getMarkerAnnotationFixes(MarkerAnnotation markerAnnotation) {
            if (markerAnnotation.isQuickFixableStateSet() && !markerAnnotation.isQuickFixable()) {
                return NO_PROPOSALS;
            }
            IMarker marker = markerAnnotation.getMarker();
            ICompilationUnit cu = ProblemInfo.getCompilationUnit(marker);
            if (cu == null) {
                return NO_PROPOSALS;
            }
            IEditorInput input = EditorUtility.getEditorInput(cu);
            if (input == null) {
                return NO_PROPOSALS;
            }
            IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)input);
            if (model == null) {
                return NO_PROPOSALS;
            }
            ISourceViewer sourceViewer = null;
            if (this.viewer instanceof ISourceViewer) {
                sourceViewer = (ISourceViewer)this.viewer;
            }
            AssistContext context = new AssistContext(cu, sourceViewer, this.position.getOffset(), this.position.getLength());
            ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
            JavaCorrectionProcessor.collectProposals(context, model, new Annotation[]{markerAnnotation}, true, false, proposals);
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private static ICompilationUnit getCompilationUnit(IMarker marker) {
            IJavaElement element;
            IResource res = marker.getResource();
            if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
            return null;
        }

        @Override
        public void fillToolBar(ToolBarManager manager, IInformationControl infoControl) {
            super.fillToolBar(manager, infoControl);
            if (!(this.annotation instanceof IJavaAnnotation)) {
                return;
            }
            IJavaAnnotation javaAnnotation = (IJavaAnnotation)this.annotation;
            String optionId = JavaCore.getOptionForConfigurableSeverity((int)javaAnnotation.getId());
            if (optionId != null) {
                IJavaProject javaProject = javaAnnotation.getCompilationUnit().getJavaProject();
                boolean isJavadocProblem = (javaAnnotation.getId() & Integer.MIN_VALUE) != 0;
                ConfigureProblemSeverityAction problemSeverityAction = new ConfigureProblemSeverityAction(javaProject, optionId, isJavadocProblem, infoControl);
                manager.add((IAction)problemSeverityAction);
            }
        }
    }
}

