/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.AbstractToggleLinkingAction;
import org.eclipse.jdt.internal.ui.search.ExceptionOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.ImplementOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.JavaElementLine;
import org.eclipse.jdt.internal.ui.search.OccurrenceMatch;
import org.eclipse.jdt.internal.ui.search.OccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchLabelProvider;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchQuery;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchResult;
import org.eclipse.jdt.internal.ui.search.TextSearchTableContentProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.jdt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class OccurrencesSearchResultPage
extends AbstractTextSearchViewPage {
    private static final String DIALOGSTORE_LINKEDITORS = "TypeHierarchyViewPart.linkeditors";
    private TextSearchTableContentProvider fContentProvider;
    private boolean fLinkingEnabled = false;
    private AbstractToggleLinkingAction fToggleLinkingAction;
    private LinkWithEditorListener fLinkWithEditorListener = new LinkWithEditorListener();

    public OccurrencesSearchResultPage() {
        super(1);
        this.fToggleLinkingAction = new ToggleLinkingAction();
        this.fToggleLinkingAction.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.setLinkingEnabled(this.getDialogSettings().getBoolean(DIALOGSTORE_LINKEDITORS));
    }

    public void dispose() {
        if (this.fLinkingEnabled) {
            this.fLinkWithEditorListener.uninstall(this.getSite().getPage());
        }
        super.dispose();
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        tbm.add((IAction)this.fToggleLinkingAction);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IActionBars bars = this.getSite().getActionBars();
        IMenuManager menu = bars.getMenuManager();
        menu.add((IAction)this.fToggleLinkingAction);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)this.fToggleLinkingAction));
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        JavaElementLine element = (JavaElementLine)match.getElement();
        ITypeRoot javaElement = element.getJavaElement();
        try {
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)javaElement, false, false);
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
            if (editor != null && activate) {
                editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
            }
        }
        catch (PartInitException partInitException) {
            return;
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        throw new IllegalStateException("Doesn't support tree mode.");
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer v, Object e1, Object e2) {
                JavaElementLine jel1 = (JavaElementLine)e1;
                JavaElementLine jel2 = (JavaElementLine)e2;
                return jel1.getLine() - jel2.getLine();
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider(new OccurrencesSearchLabelProvider(this)));
        this.fContentProvider = new TextSearchTableContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }

    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        if (this.fLinkingEnabled != enabled) {
            this.fLinkingEnabled = enabled;
            this.fToggleLinkingAction.setChecked(enabled);
            this.getDialogSettings().put(DIALOGSTORE_LINKEDITORS, enabled);
            if (enabled) {
                this.fLinkWithEditorListener.install(this.getSite().getPage());
            } else {
                this.fLinkWithEditorListener.uninstall(this.getSite().getPage());
            }
        }
    }

    private IDialogSettings getDialogSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection("OccurrencesSearchResultPage");
    }

    private void preformEditorSelectionChanged(ITextSelection selection, CompilationUnit astRoot) {
        int length;
        int offset;
        String id;
        if (!this.isLinkingEnabled()) {
            return;
        }
        AbstractTextSearchResult input = this.getInput();
        IOccurrencesFinder finder = input == null ? new OccurrencesFinder() : ((id = ((OccurrencesSearchQuery)input.getQuery()).getFinderId()) == "OccurrencesFinder" ? new OccurrencesFinder() : (id == "ExceptionOccurrencesFinder" ? new ExceptionOccurrencesFinder() : new ImplementOccurrencesFinder()));
        if (finder.initialize(astRoot, offset = selection.getOffset(), length = selection.getLength()) == null) {
            final OccurrencesSearchQuery query = new OccurrencesSearchQuery(finder, astRoot.getTypeRoot());
            query.run(null);
            OccurrencesSearchResult result = (OccurrencesSearchResult)query.getSearchResult();
            final JavaElementLine line = OccurrencesSearchResultPage.getMatchingLine(result, offset, length);
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OccurrencesSearchResultPage.this.setInput(query.getSearchResult(), line == null ? null : new StructuredSelection((Object)line));
                }
            });
        }
    }

    private static JavaElementLine getMatchingLine(OccurrencesSearchResult result, int offset, int length) {
        Object[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            JavaElementLine line = (JavaElementLine)elements[i];
            Match[] matches = result.getMatches(line);
            int j = 0;
            while (j < matches.length) {
                OccurrenceMatch match = (OccurrenceMatch)matches[j];
                if (match.getOriginalOffset() <= offset && offset + length <= match.getOriginalOffset() + match.getOriginalLength()) {
                    return line;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private class LinkWithEditorListener
    implements IPartListener2,
    ISelectionListenerWithAST {
        private ITextEditor fActiveEditor;
        private boolean fIsVisible;

        private LinkWithEditorListener() {
        }

        public void install(IWorkbenchPage page) {
            page.addPartListener((IPartListener2)this);
            this.fIsVisible = page.isPartVisible((IWorkbenchPart)OccurrencesSearchResultPage.this.getViewPart());
            if (this.fIsVisible) {
                this.installOnActiveEditor(page);
            }
        }

        private void installOnActiveEditor(IWorkbenchPage page) {
            IEditorPart activeEditor = page.getActiveEditor();
            if (activeEditor instanceof ITextEditor) {
                CompilationUnit astRoot;
                this.editorActive(activeEditor);
                ISelection selection = activeEditor.getSite().getSelectionProvider().getSelection();
                ITypeRoot typeRoot = JavaUI.getEditorInputTypeRoot(activeEditor.getEditorInput());
                if (typeRoot != null && selection instanceof ITextSelection && (astRoot = SharedASTProvider.getAST(typeRoot, SharedASTProvider.WAIT_ACTIVE_ONLY, null)) != null) {
                    OccurrencesSearchResultPage.this.preformEditorSelectionChanged((ITextSelection)selection, astRoot);
                }
            }
        }

        private void uninstallOnActiveEditor() {
            if (this.fActiveEditor != null) {
                SelectionListenerWithASTManager.getDefault().removeListener(this.fActiveEditor, this);
                this.fActiveEditor = null;
            }
        }

        public void uninstall(IWorkbenchPage page) {
            page.removePartListener((IPartListener2)this);
            this.uninstallOnActiveEditor();
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (this.fIsVisible && partRef instanceof IEditorReference) {
                this.editorActive(((IEditorReference)partRef).getEditor(true));
            }
        }

        private void editorActive(IEditorPart editor) {
            if (editor instanceof ITextEditor) {
                if (editor != this.fActiveEditor) {
                    OccurrencesSearchResultPage.this.setInput(null, null);
                }
                this.fActiveEditor = (ITextEditor)editor;
                SelectionListenerWithASTManager.getDefault().addListener(this.fActiveEditor, this);
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        @Override
        public void selectionChanged(IEditorPart part, ITextSelection selection, CompilationUnit astRoot) {
            OccurrencesSearchResultPage.this.preformEditorSelectionChanged(selection, astRoot);
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if ("org.eclipse.search.ui.views.SearchView".equals(partRef.getId()) && partRef.getPart(true) == OccurrencesSearchResultPage.this.getViewPart() && this.fActiveEditor == null) {
                this.fIsVisible = true;
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if ("org.eclipse.search.ui.views.SearchView".equals(partRef.getId()) && partRef.getPart(true) == OccurrencesSearchResultPage.this.getViewPart()) {
                this.fIsVisible = false;
                this.uninstallOnActiveEditor();
            } else if (partRef instanceof IEditorReference && partRef.getPart(true) == this.fActiveEditor) {
                this.uninstallOnActiveEditor();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference && partRef.getPart(true) == this.fActiveEditor) {
                this.uninstallOnActiveEditor();
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }
    }

    private class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        private ToggleLinkingAction() {
        }

        @Override
        public void run() {
            OccurrencesSearchResultPage.this.setLinkingEnabled(this.isChecked());
        }
    }
}

