/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;

public class ExceptionOccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String ID = "ExceptionOccurrencesFinder";
    public static final String IS_EXCEPTION = "isException";
    private CompilationUnit fASTRoot;
    private Name fSelectedName;
    private ITypeBinding fException;
    private ASTNode fStart;
    private TryStatement fTryStatement;
    private List<IOccurrencesFinder.OccurrenceLocation> fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
    private String fDescription;
    private List<ITypeBinding> fCaughtExceptions;

    @Override
    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
    }

    @Override
    public String initialize(CompilationUnit root, ASTNode node) {
        this.fASTRoot = root;
        if (!(node instanceof Name)) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        this.fSelectedName = ASTNodes.getTopMostName((Name)node);
        ASTNode parent = this.fSelectedName.getParent();
        MethodDeclaration decl = this.resolveMethodDeclaration(parent);
        if (decl != null && this.methodThrowsException(decl, this.fSelectedName)) {
            this.fException = this.fSelectedName.resolveTypeBinding();
            this.fStart = decl.getBody();
        } else if (parent instanceof Type) {
            if ((parent = parent.getParent()) instanceof UnionType) {
                parent = parent.getParent();
            }
            if (parent instanceof SingleVariableDeclaration && parent.getParent() instanceof CatchClause) {
                CatchClause catchClause = (CatchClause)parent.getParent();
                this.fTryStatement = (TryStatement)catchClause.getParent();
                if (this.fTryStatement != null) {
                    this.fException = this.fSelectedName.resolveTypeBinding();
                    this.fStart = this.fTryStatement.getBody();
                }
            }
        }
        if (this.fException == null || this.fStart == null) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        this.fDescription = Messages.format(SearchMessages.ExceptionOccurrencesFinder_occurrence_description, BasicElementLabels.getJavaElementName(this.fException.getName()));
        return null;
    }

    private MethodDeclaration resolveMethodDeclaration(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            return (MethodDeclaration)node;
        }
        Javadoc doc = (Javadoc)ASTNodes.getParent(node, 29);
        if (doc == null) {
            return null;
        }
        if (doc.getParent() instanceof MethodDeclaration) {
            return (MethodDeclaration)doc.getParent();
        }
        return null;
    }

    private boolean methodThrowsException(MethodDeclaration method, Name exception) {
        ASTMatcher matcher = new ASTMatcher();
        for (Name thrown : method.thrownExceptions()) {
            if (!exception.subtreeMatch(matcher, (Object)thrown)) continue;
            return true;
        }
        return false;
    }

    private void performSearch() {
        this.fCaughtExceptions = new ArrayList<ITypeBinding>();
        this.fStart.accept((ASTVisitor)this);
        if (this.fTryStatement != null) {
            this.handleResourceDeclarations(this.fTryStatement);
        }
        if (this.fSelectedName != null) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.fSelectedName.getStartPosition(), this.fSelectedName.getLength(), 8, this.fDescription));
        }
    }

    private void handleResourceDeclarations(TryStatement tryStatement) {
        if (tryStatement.getAST().apiLevel() >= 4) {
            List resources = tryStatement.resources();
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                ((VariableDeclarationExpression)iterator.next()).accept((ASTVisitor)this);
            }
            boolean exitMarked = false;
            for (VariableDeclarationExpression variable : resources) {
                Type type = variable.getType();
                IMethodBinding methodBinding = Bindings.findMethodInHierarchy(type.resolveBinding(), "close", new ITypeBinding[0]);
                if (methodBinding == null) continue;
                ITypeBinding[] exceptionTypes = methodBinding.getExceptionTypes();
                int j = 0;
                while (j < exceptionTypes.length) {
                    if (this.matches(exceptionTypes[j])) {
                        for (VariableDeclarationFragment fragment : variable.fragments()) {
                            SimpleName name = fragment.getName();
                            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fDescription));
                        }
                        if (!exitMarked) {
                            exitMarked = true;
                            Block body = tryStatement.getBody();
                            int offset = body.getStartPosition() + body.getLength() - 1;
                            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, 1, 0, Messages.format(SearchMessages.ExceptionOccurrencesFinder_occurrence_implicit_close_description, BasicElementLabels.getJavaElementName(this.fException.getName()))));
                        }
                    }
                    ++j;
                }
            }
        }
    }

    @Override
    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.performSearch();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    @Override
    public int getSearchKind() {
        return 6;
    }

    @Override
    public CompilationUnit getASTRoot() {
        return this.fASTRoot;
    }

    @Override
    public String getJobLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_searchfor;
    }

    @Override
    public String getElementName() {
        if (this.fSelectedName != null) {
            return ASTNodes.asString((ASTNode)this.fSelectedName);
        }
        return null;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_label_singular;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(CastExpression node) {
        if ("java.lang.ClassCastException".equals(this.fException.getQualifiedName())) {
            Type type = node.getType();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(type.getStartPosition(), type.getLength(), 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            Type type = node.getType();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(type.getStartPosition(), type.getLength(), 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 4, 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        if (this.matches(node.resolveMethodBinding())) {
            SimpleName name = node.getName();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 5, 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.matches(node.resolveMethodBinding())) {
            SimpleName name = node.getName();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(ThrowStatement node) {
        if (this.matches(node.getExpression().resolveTypeBinding())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 5, 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(TryStatement node) {
        int toRemove;
        int currentSize = this.fCaughtExceptions.size();
        List catchClauses = node.catchClauses();
        Iterator iter = catchClauses.iterator();
        while (iter.hasNext()) {
            Type type = ((CatchClause)iter.next()).getException().getType();
            if (type instanceof UnionType) {
                List types = ((UnionType)type).types();
                Iterator iterator = types.iterator();
                while (iterator.hasNext()) {
                    this.addCaughtException((Type)iterator.next());
                }
                continue;
            }
            this.addCaughtException(type);
        }
        node.getBody().accept((ASTVisitor)this);
        this.handleResourceDeclarations(node);
        int i = toRemove = this.fCaughtExceptions.size() - currentSize;
        while (i > 0) {
            this.fCaughtExceptions.remove(currentSize);
            --i;
        }
        Iterator iter2 = catchClauses.iterator();
        while (iter2.hasNext()) {
            ((CatchClause)iter2.next()).accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    private void addCaughtException(Type type) {
        ITypeBinding typeBinding = type.resolveBinding();
        if (typeBinding != null) {
            this.fCaughtExceptions.add(typeBinding);
        }
    }

    public boolean visit(TypeDeclarationStatement node) {
        return false;
    }

    private boolean matches(IMethodBinding binding) {
        if (binding == null) {
            return false;
        }
        ITypeBinding[] exceptions = binding.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            ITypeBinding exception = exceptions[i];
            if (this.matches(exception)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean matches(ITypeBinding exception) {
        if (exception == null) {
            return false;
        }
        if (!this.isCaught(exception)) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (Bindings.equals((IBinding)this.fException, (IBinding)exception)) {
                return true;
            }
            exception = exception.getSuperclass();
lbl8:
            // 2 sources

            ** while (exception != null)
        }
lbl9:
        // 1 sources

        return false;
    }

    private boolean isCaught(ITypeBinding binding) {
        for (ITypeBinding catchException : this.fCaughtExceptions) {
            if (!this.catches(catchException, binding)) continue;
            return true;
        }
        return false;
    }

    private boolean catches(ITypeBinding catchTypeBinding, ITypeBinding throwTypeBinding) {
        while (throwTypeBinding != null) {
            if (throwTypeBinding == catchTypeBinding) {
                return true;
            }
            throwTypeBinding = throwTypeBinding.getSuperclass();
        }
        return false;
    }

    public IOccurrencesFinder getNewInstance() {
        return new ExceptionOccurrencesFinder();
    }

    @Override
    public String getID() {
        return ID;
    }
}

