/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.SnippetPreview;

public final class WhiteSpaceOptions {
    private final SnippetPreview.PreviewSnippet FOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "for (int i= 0, j= array.length; i < array.length; i++, j--) {}\nfor (String s : names) {}");
    private final SnippetPreview.PreviewSnippet WHILE_PREVIEW = new SnippetPreview.PreviewSnippet(2, "while (condition) {}; do {} while (condition);");
    private final SnippetPreview.PreviewSnippet CATCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "try { number= Integer.parseInt(value); } catch (NumberFormatException e) {}");
    private final SnippetPreview.PreviewSnippet TRY_PREVIEW = new SnippetPreview.PreviewSnippet(2, "try (FileReader reader1 = new FileReader(\"file1\"); FileReader reader2 = new FileReader(\"file2\")) {}");
    private final SnippetPreview.PreviewSnippet IF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (condition) { return foo; } else {return bar;}");
    private final SnippetPreview.PreviewSnippet SYNCHRONIZED_PREVIEW = new SnippetPreview.PreviewSnippet(2, "synchronized (list) { list.add(element); }");
    private final SnippetPreview.PreviewSnippet SWITCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "switch (number) { case RED: return GREEN; case GREEN: return BLUE; case BLUE: return RED; default: return BLACK;}");
    private final SnippetPreview.PreviewSnippet CONSTRUCTOR_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "MyClass() throws E0, E1 { this(0,0,0);}MyClass(int x, int y, int z) throws E0, E1 { super(x, y, z, true);}");
    private final SnippetPreview.PreviewSnippet METHOD_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "void foo() throws E0, E1 {};void bar(int x, int y) throws E0, E1 {}");
    private final SnippetPreview.PreviewSnippet ARRAY_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int [] array0= new int [] {};\nint [] array1= new int [] {1, 2, 3};\nint [] array2= new int[3];");
    private final SnippetPreview.PreviewSnippet ARRAY_REF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "array[i].foo();");
    private final SnippetPreview.PreviewSnippet METHOD_CALL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "foo();\nbar(x, y);");
    private final SnippetPreview.PreviewSnippet ALLOC_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String str= new String(); Point point= new Point(x, y);");
    private final SnippetPreview.PreviewSnippet LABEL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "label: for (int i= 0; i<list.length; i++) {for (int j= 0; j < list[i].length; j++) continue label;}");
    private final SnippetPreview.PreviewSnippet SEMICOLON_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a= 4; foo(); bar(x, y);");
    private final SnippetPreview.PreviewSnippet CONDITIONAL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String value= condition ? TRUE : FALSE;");
    private final SnippetPreview.PreviewSnippet CLASS_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(8, "class MyClass implements I0, I1, I2 {}");
    private final SnippetPreview.PreviewSnippet ANON_CLASS_PREVIEW = new SnippetPreview.PreviewSnippet(2, "AnonClass= new AnonClass() {void foo(Some s) { }};");
    private final SnippetPreview.PreviewSnippet OPERATOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "List list= new ArrayList(); int a= -4 + -9; b= a++ / --number; c += 4; boolean value= true && false;");
    private final SnippetPreview.PreviewSnippet CAST_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String s= ((String)object);");
    private final SnippetPreview.PreviewSnippet MULT_LOCAL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a= 0, b= 1, c= 2, d= 3;");
    private final SnippetPreview.PreviewSnippet MULT_FIELD_PREVIEW = new SnippetPreview.PreviewSnippet(4, "int a=0,b=1,c=2,d=3;");
    private final SnippetPreview.PreviewSnippet BLOCK_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (true) { return 1; } else { return 2; }");
    private final SnippetPreview.PreviewSnippet PAREN_EXPR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "result= (a *( b +  c + d) * (e + f));");
    private final SnippetPreview.PreviewSnippet ASSERT_PREVIEW = new SnippetPreview.PreviewSnippet(2, "assert condition : reportError();");
    private final SnippetPreview.PreviewSnippet RETURN_PREVIEW = new SnippetPreview.PreviewSnippet(2, "return (o);");
    private final SnippetPreview.PreviewSnippet THROW_PREVIEW = new SnippetPreview.PreviewSnippet(2, "throw (e);");
    private final SnippetPreview.PreviewSnippet ANNOTATION_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "@interface MyAnnotation { String value(); }\n@interface OtherAnnotation { }\n");
    private final SnippetPreview.PreviewSnippet ANNOTATION_MODIFIER_PREVIEW = new SnippetPreview.PreviewSnippet(4, "@Annot(x=23, y=-3)\npublic class A { }\n");
    private final SnippetPreview.PreviewSnippet ENUM_PREVIEW = new SnippetPreview.PreviewSnippet(4, "enum MyEnum { GREEN(0, 1), RED() {\nvoid process() {}\n}\n}");
    private final SnippetPreview.PreviewSnippet PARAMETERIZED_TYPE_REFERENCE_PREVIEW = new SnippetPreview.PreviewSnippet(4, "Map<String, Element> map=\n new HashMap<String, Element>();");
    private final SnippetPreview.PreviewSnippet TYPE_ARGUMENTS_PREVIEW = new SnippetPreview.PreviewSnippet(2, "x.<String, Element>foo();");
    private final SnippetPreview.PreviewSnippet TYPE_PARAMETER_PREVIEW = new SnippetPreview.PreviewSnippet(4, "class MyGenericType<S, T extends Element & List> { }");
    private final SnippetPreview.PreviewSnippet VARARG_PARAMETER_PREVIEW = new SnippetPreview.PreviewSnippet(4, "void format(String s, Object ... args) {}");
    private final SnippetPreview.PreviewSnippet WILDCARD_PREVIEW = new SnippetPreview.PreviewSnippet(4, "Map<X<?>, Y<? extends K, ? super V>> t;");

    public List<InnerNode> createTreeBySyntaxElem(Map<String, String> workingValues) {
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        InnerNode element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_paren);
        this.createBeforeOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_paren);
        this.createBeforeClosingParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterCloseParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_brace);
        this.createBeforeOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_brace);
        this.createBeforeClosingBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterCloseBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_bracket);
        this.createBeforeOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_bracket);
        this.createBeforeClosingBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_operator);
        this.createBeforeOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_comma);
        this.createBeforeCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_colon);
        this.createBeforeColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_semicolon);
        this.createBeforeSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_question_mark);
        this.createBeforeQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        this.createBetweenEmptyParenTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_braces);
        this.createBetweenEmptyBracesTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        this.createBetweenEmptyBracketsTree(workingValues, element);
        roots.add(element);
        return roots;
    }

    public List<Node> createAltTree(Map<String, String> workingValues) {
        ArrayList<Node> roots = new ArrayList<Node>();
        InnerNode parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_paren);
        this.createBeforeOpenParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_paren);
        this.createAfterOpenParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_paren);
        this.createBeforeClosingParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_paren);
        this.createAfterCloseParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        this.createBetweenEmptyParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_brace);
        this.createBeforeOpenBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_brace);
        this.createAfterOpenBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_brace);
        this.createBeforeClosingBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_brace);
        this.createAfterCloseBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_braces);
        this.createBetweenEmptyBracesTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_bracket);
        this.createBeforeOpenBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_bracket);
        this.createAfterOpenBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_bracket);
        this.createBeforeClosingBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        this.createBetweenEmptyBracketsTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_angle_bracket);
        this.createBeforeOpenAngleBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_angle_bracket);
        this.createAfterOpenAngleBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_angle_bracket);
        this.createBeforeClosingAngleBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_angle_bracket);
        this.createAfterClosingAngleBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_operator);
        this.createBeforeOperatorTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_operator);
        this.createAfterOperatorTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_comma);
        this.createBeforeCommaTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_comma);
        this.createAfterCommaTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_colon);
        this.createAfterColonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_colon);
        this.createBeforeColonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon);
        this.createBeforeSemicolonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_semicolon);
        this.createAfterSemicolonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_question_mark);
        this.createBeforeQuestionTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_question_mark);
        this.createAfterQuestionTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_at);
        this.createBeforeAtTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_at);
        this.createAfterAtTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_and);
        this.createBeforeAndTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_and);
        this.createAfterAndTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_ellipsis);
        this.createBeforeEllipsis(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_ellipsis);
        this.createAfterEllipsis(workingValues, parent);
        return roots;
    }

    private InnerNode createParentNode(List<Node> roots, Map<String, String> workingValues, String text) {
        InnerNode parent = new InnerNode(null, workingValues, text);
        roots.add(parent);
        return parent;
    }

    public ArrayList<Node> createTreeByJavaElement(Map<String, String> workingValues) {
        InnerNode declarations = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_declarations);
        this.createClassTree(workingValues, declarations);
        this.createFieldTree(workingValues, declarations);
        this.createLocalVariableTree(workingValues, declarations);
        this.createConstructorTree(workingValues, declarations);
        this.createMethodDeclTree(workingValues, declarations);
        this.createLabelTree(workingValues, declarations);
        this.createAnnotationTree(workingValues, declarations);
        this.createEnumTree(workingValues, declarations);
        this.createAnnotationTypeTree(workingValues, declarations);
        InnerNode statements = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_statements);
        WhiteSpaceOptions.createOption(statements, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon", this.SEMICOLON_PREVIEW);
        this.createBlockTree(workingValues, statements);
        this.createIfStatementTree(workingValues, statements);
        this.createForStatementTree(workingValues, statements);
        this.createSwitchStatementTree(workingValues, statements);
        this.createDoWhileTree(workingValues, statements);
        this.createSynchronizedTree(workingValues, statements);
        this.createTryStatementTree(workingValues, statements);
        this.createCatchTree(workingValues, statements);
        this.createAssertTree(workingValues, statements);
        this.createReturnTree(workingValues, statements);
        this.createThrowTree(workingValues, statements);
        InnerNode expressions = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_expressions);
        this.createFunctionCallTree(workingValues, expressions);
        this.createAssignmentTree(workingValues, expressions);
        this.createOperatorTree(workingValues, expressions);
        this.createParenthesizedExpressionTree(workingValues, expressions);
        this.createTypecastTree(workingValues, expressions);
        this.createConditionalTree(workingValues, expressions);
        InnerNode arrays = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_arrays);
        this.createArrayDeclarationTree(workingValues, arrays);
        this.createArrayAllocTree(workingValues, arrays);
        this.createArrayInitializerTree(workingValues, arrays);
        this.createArrayElementAccessTree(workingValues, arrays);
        InnerNode paramtypes = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_parameterized_types);
        this.createParameterizedTypeTree(workingValues, paramtypes);
        this.createTypeArgumentTree(workingValues, paramtypes);
        this.createTypeParameterTree(workingValues, paramtypes);
        this.createWildcardTypeTree(workingValues, paramtypes);
        ArrayList<Node> roots = new ArrayList<Node>();
        roots.add(declarations);
        roots.add(statements);
        roots.add(expressions);
        roots.add(arrays);
        roots.add(paramtypes);
        return roots;
    }

    private void createBeforeQuestionTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.jdt.core.formatter.insert_space_before_question_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_wildcard, "org.eclipse.jdt.core.formatter.insert_space_before_question_in_wildcard", this.WILDCARD_PREVIEW);
    }

    private void createBeforeAtTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type, "org.eclipse.jdt.core.formatter.insert_space_before_at_in_annotation_type_declaration", this.ANNOTATION_DECL_PREVIEW);
    }

    private void createBeforeAndTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_before_and_in_type_parameter", this.TYPE_PARAMETER_PREVIEW);
    }

    private void createBeforeSemicolonTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_try, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon_in_try_resources", this.TRY_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_statements, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon", this.SEMICOLON_PREVIEW);
    }

    private void createBeforeColonTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assert, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_assert", this.ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_label, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_labeled_statement", this.LABEL_PREVIEW);
        InnerNode switchStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_case, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_case", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_default, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_default", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_for", this.FOR_PREVIEW);
    }

    private void createBeforeCommaTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode forStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_initialization, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_inits", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_incrementation, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_increments", this.FOR_PREVIEW);
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arguments);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_explicit_constructor_call, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_explicitconstructorcall_arguments", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_alloc_expr, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_allocation_expression", this.ALLOC_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameters);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_parameters", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        InnerNode throwsDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throws);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_throws", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_throws", this.METHOD_DECL_PREVIEW);
        InnerNode multDecls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_mult_decls);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_fields, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_field_declarations", this.MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_local_vars, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_local_declarations", this.MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_implements_clause, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_superinterfaces", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_declaration, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_enum_declarations", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_enum_constant_arguments", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
    }

    private void createBeforeOperatorTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.jdt.core.formatter.insert_space_before_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.jdt.core.formatter.insert_space_before_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.jdt.core.formatter.insert_space_before_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.jdt.core.formatter.insert_space_before_postfix_operator", this.OPERATOR_PREVIEW);
    }

    private void createBeforeClosingBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
    }

    private void createBeforeClosingAngleBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
    }

    private void createBeforeOpenBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_type_reference", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
    }

    private void createBeforeOpenAngleBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
    }

    private void createBeforeClosingBraceTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_init, "org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", this.CLASS_DECL_PREVIEW);
    }

    private void createBeforeOpenBraceTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_class_decl, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_anon_class_decl, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_anonymous_type_declaration", this.ANON_CLASS_PREVIEW);
        InnerNode functionDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(functionDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(functionDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block", this.BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_declaration, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_enum_declaration", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_body, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_annotation_type_declaration", this.ANNOTATION_DECL_PREVIEW);
    }

    private void createBeforeClosingParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_try, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_try", this.TRY_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_synchronized, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_synchronized", this.SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_cast", this.CAST_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier_args, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
    }

    private void createBeforeOpenParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_try, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_try", this.TRY_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_synchronized, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_synchronized", this.SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_return_with_parenthesized_expression, "org.eclipse.jdt.core.formatter.insert_space_before_parenthesized_expression_in_return", this.RETURN_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throw_with_parenthesized_expression, "org.eclipse.jdt.core.formatter.insert_space_before_parenthesized_expression_in_throw", this.THROW_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier_args, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type_member, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_annotation_type_member_declaration", this.ANNOTATION_DECL_PREVIEW);
    }

    private void createAfterQuestionTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.jdt.core.formatter.insert_space_after_question_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_wildcard, "org.eclipse.jdt.core.formatter.insert_space_after_question_in_wildcard", this.WILDCARD_PREVIEW);
    }

    private void createAfterAtTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier, "org.eclipse.jdt.core.formatter.insert_space_after_at_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type, "org.eclipse.jdt.core.formatter.insert_space_after_at_in_annotation_type_declaration", this.ANNOTATION_DECL_PREVIEW);
    }

    private void createAfterAndTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_after_and_in_type_parameter", this.TYPE_PARAMETER_PREVIEW);
    }

    private void createBeforeEllipsis(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_vararg_parameter, "org.eclipse.jdt.core.formatter.insert_space_before_ellipsis", this.VARARG_PARAMETER_PREVIEW);
    }

    private void createAfterEllipsis(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_vararg_parameter, "org.eclipse.jdt.core.formatter.insert_space_after_ellipsis", this.VARARG_PARAMETER_PREVIEW);
    }

    private void createAfterSemicolonTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_after_semicolon_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_try, "org.eclipse.jdt.core.formatter.insert_space_after_semicolon_in_try_resources", this.TRY_PREVIEW);
    }

    private void createAfterColonTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assert, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_assert", this.ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_label, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_labeled_statement", this.LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_for", this.FOR_PREVIEW);
    }

    private void createAfterCommaTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode forStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_initialization, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_inits", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_incrementation, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_increments", this.FOR_PREVIEW);
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arguments);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_explicit_constructor_call, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_explicitconstructorcall_arguments", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_alloc_expr, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_allocation_expression", this.ALLOC_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameters);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_parameters", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        InnerNode throwsDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throws);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_throws", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_throws", this.METHOD_DECL_PREVIEW);
        InnerNode multDecls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_mult_decls);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_fields, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_field_declarations", this.MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_local_vars, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_local_declarations", this.MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_implements_clause, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_superinterfaces", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_declaration, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_enum_declarations", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_enum_constant_arguments", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier_args, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
    }

    private void createAfterOperatorTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.jdt.core.formatter.insert_space_after_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.jdt.core.formatter.insert_space_after_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.jdt.core.formatter.insert_space_after_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.jdt.core.formatter.insert_space_after_postfix_operator", this.OPERATOR_PREVIEW);
    }

    private void createAfterOpenBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
    }

    private void createAfterOpenAngleBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
    }

    private void createAfterOpenBraceTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", this.ARRAY_DECL_PREVIEW);
    }

    private void createAfterCloseBraceTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.jdt.core.formatter.insert_space_after_closing_brace_in_block", this.BLOCK_PREVIEW);
    }

    private void createAfterCloseParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.jdt.core.formatter.insert_space_after_closing_paren_in_cast", this.CAST_PREVIEW);
    }

    private void createAfterClosingAngleBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
    }

    private void createAfterOpenParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_try, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_try", this.TRY_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_synchronized, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_synchronized", this.SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_while", this.WHILE_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_cast", this.CAST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier_args, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
    }

    private void createBetweenEmptyParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_constructor_decl, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type_member, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration", this.ANNOTATION_DECL_PREVIEW);
    }

    private void createBetweenEmptyBracketsTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.jdt.core.formatter.insert_space_between_empty_brackets_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.jdt.core.formatter.insert_space_between_brackets_in_array_type_reference", this.ARRAY_DECL_PREVIEW);
    }

    private void createBetweenEmptyBracesTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", this.ARRAY_DECL_PREVIEW);
    }

    private InnerNode createClassTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_classes);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_opening_brace_of_a_class, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_opening_brace_of_anon_class, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_anonymous_type_declaration", this.ANON_CLASS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_comma_implements, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_superinterfaces", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_after_comma_implements, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_superinterfaces", this.CLASS_DECL_PREVIEW);
        return root;
    }

    private InnerNode createAssignmentTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_before_assignment_operator, "org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_after_assignment_operator, "org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", this.OPERATOR_PREVIEW);
        return root;
    }

    private InnerNode createOperatorTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_operators);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_binary_operators, "org.eclipse.jdt.core.formatter.insert_space_before_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_binary_operators, "org.eclipse.jdt.core.formatter.insert_space_after_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_unary_operators, "org.eclipse.jdt.core.formatter.insert_space_before_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_unary_operators, "org.eclipse.jdt.core.formatter.insert_space_after_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_prefix_operators, "org.eclipse.jdt.core.formatter.insert_space_before_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_prefix_operators, "org.eclipse.jdt.core.formatter.insert_space_after_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_postfix_operators, "org.eclipse.jdt.core.formatter.insert_space_before_postfix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_postfix_operators, "org.eclipse.jdt.core.formatter.insert_space_after_postfix_operator", this.OPERATOR_PREVIEW);
        return root;
    }

    private InnerNode createMethodDeclTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_methods);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_ellipsis, "org.eclipse.jdt.core.formatter.insert_space_before_ellipsis", this.VARARG_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_ellipsis, "org.eclipse.jdt.core.formatter.insert_space_after_ellipsis", this.VARARG_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_throws, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_throws", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_throws, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_throws", this.METHOD_DECL_PREVIEW);
        return root;
    }

    private InnerNode createConstructorTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_constructors);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_constructor_declaration", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_parameters", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_parameters", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_throws, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_throws", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_throws, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_throws", this.CONSTRUCTOR_DECL_PREVIEW);
        return root;
    }

    private InnerNode createFieldTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_fields);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fields_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_field_declarations", this.MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fields_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_field_declarations", this.MULT_LOCAL_PREVIEW);
        return root;
    }

    private InnerNode createLocalVariableTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_local_declarations", this.MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_local_declarations", this.MULT_LOCAL_PREVIEW);
        return root;
    }

    private InnerNode createArrayInitializerTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayinit);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_brace, "org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_braces, "org.eclipse.jdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", this.ARRAY_DECL_PREVIEW);
        return root;
    }

    private InnerNode createArrayDeclarationTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arraydecls);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_type_reference", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_brackets, "org.eclipse.jdt.core.formatter.insert_space_between_brackets_in_array_type_reference", this.ARRAY_DECL_PREVIEW);
        return root;
    }

    private InnerNode createArrayElementAccessTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayelem);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_reference", this.ARRAY_REF_PREVIEW);
        return root;
    }

    private InnerNode createArrayAllocTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayalloc);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_brackets, "org.eclipse.jdt.core.formatter.insert_space_between_empty_brackets_in_array_allocation_expression", this.ARRAY_DECL_PREVIEW);
        return root;
    }

    private InnerNode createFunctionCallTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_calls);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_method_args, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_method_args, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_alloc, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_allocation_expression", this.ALLOC_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_alloc, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_allocation_expression", this.ALLOC_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_qalloc, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_explicitconstructorcall_arguments", this.CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_qalloc, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_explicitconstructorcall_arguments", this.CONSTRUCTOR_DECL_PREVIEW);
        return root;
    }

    private InnerNode createBlockTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_blocks);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block", this.BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_brace, "org.eclipse.jdt.core.formatter.insert_space_after_closing_brace_in_block", this.BLOCK_PREVIEW);
        return root;
    }

    private InnerNode createSwitchStatementTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_switch);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_case_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_case", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_default_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_default", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_switch", this.SWITCH_PREVIEW);
        return root;
    }

    private InnerNode createDoWhileTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_do);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_while", this.WHILE_PREVIEW);
        return root;
    }

    private InnerNode createSynchronizedTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_synchronized);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_synchronized", this.SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_synchronized", this.SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_synchronized", this.SYNCHRONIZED_PREVIEW);
        return root;
    }

    private InnerNode createCatchTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_catch);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_catch", this.CATCH_PREVIEW);
        return root;
    }

    private InnerNode createTryStatementTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_tryWithResources);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_try", this.TRY_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_try", this.TRY_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_semicolon, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon_in_try_resources", this.TRY_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_semicolon, "org.eclipse.jdt.core.formatter.insert_space_after_semicolon_in_try_resources", this.TRY_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_try", this.TRY_PREVIEW);
        return root;
    }

    private InnerNode createIfStatementTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_if);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_if", this.IF_PREVIEW);
        return root;
    }

    private InnerNode createForStatementTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_for);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_before_comma_init, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_inits", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_after_comma_init, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_inits", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_before_comma_inc, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_increments", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_after_comma_inc, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_increments", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_semicolon, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_semicolon, "org.eclipse.jdt.core.formatter.insert_space_after_semicolon_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_for", this.FOR_PREVIEW);
        return root;
    }

    private InnerNode createAssertTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_assert);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_assert", this.ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_assert", this.ASSERT_PREVIEW);
        return root;
    }

    private InnerNode createReturnTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceOptions_return);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_parenthesized_expressions, "org.eclipse.jdt.core.formatter.insert_space_before_parenthesized_expression_in_return", this.RETURN_PREVIEW);
        return root;
    }

    private InnerNode createThrowTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throw);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_parenthesized_expressions, "org.eclipse.jdt.core.formatter.insert_space_before_parenthesized_expression_in_throw", this.THROW_PREVIEW);
        return root;
    }

    private InnerNode createLabelTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_labels);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_labeled_statement", this.LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_labeled_statement", this.LABEL_PREVIEW);
        return root;
    }

    private InnerNode createAnnotationTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_annotations);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_at, "org.eclipse.jdt.core.formatter.insert_space_after_at_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_annotation", this.ANNOTATION_MODIFIER_PREVIEW);
        return root;
    }

    private InnerNode createAnnotationTypeTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_annotation_types);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_at, "org.eclipse.jdt.core.formatter.insert_space_before_at_in_annotation_type_declaration", this.ANNOTATION_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_at, "org.eclipse.jdt.core.formatter.insert_space_after_at_in_annotation_type_declaration", this.ANNOTATION_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_annotation_type_declaration", this.ANNOTATION_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_annot_type_method_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_annotation_type_member_declaration", this.ANNOTATION_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_annot_type_method_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration", this.ANNOTATION_DECL_PREVIEW);
        return root;
    }

    private InnerNode createEnumTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_enums);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_decl_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_enum_declaration", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_decl_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_enum_declarations", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_decl_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_enum_declarations", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_enum_constant_arguments", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_enum_constant_arguments", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_enum_constant", this.ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_enum_constant", this.ENUM_PREVIEW);
        return root;
    }

    private InnerNode createParameterizedTypeTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_param_type_ref);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", this.PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", this.PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", this.PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", this.PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", this.PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        return root;
    }

    private InnerNode createTypeArgumentTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_type_arguments);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_arguments", this.TYPE_ARGUMENTS_PREVIEW);
        return root;
    }

    private InnerNode createTypeParameterTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_type_parameters);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_parameters", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_and_list, "org.eclipse.jdt.core.formatter.insert_space_before_and_in_type_parameter", this.TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_and_list, "org.eclipse.jdt.core.formatter.insert_space_after_and_in_type_parameter", this.TYPE_PARAMETER_PREVIEW);
        return root;
    }

    private InnerNode createWildcardTypeTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_wildcardtype);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_question, "org.eclipse.jdt.core.formatter.insert_space_before_question_in_wildcard", this.WILDCARD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_question, "org.eclipse.jdt.core.formatter.insert_space_after_question_in_wildcard", this.WILDCARD_PREVIEW);
        return root;
    }

    private InnerNode createConditionalTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_conditionals);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_question, "org.eclipse.jdt.core.formatter.insert_space_before_question_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_question, "org.eclipse.jdt.core.formatter.insert_space_after_question_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        return root;
    }

    private InnerNode createTypecastTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_typecasts);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_cast", this.CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_cast", this.CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_after_closing_paren_in_cast", this.CAST_PREVIEW);
        return root;
    }

    private InnerNode createParenthesizedExpressionTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_parenexpr);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        return root;
    }

    private static InnerNode createChild(InnerNode root, Map<String, String> workingValues, String message) {
        return new InnerNode(root, workingValues, message);
    }

    private static OptionNode createOption(InnerNode root, Map<String, String> workingValues, String message, String key, SnippetPreview.PreviewSnippet snippet) {
        return new OptionNode(root, workingValues, message, key, snippet);
    }

    public static void makeIndexForNodes(List<Node> tree, List<Node> flatList) {
        for (Node node : tree) {
            node.index = flatList.size();
            flatList.add(node);
            WhiteSpaceOptions.makeIndexForNodes(node.getChildren(), flatList);
        }
    }

    public static class InnerNode
    extends Node {
        public InnerNode(InnerNode parent, Map<String, String> workingValues, String messageKey) {
            super(parent, workingValues, messageKey);
        }

        @Override
        public void setChecked(boolean checked) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).setChecked(checked);
            }
        }

        public void add(Node child) {
            this.fChildren.add(child);
        }

        @Override
        public List<SnippetPreview.PreviewSnippet> getSnippets() {
            ArrayList<SnippetPreview.PreviewSnippet> snippets = new ArrayList<SnippetPreview.PreviewSnippet>(this.fChildren.size());
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                List<SnippetPreview.PreviewSnippet> childSnippets = ((Node)iter.next()).getSnippets();
                for (SnippetPreview.PreviewSnippet snippet : childSnippets) {
                    if (snippets.contains(snippet)) continue;
                    snippets.add(snippet);
                }
            }
            return snippets;
        }

        @Override
        public void getCheckedLeafs(List<OptionNode> list) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).getCheckedLeafs(list);
            }
        }
    }

    public static abstract class Node {
        private final InnerNode fParent;
        private final String fName;
        public int index;
        protected final Map<String, String> fWorkingValues;
        protected final ArrayList<Node> fChildren;

        public Node(InnerNode parent, Map<String, String> workingValues, String message) {
            if (workingValues == null || message == null) {
                throw new IllegalArgumentException();
            }
            this.fParent = parent;
            this.fWorkingValues = workingValues;
            this.fName = message;
            this.fChildren = new ArrayList();
            if (this.fParent != null) {
                this.fParent.add(this);
            }
        }

        public abstract void setChecked(boolean var1);

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public List<Node> getChildren() {
            return Collections.unmodifiableList(this.fChildren);
        }

        public InnerNode getParent() {
            return this.fParent;
        }

        public final String toString() {
            return this.fName;
        }

        public abstract List<SnippetPreview.PreviewSnippet> getSnippets();

        public abstract void getCheckedLeafs(List<OptionNode> var1);
    }

    public static class OptionNode
    extends Node {
        private final String fKey;
        private final ArrayList<SnippetPreview.PreviewSnippet> fSnippets;

        public OptionNode(InnerNode parent, Map<String, String> workingValues, String messageKey, String key, SnippetPreview.PreviewSnippet snippet) {
            super(parent, workingValues, messageKey);
            this.fKey = key;
            this.fSnippets = new ArrayList(1);
            this.fSnippets.add(snippet);
        }

        @Override
        public void setChecked(boolean checked) {
            this.fWorkingValues.put(this.fKey, checked ? "insert" : "do not insert");
        }

        public boolean getChecked() {
            return "insert".equals(this.fWorkingValues.get(this.fKey));
        }

        @Override
        public List<SnippetPreview.PreviewSnippet> getSnippets() {
            return this.fSnippets;
        }

        @Override
        public void getCheckedLeafs(List<OptionNode> list) {
            if (this.getChecked()) {
                list.add(this);
            }
        }
    }
}

