/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.preferences.ImportOrganizeConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ImportOrganizeInputDialog
extends StatusDialog {
    private StringButtonDialogField fNameDialogField;
    private SelectionButtonDialogField fBrowseTypeButton;
    private List<ImportOrganizeConfigurationBlock.ImportOrderEntry> fExistingEntries;
    private final boolean fIsStatic;

    public ImportOrganizeInputDialog(Shell parent, List<ImportOrganizeConfigurationBlock.ImportOrderEntry> existingEntries, boolean isStatic) {
        super(parent);
        String label;
        String title;
        this.fIsStatic = isStatic;
        this.fExistingEntries = existingEntries;
        if (isStatic) {
            title = PreferencesMessages.ImportOrganizeInputDialog_title_static;
            label = PreferencesMessages.ImportOrganizeInputDialog_name_group_static_label;
        } else {
            title = PreferencesMessages.ImportOrganizeInputDialog_title;
            label = PreferencesMessages.ImportOrganizeInputDialog_name_group_label;
        }
        this.setTitle(title);
        ImportOrganizeInputAdapter adapter = new ImportOrganizeInputAdapter();
        this.fNameDialogField = new StringButtonDialogField(adapter);
        this.fNameDialogField.setLabelText(label);
        this.fNameDialogField.setButtonLabel(PreferencesMessages.ImportOrganizeInputDialog_browse_packages_button);
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText("");
        this.fBrowseTypeButton = new SelectionButtonDialogField(8);
        this.fBrowseTypeButton.setLabelText(PreferencesMessages.ImportOrganizeInputDialog_browse_types_label);
        this.fBrowseTypeButton.setDialogFieldListener(adapter);
    }

    protected boolean isResizable() {
        return true;
    }

    public void setInitialSelection(ImportOrganizeConfigurationBlock.ImportOrderEntry editedEntry) {
        Assert.isNotNull((Object)editedEntry);
        if (editedEntry.name.length() == 0) {
            this.fNameDialogField.setText("");
        } else {
            this.fNameDialogField.setText(editedEntry.name);
        }
    }

    public ImportOrganizeConfigurationBlock.ImportOrderEntry getResult() {
        String val = this.fNameDialogField.getText();
        if ("*".equals(val)) {
            return new ImportOrganizeConfigurationBlock.ImportOrderEntry("", this.fIsStatic);
        }
        return new ImportOrganizeConfigurationBlock.ImportOrderEntry(val, this.fIsStatic);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        this.fNameDialogField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fNameDialogField.getLabelControl(null), 2);
        int fieldWidthHint = this.convertWidthInCharsToPixels(60);
        Text text = this.fNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, fieldWidthHint);
        LayoutUtil.setHorizontalGrabbing((Control)text);
        BidiUtils.applyBidiProcessing((Text)text, (String)"java");
        TextFieldNavigationHandler.install(text);
        DialogField.createEmptySpace(composite, 1);
        this.fBrowseTypeButton.doFillIntoGrid(composite, 1);
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        ImportOrganizeInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    final void doBrowsePackages() {
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        int style = 7;
        PackageSelectionDialog dialog = new PackageSelectionDialog(this.getShell(), context, style, scope);
        dialog.setFilter(this.fNameDialogField.getText());
        dialog.setIgnoreCase(false);
        dialog.setTitle(PreferencesMessages.ImportOrganizeInputDialog_ChoosePackageDialog_title);
        dialog.setMessage(PreferencesMessages.ImportOrganizeInputDialog_ChoosePackageDialog_description);
        dialog.setEmptyListMessage(PreferencesMessages.ImportOrganizeInputDialog_ChoosePackageDialog_empty);
        if (dialog.open() == 0) {
            IPackageFragment res = (IPackageFragment)dialog.getFirstResult();
            this.fNameDialogField.setText(res.getElementName());
        }
    }

    private void doBrowseTypes() {
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        int style = 256;
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog(this.getShell(), context, scope, style, false, this.fNameDialogField.getText());
            dialog.setTitle(PreferencesMessages.ImportOrganizeInputDialog_ChooseTypeDialog_title);
            dialog.setMessage(PreferencesMessages.ImportOrganizeInputDialog_ChooseTypeDialog_description);
            if (dialog.open() == 0) {
                IType res = (IType)dialog.getResult()[0];
                this.fNameDialogField.setText(res.getFullyQualifiedName('.'));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), PreferencesMessages.ImportOrganizeInputDialog_ChooseTypeDialog_title, PreferencesMessages.ImportOrganizeInputDialog_ChooseTypeDialog_error_message);
        }
    }

    final void doDialogFieldChanged(DialogField field) {
        if (field == this.fBrowseTypeButton) {
            this.doBrowseTypes();
        } else {
            this.doValidation();
        }
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status.setError("");
        } else if (newText.equals("*")) {
            if (this.doesExist("", this.fIsStatic)) {
                status.setError(PreferencesMessages.ImportOrganizeInputDialog_error_entryExists);
            }
        } else {
            IStatus val = JavaConventions.validateJavaTypeName((String)newText, (String)"1.3", (String)"1.3");
            if (val.matches(4)) {
                status.setError(PreferencesMessages.ImportOrganizeInputDialog_error_invalidName);
            } else if (this.doesExist(newText, this.fIsStatic)) {
                status.setError(PreferencesMessages.ImportOrganizeInputDialog_error_entryExists);
            }
        }
        this.updateStatus(status);
    }

    private boolean doesExist(String name, boolean isStatic) {
        int i = 0;
        while (i < this.fExistingEntries.size()) {
            ImportOrganizeConfigurationBlock.ImportOrderEntry entry = this.fExistingEntries.get(i);
            if (name.equals(entry.name) && isStatic == entry.isStatic) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.import_organize_input_dialog_context");
    }

    private class ImportOrganizeInputAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private ImportOrganizeInputAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ImportOrganizeInputDialog.this.doDialogFieldChanged(field);
        }

        @Override
        public void changeControlPressed(DialogField field) {
            ImportOrganizeInputDialog.this.doBrowsePackages();
        }
    }
}

