/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditorInputFactory;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;

public class InternalClassFileEditorInput
implements IClassFileEditorInput,
IPersistableElement,
IPathEditorInput {
    private IClassFile fClassFile;
    private IPath fPath;

    public InternalClassFileEditorInput(IClassFile classFile) {
        this.fClassFile = classFile;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InternalClassFileEditorInput)) {
            return false;
        }
        InternalClassFileEditorInput other = (InternalClassFileEditorInput)obj;
        return this.fClassFile.equals(other.fClassFile);
    }

    public int hashCode() {
        return this.fClassFile.hashCode();
    }

    @Override
    public IClassFile getClassFile() {
        return this.fClassFile;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getName() {
        return this.fClassFile.getElementName();
    }

    public String getToolTipText() {
        return this.fClassFile.getType().getFullyQualifiedName();
    }

    public ImageDescriptor getImageDescriptor() {
        try {
            if (this.fClassFile.isClass()) {
                return JavaPluginImages.DESC_OBJS_CFILECLASS;
            }
            return JavaPluginImages.DESC_OBJS_CFILEINT;
        }
        catch (JavaModelException javaModelException) {
            return JavaPluginImages.DESC_OBJS_CFILE;
        }
    }

    public boolean exists() {
        return this.fClassFile.exists();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IClassFile.class) {
            return this.fClassFile;
        }
        if (adapter == IJavaElement.class) {
            return this.fClassFile;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        ClassFileEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.eclipse.jdt.ui.ClassFileEditorInputFactory";
    }

    public IPath getPath() {
        if (this.fPath == null) {
            this.fPath = InternalClassFileEditorInput.writeToTempFile(this.fClassFile);
        }
        return this.fPath;
    }

    private static IPath writeToTempFile(IClassFile classFile) {
        FileOutputStream writer = null;
        try {
            File file = File.createTempFile(classFile.getElementName(), ".class");
            byte[] bytes = classFile.getBytes();
            writer = new FileOutputStream(file);
            writer.write(bytes);
            Path path = new Path(file.toString());
            return path;
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        catch (CoreException e) {
            JavaPlugin.log(e.getStatus());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        throw new IllegalArgumentException("Could not create temporary file.");
    }
}

