/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.GenerateToStringOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringTemplateParser;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class GenerateToStringDialog
extends SourceActionDialog {
    private ToStringGenerationSettings fGenerationSettings;
    private static final int DOWN_BUTTON = 1026;
    private static final int UP_BUTTON = 1025;
    private static final int SORT_BUTTON = 1027;
    protected Button[] fButtonControls;
    boolean[] fButtonsEnabled;
    private static final int DOWN_INDEX = 1;
    private static final int UP_INDEX = 0;
    private Label formatLabel;
    private Combo formatCombo;
    private Button skipNullsButton;
    private Button styleButton;

    public ToStringGenerationSettings getGenerationSettings() {
        return this.fGenerationSettings;
    }

    public static String[] getTemplates(IDialogSettings dialogSettings) {
        String[] result = dialogSettings.getArray("ToStringTemplates");
        if (result != null && result.length > 0) {
            return result;
        }
        return new String[]{"${object.className} [${member.name()}=${member.value}, ${otherMembers}]"};
    }

    public String[] getTemplateNames() {
        String[] result = this.getDialogSettings().getArray("ToStringTemplateNames");
        if (result != null && result.length > 0) {
            return result;
        }
        return new String[]{JavaUIMessages.GenerateToStringDialog_defaultTemplateName};
    }

    public int getSelectedTemplate() {
        int result;
        block3: {
            try {
                result = this.getDialogSettings().getInt("ToStringTemplateSelected");
                if (result >= 0) break block3;
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return result;
    }

    public void setSelectedTemplate(int templateNumber) {
        this.getDialogSettings().put("ToStringTemplateSelected", templateNumber);
    }

    public GenerateToStringDialog(Shell shell, CompilationUnitEditor editor, IType type, IVariableBinding[] fields, IVariableBinding[] inheritedFields, IVariableBinding[] selectedFields, IMethodBinding[] methods, IMethodBinding[] inheritededMethods) throws JavaModelException {
        super(shell, (ILabelProvider)new BindingLabelProvider(), new GenerateToStringContentProvider(fields, inheritedFields, methods, inheritededMethods), editor, type, false);
        this.setEmptyListMessage(JavaUIMessages.GenerateHashCodeEqualsDialog_no_entries);
        ArrayList<IVariableBinding> selected = new ArrayList<IVariableBinding>(Arrays.asList(selectedFields));
        if (selectedFields.length == fields.length && selectedFields.length > 0) {
            selected.add((IVariableBinding)this.getContentProvider().getParent((Object)selectedFields[0]));
        }
        this.setInitialElementSelections(selected);
        this.setTitle(JavaUIMessages.GenerateToStringDialog_dialog_title);
        this.setMessage(JavaUIMessages.GenerateToStringDialog_select_fields_to_include);
        this.setValidator(new GenerateToStringValidator(fields.length + inheritedFields.length, methods.length + inheritededMethods.length));
        this.setSize(60, 18);
        this.setInput(new Object());
        this.fGenerationSettings = new ToStringGenerationSettings(this.getDialogSettings());
    }

    @Override
    public boolean close() {
        this.fGenerationSettings.writeDialogSettings();
        this.fGenerationSettings.stringFormatTemplate = GenerateToStringDialog.getTemplates(this.getDialogSettings())[this.fGenerationSettings.stringFormatTemplateNumber];
        this.fGenerationSettings.createComments = this.getGenerateComment();
        return super.close();
    }

    public Object[] getResult() {
        Object[] oldResult = super.getResult();
        ArrayList<Object> newResult = new ArrayList<Object>();
        int i = 0;
        while (i < oldResult.length) {
            if (!(oldResult[i] instanceof String)) {
                newResult.add(oldResult[i]);
            }
            ++i;
        }
        return newResult.toArray();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.to_string_tree_selection_dialog_context");
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
        treeViewer.setLabelProvider((IBaseLabelProvider)new GenerateToStringLabelProvider());
        treeViewer.expandAll();
        treeViewer.collapseAll();
        treeViewer.expandToLevel((Object)GenerateToStringContentProvider.fieldsNode, 1);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)GenerateToStringDialog.this.getTreeViewer().getSelection();
                Object selected = selection.size() > 0 ? selection.toList().get(0) : null;
                GenerateToStringContentProvider cp = (GenerateToStringContentProvider)GenerateToStringDialog.this.getContentProvider();
                GenerateToStringDialog.this.fButtonControls[0].setEnabled(cp.canMoveUp(selected));
                GenerateToStringDialog.this.fButtonControls[1].setEnabled(cp.canMoveDown(selected));
            }
        });
        treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GenerateToStringDialog.this.getTreeViewer().setSubtreeChecked(event.getElement(), event.getChecked());
                GenerateToStringDialog.this.getTreeViewer().setGrayed(event.getElement(), false);
                Object parentElement = ((ITreeContentProvider)GenerateToStringDialog.this.getTreeViewer().getContentProvider()).getParent(event.getElement());
                if (parentElement != null) {
                    Object[] siblings = ((ITreeContentProvider)GenerateToStringDialog.this.getTreeViewer().getContentProvider()).getChildren(parentElement);
                    int count = 0;
                    int i = 0;
                    while (i < siblings.length) {
                        if (GenerateToStringDialog.this.getTreeViewer().getChecked(siblings[i])) {
                            ++count;
                        }
                        ++i;
                    }
                    if (count == 0) {
                        GenerateToStringDialog.this.getTreeViewer().setGrayChecked(parentElement, false);
                    } else if (count == siblings.length) {
                        GenerateToStringDialog.this.getTreeViewer().setChecked(parentElement, true);
                        GenerateToStringDialog.this.getTreeViewer().setGrayed(parentElement, false);
                    } else {
                        GenerateToStringDialog.this.getTreeViewer().setGrayChecked(parentElement, true);
                    }
                }
                GenerateToStringDialog.this.updateOKStatus();
            }
        });
        return treeViewer;
    }

    @Override
    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = super.createSelectionButtons(composite);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        this.createUpDownButtons(buttonComposite);
        this.createButton(buttonComposite, 1027, JavaUIMessages.GenerateToStringDialog_sort_button, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        return buttonComposite;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        switch (buttonId) {
            case 1025: {
                GenerateToStringContentProvider contentProvider = (GenerateToStringContentProvider)this.getTreeViewer().getContentProvider();
                List selection = ((IStructuredSelection)this.getTreeViewer().getSelection()).toList();
                if (selection.size() > 0) {
                    contentProvider.up(selection.get(0), this.getTreeViewer());
                }
                this.updateOKStatus();
                break;
            }
            case 1026: {
                GenerateToStringContentProvider contentProvider = (GenerateToStringContentProvider)this.getTreeViewer().getContentProvider();
                List selection = ((IStructuredSelection)this.getTreeViewer().getSelection()).toList();
                if (selection.size() > 0) {
                    contentProvider.down(selection.get(0), this.getTreeViewer());
                }
                this.updateOKStatus();
                break;
            }
            case 1027: {
                GenerateToStringContentProvider contentProvider = (GenerateToStringContentProvider)this.getTreeViewer().getContentProvider();
                contentProvider.sort();
                this.getTreeViewer().refresh();
                this.updateOKStatus();
            }
        }
    }

    protected void createUpDownButtons(Composite buttonComposite) {
        int numButtons = 2;
        this.fButtonControls = new Button[numButtons];
        this.fButtonsEnabled = new boolean[numButtons];
        this.fButtonControls[0] = this.createButton(buttonComposite, 1025, JavaUIMessages.GenerateToStringDialog_up_button, false);
        this.fButtonControls[1] = this.createButton(buttonComposite, 1026, JavaUIMessages.GenerateToStringDialog_down_button, false);
        boolean defaultState = false;
        this.fButtonControls[0].setEnabled(defaultState);
        this.fButtonControls[1].setEnabled(defaultState);
        this.fButtonsEnabled[0] = defaultState;
        this.fButtonsEnabled[1] = defaultState;
    }

    @Override
    protected Composite createCommentSelection(Composite parentComposite) {
        Composite composite = super.createCommentSelection(parentComposite);
        Group group = new Group(parentComposite, 0);
        group.setText(JavaUIMessages.GenerateToStringDialog_generated_code_group);
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite2 = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite2.setLayout((Layout)layout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.formatLabel = new Label(composite2, 0);
        this.formatLabel.setText(JavaUIMessages.GenerateToStringDialog_string_format_combo);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        this.formatLabel.setLayoutData((Object)gridData);
        this.formatCombo = new Combo(composite2, 8);
        this.formatCombo.setItems(this.getTemplateNames());
        this.formatCombo.select(this.fGenerationSettings.stringFormatTemplateNumber);
        this.formatCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SWTUtil.setDefaultVisibleItemCount(this.formatCombo);
        this.formatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((GenerateToStringDialog)GenerateToStringDialog.this).fGenerationSettings.stringFormatTemplateNumber = ((Combo)e.widget).getSelectionIndex();
            }
        });
        Button formatButton = new Button(composite2, 0);
        formatButton.setText(JavaUIMessages.GenerateToStringDialog_manage_templates_button);
        this.setButtonLayoutData(formatButton);
        formatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateToStringDialog.this.manageTemplatesButtonSelected();
            }
        });
        Label styleLabel = new Label(composite2, 0);
        styleLabel.setText(JavaUIMessages.GenerateToStringDialog_code_style_combo);
        gridData = new GridData(4, 0x1000000, false, false);
        styleLabel.setLayoutData((Object)gridData);
        Combo styleCombo = new Combo(composite2, 8);
        styleCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        styleCombo.setItems(GenerateToStringOperation.getStyleNames());
        styleCombo.select(Math.min(this.fGenerationSettings.toStringStyle, styleCombo.getItemCount() - 1));
        SWTUtil.setDefaultVisibleItemCount(styleCombo);
        styleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateToStringDialog.this.changeToStringStyle(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.styleButton = new Button(composite2, 0);
        this.styleButton.setText(JavaUIMessages.GenerateToStringDialog_codeStyleConfigureButton);
        this.setButtonLayoutData(this.styleButton);
        this.styleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateToStringDialog.this.configureStyleButtonSelected();
            }
        });
        this.skipNullsButton = new Button((Composite)group, 32);
        this.skipNullsButton.setText(JavaUIMessages.GenerateToStringDialog_skip_null_button);
        this.skipNullsButton.setSelection(this.fGenerationSettings.skipNulls);
        this.skipNullsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((GenerateToStringDialog)GenerateToStringDialog.this).fGenerationSettings.skipNulls = ((Button)event.widget).getSelection();
            }
        });
        Button arrayButton = new Button((Composite)group, 32);
        arrayButton.setText(JavaUIMessages.GenerateToStringDialog_ignore_default_button);
        arrayButton.setSelection(this.fGenerationSettings.customArrayToString);
        arrayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((GenerateToStringDialog)GenerateToStringDialog.this).fGenerationSettings.customArrayToString = ((Button)e.widget).getSelection();
            }
        });
        Composite limitRow = new Composite((Composite)group, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.center = true;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        limitRow.setLayout((Layout)rowLayout);
        Button limitButton = new Button(limitRow, 32);
        limitButton.setText(JavaUIMessages.GenerateToStringDialog_limit_elements_button);
        limitButton.setSelection(this.fGenerationSettings.limitElements);
        limitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((GenerateToStringDialog)GenerateToStringDialog.this).fGenerationSettings.limitElements = ((Button)e.widget).getSelection();
            }
        });
        Spinner limitSpinner = new Spinner(limitRow, 2048);
        limitSpinner.setMinimum(0);
        limitSpinner.setSelection(this.fGenerationSettings.limitValue);
        limitSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((GenerateToStringDialog)GenerateToStringDialog.this).fGenerationSettings.limitValue = ((Spinner)e.widget).getSelection();
            }
        });
        this.changeToStringStyle(styleCombo.getSelectionIndex());
        return composite;
    }

    private void manageTemplatesButtonSelected() {
        ToStringTemplatesDialog dialog = new ToStringTemplatesDialog(this.getShell(), GenerateToStringOperation.createTemplateParser(this.fGenerationSettings.toStringStyle));
        dialog.open();
        this.formatCombo.setItems(this.getTemplateNames());
        this.formatCombo.select(Math.min(this.fGenerationSettings.stringFormatTemplateNumber, this.formatCombo.getItemCount() - 1));
    }

    private void configureStyleButtonSelected() {
        CustomBuilderConfigurationDialog dialog = new CustomBuilderConfigurationDialog(this.getShell());
        dialog.open();
        this.updateOKStatus();
    }

    private void changeToStringStyle(int style) {
        this.fGenerationSettings.toStringStyle = style;
        this.skipNullsButton.setEnabled(style != 3);
        boolean enableFormat = style != 4;
        this.formatLabel.setEnabled(enableFormat);
        this.formatCombo.setEnabled(enableFormat);
        this.styleButton.setEnabled(style == 4);
        this.updateOKStatus();
    }

    private class CustomBuilderConfigurationDialog
    extends StatusDialog {
        private final int APPLY_BUTTON = 1025;
        private final TypeSelectionExtension fExtension;
        private final ModifyListener modifyListener;
        private final CustomBuilderValidator fValidator;
        private Text fBuilderClassName;
        private Text fBuilderVariableName;
        private Combo fAppendMethodName;
        private Combo fResultMethodName;
        private Button fChainInvocations;
        private ToStringGenerationSettings.CustomBuilderSettings fBuilderSettings;
        private boolean somethingChanged;

        public CustomBuilderConfigurationDialog(Shell parent) {
            super(parent);
            this.APPLY_BUTTON = 1025;
            this.fExtension = new TypeSelectionExtension(){

                @Override
                public ISelectionStatusValidator getSelectionValidator() {
                    return CustomBuilderConfigurationDialog.this.getValidator();
                }
            };
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (e.widget == CustomBuilderConfigurationDialog.this.fBuilderClassName) {
                        ((CustomBuilderConfigurationDialog)CustomBuilderConfigurationDialog.this).fBuilderSettings.className = CustomBuilderConfigurationDialog.this.fBuilderClassName.getText();
                        CustomBuilderConfigurationDialog.this.updateCombos();
                    } else if (e.widget == CustomBuilderConfigurationDialog.this.fBuilderVariableName) {
                        ((CustomBuilderConfigurationDialog)CustomBuilderConfigurationDialog.this).fBuilderSettings.variableName = CustomBuilderConfigurationDialog.this.fBuilderVariableName.getText();
                    }
                    IStatus status = CustomBuilderConfigurationDialog.this.getValidator().revalidateAll(CustomBuilderConfigurationDialog.this.fBuilderSettings);
                    CustomBuilderConfigurationDialog.this.updateStatus(status);
                    CustomBuilderConfigurationDialog.this.enableApplyButton();
                }
            };
            this.fValidator = new CustomBuilderValidator(GenerateToStringDialog.this.getType().getJavaProject());
            this.somethingChanged = false;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.fBuilderSettings = GenerateToStringDialog.this.getGenerationSettings().getCustomBuilderSettings();
        }

        public CustomBuilderValidator getValidator() {
            return this.fValidator;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_windowTitle);
            Composite composite = (Composite)super.createDialogArea(parent);
            ((GridLayout)composite.getLayout()).numColumns = 3;
            LayoutUtil.setWidthHint((Control)composite, this.convertWidthInCharsToPixels(100));
            Label label = new Label(composite, 16384);
            label.setText(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_builderClassField);
            this.fBuilderClassName = this.createTextField(composite, 1, this.fBuilderSettings.className);
            Button button = new Button(composite, 0);
            button.setText(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_browseButton);
            this.setButtonLayoutData(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomBuilderConfigurationDialog.this.browseForBuilderClass();
                }
            });
            label = new Label(composite, 16384);
            label.setText(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_varNameField);
            this.fBuilderVariableName = this.createTextField(composite, 2, this.fBuilderSettings.variableName);
            label = new Label(composite, 16384);
            label.setText(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_appendMethodField);
            this.fAppendMethodName = new Combo(composite, 8);
            this.fAppendMethodName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            label = new Label(composite, 16384);
            label.setText(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_resultMethodField);
            this.fResultMethodName = new Combo(composite, 8);
            this.fResultMethodName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.updateCombos();
            ModifyListener comboListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Combo c = (Combo)e.widget;
                    if (c.getText().length() > 0) {
                        if (c == CustomBuilderConfigurationDialog.this.fAppendMethodName) {
                            ((CustomBuilderConfigurationDialog)CustomBuilderConfigurationDialog.this).fBuilderSettings.appendMethod = c.getText();
                        }
                        if (c == CustomBuilderConfigurationDialog.this.fResultMethodName) {
                            ((CustomBuilderConfigurationDialog)CustomBuilderConfigurationDialog.this).fBuilderSettings.resultMethod = c.getText();
                        }
                    }
                    CustomBuilderConfigurationDialog.this.updateStatus(CustomBuilderConfigurationDialog.this.fValidator.revalidateAll(CustomBuilderConfigurationDialog.this.fBuilderSettings));
                    CustomBuilderConfigurationDialog.this.enableApplyButton();
                }
            };
            this.fAppendMethodName.addModifyListener(comboListener);
            this.fResultMethodName.addModifyListener(comboListener);
            if (!this.select(this.fAppendMethodName, this.fBuilderSettings.appendMethod)) {
                this.fAppendMethodName.select(0);
            }
            if (!this.select(this.fResultMethodName, this.fBuilderSettings.resultMethod)) {
                this.fResultMethodName.select(0);
            }
            this.fChainInvocations = new Button(composite, 32);
            this.fChainInvocations.setText(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_chainedCallsCheckbox);
            this.fChainInvocations.setSelection(this.fBuilderSettings.chainCalls);
            this.fChainInvocations.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.fChainInvocations.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((CustomBuilderConfigurationDialog)CustomBuilderConfigurationDialog.this).fBuilderSettings.chainCalls = CustomBuilderConfigurationDialog.this.fChainInvocations.getSelection();
                    CustomBuilderConfigurationDialog.this.enableApplyButton();
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.jdt.ui.to_string_configure_custom_builder_dialog_context");
            return composite;
        }

        public void create() {
            super.create();
            IStatus status = this.getValidator().revalidateAll(this.fBuilderSettings);
            this.updateStatus(status);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.createButton(parent, 1025, JavaUIMessages.GenerateToStringDialog_customBuilderConfig_applyButton, false).setEnabled(false);
        }

        private void enableApplyButton() {
            this.somethingChanged = true;
            this.getButton(1025).setEnabled(!this.getStatus().matches(4));
        }

        protected void updateButtonsEnableState(IStatus status) {
            super.updateButtonsEnableState(status);
            this.getButton(1025).setEnabled(!status.matches(4) && this.somethingChanged);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 1025: {
                    this.getButton(1025).setEnabled(false);
                    this.somethingChanged = false;
                }
                case 0: {
                    this.applyChanges();
                }
            }
            super.buttonPressed(buttonId);
        }

        private boolean select(Combo combo, String item) {
            int index = Arrays.asList(combo.getItems()).indexOf(item);
            if (index >= 0) {
                combo.select(index);
                return true;
            }
            return false;
        }

        private void updateCombos() {
            String[] empty = new String[]{};
            try {
                IType type = this.fValidator.findType(this.fBuilderSettings.className);
                if (type == null) {
                    this.fAppendMethodName.setItems(empty);
                    this.fResultMethodName.setItems(empty);
                } else {
                    this.fAppendMethodName.setItems(this.fValidator.getAppendMethodSuggestions(type).toArray(empty));
                    this.select(this.fAppendMethodName, this.fBuilderSettings.appendMethod);
                    this.fResultMethodName.setItems(this.fValidator.getResultMethodSuggestions(type).toArray(empty));
                    this.select(this.fResultMethodName, this.fBuilderSettings.resultMethod);
                }
            }
            catch (JavaModelException javaModelException) {
                this.fAppendMethodName.setItems(empty);
                this.fResultMethodName.setItems(empty);
            }
        }

        private void applyChanges() {
            this.fBuilderSettings.appendMethod = this.fAppendMethodName.getText();
            this.fBuilderSettings.resultMethod = this.fResultMethodName.getText();
            GenerateToStringDialog.this.getGenerationSettings().writeCustomBuilderSettings(this.fBuilderSettings);
        }

        private Text createTextField(Composite composite, int gridHSpan, String text) {
            Text result = new Text(composite, 2048);
            result.setLayoutData((Object)new GridData(4, 0x1000000, true, false, gridHSpan, 1));
            result.setText(text);
            result.addModifyListener(this.modifyListener);
            TextFieldNavigationHandler.install(result);
            return result;
        }

        private void browseForBuilderClass() {
            try {
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{GenerateToStringDialog.this.getType().getJavaProject()});
                SelectionDialog dialog = JavaUI.createTypeDialog(this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), scope, 2, false, "*ToString", this.fExtension);
                dialog.setTitle(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_classSelection_windowTitle);
                dialog.setMessage(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_classSelection_message);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    IType type = (IType)dialog.getResult()[0];
                    this.fBuilderClassName.setText(type.getFullyQualifiedParameterizedName());
                    List<String> suggestions = this.fValidator.getAppendMethodSuggestions(type);
                    if (!suggestions.contains(this.fAppendMethodName.getText())) {
                        this.fAppendMethodName.setText(suggestions.get(0));
                    }
                    if (!(suggestions = this.fValidator.getResultMethodSuggestions(type)).contains(this.fResultMethodName.getText())) {
                        this.fResultMethodName.setText(suggestions.get(0));
                    }
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private static class CustomBuilderValidator
    implements ISelectionStatusValidator {
        private final IJavaProject fJavaProject;
        private IType fLastValidBuilderType;
        private List<String> fLastValidAppendMethodSuggestions;
        private List<String> fLastValidResultMethodSuggestions;

        public CustomBuilderValidator(IJavaProject javaProject) {
            this.fJavaProject = javaProject;
        }

        public IStatus validateBuilderType(IType type) {
            if (this.fLastValidBuilderType != null && this.fLastValidBuilderType.equals(type)) {
                return new StatusInfo();
            }
            try {
                IMethod[] methods = type.getMethods();
                boolean foundConstructor = false;
                int i = 0;
                while (i < methods.length) {
                    String[] parameterTypes;
                    if (methods[i].isConstructor() && Flags.isPublic((int)methods[i].getFlags()) && (parameterTypes = methods[i].getParameterTypes()).length == 1 && "java.lang.Object".equals(JavaModelUtil.getResolvedTypeName(parameterTypes[0], type))) {
                        foundConstructor = true;
                        break;
                    }
                    ++i;
                }
                if (!foundConstructor) {
                    return new StatusInfo(4, JavaUIMessages.GenerateToStringDialog_customBuilderConfig_noConstructorError);
                }
                List<String> appendMethodSuggestions = this.getAppendMethodSuggestions(type);
                if (appendMethodSuggestions.isEmpty()) {
                    return new StatusInfo(4, JavaUIMessages.GenerateToStringDialog_customBuilderConfig_noAppendMethodError);
                }
                List<String> resultMethodSuggestions = this.getResultMethodSuggestions(type);
                if (resultMethodSuggestions.isEmpty()) {
                    return new StatusInfo(4, JavaUIMessages.GenerateToStringDialog_customBuilderConfig_noResultMethodError);
                }
                this.fLastValidBuilderType = type;
                this.fLastValidAppendMethodSuggestions = appendMethodSuggestions;
                this.fLastValidResultMethodSuggestions = resultMethodSuggestions;
                return new StatusInfo();
            }
            catch (JavaModelException javaModelException) {
                return new StatusInfo(2, JavaUIMessages.GenerateToStringDialog_customBuilderConfig_typeValidationError);
            }
        }

        public IStatus validate(Object[] selection) {
            return this.validateBuilderType((IType)selection[0]);
        }

        public IStatus revalidateAll(ToStringGenerationSettings.CustomBuilderSettings builderSettings) {
            try {
                if (builderSettings.className.length() == 0) {
                    return new StatusInfo(4, JavaUIMessages.GenerateToStringDialog_customBuilderConfig_noBuilderClassError);
                }
                IType type = this.findType(builderSettings.className);
                if (type == null || !type.exists()) {
                    return new StatusInfo(4, MessageFormat.format(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_invalidClassError, builderSettings.className));
                }
                IStatus typeValidation = this.validateBuilderType(type);
                if (!typeValidation.isOK()) {
                    return typeValidation;
                }
                if (!this.getAppendMethodSuggestions(type).contains(builderSettings.appendMethod)) {
                    return new StatusInfo(4, MessageFormat.format(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_invalidAppendMethodError, builderSettings.appendMethod));
                }
                if (!this.getResultMethodSuggestions(type).contains(builderSettings.resultMethod)) {
                    return new StatusInfo(4, MessageFormat.format(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_invalidResultMethodError, builderSettings.resultMethod));
                }
                if (!this.isValidJavaIdentifier(builderSettings.variableName)) {
                    return new StatusInfo(4, MessageFormat.format(JavaUIMessages.GenerateToStringDialog_customBuilderConfig_invalidVariableNameError, builderSettings.variableName));
                }
            }
            catch (JavaModelException javaModelException) {
                return new StatusInfo(2, JavaUIMessages.GenerateToStringDialog_customBuilderConfig_dataValidationError);
            }
            return new StatusInfo();
        }

        public IType findType(String builderClassName) throws JavaModelException {
            if (this.fLastValidBuilderType != null && builderClassName.equals(this.fLastValidBuilderType.getFullyQualifiedParameterizedName())) {
                return this.fLastValidBuilderType;
            }
            return this.fJavaProject.findType(builderClassName, null);
        }

        public List<String> getAppendMethodSuggestions(final IType type) throws JavaModelException {
            if (this.fLastValidBuilderType != null && this.fLastValidBuilderType.equals(type)) {
                return this.fLastValidAppendMethodSuggestions;
            }
            return this.getMethodSuggestions(type, new MethodChecker(){

                @Override
                public boolean isMethodOK(IMethod method) throws JavaModelException {
                    if (!Flags.isPublic((int)method.getFlags()) || method.isConstructor()) {
                        return false;
                    }
                    String[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length == 0 || parameterTypes.length > 2) {
                        return false;
                    }
                    int countObjects = 0;
                    int countStrings = 0;
                    int i = 0;
                    while (i < parameterTypes.length) {
                        String resolvedParameterTypeName = JavaModelUtil.getResolvedTypeName(parameterTypes[i], type);
                        if ("java.lang.Object".equals(resolvedParameterTypeName)) {
                            ++countObjects;
                        }
                        if ("java.lang.String".equals(resolvedParameterTypeName)) {
                            ++countStrings;
                        }
                        ++i;
                    }
                    return countObjects == 1 && countObjects + countStrings == parameterTypes.length;
                }
            });
        }

        public List<String> getResultMethodSuggestions(final IType type) throws JavaModelException {
            if (this.fLastValidBuilderType != null && this.fLastValidBuilderType.equals(type)) {
                return this.fLastValidResultMethodSuggestions;
            }
            return this.getMethodSuggestions(type, new MethodChecker(){

                @Override
                public boolean isMethodOK(IMethod method) throws JavaModelException {
                    return Flags.isPublic((int)method.getFlags()) && method.getParameterTypes().length == 0 && "java.lang.String".equals(JavaModelUtil.getResolvedTypeName(method.getReturnType(), type));
                }
            });
        }

        private List<String> getMethodSuggestions(IType type, MethodChecker checker) throws JavaModelException {
            ArrayList<String> result = new ArrayList<String>();
            IType[] classes = type.newSupertypeHierarchy(null).getAllClasses();
            int i = 0;
            while (i < classes.length) {
                IMethod[] methods = classes[i].getMethods();
                int j = 0;
                while (j < methods.length) {
                    String name;
                    if (checker.isMethodOK(methods[j]) && !result.contains(name = methods[j].getElementName())) {
                        result.add(name);
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }

        private boolean isValidJavaIdentifier(String identifier) {
            return JavaConventionsUtil.validateIdentifier(identifier, (IJavaElement)this.fJavaProject).isOK();
        }

        private static interface MethodChecker {
            public boolean isMethodOK(IMethod var1) throws JavaModelException;
        }
    }

    private static class GenerateToStringContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private IVariableBinding[] fFields;
        private IMethodBinding[] fMethods;
        private IVariableBinding[] fInheritedFields;
        private IMethodBinding[] fInheritedMethods;
        private String[] mainNodes;
        private static final String fieldsNode = JavaUIMessages.GenerateToStringDialog_fields_node;
        private static final String methodsNode = JavaUIMessages.GenerateToStringDialog_methods_node;
        private static final String inheritedFieldsNode = JavaUIMessages.GenerateToStringDialog_inherited_fields_node;
        private static final String inheritedMethodsNode = JavaUIMessages.GenerateToStringDialog_inherited_methods_node;

        public GenerateToStringContentProvider(IVariableBinding[] fields, IVariableBinding[] inheritedFields, IMethodBinding[] methods, IMethodBinding[] inheritedMethods) {
            ArrayList<String> nodes = new ArrayList<String>();
            this.fFields = (IVariableBinding[])fields.clone();
            if (this.fFields.length > 0) {
                nodes.add(fieldsNode);
            }
            this.fInheritedFields = (IVariableBinding[])inheritedFields.clone();
            if (this.fInheritedFields.length > 0) {
                nodes.add(inheritedFieldsNode);
            }
            this.fMethods = (IMethodBinding[])methods.clone();
            if (this.fMethods.length > 0) {
                nodes.add(methodsNode);
            }
            this.fInheritedMethods = (IMethodBinding[])inheritedMethods.clone();
            if (this.fInheritedMethods.length > 0) {
                nodes.add(inheritedMethodsNode);
            }
            this.mainNodes = nodes.toArray(new String[nodes.size()]);
        }

        private int getElementPosition(Object element, Object[] array) {
            int i = 0;
            while (i < array.length) {
                if (array[i].equals(element)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private Object[] getContainingArray(Object element) {
            if (element instanceof String) {
                return this.mainNodes;
            }
            if (element instanceof IVariableBinding) {
                if (this.getElementPosition(element, this.fFields) >= 0) {
                    return this.fFields;
                }
                if (this.getElementPosition(element, this.fInheritedFields) >= 0) {
                    return this.fInheritedFields;
                }
            }
            if (element instanceof IMethodBinding) {
                if (this.getElementPosition(element, this.fMethods) >= 0) {
                    return this.fMethods;
                }
                if (this.getElementPosition(element, this.fInheritedMethods) >= 0) {
                    return this.fInheritedMethods;
                }
            }
            return EMPTY;
        }

        public boolean canMoveDown(Object element) {
            Object[] array = this.getContainingArray(element);
            int position = this.getElementPosition(element, array);
            return position != -1 && position != array.length - 1;
        }

        public boolean canMoveUp(Object element) {
            return this.getElementPosition(element, this.getContainingArray(element)) > 0;
        }

        public void down(Object element, CheckboxTreeViewer tree) {
            this.move(element, tree, 1);
        }

        public void up(Object element, CheckboxTreeViewer tree) {
            this.move(element, tree, -1);
        }

        private void move(Object element, CheckboxTreeViewer tree, int direction) {
            Object[] array = this.getContainingArray(element);
            int position = this.getElementPosition(element, array);
            Object temp = array[position];
            array[position] = array[position + direction];
            array[position + direction] = temp;
            tree.setSelection((ISelection)new StructuredSelection(element));
            tree.refresh();
        }

        public void sort() {
            Comparator<IBinding> comparator = new Comparator<IBinding>(){
                Collator collator = Collator.getInstance();

                @Override
                public int compare(IBinding b1, IBinding b2) {
                    return this.collator.compare(b1.getName(), b2.getName());
                }
            };
            Arrays.sort(this.fFields, comparator);
            Arrays.sort(this.fMethods, comparator);
            Arrays.sort(this.fInheritedFields, comparator);
            Arrays.sort(this.fInheritedMethods, comparator);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == fieldsNode) {
                return this.fFields;
            }
            if (parentElement == inheritedFieldsNode) {
                return this.fInheritedFields;
            }
            if (parentElement == methodsNode) {
                return this.fMethods;
            }
            if (parentElement == inheritedMethodsNode) {
                return this.fInheritedMethods;
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            Object[] array = this.getContainingArray(element);
            if (array == this.fFields) {
                return fieldsNode;
            }
            if (array == this.fInheritedFields) {
                return inheritedFieldsNode;
            }
            if (array == this.fMethods) {
                return methodsNode;
            }
            if (array == this.fInheritedMethods) {
                return inheritedMethodsNode;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }

        public Object[] getElements(Object inputElement) {
            return this.mainNodes;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class GenerateToStringLabelProvider
    extends BindingLabelProvider {
        private GenerateToStringLabelProvider() {
        }

        @Override
        public Image getImage(Object element) {
            Object descriptor = null;
            if (element == GenerateToStringContentProvider.fieldsNode || element == GenerateToStringContentProvider.inheritedFieldsNode) {
                descriptor = JavaPluginImages.DESC_FIELD_PUBLIC;
            }
            if (element == GenerateToStringContentProvider.methodsNode || element == GenerateToStringContentProvider.inheritedMethodsNode) {
                descriptor = JavaPluginImages.DESC_MISC_PUBLIC;
            }
            if (descriptor != null) {
                descriptor = new JavaElementImageDescriptor((ImageDescriptor)descriptor, 0, JavaElementImageProvider.BIG_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
            }
            return super.getImage(element);
        }
    }

    private class GenerateToStringValidator
    implements ISelectionStatusValidator {
        private int fNumFields;
        private int fNumMethods;
        private CustomBuilderValidator fValidator;

        public GenerateToStringValidator(int fields, int methods) {
            this.fNumFields = fields;
            this.fNumMethods = methods;
        }

        public IStatus validate(Object[] selection) {
            if (GenerateToStringDialog.this.getGenerationSettings().toStringStyle == 4) {
                IStatus status;
                if (this.fValidator == null) {
                    this.fValidator = new CustomBuilderValidator(GenerateToStringDialog.this.getType().getJavaProject());
                }
                if (!(status = this.fValidator.revalidateAll(GenerateToStringDialog.this.getGenerationSettings().getCustomBuilderSettings())).isOK()) {
                    return new StatusInfo(4, JavaUIMessages.GenerateToStringDialog_selectioninfo_customBuilderConfigError);
                }
            }
            int countFields = 0;
            int countMethods = 0;
            int index = 0;
            while (index < selection.length) {
                if (selection[index] instanceof IVariableBinding) {
                    ++countFields;
                } else if (selection[index] instanceof IMethodBinding) {
                    ++countMethods;
                }
                ++index;
            }
            return new StatusInfo(1, Messages.format(JavaUIMessages.GenerateToStringDialog_selectioninfo_more, new String[]{String.valueOf(countFields), String.valueOf(this.fNumFields), String.valueOf(countMethods), String.valueOf(this.fNumMethods)}));
        }
    }

    private class ToStringTemplatesDialog
    extends StatusDialog {
        private final int ADD_BUTTON = 1025;
        private final int REMOVE_BUTTON = 1026;
        private final int APPLY_BUTTON = 1027;
        private final int EDIT_BUTTON = 1028;
        private Text templateTextControl;
        private org.eclipse.swt.widgets.List templateNameControl;
        private ToStringTemplateParser parser;
        private List<String> templateNames;
        private List<String> templates;
        private int selectedTemplateNumber;
        private boolean somethingChanged;
        private StatusInfo validationStatus;

        protected ToStringTemplatesDialog(Shell parentShell, ToStringTemplateParser parser) {
            super(parentShell);
            this.ADD_BUTTON = 1025;
            this.REMOVE_BUTTON = 1026;
            this.APPLY_BUTTON = 1027;
            this.EDIT_BUTTON = 1028;
            this.somethingChanged = false;
            this.validationStatus = new StatusInfo();
            this.parser = parser;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.jdt.ui.to_string_manage_templates_dialog_context");
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(JavaUIMessages.GenerateToStringDialog_templatesManagerTitle);
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 16384);
            label.setText(JavaUIMessages.GenerateToStringDialog_templatesManagerTemplatesList);
            Composite templatesComposite = new Composite(composite, 0);
            templatesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            templatesComposite.setLayout((Layout)gl);
            this.templateNameControl = new org.eclipse.swt.widgets.List(templatesComposite, 2820);
            this.templateNameControl.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite rightComposite = new Composite(templatesComposite, 0);
            gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            rightComposite.setLayout((Layout)gl);
            rightComposite.setLayoutData((Object)new GridData(4, 128, false, false));
            this.createButton(rightComposite, 1025, JavaUIMessages.GenerateToStringDialog_templatesManagerNewButton, false);
            this.createButton(rightComposite, 1026, JavaUIMessages.GenerateToStringDialog_templatesManagerRemoveButton, false);
            this.createButton(rightComposite, 1028, JavaUIMessages.GenerateToStringDialog_teplatesManagerEditButton, false);
            ((GridLayout)rightComposite.getLayout()).numColumns = 1;
            label = new Label(composite, 16384);
            label.setText(JavaUIMessages.GenerateToStringDialog_templatesManagerPreview);
            this.templateTextControl = new Text(composite, 2826);
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = 80;
            gd.widthHint = 450;
            this.templateTextControl.setLayoutData((Object)gd);
            this.templateNames = new ArrayList<String>(Arrays.asList(GenerateToStringDialog.this.getTemplateNames()));
            this.templates = new ArrayList<String>(Arrays.asList(GenerateToStringDialog.getTemplates(GenerateToStringDialog.this.getDialogSettings())));
            this.selectedTemplateNumber = GenerateToStringDialog.this.getGenerationSettings().stringFormatTemplateNumber;
            this.refreshControls();
            this.templateNameControl.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ToStringTemplatesDialog.this.onEdit();
                }

                public void widgetSelected(SelectionEvent e) {
                    if (ToStringTemplatesDialog.this.templateNameControl.getSelectionIndex() >= 0) {
                        ToStringTemplatesDialog.this.selectedTemplateNumber = ToStringTemplatesDialog.this.templateNameControl.getSelectionIndex();
                        ToStringTemplatesDialog.this.templateTextControl.setText((String)ToStringTemplatesDialog.this.templates.get(ToStringTemplatesDialog.this.selectedTemplateNumber));
                    }
                }
            });
            ToStringTemplatesDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.createButton(parent, 1027, JavaUIMessages.GenerateToStringDialog_templateManagerApplyButton, false).setEnabled(false);
        }

        private void applyChanges() {
            GenerateToStringDialog.this.getDialogSettings().put("ToStringTemplateNames", this.templateNames.toArray(new String[0]));
            GenerateToStringDialog.this.getDialogSettings().put("ToStringTemplates", this.templates.toArray(new String[0]));
            GenerateToStringDialog.this.getGenerationSettings().stringFormatTemplateNumber = Math.max(this.selectedTemplateNumber, 0);
            this.somethingChanged = false;
            this.getButton(1027).setEnabled(false);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 1027: {
                    this.applyChanges();
                    break;
                }
                case 0: {
                    this.applyChanges();
                    this.close();
                    break;
                }
                case 1: {
                    this.close();
                    break;
                }
                case 1025: {
                    TemplateEditionDialog dialog = new TemplateEditionDialog(this.getShell(), -1);
                    dialog.open();
                    if (dialog.getReturnCode() != 0) break;
                    this.templateNames.add(dialog.getTemplateName());
                    this.templates.add(dialog.getTemplate());
                    this.selectedTemplateNumber = this.templateNames.size() - 1;
                    this.somethingChanged = true;
                    this.refreshControls();
                    break;
                }
                case 1026: {
                    if (this.templateNames.size() > 0) {
                        this.templateNames.remove(this.selectedTemplateNumber);
                        this.templates.remove(this.selectedTemplateNumber);
                    }
                    if (this.selectedTemplateNumber >= this.templateNames.size()) {
                        this.selectedTemplateNumber = this.templateNames.size() - 1;
                    }
                    this.somethingChanged = true;
                    this.refreshControls();
                    break;
                }
                case 1028: {
                    this.onEdit();
                }
            }
        }

        private void onEdit() {
            TemplateEditionDialog dialog = new TemplateEditionDialog(this.getShell(), this.selectedTemplateNumber);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.templateNames.set(this.selectedTemplateNumber, dialog.getTemplateName());
                this.templates.set(this.selectedTemplateNumber, dialog.getTemplate());
                this.somethingChanged = true;
                this.refreshControls();
            }
        }

        public void refreshControls() {
            this.templateNameControl.setItems(this.templateNames.toArray(new String[0]));
            if (this.templateNames.size() > 0) {
                this.templateNameControl.select(this.selectedTemplateNumber);
                this.templateTextControl.setText(this.templates.get(this.selectedTemplateNumber));
            } else {
                this.templateTextControl.setText("");
            }
            this.revalidate();
            if (this.getButton(1027) != null) {
                this.getButton(1027).setEnabled(this.somethingChanged && this.getButton(0).getEnabled());
            }
            if (this.getButton(1026) != null) {
                this.getButton(1026).setEnabled(this.templateNames.size() > 0);
            }
            if (this.getButton(1028) != null) {
                this.getButton(1028).setEnabled(this.templateNames.size() > 0);
            }
        }

        private void revalidate() {
            if (this.templateNames.size() > 0) {
                this.validationStatus.setOK();
            } else {
                this.validationStatus.setError(JavaUIMessages.GenerateToStringDialog_templateManagerNoTemplateErrorMessage);
            }
            this.updateStatus(this.validationStatus);
        }

        private class TemplateEditionDialog
        extends StatusDialog {
            private final int templateNumber;
            private final String fInitialTemplateName;
            private Text templateName;
            private Text template;
            private String resultTemplateName;
            private String resultTemplate;
            private StatusInfo nameValidationStatus;

            public TemplateEditionDialog(Shell parent, int templateNumber) {
                super(parent);
                this.nameValidationStatus = new StatusInfo();
                this.templateNumber = templateNumber;
                this.fInitialTemplateName = templateNumber < 0 ? null : (String)ToStringTemplatesDialog.this.templateNames.get(templateNumber);
                this.setHelpAvailable(false);
            }

            protected boolean isResizable() {
                return true;
            }

            protected Control createDialogArea(Composite parent) {
                this.getShell().setText(this.templateNumber >= 0 ? JavaUIMessages.GenerateToStringDialog_templateEdition_WindowTitle : JavaUIMessages.GenerateToStringDialog_templateEdition_NewWindowTitle);
                Composite composite = (Composite)super.createDialogArea(parent);
                GridLayout layout = (GridLayout)composite.getLayout();
                layout.numColumns = 2;
                layout.horizontalSpacing = 8;
                Label label = new Label(composite, 16384);
                label.setText(JavaUIMessages.GenerateToStringDialog_template_name);
                label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                this.templateName = new Text(composite, 2052);
                this.templateName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                label = new Label(composite, 16384);
                label.setText(JavaUIMessages.GenerateToStringDialog_template_content);
                label.setLayoutData((Object)new GridData(4, 128, false, false));
                this.template = new Text(composite, 2818);
                GridData gridData = new GridData(4, 4, true, true);
                gridData.heightHint = 80;
                gridData.widthHint = 480;
                this.template.setLayoutData((Object)gridData);
                new ContentAssistCommandAdapter((Control)this.template, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new ToStringTemplateProposalProvider(), null, new char[]{'$'}, true).setPropagateKeys(false);
                if (this.templateNumber >= 0) {
                    this.templateName.setText(this.fInitialTemplateName);
                    this.template.setText((String)ToStringTemplatesDialog.this.templates.get(this.templateNumber));
                } else {
                    this.templateName.setText(this.createNewTemplateName());
                    this.template.setText("${object.className} [${member.name()}=${member.value}, ${otherMembers}]");
                }
                this.templateName.setSelection(0, this.templateName.getText().length());
                this.templateName.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        TemplateEditionDialog.this.validate(TemplateEditionDialog.this.templateName.getText());
                    }
                });
                this.template.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 4 && (e.stateMask & SWT.MODIFIER_MASK) != 0) {
                            TemplateEditionDialog.this.buttonPressed((Integer)TemplateEditionDialog.this.getShell().getDefaultButton().getData());
                        }
                    }
                });
                return composite;
            }

            private void validate(String newName) {
                if (newName.length() == 0) {
                    this.nameValidationStatus.setError(JavaUIMessages.GenerateToStringDialog_templateEdition_TemplateNameEmptyErrorMessage);
                } else if (!newName.equals(this.fInitialTemplateName) && ToStringTemplatesDialog.this.templateNames.contains(newName)) {
                    this.nameValidationStatus.setError(JavaUIMessages.GenerateToStringDialog_templateEdition_TemplateNameDuplicateErrorMessage);
                } else {
                    this.nameValidationStatus.setOK();
                }
                this.updateStatus(this.nameValidationStatus);
            }

            private String createNewTemplateName() {
                String newName;
                if (!ToStringTemplatesDialog.this.templateNames.contains(JavaUIMessages.GenerateToStringDialog_newTemplateName)) {
                    return JavaUIMessages.GenerateToStringDialog_newTemplateName;
                }
                int copyCount = 2;
                do {
                    newName = Messages.format(JavaUIMessages.GenerateToStringDialog_newTemplateNameArg, new Integer(copyCount));
                    ++copyCount;
                } while (ToStringTemplatesDialog.this.templateNames.contains(newName));
                return newName;
            }

            public boolean close() {
                this.resultTemplateName = this.templateName.getText();
                this.resultTemplate = this.fixLineBreaks(this.template.getText());
                return super.close();
            }

            public String getTemplateName() {
                return this.resultTemplateName;
            }

            public String getTemplate() {
                return this.resultTemplate;
            }

            private String fixLineBreaks(String input) {
                String systemLineDelimiter = Text.DELIMITER;
                if (!systemLineDelimiter.equals("\n")) {
                    StringBuffer outputBuffer = new StringBuffer(input);
                    int pos = outputBuffer.indexOf(systemLineDelimiter);
                    while (pos >= 0) {
                        outputBuffer.delete(pos, pos + systemLineDelimiter.length());
                        outputBuffer.insert(pos, "\n");
                        pos = outputBuffer.indexOf(systemLineDelimiter, pos + "\n".length());
                    }
                    return outputBuffer.toString();
                }
                return input;
            }
        }

        private class ToStringTemplateProposalProvider
        implements IContentProposalProvider {
            private String latestContents;
            private int latestPosition;

            private ToStringTemplateProposalProvider() {
            }

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<Proposal> primaryProposals = new ArrayList<Proposal>();
                ArrayList<Proposal> secondaryProposals = new ArrayList<Proposal>();
                String[] proposalStrings = ToStringTemplatesDialog.this.parser.getVariables();
                String contentToCursor = contents.substring(0, position);
                int i = 0;
                while (i < proposalStrings.length) {
                    if (this.stringOverlap(contentToCursor, proposalStrings[i]) > 0) {
                        primaryProposals.add(new Proposal(proposalStrings[i]));
                    } else {
                        secondaryProposals.add(new Proposal(proposalStrings[i]));
                    }
                    ++i;
                }
                this.latestContents = contents;
                this.latestPosition = position;
                primaryProposals.addAll(secondaryProposals);
                return primaryProposals.toArray(new IContentProposal[0]);
            }

            private int stringOverlap(String s1, String s2) {
                int l1 = s1.length();
                int l = 1;
                while (l <= Math.min(s1.length(), s2.length())) {
                    boolean ok = true;
                    int i = 0;
                    while (i < l) {
                        if (s1.charAt(l1 - l + i) != s2.charAt(i)) {
                            ok = false;
                            break;
                        }
                        ++i;
                    }
                    if (ok) {
                        return l;
                    }
                    ++l;
                }
                return 0;
            }

            private class Proposal
            implements IContentProposal {
                private final String proposal;
                private int position;

                public Proposal(String proposal) {
                    this.proposal = proposal;
                    this.position = proposal.length();
                }

                public String getContent() {
                    int overlap = ToStringTemplateProposalProvider.this.stringOverlap(ToStringTemplateProposalProvider.this.latestContents.substring(0, ToStringTemplateProposalProvider.this.latestPosition), this.proposal);
                    this.position = this.proposal.length() - overlap;
                    return this.proposal.substring(overlap);
                }

                public int getCursorPosition() {
                    return this.position;
                }

                public String getDescription() {
                    return ToStringTemplatesDialog.this.parser.getVariableDescriptions().get(this.proposal);
                }

                public String getLabel() {
                    return this.proposal;
                }
            }
        }
    }
}

