/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyQualifiedNameAction
extends SelectionDispatchAction {
    private static final long LABEL_FLAGS = new Long(281477260838017L);
    public static final String ACTION_DEFINITION_ID = "org.eclipse.jdt.ui.edit.text.java.copy.qualified.name";
    public static final String ACTION_HANDLER_ID = "org.eclipse.jdt.ui.actions.CopyQualifiedName";
    private JavaEditor fEditor;

    public CopyQualifiedNameAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getSite());
        this.fEditor = editor;
        this.setEnabled(true);
    }

    public CopyQualifiedNameAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.CopyQualifiedNameAction_ActionName);
        this.setToolTipText(ActionMessages.CopyQualifiedNameAction_ToolTipText);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_COPY_QUALIFIED_NAME);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_COPY_QUALIFIED_NAME);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.copy_qualified_name_action_context");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection.toArray()));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    private boolean canEnable(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            Object element = objects[i];
            if (this.isValidElement(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidElement(Object element) {
        if (element instanceof IMember) {
            return true;
        }
        if (element instanceof IClassFile) {
            return true;
        }
        if (element instanceof ICompilationUnit) {
            return true;
        }
        if (element instanceof IPackageDeclaration) {
            return true;
        }
        if (element instanceof IImportDeclaration) {
            return true;
        }
        if (element instanceof IPackageFragment) {
            return true;
        }
        if (element instanceof IPackageFragmentRoot) {
            return true;
        }
        if (element instanceof IJavaProject) {
            return true;
        }
        if (element instanceof IJarEntryResource) {
            return true;
        }
        if (element instanceof IResource) {
            return true;
        }
        return element instanceof LogicalPackage;
    }

    @Override
    public void run() {
        try {
            Object[] elements = this.getSelectedElements();
            if (elements == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.CopyQualifiedNameAction_InfoDialogTitel, (String)ActionMessages.CopyQualifiedNameAction_NoElementToQualify);
                return;
            }
            Object[] data = null;
            Transfer[] dataTypes = null;
            if (elements.length == 1) {
                Object element = elements[0];
                String qualifiedName = this.getQualifiedName(element);
                IResource resource = null;
                if (element instanceof IJavaElement) {
                    IJavaElement je = (IJavaElement)element;
                    if (je.exists()) {
                        resource = je.getCorrespondingResource();
                    }
                } else if (element instanceof IResource) {
                    resource = (IResource)element;
                }
                if (resource != null) {
                    IPath location = resource.getLocation();
                    if (location != null) {
                        data = new Object[]{qualifiedName, resource, new String[]{location.toOSString()}};
                        dataTypes = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
                    } else {
                        data = new Object[]{qualifiedName, resource};
                        dataTypes = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance()};
                    }
                } else {
                    data = new Object[]{qualifiedName};
                    dataTypes = new Transfer[]{TextTransfer.getInstance()};
                }
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append(this.getQualifiedName(elements[0]));
                int i = 1;
                while (i < elements.length) {
                    String qualifiedName = this.getQualifiedName(elements[i]);
                    buf.append(System.getProperty("line.separator")).append(qualifiedName);
                    ++i;
                }
                data = new Object[]{buf.toString()};
                dataTypes = new Transfer[]{TextTransfer.getInstance()};
            }
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            try {
                try {
                    clipboard.setContents(data, dataTypes);
                }
                catch (SWTError e) {
                    if (e.code != 2002) {
                        throw e;
                    }
                    if (MessageDialog.openQuestion((Shell)this.getShell(), (String)ActionMessages.CopyQualifiedNameAction_ErrorTitle, (String)ActionMessages.CopyQualifiedNameAction_ErrorDescription)) {
                        clipboard.setContents(data, dataTypes);
                    }
                    clipboard.dispose();
                }
            }
            finally {
                clipboard.dispose();
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private String getQualifiedName(Object element) throws JavaModelException {
        IResource resource;
        if (element instanceof IResource) {
            return ((IResource)element).getFullPath().toString();
        }
        if (element instanceof IJarEntryResource) {
            return ((IJarEntryResource)element).getFullPath().toString();
        }
        if (element instanceof LogicalPackage) {
            return ((LogicalPackage)((Object)element)).getElementName();
        }
        if ((element instanceof IJavaProject || element instanceof IPackageFragmentRoot || element instanceof ITypeRoot) && (resource = ((IJavaElement)element).getCorrespondingResource()) != null) {
            return this.getQualifiedName(resource);
        }
        if (element instanceof IBinding) {
            return BindingLabelProvider.getBindingLabel((IBinding)element, LABEL_FLAGS);
        }
        return TextProcessor.deprocess((String)JavaElementLabels.getTextLabel(element, LABEL_FLAGS));
    }

    private Object[] getSelectedElements() {
        if (this.fEditor != null) {
            Object element = this.getSelectedElement(this.fEditor);
            if (element == null) {
                return null;
            }
            return new Object[]{element};
        }
        ISelection selection = this.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Object element : (IStructuredSelection)selection) {
            if (!this.isValidElement(element)) continue;
            result.add(element);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Object[result.size()]);
    }

    private Object getSelectedElement(JavaEditor editor) {
        ISourceViewer viewer = editor.getViewer();
        if (viewer == null) {
            return null;
        }
        Point selectedRange = viewer.getSelectedRange();
        int length = selectedRange.y;
        int offset = selectedRange.x;
        ITypeRoot element = JavaUI.getEditorInputTypeRoot(editor.getEditorInput());
        if (element == null) {
            return null;
        }
        CompilationUnit ast = SharedASTProvider.getAST(element, SharedASTProvider.WAIT_YES, null);
        if (ast == null) {
            return null;
        }
        NodeFinder finder = new NodeFinder((ASTNode)ast, offset, length);
        ASTNode node = finder.getCoveringNode();
        IBinding binding = null;
        if (node instanceof Name) {
            binding = this.getConstructorBindingIfAvailable((Name)node);
            if (binding != null) {
                return binding;
            }
            binding = ((Name)node).resolveBinding();
        } else if (node instanceof MethodInvocation) {
            binding = ((MethodInvocation)node).resolveMethodBinding();
        } else if (node instanceof MethodDeclaration) {
            binding = ((MethodDeclaration)node).resolveBinding();
        } else if (node instanceof Type) {
            binding = ((Type)node).resolveBinding();
        } else if (node instanceof AnonymousClassDeclaration) {
            binding = ((AnonymousClassDeclaration)node).resolveBinding();
        } else if (node instanceof TypeDeclaration) {
            binding = ((TypeDeclaration)node).resolveBinding();
        } else {
            if (node instanceof CompilationUnit) {
                return ((CompilationUnit)node).getJavaElement();
            }
            if (node instanceof Expression) {
                binding = ((Expression)node).resolveTypeBinding();
            } else if (node instanceof ImportDeclaration) {
                binding = ((ImportDeclaration)node).resolveBinding();
            } else if (node instanceof MemberRef) {
                binding = ((MemberRef)node).resolveBinding();
            } else if (node instanceof MemberValuePair) {
                binding = ((MemberValuePair)node).resolveMemberValuePairBinding();
            } else if (node instanceof PackageDeclaration) {
                binding = ((PackageDeclaration)node).resolveBinding();
            } else if (node instanceof TypeParameter) {
                binding = ((TypeParameter)node).resolveBinding();
            } else if (node instanceof VariableDeclaration) {
                binding = ((VariableDeclaration)node).resolveBinding();
            }
        }
        if (binding != null) {
            return binding.getJavaElement();
        }
        return null;
    }

    private IBinding getConstructorBindingIfAvailable(Name nameNode) {
        ASTNode parent;
        StructuralPropertyDescriptor loc = nameNode.getLocationInParent();
        if (loc == SimpleType.NAME_PROPERTY && (loc = (parent = nameNode.getParent()).getLocationInParent()) == ClassInstanceCreation.TYPE_PROPERTY) {
            return ((ClassInstanceCreation)parent.getParent()).resolveConstructorBinding();
        }
        return null;
    }
}

