/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.AbstractJavaElementLabelDecorator;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class InterfaceIndicatorLabelDecorator
extends AbstractJavaElementLabelDecorator {
    @Override
    public void decorate(Object element, IDecoration decoration) {
        try {
            this.addOverlays(element, decoration);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    private void addOverlays(Object element, IDecoration decoration) throws JavaModelException {
        if (element instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)element;
            if (unit.isOpen()) {
                IType mainType = unit.findPrimaryType();
                if (mainType != null) {
                    this.addOverlaysFromFlags(mainType.getFlags(), decoration);
                }
                return;
            }
            String typeName = JavaCore.removeJavaLikeExtension((String)unit.getElementName());
            this.addOverlaysWithSearchEngine((ITypeRoot)unit, typeName, decoration);
        } else if (element instanceof IClassFile) {
            IClassFile classFile = (IClassFile)element;
            if (classFile.isOpen()) {
                this.addOverlaysFromFlags(classFile.getType().getFlags(), decoration);
            } else {
                String typeName = classFile.getType().getElementName();
                this.addOverlaysWithSearchEngine((ITypeRoot)classFile, typeName, decoration);
            }
        }
    }

    private void addOverlaysWithSearchEngine(ITypeRoot element, String typeName, IDecoration decoration) {
        class Result
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            int modifiers;

            public Result(int modifiers) {
                this.modifiers = modifiers;
            }
        }
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element});
        TypeNameRequestor requestor = new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (enclosingTypeNames.length == 0) {
                    throw new Result(modifiers);
                }
            }
        };
        try {
            String packName = element.getParent().getElementName();
            int matchRule = 8;
            engine.searchAllTypeNames(packName.toCharArray(), matchRule, typeName.toCharArray(), matchRule, 0, scope, requestor, 3, null);
        }
        catch (Result e) {
            this.addOverlaysFromFlags(e.modifiers, decoration);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private void addOverlaysFromFlags(int flags, IDecoration decoration) {
        Object type = Flags.isAnnotation((int)flags) ? JavaPluginImages.DESC_OVR_ANNOTATION : (Flags.isEnum((int)flags) ? JavaPluginImages.DESC_OVR_ENUM : (Flags.isInterface((int)flags) ? JavaPluginImages.DESC_OVR_INTERFACE : (Flags.isAbstract((int)flags) ? JavaPluginImages.DESC_OVR_ABSTRACT_CLASS : null)));
        boolean deprecated = Flags.isDeprecated((int)flags);
        boolean packageDefault = Flags.isPackageDefault((int)flags);
        if (type != null && !deprecated && !packageDefault) {
            decoration.addOverlay(type, 1);
        } else if (type == null && deprecated && !packageDefault) {
            decoration.addOverlay(JavaPluginImages.DESC_OVR_DEPRECATED, 1);
        } else if (type != null || deprecated || packageDefault) {
            decoration.addOverlay((ImageDescriptor)new TypeIndicatorOverlay((ImageDescriptor)type, deprecated, packageDefault), 1);
        }
    }

    @Override
    protected void processDelta(IJavaElementDelta delta, List<IJavaElement> result) {
        IJavaElement elem = delta.getElement();
        boolean isChanged = delta.getKind() == 4;
        boolean isRemoved = delta.getKind() == 2;
        int flags = delta.getFlags();
        switch (elem.getElementType()) {
            case 2: {
                if (isRemoved || isChanged && (flags & 0x400) != 0) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 3: {
                if (isRemoved || isChanged && ((flags & 0x8000) != 0 || (flags & 0x80) != 0)) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 4: {
                if (isRemoved) {
                    return;
                }
                this.processChildrenDelta(delta, result);
                return;
            }
            case 6: 
            case 7: {
                return;
            }
            case 1: {
                this.processChildrenDelta(delta, result);
                return;
            }
            case 5: {
                if (!JavaModelUtil.isPrimary((ICompilationUnit)elem)) {
                    return;
                }
                if (isChanged && ((flags & 1) != 0 || (flags & 0x4000) != 0)) {
                    if (delta.getAffectedChildren().length == 0) {
                        return;
                    }
                    result.add(elem);
                }
                return;
            }
        }
    }

    private static class TypeIndicatorOverlay
    extends CompositeImageDescriptor {
        private static Point fgSize;
        private final ImageDescriptor fType;
        private final boolean fDeprecated;
        private final boolean fPackageDefault;

        public TypeIndicatorOverlay(ImageDescriptor type, boolean deprecated, boolean packageDefault) {
            this.fType = type;
            this.fDeprecated = deprecated;
            this.fPackageDefault = packageDefault;
        }

        protected void drawCompositeImage(int width, int height) {
            ImageData imageData;
            if (this.fDeprecated) {
                imageData = JavaPluginImages.DESC_OVR_DEPRECATED.getImageData();
                this.drawImage(imageData, -1, 1);
            }
            if (this.fType != null) {
                imageData = this.fType.getImageData();
                this.drawImage(imageData, width - imageData.width, 0);
            }
            if (this.fPackageDefault) {
                imageData = JavaPluginImages.DESC_OVR_DEFAULT.getImageData();
                this.drawImage(imageData, width - imageData.width, height - imageData.height);
            }
        }

        protected Point getSize() {
            if (fgSize == null) {
                ImageData imageData = JavaPluginImages.DESC_OVR_DEPRECATED.getImageData();
                fgSize = new Point(imageData.width, imageData.height);
            }
            return fgSize;
        }
    }
}

