/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public abstract class AbstractJavaElementLabelDecorator
implements ILightweightLabelDecorator {
    private ListenerList fListeners;
    private IElementChangedListener fChangeListener;

    public void addListener(ILabelProviderListener listener) {
        if (this.fChangeListener == null) {
            this.fChangeListener = new DecoratorElementChangeListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fChangeListener);
        }
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fChangeListener);
            this.fChangeListener = null;
        }
        if (this.fListeners != null) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                this.fListeners.remove(listeners[i]);
                ++i;
            }
            this.fListeners = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty() && this.fChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fChangeListener);
            this.fChangeListener = null;
        }
    }

    private void fireChange(IJavaElement[] elements) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])elements);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    public abstract void decorate(Object var1, IDecoration var2);

    protected abstract void processDelta(IJavaElementDelta var1, List<IJavaElement> var2);

    protected boolean processChildrenDelta(IJavaElementDelta delta, List<IJavaElement> result) {
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], result);
            ++i;
        }
        return false;
    }

    private class DecoratorElementChangeListener
    implements IElementChangedListener {
        private DecoratorElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            ArrayList<IJavaElement> changed = new ArrayList<IJavaElement>();
            AbstractJavaElementLabelDecorator.this.processDelta(event.getDelta(), changed);
            if (changed.size() == 0) {
                return;
            }
            AbstractJavaElementLabelDecorator.this.fireChange(changed.toArray(new IJavaElement[changed.size()]));
        }
    }
}

