/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RenameLocalVariableProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private ILocalVariable fLocalVariable;
    private ICompilationUnit fCu;
    private boolean fUpdateReferences;
    private String fCurrentName;
    private String fNewName;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private CompilationUnitChange fChange;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private TextChangeManager fChangeManager;
    private RenameAnalyzeUtil.LocalAnalyzePackage fLocalAnalyzePackage;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameLocalVariableProcessor";

    public RenameLocalVariableProcessor(ILocalVariable localVariable) {
        this.fLocalVariable = localVariable;
        this.fUpdateReferences = true;
        if (localVariable != null) {
            this.fCu = (ICompilationUnit)localVariable.getAncestor(5);
        }
        this.fNewName = "";
        this.fIsComposite = false;
    }

    public RenameLocalVariableProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    RenameLocalVariableProcessor(ILocalVariable localVariable, TextChangeManager manager, CompilationUnit node, GroupCategorySet categorySet) {
        this(localVariable);
        this.fChangeManager = manager;
        this.fCategorySet = categorySet;
        this.fCompilationUnitNode = node;
        this.fIsComposite = true;
    }

    @Override
    protected final String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fLocalVariable);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fLocalVariable};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTempRefactoring_rename;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fLocalVariable);
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    @Override
    public String getCurrentElementName() {
        return this.fCurrentName;
    }

    @Override
    public String getNewElementName() {
        return this.fNewName;
    }

    @Override
    public void setNewElementName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewName = newName;
    }

    @Override
    public Object getNewElement() {
        return null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        this.initAST();
        if (this.fTempDeclarationNode == null || this.fTempDeclarationNode.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_must_select_local);
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, MethodDeclaration.class) && !Checks.isDeclaredIn(this.fTempDeclarationNode, Initializer.class)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_only_in_methods_and_initializers);
        }
        this.initNames();
        return new RefactoringStatus();
    }

    private void initAST() {
        ISourceRange sourceRange;
        ASTNode name;
        if (!this.fIsComposite) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, null);
        }
        if ((name = NodeFinder.perform((ASTNode)this.fCompilationUnitNode, (ISourceRange)(sourceRange = this.fLocalVariable.getNameRange()))) == null) {
            return;
        }
        if (name.getParent() instanceof VariableDeclaration) {
            this.fTempDeclarationNode = (VariableDeclaration)name.getParent();
        }
    }

    private void initNames() {
        this.fCurrentName = this.fTempDeclarationNode.getName().getIdentifier();
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fLocalVariable, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[]{ResourceUtil.getFile(this.fCu)};
    }

    @Override
    public int getSaveMode() {
        return 3;
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = this.checkNewElementName(this.fNewName);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.createEdits();
            if (!this.fIsComposite) {
                RenameAnalyzeUtil.LocalAnalyzePackage[] localAnalyzePackages = new RenameAnalyzeUtil.LocalAnalyzePackage[]{this.fLocalAnalyzePackage};
                result.merge(RenameAnalyzeUtil.analyzeLocalRenames(localAnalyzePackages, (TextChange)this.fChange, this.fCompilationUnitNode, true));
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
            if (this.fIsComposite) {
                this.fChange = null;
                this.fCompilationUnitNode = null;
                this.fTempDeclarationNode = null;
            }
        }
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws JavaModelException {
        RefactoringStatus result = Checks.checkFieldName(newName, (IJavaElement)this.fCu);
        if (!Checks.startsWithLowerCase(newName)) {
            if (this.fIsComposite) {
                String nameOfParent = JavaElementLabels.getElementLabel(this.fLocalVariable.getParent(), JavaElementLabels.ALL_DEFAULT);
                String nameOfType = JavaElementLabels.getElementLabel(this.fLocalVariable.getAncestor(7), JavaElementLabels.ALL_DEFAULT);
                result.addWarning(Messages.format(RefactoringCoreMessages.RenameTempRefactoring_lowercase2, new String[]{BasicElementLabels.getJavaElementName(newName), nameOfParent, nameOfType}));
            } else {
                result.addWarning(RefactoringCoreMessages.RenameTempRefactoring_lowercase);
            }
        }
        return result;
    }

    private void createEdits() {
        TextEdit declarationEdit = this.createRenameEdit(this.fTempDeclarationNode.getName().getStartPosition());
        TextEdit[] allRenameEdits = this.getAllRenameEdits(declarationEdit);
        TextEdit[] allUnparentedRenameEdits = new TextEdit[allRenameEdits.length];
        TextEdit unparentedDeclarationEdit = null;
        this.fChange = new CompilationUnitChange(RefactoringCoreMessages.RenameTempRefactoring_rename, this.fCu);
        MultiTextEdit rootEdit = new MultiTextEdit();
        this.fChange.setEdit((TextEdit)rootEdit);
        this.fChange.setKeepPreviewEdits(true);
        int i = 0;
        while (i < allRenameEdits.length) {
            if (this.fIsComposite) {
                TextChangeCompatibility.addTextEdit(this.fChangeManager.get(this.fCu), RefactoringCoreMessages.RenameTempRefactoring_changeName, allRenameEdits[i].copy(), this.fCategorySet);
                allUnparentedRenameEdits[i] = allRenameEdits[i].copy();
                if (allRenameEdits[i].equals((Object)declarationEdit)) {
                    unparentedDeclarationEdit = allUnparentedRenameEdits[i];
                }
            }
            rootEdit.addChild(allRenameEdits[i]);
            this.fChange.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.RenameTempRefactoring_changeName, allRenameEdits[i]));
            ++i;
        }
        this.fLocalAnalyzePackage = this.fIsComposite ? new RenameAnalyzeUtil.LocalAnalyzePackage(unparentedDeclarationEdit, allUnparentedRenameEdits) : new RenameAnalyzeUtil.LocalAnalyzePackage(declarationEdit, allRenameEdits);
    }

    private TextEdit[] getAllRenameEdits(TextEdit declarationEdit) {
        if (!this.fUpdateReferences) {
            return new TextEdit[]{declarationEdit};
        }
        TempOccurrenceAnalyzer fTempAnalyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, true);
        fTempAnalyzer.perform();
        int[] referenceOffsets = fTempAnalyzer.getReferenceAndJavadocOffsets();
        TextEdit[] allRenameEdits = new TextEdit[referenceOffsets.length + 1];
        int i = 0;
        while (i < referenceOffsets.length) {
            allRenameEdits[i] = this.createRenameEdit(referenceOffsets[i]);
            ++i;
        }
        allRenameEdits[referenceOffsets.length] = declarationEdit;
        return allRenameEdits;
    }

    private TextEdit createRenameEdit(int offset) {
        return new ReplaceEdit(offset, this.fCurrentName.length(), this.fNewName);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameTypeProcessor_creating_changes, 1);
            RenameJavaElementDescriptor descriptor = this.createRefactoringDescriptor();
            this.fChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            CompilationUnitChange compilationUnitChange = this.fChange;
            return compilationUnitChange;
        }
        finally {
            monitor.done();
        }
    }

    private RenameJavaElementDescriptor createRefactoringDescriptor() {
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String header = Messages.format(RefactoringCoreMessages.RenameLocalVariableProcessor_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fCurrentName), JavaElementLabels.getElementLabel(this.fLocalVariable.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), BasicElementLabels.getJavaElementName(this.fNewName)});
        String description = Messages.format(RefactoringCoreMessages.RenameLocalVariableProcessor_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fCurrentName));
        String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
        RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor((String)"org.eclipse.jdt.ui.rename.local.variable");
        descriptor.setProject(project);
        descriptor.setDescription(description);
        descriptor.setComment(comment);
        descriptor.setFlags(0);
        descriptor.setJavaElement((IJavaElement)this.fLocalVariable);
        descriptor.setNewName(this.getNewElementName());
        descriptor.setUpdateReferences(this.fUpdateReferences);
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        String references;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists()) return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.local.variable");
        if (element.getElementType() == 5) {
            this.fCu = (ICompilationUnit)element;
        } else {
            if (element.getElementType() != 14) return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.local.variable");
            this.fLocalVariable = (ILocalVariable)element;
            this.fCu = (ICompilationUnit)this.fLocalVariable.getAncestor(5);
            if (this.fCu == null) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.local.variable");
            }
        }
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        if (this.fCu != null && this.fLocalVariable == null) {
            String selection = extended.getAttribute("selection");
            if (selection == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            int offset = -1;
            int length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            try {
                IJavaElement[] elements = this.fCu.codeSelect(offset, length);
                if (elements != null) {
                    int index = 0;
                    while (index < elements.length) {
                        IJavaElement element2 = elements[index];
                        if (element2 instanceof ILocalVariable) {
                            this.fLocalVariable = (ILocalVariable)element2;
                        }
                        ++index;
                    }
                }
                if (this.fLocalVariable == null) {
                    return JavaRefactoringDescriptorUtil.createInputFatalStatus(null, this.getProcessorName(), "org.eclipse.jdt.ui.rename.local.variable");
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        if ((references = extended.getAttribute("references")) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }

    public RenameAnalyzeUtil.LocalAnalyzePackage getLocalAnalyzePackage() {
        return this.fLocalAnalyzePackage;
    }
}

