/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.text.edits.TextEdit;

public final class GenerateHashCodeEqualsOperation
implements IWorkspaceRunnable {
    private static final String JAVA_UTIL_ARRAYS = "java.util.Arrays";
    private static final String BOOLEAN_TRUE_CONSTANT = "1231";
    private static final String BOOLEAN_FALSE_CONSTANT = "1237";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String METHODNAME_GETCLASS = "getClass";
    private static final String METHODNAME_EQUALS = "equals";
    private static final String METHODNAME_DEEP_EQUALS = "deepEquals";
    private static final String METHODNAME_HASH_CODE = "hashCode";
    private static final String METHODNAME_OUTER_TYPE = "getOuterType";
    private static final String PRIME_NUMBER = "31";
    private static final String INITIAL_HASHCODE_VALUE = "1";
    private static final String VARIABLE_NAME_DOUBLE_TEMPORARY = "temp";
    private static final String VARIABLE_NAME_PRIME = "prime";
    private static final String VARIABLE_NAME_RESULT = "result";
    private static final String VARIABLE_NAME_EQUALS_PARAM = "obj";
    private static final String VARIABLE_NAME_HASHCODE_PARAM = "array";
    private static final String VARIABLE_NAME_EQUALS_CASTED = "other";
    private static final String VARIABLE_NAME_INDEX = "index";
    private final boolean fApply;
    private TextEdit fEdit = null;
    private final IJavaElement fInsert;
    private final IVariableBinding[] fFields;
    private final boolean fForce;
    private final boolean fSave;
    private final CodeGenerationSettings fSettings;
    private final ITypeBinding fType;
    private final CompilationUnit fUnit;
    private final CompilationUnitRewrite fRewrite;
    private final AST fAst;
    private int fDoubleCount;
    private List<ITypeBinding> fCustomHashCodeTypes = new ArrayList<ITypeBinding>();
    private final boolean fUseInstanceOf;
    private boolean fUseBlocksForThen;
    private ImportRewrite.ImportRewriteContext fImportRewriteContext;

    public GenerateHashCodeEqualsOperation(ITypeBinding type, IVariableBinding[] fields, CompilationUnit unit, IJavaElement insert, CodeGenerationSettings settings, boolean useInstanceof, boolean force, boolean apply, boolean save) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)fields);
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)settings);
        Assert.isTrue((boolean)(unit.getTypeRoot() instanceof ICompilationUnit));
        this.fType = type;
        this.fInsert = insert;
        this.fUnit = unit;
        this.fFields = fields;
        this.fSettings = settings;
        this.fUseInstanceOf = useInstanceof;
        this.fSave = save;
        this.fApply = apply;
        this.fDoubleCount = 0;
        this.fRewrite = new CompilationUnitRewrite((ICompilationUnit)this.fUnit.getTypeRoot(), this.fUnit);
        this.fForce = force;
        this.fAst = this.fRewrite.getAST();
        this.fUseBlocksForThen = false;
    }

    public void setUseBlocksForThen(boolean useBlocksForThen) {
        this.fUseBlocksForThen = useBlocksForThen;
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_description);
            this.fCustomHashCodeTypes.clear();
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.findDeclaration((IBinding)this.fType, (ASTNode)this.fRewrite.getRoot());
            ListRewrite rewriter = this.fRewrite.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
            List list = (List)declaration.getStructuralProperty((StructuralPropertyDescriptor)declaration.getBodyDeclarationsProperty());
            if (this.fType != null && rewriter != null) {
                ICompilationUnit cu = (ICompilationUnit)this.fUnit.getJavaElement();
                ASTNode insertion = StubUtility2.getNodeToInsertBefore(rewriter, this.fInsert);
                ITypeBinding[] objectAsParam = new ITypeBinding[]{declaration.getAST().resolveWellKnownType(JAVA_LANG_OBJECT)};
                BodyDeclaration oldEquals = this.fForce ? this.findMethodToReplace(list, METHODNAME_EQUALS, objectAsParam) : null;
                this.fImportRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)declaration, this.fRewrite.getImportRewrite());
                MethodDeclaration equalsMethod = this.createEqualsMethod();
                this.addMethod(rewriter, insertion, equalsMethod, oldEquals);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                BodyDeclaration oldHash = this.fForce ? this.findMethodToReplace(list, METHODNAME_HASH_CODE, new ITypeBinding[0]) : null;
                MethodDeclaration hashCodeMethod = this.createHashCodeMethod();
                this.addMethod(rewriter, (ASTNode)equalsMethod, hashCodeMethod, oldHash);
                for (ITypeBinding binding : this.fCustomHashCodeTypes) {
                    if (this.findMethodToReplace(list, METHODNAME_HASH_CODE, objectAsParam) != null) continue;
                    MethodDeclaration helperDecl = this.createHashCodeHelper(binding);
                    this.addHelper(rewriter, null, helperDecl);
                }
                if (this.isMemberType() && this.findMethodToReplace(list, METHODNAME_OUTER_TYPE, new ITypeBinding[0]) == null) {
                    MethodDeclaration helperDecl = this.createGetOuterHelper();
                    rewriter.insertLast((ASTNode)helperDecl, null);
                }
                this.fEdit = this.fRewrite.createChange(true).getEdit();
                if (this.fApply) {
                    JavaModelUtil.applyEdit(cu, this.fEdit, this.fSave, monitor);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean isMemberType() {
        return this.fType.isMember() && !Modifier.isStatic((int)this.fType.getModifiers());
    }

    private BodyDeclaration findMethodToReplace(List<BodyDeclaration> list, String name, ITypeBinding[] paramTypes) {
        for (BodyDeclaration bodyDecl : list) {
            MethodDeclaration method;
            IMethodBinding binding;
            if (!(bodyDecl instanceof MethodDeclaration) || (binding = (method = (MethodDeclaration)bodyDecl).resolveBinding()) == null || !binding.getName().equals(name) || !Bindings.equals((IBinding[])binding.getParameterTypes(), (IBinding[])paramTypes)) continue;
            return method;
        }
        return null;
    }

    private void addHelper(ListRewrite rewriter, ASTNode insertion, MethodDeclaration stub) {
        if (insertion != null) {
            rewriter.insertBefore((ASTNode)stub, insertion, null);
        } else {
            rewriter.insertFirst((ASTNode)stub, null);
        }
    }

    private void addMethod(ListRewrite rewriter, ASTNode insertion, MethodDeclaration stub, BodyDeclaration replace) {
        if (replace != null) {
            rewriter.replace((ASTNode)replace, (ASTNode)stub, null);
        } else if (insertion != null) {
            rewriter.insertBefore((ASTNode)stub, insertion, null);
        } else {
            rewriter.insertLast((ASTNode)stub, null);
        }
    }

    private MethodDeclaration createHashCodeMethod() throws CoreException {
        MethodDeclaration hashCodeMethod = this.fAst.newMethodDeclaration();
        hashCodeMethod.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 1));
        hashCodeMethod.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        hashCodeMethod.setConstructor(false);
        hashCodeMethod.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        Block body = this.fAst.newBlock();
        hashCodeMethod.setBody(body);
        VariableDeclarationFragment frag = this.fAst.newVariableDeclarationFragment();
        frag.setName(this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        frag.setInitializer((Expression)this.fAst.newNumberLiteral(PRIME_NUMBER));
        VariableDeclarationStatement primeNumberDeclaration = this.fAst.newVariableDeclarationStatement(frag);
        primeNumberDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        primeNumberDeclaration.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        body.statements().add(primeNumberDeclaration);
        VariableDeclarationFragment fragment = this.fAst.newVariableDeclarationFragment();
        fragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        VariableDeclarationStatement resultDeclaration = this.fAst.newVariableDeclarationStatement(fragment);
        resultDeclaration.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        body.statements().add(resultDeclaration);
        if (this.needsNoSuperCall(this.fType, METHODNAME_HASH_CODE, new ITypeBinding[0])) {
            fragment.setInitializer((Expression)this.fAst.newNumberLiteral(INITIAL_HASHCODE_VALUE));
        } else {
            SuperMethodInvocation invoc = this.fAst.newSuperMethodInvocation();
            invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            fragment.setInitializer((Expression)invoc);
        }
        if (this.isMemberType()) {
            body.statements().add(this.createAddOuterHashCode());
        }
        int i = 0;
        while (i < this.fFields.length) {
            if (this.fFields[i].getType().isPrimitive()) {
                Statement[] sts = this.createAddSimpleHashCode(this.fFields[i].getType(), new IHashCodeAccessProvider(){

                    @Override
                    public Expression getThisAccess(String name) {
                        return GenerateHashCodeEqualsOperation.this.getThisAccessForHashCode(name);
                    }
                }, this.fFields[i].getName(), false);
                int j = 0;
                while (j < sts.length) {
                    body.statements().add(sts[j]);
                    ++j;
                }
            } else if (this.fFields[i].getType().isArray()) {
                body.statements().add(this.createAddArrayHashCode(this.fFields[i]));
            } else {
                body.statements().add(this.createAddQualifiedHashCode(this.fFields[i]));
            }
            ++i;
        }
        ReturnStatement endReturn = this.fAst.newReturnStatement();
        endReturn.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        body.statements().add(endReturn);
        if (this.fSettings != null) {
            ITypeBinding object = this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT);
            IMethodBinding[] objms = object.getDeclaredMethods();
            IMethodBinding objectMethod = null;
            int i2 = 0;
            while (i2 < objms.length) {
                if (objms[i2].getName().equals(METHODNAME_HASH_CODE) && objms[i2].getParameterTypes().length == 0) {
                    objectMethod = objms[i2];
                }
                ++i2;
            }
            this.createMethodComment(hashCodeMethod, objectMethod);
        }
        return hashCodeMethod;
    }

    private Statement createAddOuterHashCode() {
        MethodInvocation outer = this.fAst.newMethodInvocation();
        outer.setName(this.fAst.newSimpleName(METHODNAME_OUTER_TYPE));
        MethodInvocation hashAccess = this.fAst.newMethodInvocation();
        hashAccess.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        hashAccess.setExpression((Expression)outer);
        return this.prepareAssignment((Expression)hashAccess);
    }

    private Statement[] createAddSimpleHashCode(ITypeBinding type, IHashCodeAccessProvider provider, String name, boolean singleTemp) {
        ArrayList<Object> statements = new ArrayList<Object>();
        if (!type.isPrimitive()) {
            ConditionalExpression ce = this.fAst.newConditionalExpression();
            InfixExpression exp = this.fAst.newInfixExpression();
            ArrayAccess access = this.fAst.newArrayAccess();
            access.setArray((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            access.setIndex((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
            exp.setLeftOperand((Expression)access);
            exp.setOperator(InfixExpression.Operator.EQUALS);
            exp.setRightOperand((Expression)this.fAst.newNullLiteral());
            ce.setExpression((Expression)exp);
            ce.setThenExpression((Expression)this.fAst.newNumberLiteral("0"));
            MethodInvocation invoc = this.fAst.newMethodInvocation();
            access = this.fAst.newArrayAccess();
            access.setArray((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            access.setIndex((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
            invoc.setExpression((Expression)access);
            invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            ce.setElseExpression((Expression)invoc);
            statements.add(this.prepareAssignment(this.parenthesize((Expression)ce)));
        } else if (this.isPrimitiveType(type, PrimitiveType.BOOLEAN)) {
            ConditionalExpression ce = this.fAst.newConditionalExpression();
            ce.setExpression(provider.getThisAccess(name));
            ce.setThenExpression((Expression)this.fAst.newNumberLiteral(BOOLEAN_TRUE_CONSTANT));
            ce.setElseExpression((Expression)this.fAst.newNumberLiteral(BOOLEAN_FALSE_CONSTANT));
            statements.add(this.prepareAssignment(this.parenthesize((Expression)ce)));
        } else if (this.isPrimitiveType(type, new PrimitiveType.Code[]{PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.SHORT, PrimitiveType.BYTE})) {
            statements.add(this.prepareAssignment(provider.getThisAccess(name)));
        } else if (this.isPrimitiveType(type, PrimitiveType.FLOAT)) {
            statements.add(this.prepareAssignment(this.createFloatInvocation(provider.getThisAccess(name))));
        } else if (this.isPrimitiveType(type, PrimitiveType.LONG)) {
            statements.add(this.prepareAssignment(this.createShiftAssignment(provider.getThisAccess(name), provider.getThisAccess(name))));
        } else if (this.isPrimitiveType(type, PrimitiveType.DOUBLE)) {
            VariableDeclarationFragment fragment = null;
            if (singleTemp || this.fDoubleCount == 0) {
                fragment = this.fAst.newVariableDeclarationFragment();
                fragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY));
                VariableDeclarationStatement st2 = this.fAst.newVariableDeclarationStatement(fragment);
                st2.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.LONG));
                statements.add(st2);
            }
            ++this.fDoubleCount;
            Expression comparison = this.createDoubleInvocation(provider.getThisAccess(name));
            if (singleTemp) {
                fragment.setInitializer(comparison);
            } else {
                Assignment ass = this.fAst.newAssignment();
                ass.setLeftHandSide((Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY));
                ass.setRightHandSide(comparison);
                statements.add(this.fAst.newExpressionStatement((Expression)ass));
            }
            statements.add(this.prepareAssignment(this.createShiftAssignment((Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY), (Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY))));
        }
        return statements.toArray(new Statement[statements.size()]);
    }

    private Statement createAddArrayHashCode(IVariableBinding binding) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        if (JavaModelUtil.is50OrHigher(this.fRewrite.getCu().getJavaProject())) {
            invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            invoc.setExpression((Expression)this.getQualifiedName(JAVA_UTIL_ARRAYS));
            invoc.arguments().add(this.getThisAccessForHashCode(binding.getName()));
        } else {
            invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            IJavaElement element = this.fType.getJavaElement();
            if (element != null && !"".equals(element.getElementName())) {
                invoc.setExpression((Expression)this.fAst.newSimpleName(element.getElementName()));
            }
            invoc.arguments().add(this.getThisAccessForHashCode(binding.getName()));
            ITypeBinding type = binding.getType().getElementType();
            if (!Bindings.isVoidType(type)) {
                if (!type.isPrimitive() || binding.getType().getDimensions() >= 2) {
                    type = this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT);
                }
                if (!this.fCustomHashCodeTypes.contains(type)) {
                    this.fCustomHashCodeTypes.add(type);
                }
            }
        }
        return this.prepareAssignment((Expression)invoc);
    }

    private MethodDeclaration createGetOuterHelper() {
        String outerTypeName = this.fType.getDeclaringClass().getTypeDeclaration().getName();
        MethodDeclaration helperMethod = this.fAst.newMethodDeclaration();
        helperMethod.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 2));
        helperMethod.setName(this.fAst.newSimpleName(METHODNAME_OUTER_TYPE));
        helperMethod.setConstructor(false);
        helperMethod.setReturnType2((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName(outerTypeName)));
        Block body = this.fAst.newBlock();
        helperMethod.setBody(body);
        ThisExpression thisExpression = this.fAst.newThisExpression();
        thisExpression.setQualifier((Name)this.fAst.newSimpleName(outerTypeName));
        ReturnStatement endReturn = this.fAst.newReturnStatement();
        endReturn.setExpression((Expression)thisExpression);
        body.statements().add(endReturn);
        return helperMethod;
    }

    private MethodDeclaration createHashCodeHelper(ITypeBinding binding) {
        Assert.isTrue((!binding.isArray() ? 1 : 0) != 0);
        MethodDeclaration hashCodeMethod = this.fAst.newMethodDeclaration();
        hashCodeMethod.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 10));
        hashCodeMethod.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        hashCodeMethod.setConstructor(false);
        hashCodeMethod.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        List parameters = hashCodeMethod.parameters();
        SingleVariableDeclaration hashCodeParam = this.fAst.newSingleVariableDeclaration();
        if (!binding.isPrimitive()) {
            hashCodeParam.setType((Type)this.fAst.newArrayType((Type)this.fAst.newSimpleType(this.getQualifiedName(JAVA_LANG_OBJECT)), 1));
        } else {
            hashCodeParam.setType((Type)this.fAst.newArrayType((Type)this.fAst.newPrimitiveType(PrimitiveType.toCode((String)binding.getName())), 1));
        }
        hashCodeParam.setName(this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        parameters.add(hashCodeParam);
        Block body = this.fAst.newBlock();
        hashCodeMethod.setBody(body);
        VariableDeclarationFragment frag = this.fAst.newVariableDeclarationFragment();
        frag.setName(this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        frag.setInitializer((Expression)this.fAst.newNumberLiteral(PRIME_NUMBER));
        VariableDeclarationStatement primeNumberDeclaration = this.fAst.newVariableDeclarationStatement(frag);
        primeNumberDeclaration.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        body.statements().add(primeNumberDeclaration);
        IfStatement ifStatement = this.fAst.newIfStatement();
        InfixExpression newInfixExpression = this.fAst.newInfixExpression();
        newInfixExpression.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        newInfixExpression.setRightOperand((Expression)this.fAst.newNullLiteral());
        newInfixExpression.setOperator(InfixExpression.Operator.EQUALS);
        ifStatement.setExpression((Expression)newInfixExpression);
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression((Expression)this.fAst.newNumberLiteral("0"));
        ifStatement.setThenStatement(this.getThenStatement((Statement)returnStatement));
        body.statements().add(ifStatement);
        VariableDeclarationFragment resultFragment = this.fAst.newVariableDeclarationFragment();
        resultFragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        resultFragment.setInitializer((Expression)this.fAst.newNumberLiteral(INITIAL_HASHCODE_VALUE));
        VariableDeclarationStatement resultDeclaration = this.fAst.newVariableDeclarationStatement(resultFragment);
        resultDeclaration.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        body.statements().add(resultDeclaration);
        ForStatement forStatement = this.fAst.newForStatement();
        VariableDeclarationFragment indexDeclaration = this.fAst.newVariableDeclarationFragment();
        indexDeclaration.setName(this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        indexDeclaration.setInitializer((Expression)this.fAst.newNumberLiteral("0"));
        VariableDeclarationExpression declExpression = this.fAst.newVariableDeclarationExpression(indexDeclaration);
        declExpression.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        forStatement.initializers().add(declExpression);
        InfixExpression infixExpr = this.fAst.newInfixExpression();
        infixExpr.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        FieldAccess access = this.fAst.newFieldAccess();
        access.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        access.setName(this.fAst.newSimpleName("length"));
        infixExpr.setRightOperand((Expression)access);
        infixExpr.setOperator(InfixExpression.Operator.LESS);
        forStatement.setExpression((Expression)infixExpr);
        PostfixExpression postfixExpr = this.fAst.newPostfixExpression();
        postfixExpr.setOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        postfixExpr.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpr);
        body.statements().add(forStatement);
        Block forBody = this.fAst.newBlock();
        Statement[] statements = this.createAddSimpleHashCode(binding, new IHashCodeAccessProvider(){

            @Override
            public Expression getThisAccess(String name) {
                ArrayAccess a = GenerateHashCodeEqualsOperation.this.fAst.newArrayAccess();
                a.setArray((Expression)GenerateHashCodeEqualsOperation.this.fAst.newSimpleName(GenerateHashCodeEqualsOperation.VARIABLE_NAME_HASHCODE_PARAM));
                a.setIndex((Expression)GenerateHashCodeEqualsOperation.this.fAst.newSimpleName(name));
                return a;
            }
        }, VARIABLE_NAME_INDEX, true);
        int index = 0;
        while (index < statements.length) {
            forBody.statements().add(statements[index]);
            ++index;
        }
        forStatement.setBody((Statement)forBody);
        ReturnStatement endReturn = this.fAst.newReturnStatement();
        endReturn.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        body.statements().add(endReturn);
        if (this.fSettings != null && this.fSettings.createComments) {
            Javadoc javadoc = this.fAst.newJavadoc();
            TagElement tagComment = this.fAst.newTagElement();
            TextElement text = this.fAst.newTextElement();
            text.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_hash_code_comment);
            tagComment.fragments().add(text);
            javadoc.tags().add(tagComment);
            TagElement tagParam = this.fAst.newTagElement();
            tagParam.setTagName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_tag_param);
            tagParam.fragments().add(this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            text = this.fAst.newTextElement();
            text.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_hash_code_argument);
            tagParam.fragments().add(text);
            javadoc.tags().add(tagParam);
            TagElement tagReturn = this.fAst.newTagElement();
            tagReturn.setTagName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_tag_return);
            text = this.fAst.newTextElement();
            text.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_return_comment);
            tagReturn.fragments().add(text);
            javadoc.tags().add(tagReturn);
            hashCodeMethod.setJavadoc(javadoc);
        }
        return hashCodeMethod;
    }

    private Statement createAddQualifiedHashCode(IVariableBinding binding) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setExpression(this.getThisAccessForHashCode(binding.getName()));
        invoc.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        InfixExpression expr = this.fAst.newInfixExpression();
        expr.setOperator(InfixExpression.Operator.EQUALS);
        expr.setLeftOperand(this.getThisAccessForHashCode(binding.getName()));
        expr.setRightOperand((Expression)this.fAst.newNullLiteral());
        ConditionalExpression cexpr = this.fAst.newConditionalExpression();
        cexpr.setThenExpression((Expression)this.fAst.newNumberLiteral("0"));
        cexpr.setElseExpression((Expression)invoc);
        cexpr.setExpression(this.parenthesize((Expression)expr));
        return this.prepareAssignment(this.parenthesize((Expression)cexpr));
    }

    private Expression createShiftAssignment(Expression shift1, Expression shift2) {
        CastExpression ce = this.fAst.newCastExpression();
        ce.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        InfixExpression unsignedShiftRight = this.fAst.newInfixExpression();
        unsignedShiftRight.setLeftOperand(shift1);
        unsignedShiftRight.setRightOperand((Expression)this.fAst.newNumberLiteral("32"));
        unsignedShiftRight.setOperator(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED);
        InfixExpression xor = this.fAst.newInfixExpression();
        xor.setLeftOperand(shift2);
        xor.setRightOperand(this.parenthesize((Expression)unsignedShiftRight));
        xor.setOperator(InfixExpression.Operator.XOR);
        ce.setExpression(this.parenthesize((Expression)xor));
        return ce;
    }

    private Statement prepareAssignment(Expression rightHand) {
        InfixExpression mul = this.fAst.newInfixExpression();
        mul.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        mul.setRightOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        mul.setOperator(InfixExpression.Operator.TIMES);
        Assignment ass = this.fAst.newAssignment();
        ass.setLeftHandSide((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        InfixExpression plus = this.fAst.newInfixExpression();
        plus.setLeftOperand((Expression)mul);
        plus.setOperator(InfixExpression.Operator.PLUS);
        plus.setRightOperand(rightHand);
        ass.setRightHandSide((Expression)plus);
        return this.fAst.newExpressionStatement((Expression)ass);
    }

    private MethodDeclaration createEqualsMethod() throws CoreException {
        MethodDeclaration equalsMethodDeclaration = this.fAst.newMethodDeclaration();
        equalsMethodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 1));
        equalsMethodDeclaration.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        equalsMethodDeclaration.setConstructor(false);
        equalsMethodDeclaration.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.BOOLEAN));
        List parameters = equalsMethodDeclaration.parameters();
        SingleVariableDeclaration equalsParam = this.fAst.newSingleVariableDeclaration();
        equalsParam.setType(this.fRewrite.getImportRewrite().addImport(this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT), this.fAst, this.fImportRewriteContext));
        equalsParam.setName(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
        parameters.add(equalsParam);
        Block body = this.fAst.newBlock();
        equalsMethodDeclaration.setBody(body);
        body.statements().add(this.createReturningIfStatement((Expression)this.fAst.newThisExpression(), (Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM), InfixExpression.Operator.EQUALS, true));
        if (this.needsNoSuperCall(this.fType, METHODNAME_EQUALS, new ITypeBinding[]{this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT)})) {
            body.statements().add(this.createReturningIfStatement((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM), (Expression)this.fAst.newNullLiteral(), InfixExpression.Operator.EQUALS, false));
        } else {
            SuperMethodInvocation superEqualsCall = this.fAst.newSuperMethodInvocation();
            superEqualsCall.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
            superEqualsCall.arguments().add(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
            PrefixExpression pe = this.fAst.newPrefixExpression();
            pe.setOperator(PrefixExpression.Operator.NOT);
            pe.setOperand((Expression)superEqualsCall);
            IfStatement superEqualsIf = this.fAst.newIfStatement();
            superEqualsIf.setExpression((Expression)pe);
            superEqualsIf.setThenStatement(this.getThenStatement((Statement)this.getReturnFalse()));
            body.statements().add(superEqualsIf);
        }
        if (this.fUseInstanceOf) {
            InstanceofExpression expression = this.fAst.newInstanceofExpression();
            expression.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
            expression.setRightOperand(this.fRewrite.getImportRewrite().addImport(this.fType, this.fAst, this.fImportRewriteContext));
            PrefixExpression notExpression = this.fAst.newPrefixExpression();
            notExpression.setOperator(PrefixExpression.Operator.NOT);
            ParenthesizedExpression parenthesizedExpression = this.fAst.newParenthesizedExpression();
            parenthesizedExpression.setExpression((Expression)expression);
            notExpression.setOperand((Expression)parenthesizedExpression);
            body.statements().add(this.createReturningIfStatement(false, (Expression)notExpression));
        } else {
            MethodInvocation thisClass = this.fAst.newMethodInvocation();
            thisClass.setName(this.fAst.newSimpleName(METHODNAME_GETCLASS));
            MethodInvocation objGetClass = this.fAst.newMethodInvocation();
            objGetClass.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
            objGetClass.setName(this.fAst.newSimpleName(METHODNAME_GETCLASS));
            body.statements().add(this.createReturningIfStatement((Expression)thisClass, (Expression)objGetClass, InfixExpression.Operator.NOT_EQUALS, false));
        }
        VariableDeclarationFragment sd = this.fAst.newVariableDeclarationFragment();
        sd.setName(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_CASTED));
        CastExpression cast = this.fAst.newCastExpression();
        cast.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName(this.fType.getName())));
        cast.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
        sd.setInitializer((Expression)cast);
        VariableDeclarationStatement otherDeclaration = this.fAst.newVariableDeclarationStatement(sd);
        otherDeclaration.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName(this.fType.getName())));
        body.statements().add(otherDeclaration);
        if (this.isMemberType()) {
            body.statements().add(this.createOuterComparison());
        }
        int i = 0;
        while (i < this.fFields.length) {
            IVariableBinding field = this.fFields[i];
            ITypeBinding type = field.getType();
            if (type.isPrimitive() || type.isEnum()) {
                body.statements().add(this.createSimpleComparison(field));
            } else if (type.isArray()) {
                IJavaProject project = this.fUnit.getJavaElement().getJavaProject();
                if (type.getDimensions() > 1 && JavaModelUtil.is50OrHigher(project)) {
                    body.statements().add(this.createMultiArrayComparison(field.getName()));
                } else {
                    body.statements().add(this.createArrayComparison(field.getName()));
                }
            } else {
                body.statements().add(this.createQualifiedComparison(field.getName()));
            }
            ++i;
        }
        ReturnStatement endReturn = this.fAst.newReturnStatement();
        endReturn.setExpression((Expression)this.fAst.newBooleanLiteral(true));
        body.statements().add(endReturn);
        if (this.fSettings != null) {
            ITypeBinding object = this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT);
            IMethodBinding[] objms = object.getDeclaredMethods();
            IMethodBinding objectMethod = null;
            int i2 = 0;
            while (i2 < objms.length) {
                if (objms[i2].getName().equals(METHODNAME_EQUALS) && objms[i2].getParameterTypes().length == 1 && objms[i2].getParameterTypes()[0].getQualifiedName().equals(JAVA_LANG_OBJECT)) {
                    objectMethod = objms[i2];
                }
                ++i2;
            }
            this.createMethodComment(equalsMethodDeclaration, objectMethod);
        }
        return equalsMethodDeclaration;
    }

    private Statement createOuterComparison() {
        MethodInvocation outer1 = this.fAst.newMethodInvocation();
        outer1.setName(this.fAst.newSimpleName(METHODNAME_OUTER_TYPE));
        MethodInvocation outer2 = this.fAst.newMethodInvocation();
        outer2.setName(this.fAst.newSimpleName(METHODNAME_OUTER_TYPE));
        outer2.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_CASTED));
        MethodInvocation outerEql = this.fAst.newMethodInvocation();
        outerEql.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        outerEql.setExpression((Expression)outer1);
        outerEql.arguments().add(outer2);
        PrefixExpression not = this.fAst.newPrefixExpression();
        not.setOperand((Expression)outerEql);
        not.setOperator(PrefixExpression.Operator.NOT);
        IfStatement notEqNull = this.fAst.newIfStatement();
        notEqNull.setExpression((Expression)not);
        notEqNull.setThenStatement(this.getThenStatement((Statement)this.getReturnFalse()));
        return notEqNull;
    }

    private Statement createSimpleComparison(IVariableBinding binding) {
        if (this.isPrimitiveType(binding.getType(), PrimitiveType.FLOAT)) {
            return this.createReturningIfStatement(this.createFloatInvocation(this.getThisAccessForEquals(binding.getName())), this.createFloatInvocation(this.getOtherAccess(binding.getName())), InfixExpression.Operator.NOT_EQUALS, false);
        }
        if (this.isPrimitiveType(binding.getType(), PrimitiveType.DOUBLE)) {
            return this.createReturningIfStatement(this.createDoubleInvocation(this.getThisAccessForEquals(binding.getName())), this.createDoubleInvocation(this.getOtherAccess(binding.getName())), InfixExpression.Operator.NOT_EQUALS, false);
        }
        return this.createReturningIfStatement(this.getThisAccessForEquals(binding.getName()), this.getOtherAccess(binding.getName()), InfixExpression.Operator.NOT_EQUALS, false);
    }

    private Statement createArrayComparison(String name) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        invoc.setExpression((Expression)this.getQualifiedName(JAVA_UTIL_ARRAYS));
        invoc.arguments().add(this.getThisAccessForEquals(name));
        invoc.arguments().add(this.getOtherAccess(name));
        PrefixExpression pe = this.fAst.newPrefixExpression();
        pe.setOperator(PrefixExpression.Operator.NOT);
        pe.setOperand((Expression)invoc);
        IfStatement ifSt = this.fAst.newIfStatement();
        ifSt.setExpression((Expression)pe);
        ifSt.setThenStatement(this.getThenStatement((Statement)this.getReturnFalse()));
        return ifSt;
    }

    private Statement createMultiArrayComparison(String name) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setName(this.fAst.newSimpleName(METHODNAME_DEEP_EQUALS));
        invoc.setExpression((Expression)this.getQualifiedName(JAVA_UTIL_ARRAYS));
        invoc.arguments().add(this.getThisAccessForEquals(name));
        invoc.arguments().add(this.getOtherAccess(name));
        PrefixExpression pe = this.fAst.newPrefixExpression();
        pe.setOperator(PrefixExpression.Operator.NOT);
        pe.setOperand((Expression)invoc);
        IfStatement ifSt = this.fAst.newIfStatement();
        ifSt.setExpression((Expression)pe);
        ifSt.setThenStatement(this.getThenStatement((Statement)this.getReturnFalse()));
        return ifSt;
    }

    private Statement createQualifiedComparison(String name) {
        InfixExpression newCondition = this.fAst.newInfixExpression();
        newCondition.setOperator(InfixExpression.Operator.EQUALS);
        newCondition.setLeftOperand(this.getThisAccessForEquals(name));
        newCondition.setRightOperand((Expression)this.fAst.newNullLiteral());
        InfixExpression notEqNull = this.fAst.newInfixExpression();
        notEqNull.setOperator(InfixExpression.Operator.NOT_EQUALS);
        notEqNull.setLeftOperand(this.getOtherAccess(name));
        notEqNull.setRightOperand((Expression)this.fAst.newNullLiteral());
        IfStatement thenPart = this.fAst.newIfStatement();
        thenPart.setExpression((Expression)notEqNull);
        thenPart.setThenStatement(this.getThenStatement((Statement)this.getReturnFalse()));
        Block thenPart2 = this.fAst.newBlock();
        thenPart2.statements().add(thenPart);
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        invoc.setExpression(this.getThisAccessForEquals(name));
        invoc.arguments().add(this.getOtherAccess(name));
        PrefixExpression pe = this.fAst.newPrefixExpression();
        pe.setOperator(PrefixExpression.Operator.NOT);
        pe.setOperand((Expression)invoc);
        IfStatement elsePart = this.fAst.newIfStatement();
        elsePart.setExpression((Expression)pe);
        elsePart.setThenStatement(this.getThenStatement((Statement)this.getReturnFalse()));
        IfStatement isNull = this.fAst.newIfStatement();
        isNull.setExpression((Expression)newCondition);
        isNull.setThenStatement((Statement)thenPart2);
        isNull.setElseStatement((Statement)elsePart);
        return isNull;
    }

    private Statement createReturningIfStatement(Expression left, Expression right, InfixExpression.Operator operator, boolean whatToReturn) {
        InfixExpression newCondition = this.fAst.newInfixExpression();
        newCondition.setOperator(operator);
        newCondition.setLeftOperand(left);
        newCondition.setRightOperand(right);
        return this.createReturningIfStatement(whatToReturn, (Expression)newCondition);
    }

    private Statement createReturningIfStatement(boolean result, Expression condition) {
        IfStatement firstIf = this.fAst.newIfStatement();
        firstIf.setExpression(condition);
        ReturnStatement returner = this.fAst.newReturnStatement();
        returner.setExpression((Expression)this.fAst.newBooleanLiteral(result));
        firstIf.setThenStatement(this.getThenStatement((Statement)returner));
        return firstIf;
    }

    private void createMethodComment(MethodDeclaration newDeclaration, IMethodBinding copyFrom) throws CoreException {
        String string;
        if (this.fSettings.createComments && (string = CodeGeneration.getMethodComment(this.fRewrite.getCu(), this.fType.getQualifiedName(), newDeclaration, copyFrom, StubUtility.getLineDelimiterUsed((IJavaElement)this.fRewrite.getCu()))) != null) {
            Javadoc javadoc = (Javadoc)this.fRewrite.getASTRewrite().createStringPlaceholder(string, 29);
            newDeclaration.setJavadoc(javadoc);
        }
        IJavaProject project = this.fUnit.getJavaElement().getJavaProject();
        if (this.fSettings.overrideAnnotation && JavaModelUtil.is50OrHigher(project)) {
            StubUtility2.addOverrideAnnotation(project, this.fRewrite.getASTRewrite(), newDeclaration, copyFrom);
        }
    }

    private boolean needsNoSuperCall(ITypeBinding typeBinding, String name, ITypeBinding[] parameters) {
        Assert.isNotNull((Object)typeBinding);
        IMethodBinding binding = Bindings.findMethodInHierarchy(typeBinding.getSuperclass(), name, parameters);
        if (binding != null && !Modifier.isAbstract((int)binding.getModifiers())) {
            ITypeBinding declaring = binding.getDeclaringClass();
            return declaring.getQualifiedName().equals(JAVA_LANG_OBJECT);
        }
        return true;
    }

    private Expression getThisAccessForEquals(String name) {
        return this.getThisAccess(name, false);
    }

    private Expression getThisAccessForHashCode(String name) {
        return this.getThisAccess(name, true);
    }

    private Expression getThisAccess(String name, boolean forHashCode) {
        if (this.fSettings.useKeywordThis || this.needsThisQualification(name, forHashCode)) {
            FieldAccess fa = this.fAst.newFieldAccess();
            fa.setExpression((Expression)this.fAst.newThisExpression());
            fa.setName(this.fAst.newSimpleName(name));
            return fa;
        }
        return this.fAst.newSimpleName(name);
    }

    private Expression getOtherAccess(String name) {
        return this.fAst.newQualifiedName((Name)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_CASTED), this.fAst.newSimpleName(name));
    }

    private boolean isPrimitiveType(ITypeBinding binding, PrimitiveType.Code code) {
        return binding.getName().equals(code.toString());
    }

    private boolean isPrimitiveType(ITypeBinding type, PrimitiveType.Code[] codes) {
        int i = 0;
        while (i < codes.length) {
            PrimitiveType.Code code = codes[i];
            if (this.isPrimitiveType(type, code)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Name getQualifiedName(String name) {
        String importedType = this.fRewrite.getImportRewrite().addImport(name, this.fImportRewriteContext);
        return ASTNodeFactory.newName(this.fAst, importedType);
    }

    private ReturnStatement getReturnFalse() {
        ReturnStatement falseReturn = this.fAst.newReturnStatement();
        falseReturn.setExpression((Expression)this.fAst.newBooleanLiteral(false));
        return falseReturn;
    }

    private Statement getThenStatement(Statement statement) {
        if (this.fUseBlocksForThen && !(statement instanceof Block)) {
            Block block = this.fAst.newBlock();
            block.statements().add(statement);
            return block;
        }
        return statement;
    }

    private Expression parenthesize(Expression expression) {
        ParenthesizedExpression pe = this.fAst.newParenthesizedExpression();
        pe.setExpression(expression);
        return pe;
    }

    private Expression createFloatInvocation(Expression access) {
        return this.createMethodInvocation(access, "java.lang.Float", "floatToIntBits");
    }

    private Expression createDoubleInvocation(Expression access) {
        return this.createMethodInvocation(access, "java.lang.Double", "doubleToLongBits");
    }

    private Expression createMethodInvocation(Expression access, String qualifiedClassName, String methodName) {
        MethodInvocation invoc = this.fAst.newMethodInvocation();
        invoc.setExpression((Expression)this.getQualifiedName(qualifiedClassName));
        invoc.setName(this.fAst.newSimpleName(methodName));
        invoc.arguments().add(access);
        return invoc;
    }

    private boolean needsThisQualification(String name, boolean isHashCode) {
        if (isHashCode) {
            return this.fDoubleCount > 0 && name.equals(VARIABLE_NAME_DOUBLE_TEMPORARY) || name.equals(VARIABLE_NAME_PRIME) || name.equals(VARIABLE_NAME_RESULT);
        }
        return name.equals(VARIABLE_NAME_EQUALS_CASTED) || name.equals(VARIABLE_NAME_EQUALS_PARAM);
    }

    private static interface IHashCodeAccessProvider {
        public Expression getThisAccess(String var1);
    }
}

