/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.view;

import info.gongqi.view.LogRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MysqlBinLogParser {
    public static List<LogRecord> parserBinLog(File file) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                SimpleDateFormat format = new SimpleDateFormat("yyMMdd HH:mm:ss");
                LogRecord record = null;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("# at ")) continue;
                    record = new LogRecord();
                    line = br.readLine();
                    record.setStartDate(format.parse(line.substring(1, 16)));
                    br.readLine();
                    String sql = br.readLine();
                    record.setSql(sql);
                    if (sql.toLowerCase().startsWith("insert")) {
                        record.setAction('I');
                    } else if (sql.toLowerCase().startsWith("update")) {
                        record.setAction('U');
                    } else if (sql.toLowerCase().startsWith("delete")) {
                        record.setAction('D');
                    }
                    br.readLine();
                    line = br.readLine();
                    record.setEndDate(format.parse(line.substring(1, 16)));
                    records.add(record);
                }
            }
            catch (Exception exception) {
                List list = Collections.EMPTY_LIST;
                if (br != null) {
                    try {
                        br.close();
                        br = null;
                    }
                    catch (IOException iOException) {}
                }
                return list;
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                    br = null;
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (br != null) {
            try {
                br.close();
                br = null;
            }
            catch (IOException iOException) {}
        }
        return records;
    }
}

