/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.view;

import core.util.SystemUtil;
import core.util.file.FileUtil;
import info.gongqi.util.PreferenceHelp;
import info.gongqi.view.LogRecord;
import info.gongqi.view.MysqlBinLogParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class MySQLBinlogMonitor {
    private String mysql_home = this.getMySQLHome();
    private File index = new File(String.valueOf(this.mysql_home) + "\\data\\mysql-bin.index");
    private static MySQLBinlogMonitor instance;

    private MySQLBinlogMonitor() {
    }

    public static MySQLBinlogMonitor getInstance() {
        if (instance == null) {
            instance = new MySQLBinlogMonitor();
        }
        return instance;
    }

    public void start() {
        String date = this.getCurrentDate();
        String indexName = this.getLastBinlog();
        PreferenceHelp.setString("startdatetime", date);
        PreferenceHelp.setString("startIndex", indexName);
    }

    public List<LogRecord> flushLogRecord() {
        File temp = new File(SystemUtil.getSystemTempDirectory(), UUID.randomUUID() + ".sql");
        try {
            String stopDateTime = this.getCurrentDate();
            String startDateTime = PreferenceHelp.getString("startdatetime");
            String indexFiles = this.getIndexFiles(PreferenceHelp.getString("startIndex"));
            String command = "..\\bin\\mysqlbinlog.exe " + indexFiles + "  --base64-output=decode-rows" + " -d \"" + this.getDatabaseName() + "\"" + " --start-datetime=\"" + startDateTime + "\"" + " --stop-datetime=\"" + stopDateTime + "\"" + " --result-file=\"" + temp.getAbsolutePath() + "\"";
            SystemUtil.executeCommandByBAT((String[])new String[]{"cd /d " + this.mysql_home + "\\data", command});
            this.treatmentResult(temp);
            List<LogRecord> list = MysqlBinLogParser.parserBinLog(temp);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (temp.exists()) {
                temp.delete();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private String getCurrentDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date());
    }

    private String getLastBinlog() {
        String path;
        block15: {
            path = null;
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(this.index));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if ("".equals(line = line.trim())) continue;
                        path = line;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                            br = null;
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                        br = null;
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                    br = null;
                }
                catch (IOException iOException) {}
            }
        }
        return path;
    }

    private String getIndexFiles(String startIndexFile) {
        StringBuilder stringBuilder;
        block15: {
            stringBuilder = new StringBuilder();
            int start = Integer.parseInt(startIndexFile.substring(startIndexFile.lastIndexOf(".") + 1));
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(this.index));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        int i;
                        if ("".equals(line = line.trim()) || (i = Integer.parseInt(line.substring(line.lastIndexOf(".") + 1))) < start) continue;
                        stringBuilder.append(String.valueOf(line) + " ");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                            br = null;
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                        br = null;
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                    br = null;
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString().trim();
    }

    private void treatmentResult(File result) {
        block20: {
            if (!result.exists()) {
                return;
            }
            StringBuffer content = new StringBuffer();
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(result));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if ("".equals(line = line.trim()) || line.startsWith("/*!") && line.endsWith("*/;") || line.startsWith("# Warning:") || line.startsWith("SET @@session") || line.startsWith("SET TIMESTAMP=") || line.startsWith("DELIMITER") || line.startsWith("use ")) continue;
                        if (line.startsWith("# End of log file")) break;
                        line = line.replace("/*!*/", "");
                        content.append(String.valueOf(line) + SystemUtil.getLineSeparator());
                    }
                    line = null;
                    br = new BufferedReader(new StringReader(content.toString()));
                    content.delete(0, content.length());
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).startsWith("# at ")) {
                            String next = null;
                            while ((next = br.readLine().trim()).startsWith("# at ")) {
                                line = next;
                            }
                            line = String.valueOf(line) + SystemUtil.getLineSeparator() + next;
                        }
                        content.append(String.valueOf(line) + SystemUtil.getLineSeparator());
                    }
                    line = null;
                    br = new BufferedReader(new StringReader(content.toString()));
                    content.delete(0, content.length());
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("# at ")) continue;
                        line = String.valueOf(line) + SystemUtil.getLineSeparator() + br.readLine();
                        String str = br.readLine();
                        if (str.startsWith("ROLLBACK") || !str.startsWith("BEGIN")) continue;
                        line = String.valueOf(line) + SystemUtil.getLineSeparator() + str;
                        br.readLine();
                        br.readLine();
                        str = br.readLine();
                        if (!str.toUpperCase().startsWith("INSERT") && !str.toUpperCase().startsWith("UPDATE") && !str.toUpperCase().startsWith("DELETE")) continue;
                        line = String.valueOf(line) + SystemUtil.getLineSeparator() + str + SystemUtil.getLineSeparator() + br.readLine() + SystemUtil.getLineSeparator() + br.readLine() + SystemUtil.getLineSeparator() + br.readLine();
                        content.append(String.valueOf(line) + SystemUtil.getLineSeparator());
                    }
                    FileUtil.save((String)result.getAbsolutePath(), (String)content.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                            br = null;
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                        br = null;
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                    br = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getMySQLHome() {
        return PreferenceHelp.getString("mySQLHome");
    }

    private String getDatabaseName() {
        return PreferenceHelp.getString("databaseName");
    }
}

