/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.util;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class PreferenceHelp {
    public static final String KEY_TABLE_NAME_COLOR = "tableNameColor";
    public static final String KEY_TABLE_NAME_ALIASCOLOR = "tableAliasColor";
    public static final String KEY_TABLE_FIELD_COLOR = "tableFieldColor";
    public static final String KEY_TABLE_PATH = "tables";
    public static final String KEY_DATATYPE_PATH = "datatypes";
    public static final String KEY_SAVECHECK = "saveCheck";
    public static final String KEY_DYNAMICCHECK = "dynamic";
    public static final String KEY_HIGHLIGHTING = "highlighting";
    public static final String KEY_MYSQLHOME = "mySQLHome";
    public static final String KEY_FILE_MONITOR_PATH = "fileMonitorPath";
    public static final String KEY_DatabaseName = "databaseName";

    public static Color getColor(String key) {
        String color = PreferenceHelp.getJavaPluginPreferenceStore().getString(key);
        return new Color(null, PreferenceHelp.decoderRGB(color));
    }

    public static void setColor(String key, RGB rgb) {
        PreferenceHelp.getJavaPluginPreferenceStore().setValue(key, PreferenceHelp.encoderRGB(rgb));
    }

    public static String getString(String key) {
        return PreferenceHelp.getJavaPluginPreferenceStore().getString(key);
    }

    public static String getString(String key, String defaultValue) {
        String value = PreferenceHelp.getJavaPluginPreferenceStore().getString(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void setString(String key, String value) {
        PreferenceHelp.getJavaPluginPreferenceStore().setValue(key, value);
    }

    public static boolean getBoolean(String key) {
        return PreferenceHelp.getJavaPluginPreferenceStore().getBoolean(key);
    }

    public static void setBoolean(String key, boolean value) {
        PreferenceHelp.getJavaPluginPreferenceStore().setValue(key, value);
    }

    private static RGB decoderRGB(String value) {
        try {
            if (value == null || "".equals(value.trim())) {
                return new RGB(0, 0, 0);
            }
            String[] values = value.split(",");
            return new RGB(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]));
        }
        catch (Exception e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private static String encoderRGB(RGB rgb) {
        try {
            return String.valueOf(String.valueOf(rgb.red)) + "," + String.valueOf(rgb.green) + "," + String.valueOf(rgb.blue);
        }
        catch (Exception e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private static IPreferenceStore getJavaPluginPreferenceStore() {
        return JavaPlugin.getDefault().getPreferenceStore();
    }
}

