/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.Workbench;

public class JavaElementHelp {
    private static Logger log = Logger.getLogger(JavaElementHelp.class);

    public static ICompilationUnit loadCompilationUnit(String path) {
        return JavaElementHelp.loadICompilatinUnit((IPath)new Path(path));
    }

    public static ICompilationUnit loadICompilatinUnit(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(path);
        IJavaElement element = JavaCore.create((IFile)file);
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    public static IMethod findMethod(IJavaElement element, MethodDeclaration methodDeclaration) {
        if (element instanceof ICompilationUnit) {
            return JavaElementHelp.findMethod((ICompilationUnit)element, methodDeclaration);
        }
        if (element instanceof IClassFile) {
            return JavaElementHelp.findMethod((IClassFile)element, methodDeclaration);
        }
        return null;
    }

    public static IMethod findMethod(ICompilationUnit unit, MethodDeclaration methodDeclaration) {
        try {
            IMethod[] methods;
            IType[] types = unit.getAllTypes();
            SourceType type = (SourceType)types[0];
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                MethodDeclaration methodDeclaration2 = JavaElementHelp.createMethod(method.getSource());
                if (JavaElementHelp.equalsMethodDeclaration(methodDeclaration, methodDeclaration2)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static IMethod findMethod(IClassFile classFile, MethodDeclaration methodDeclaration) {
        try {
            IJavaElement[] children;
            IJavaElement[] iJavaElementArray = children = classFile.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryType binaryType;
                IJavaElement javaElement = iJavaElementArray[n2];
                if (javaElement instanceof BinaryType && Flags.isPublic((int)(binaryType = (BinaryType)javaElement).getFlags())) {
                    IMethod[] methods;
                    IMethod[] iMethodArray = methods = binaryType.getMethods();
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod method = iMethodArray[n4];
                        try {
                            if (JavaElementHelp.equalsMethodDeclaration(JavaElementHelp.createMethod(method.getSource()), methodDeclaration)) {
                                return method;
                            }
                        }
                        catch (Exception exception) {}
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static boolean equalsMethodDeclaration(MethodDeclaration methodDeclaration1, MethodDeclaration methodDeclaration2) {
        if (methodDeclaration1.getName().getFullyQualifiedName().equals(methodDeclaration2.getName().getFullyQualifiedName())) {
            List parameters1 = methodDeclaration1.parameters();
            List parameters2 = methodDeclaration2.parameters();
            if (parameters1.size() == parameters2.size()) {
                if (parameters1.size() != 0) {
                    int i = 0;
                    while (i < parameters1.size()) {
                        SingleVariableDeclaration singleVariableDeclaration1 = (SingleVariableDeclaration)parameters1.get(i);
                        SingleVariableDeclaration singleVariableDeclaration2 = (SingleVariableDeclaration)parameters2.get(i);
                        if (singleVariableDeclaration1.getType().toString().equals(singleVariableDeclaration2.getType().toString())) {
                            return true;
                        }
                        singleVariableDeclaration1.getType();
                        ++i;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getPackageName(IClassFile classFile) {
        try {
            CompilationUnit unit = JavaElementHelp.createCompilationUnit(classFile);
            return unit.getPackage().getName().getFullyQualifiedName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static CompilationUnit createCompilationUnit(IClassFile source) {
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setKind(8);
            parser.setSource(source);
            parser.setResolveBindings(true);
            ASTNode ast = parser.createAST(null);
            if (ast instanceof CompilationUnit) {
                return (CompilationUnit)ast;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static CompilationUnit createCompilationUnit(String source) {
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setKind(8);
            parser.setSource(source.toCharArray());
            parser.setResolveBindings(true);
            ASTNode ast = parser.createAST(null);
            if (ast instanceof CompilationUnit) {
                return (CompilationUnit)ast;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static MethodDeclaration createMethod(String source) {
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setKind(4);
            parser.setSource(source.toCharArray());
            parser.setResolveBindings(true);
            ASTNode ast = parser.createAST(null);
            if (ast instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)ast;
                return typeDeclaration.getMethods()[0];
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String getName(IClassFile classFile) {
        String elementName = classFile.getElementName();
        return elementName.substring(0, elementName.length() - ".class".length());
    }

    public static IJavaProject getActiveJavaProject() {
        ISelection selection = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService().getSelection();
        IJavaProject project = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object element = structuredSelection.getFirstElement();
            if (element instanceof IResource) {
                IProject _project = ((IResource)element).getProject();
                if (JavaProject.hasJavaNature((IProject)_project)) {
                    project = JavaCore.create((IProject)_project);
                }
            } else if (element instanceof PackageFragmentRootContainer) {
                project = ((PackageFragmentRootContainer)element).getJavaProject();
            } else if (element instanceof IJavaElement) {
                project = ((IJavaElement)element).getJavaProject();
            }
        }
        if (project != null && project.isOpen()) {
            return project;
        }
        return null;
    }

    public static JavaProject getLayerProject() {
        return (JavaProject)JavaElementHelp.getJavaModel().getJavaProject(JavaElementHelp.getName());
    }

    public static JavaModel getJavaModel() {
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public static IJavaProject getProject(String projectName) {
        try {
            IJavaProject[] projects = JavaElementHelp.getJavaModel().getJavaProjects();
            if (projects != null) {
                IJavaProject[] iJavaProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject javaProject = iJavaProjectArray[n2];
                    if (javaProject.getElementName().equals(projectName)) {
                        return javaProject;
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            log.error((Object)("\u83b7\u53d6\u9879\u76ee\u3010" + projectName + "\u3011\u5931\u8d25"), (Throwable)e);
        }
        return null;
    }

    public static List<ICompilationUnit> getCompilationUnits(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] fragmentRoots;
        ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = project.getAllPackageFragmentRoots();
        int n = fragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot rootPackage = iPackageFragmentRootArray[n2];
            if (rootPackage.hasChildren()) {
                IJavaElement[] iJavaElementArray = rootPackage.getChildren();
                int n3 = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement javaElement = iJavaElementArray[n4];
                    if (javaElement instanceof IPackageFragment) {
                        compilationUnits.addAll(JavaElementHelp.getICompilationUnits((IPackageFragment)javaElement));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return compilationUnits;
    }

    private static List<ICompilationUnit> getICompilationUnits(IPackageFragment packageFragment) throws JavaModelException {
        ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>();
        compilationUnits.addAll(Arrays.asList(packageFragment.getCompilationUnits()));
        if (packageFragment.hasSubpackages()) {
            IJavaElement[] childrens;
            IJavaElement[] iJavaElementArray = childrens = packageFragment.getChildren();
            int n = childrens.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement javaElement = iJavaElementArray[n2];
                if (javaElement instanceof IPackageFragment) {
                    compilationUnits.addAll(JavaElementHelp.getICompilationUnits((IPackageFragment)javaElement));
                }
                ++n2;
            }
        }
        return compilationUnits;
    }

    public static String getName() {
        return "LayerProject";
    }

    public static boolean existProject(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        return workspaceRoot.getProject(projectName).exists();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return JavaPlugin.getWorkspace().getRoot();
    }
}

