/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;

public final class Gongqi {
    public static final String HQL_MARKER_ID = String.valueOf(JavaPlugin.getPluginId()) + ".HQLmarker";
    public static final String LAYER_MARKER_ID = String.valueOf(JavaPlugin.getPluginId()) + ".layersMark";
    public static Color keyWord = new Color(null, 0, 0, 0);
    public static Color table = new Color(null, 255, 0, 0);
    public static Color tableAlias = new Color(null, 0, 255, 0);
    public static Color tableField = new Color(null, 150, 50, 180);

    public static boolean createMarker(IResource resource, String markerId, int start, int end, String errinfo) {
        try {
            IMarker marker = resource.createMarker(markerId);
            marker.setAttribute("message", (Object)errinfo);
            marker.setAttribute("charStart", start);
            marker.setAttribute("charEnd", end);
            marker.setAttribute("severity", 2);
            return true;
        }
        catch (CoreException e) {
            JavaPlugin.logErrorMessage("\u521b\u5efa\u6807\u8bb0\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
    }

    public static boolean deleteMarker(IResource resource, String markerId) {
        try {
            resource.deleteMarkers(HQL_MARKER_ID, false, 2);
            return true;
        }
        catch (Exception e) {
            JavaPlugin.logErrorMessage("\u5220\u9664\u6807\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
    }

    public static final String concatWith(String[] array, char separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(array[i]);
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String concatWith(char[][] array, char separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(new String(array[i]));
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getProjectPath() {
        ISelectionService selectionService;
        ISelection selection;
        IProject project = null;
        IEditorPart part = null;
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activiteWindow = workbench.getActiveWorkbenchWindow();
            part = activiteWindow.getActivePage().getActiveEditor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (part != null) {
            IEditorInput editorInput = part.getEditorInput();
            Object object = editorInput.getAdapter(IFile.class);
            if (object != null) {
                project = ((IFile)object).getProject();
            }
            if ((object = editorInput.getAdapter(IClassFile.class)) != null) {
                project = ((IClassFile)object).getJavaProject().getProject();
            }
        }
        if (project == null && (selection = (selectionService = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService()).getSelection()) instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                project = ((IResource)element).getProject();
            } else if (element instanceof PackageFragmentRootContainer) {
                IJavaProject jProject = ((PackageFragmentRootContainer)element).getJavaProject();
                project = jProject.getProject();
            } else if (element instanceof IJavaElement) {
                IJavaProject jProject = ((IJavaElement)element).getJavaProject();
                project = jProject.getProject();
            }
        }
        if (project != null) {
            return project.getLocation().toOSString();
        }
        return null;
    }
}

