/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.listener;

import core.util.file.FileUtil;
import gongqi.designer.rmi.CodeOperation;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.util.ExecutorServiceUtils;
import gongqi.erp.framework.util.FileUtils;
import gongqi.gdt.core.GDTManager;
import info.gongqi.cfg.Configuration;
import info.gongqi.file.monitor.MonitorController;
import info.gongqi.rmi.CodeOperationImpl;
import info.gongqi.util.PluginUtil;
import java.io.File;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;

public class JavaPluginContextListener {
    private static Logger log = Logger.getLogger(JavaPluginContextListener.class);
    private static CodeOperation operation;

    public void start(BundleContext context) throws Exception {
        try {
            File jdtTempDir;
            block14: {
                File tempDir = new File(PluginUtil.getBasePath(), "Eclipse/temp");
                System.setProperty("java.io.tmpdir", tempDir.getAbsolutePath());
                jdtTempDir = new File(tempDir, "JDT");
                try {
                    try {
                        if (jdtTempDir.exists()) {
                            FileUtil.deleteDirectory((File)jdtTempDir);
                        }
                        if (jdtTempDir.exists()) {
                            jdtTempDir = new File(tempDir, UUID.randomUUID().toString());
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)String.format("\u6e05\u7406\u4e34\u65f6\u76ee\u5f55\u5f02\u5e38\uff1a%s", jdtTempDir), (Throwable)e);
                        jdtTempDir = new File(tempDir, UUID.randomUUID().toString());
                        if (!jdtTempDir.exists()) {
                            jdtTempDir.mkdirs();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (!jdtTempDir.exists()) {
                        jdtTempDir.mkdirs();
                    }
                    throw throwable;
                }
                if (!jdtTempDir.exists()) {
                    jdtTempDir.mkdirs();
                }
            }
            FileUtils.setTempDirectory((File)jdtTempDir);
            ExecutorServiceUtils.initialize();
            Properties logConfig = new Properties();
            if (PluginUtil.isDebug()) {
                logConfig.put("log4j.rootLogger", "debug, console");
                logConfig.put("log4j.logger.gongqi.erp.framework.core", "info");
                logConfig.put("log4j.logger.org.springframework.jdbc.datasource.DataSourceUtils", "warn");
                logConfig.put("log4j.logger.org.springframework.jdbc.core.StatementCreatorUtils", "warn");
                logConfig.put("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
                logConfig.put("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
                logConfig.put("log4j.appender.console.layout.ConversionPattern", "%c %m%n");
            } else {
                logConfig.put("log4j.rootLogger", "debug, file");
                logConfig.put("log4j.logger.gongqi.erp.framework.core", "warn");
                logConfig.put("log4j.logger.com.mchange", "debug");
                logConfig.put("log4j.logger.org.springframework.jdbc.datasource.DataSourceUtils", "debug");
                logConfig.put("log4j.logger.org.springframework.jdbc.core.StatementCreatorUtils", "debug");
                logConfig.put("log4j.appender.file", "org.apache.log4j.DailyRollingFileAppender");
                logConfig.put("log4j.appender.file.File", new File(PluginUtil.getBasePath(), "Eclipse/logs/JavaPlugin.log").getAbsolutePath());
                logConfig.put("log4j.appender.file.Append", "true");
                logConfig.put("log4j.appender.file.Encoding", "UTF-8");
                logConfig.put("log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
                logConfig.put("log4j.appender.file.layout.ConversionPattern", "%p %c %-d{yyyy-MM-dd HH:mm:ss} %m%n");
            }
            PropertyConfigurator.configure((Properties)logConfig);
            Configuration.initConfiguration((File)new File(PluginUtil.getBasePath(), "conf/environment.cfg"));
            log.debug((Object)("GongqiDir\uff1a" + Configuration.getBasePath()));
            GDTManager.registerObjects();
            ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer();
            MonitorController.startMf();
            Properties properties = new Properties();
            properties.put("file.resource.loader.class", ClasspathResourceLoader.class.getName());
            properties.put("ISO-8859-1", "UTF-8");
            properties.put("input.encoding", "UTF-8");
            properties.put("output.encoding", "UTF-8");
            Velocity.init((Properties)properties);
            this.initializedRMI();
            new Timer("RMI").schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        int errCount = 0;
                        while (errCount <= 3) {
                            try {
                                String baseURI = "rmi://" + Configuration.getRMIHost() + ":" + Configuration.getRMIPort();
                                Naming.lookup(String.valueOf(baseURI) + "/code");
                                break;
                            }
                            catch (Exception exception) {
                                ++errCount;
                            }
                        }
                        if (errCount > 3) {
                            JavaPluginContextListener.this.initializedRMI();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"RMI\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
                    }
                }
            }, 10000L, 10000L);
            log.info((Object)"\u542f\u52a8\u6210\u529f");
        }
        catch (Throwable e) {
            log.error((Object)"JavaPlugin\u542f\u52a8\u5931\u8d25", e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u63d0\u9192", (String)("\u63d2\u4ef6\u542f\u52a8\u5931\u8d25\uff1a\u3010" + e.getMessage() + "\u3011"));
        }
    }

    private void initializedRMI() throws Exception {
        log.info((Object)"\u521d\u59cb\u5316\u8fdc\u7a0b\u5bf9\u8c61");
        System.setProperty("java.rmi.server.hostname", Configuration.getRMIHost());
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String port = Configuration.getRMIPort();
            String baseURI = "rmi://" + Configuration.getRMIHost() + ":" + port;
            LocateRegistry.createRegistry(Integer.parseInt(port));
            operation = new CodeOperationImpl();
            Naming.bind(String.valueOf(baseURI) + "/code", operation);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }
}

