/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.layer;

import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.util.Gongqi;
import info.gongqi.util.LayerUtil;
import info.gongqi.util.MarkUtil;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

public final class CodeVerify {
    private static Logger log = Logger.getLogger(CodeVerify.class);
    private CompilationUnit ast;
    private static CodeVerify defaultInspect;

    public CodeVerify(CompilationUnit ast) {
        this.ast = ast;
    }

    public static void verify(CompilationUnit ast) {
        if (defaultInspect == null) {
            defaultInspect = new CodeVerify(ast);
        }
        CodeVerify.defaultInspect.ast = ast;
        defaultInspect.verify();
    }

    public void verify() {
        try {
            this.cleanLayerMark(this.ast);
            if (this.ast.getPackage() != null && !LayerUtil.isBasePackage(this.ast.getPackage().getName().getFullyQualifiedName())) {
                this.parserCompilationUnit(this.ast);
            }
        }
        catch (Exception e) {
            log.debug((Object)"\u5c42\u63a7\u5236\u6821\u9a8c\u5931\u8d25", (Throwable)e);
        }
    }

    private void parserCompilationUnit(CompilationUnit unit) {
        this.parserImports(unit.imports());
        this.parserBodyDeclaration(unit.types());
    }

    private void parserImports(List<ImportDeclaration> importDeclarationList) {
        for (ImportDeclaration importDeclaration : importDeclarationList) {
            String typeBindingPackageName;
            if (importDeclaration.isOnDemand()) continue;
            ITypeBinding typeBinding = importDeclaration.getName().resolveTypeBinding();
            if (typeBinding != null && typeBinding.getPackage() != null && LayerUtil.isLayerPackage(typeBinding.getPackage().getName()) && !LayerUtil.isHostingHighestLayer(typeBinding.getQualifiedName())) {
                MarkUtil.createLayerMark(this.getResource(), importDeclaration.getStartPosition(), importDeclaration.getLength(), this.ast.getLineNumber(importDeclaration.getStartPosition()), "\u5f53\u524d\u5c42\u63a7\u5236\u7c7b\u4e0d\u662f\u6700\u9ad8\u5c42\u7c7b");
            }
            if (this.upLayerPackage(typeBindingPackageName = typeBinding.getPackage().getName())) {
                MarkUtil.createLayerMark(this.getResource(), importDeclaration.getStartPosition(), importDeclaration.getLength(), this.ast.getLineNumber(importDeclaration.getStartPosition()), "\u4e0d\u5141\u8bb8\u5f15\u7528\u4e0a\u5c42\u7c7b\u578b");
                continue;
            }
            if (!this.acrossSolutionRef(typeBindingPackageName)) continue;
            MarkUtil.createLayerMark(this.getResource(), importDeclaration.getStartPosition(), importDeclaration.getLength(), this.ast.getLineNumber(importDeclaration.getStartPosition()), "\u4e0d\u5141\u8bb8\u8de8\u5e94\u7528\u8fdb\u884c\u7c7b\u578b\u5f15\u7528");
        }
    }

    private void parserTypeDeclaration(TypeDeclaration typeDeclaration) {
        if (typeDeclaration == null) {
            return;
        }
        if (typeDeclaration.resolveBinding() != null && LayerUtil.isLayerPackage(typeDeclaration.resolveBinding().getPackage().getName()) && !typeDeclaration.isPackageMemberTypeDeclaration()) {
            if (typeDeclaration.isInterface()) {
                MarkUtil.createLayerMark(this.getResource(), typeDeclaration.getStartPosition(), typeDeclaration.getLength(), this.ast.getLineNumber(typeDeclaration.getStartPosition()), "\u5c42\u63a7\u5236\u7c7b\u4e0d\u5141\u8bb8\u5b9a\u4e49\u5185\u90e8\u63a5\u53e3");
            } else {
                MarkUtil.createLayerMark(this.getResource(), typeDeclaration.getStartPosition(), typeDeclaration.getStartPosition() + typeDeclaration.getLength(), this.ast.getLineNumber(typeDeclaration.getStartPosition()), "\u5c42\u63a7\u5236\u7c7b\u4e0d\u5141\u8bb8\u5b9a\u4e49\u5185\u90e8\u7c7b");
            }
        }
        this.parserTypeParameter(typeDeclaration.typeParameters());
        this.parserType(typeDeclaration.superInterfaceTypes());
        this.parserBodyDeclaration(typeDeclaration.bodyDeclarations());
    }

    private void parserBodyDeclaration(List<?> bodyDeclarations) {
        for (Object object : bodyDeclarations) {
            if (!(object instanceof BodyDeclaration)) continue;
            this.parserBodyDeclaration((BodyDeclaration)object);
        }
    }

    private void parserBodyDeclaration(BodyDeclaration bodyDeclaration) {
        if (bodyDeclaration == null) {
            return;
        }
        if (bodyDeclaration instanceof AnnotationTypeDeclaration) {
            this.parserAnnotationTypeDeclaration((AnnotationTypeDeclaration)bodyDeclaration);
        } else if (bodyDeclaration instanceof EnumDeclaration) {
            this.parserEnumDeclaration((EnumDeclaration)bodyDeclaration);
        } else if (bodyDeclaration instanceof TypeDeclaration) {
            this.parserTypeDeclaration((TypeDeclaration)bodyDeclaration);
        } else if (bodyDeclaration instanceof AnnotationTypeMemberDeclaration) {
            this.parserAnnotationTypeMemberDeclaration((AnnotationTypeMemberDeclaration)bodyDeclaration);
        } else if (bodyDeclaration instanceof EnumConstantDeclaration) {
            this.parserEnumConstantDeclaration((EnumConstantDeclaration)bodyDeclaration);
        } else if (bodyDeclaration instanceof FieldDeclaration) {
            this.parserFieldDeclaration((FieldDeclaration)bodyDeclaration);
        } else if (bodyDeclaration instanceof Initializer) {
            this.parserInitializer((Initializer)bodyDeclaration);
        } else if (bodyDeclaration instanceof MethodDeclaration) {
            this.parserMethodDeclaration((MethodDeclaration)bodyDeclaration);
        }
    }

    private void parserAnnotationTypeDeclaration(AnnotationTypeDeclaration annotationTypeDeclaration) {
        if (annotationTypeDeclaration == null) {
            return;
        }
        this.parserBodyDeclaration(annotationTypeDeclaration.bodyDeclarations());
    }

    private void parserEnumDeclaration(EnumDeclaration enumDeclaration) {
        if (enumDeclaration == null) {
            return;
        }
        this.parserBodyDeclaration(enumDeclaration.bodyDeclarations());
        this.parserBodyDeclaration(enumDeclaration.enumConstants());
    }

    private void parserAnnotationTypeMemberDeclaration(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        if (annotationTypeMemberDeclaration == null) {
            return;
        }
        this.parserType(annotationTypeMemberDeclaration.getType());
        this.parserExpression(annotationTypeMemberDeclaration.getDefault());
    }

    private void parserEnumConstantDeclaration(EnumConstantDeclaration enumConstantDeclaration) {
        if (enumConstantDeclaration == null) {
            return;
        }
        this.parserExpression(enumConstantDeclaration.arguments());
        this.parserAnonymousClassDeclaration(enumConstantDeclaration.getAnonymousClassDeclaration());
    }

    private void parserInitializer(Initializer initializer) {
        if (initializer == null) {
            return;
        }
        ASTNode parent = initializer.getParent();
        while (!(parent instanceof TypeDeclaration)) {
            parent = parent.getParent();
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)parent;
        if (LayerUtil.isLayerPackage(typeDeclaration.resolveBinding().getPackage().getName())) {
            MarkUtil.createLayerMark(this.getResource(), initializer.getStartPosition(), initializer.getLength(), this.ast.getLineNumber(initializer.getStartPosition()), "\u5c42\u63a7\u5236\u7c7b\u4e2d\u4e0d\u5141\u8bb8\u5b9a\u4e49\u9759\u6001\u4ee3\u7801\u5757");
        }
        this.parserBlock(initializer.getBody());
    }

    private void parserFieldDeclaration(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration == null) {
            return;
        }
        this.validateModifiers((BodyDeclaration)fieldDeclaration);
        this.parserType(fieldDeclaration.getType());
        this.parserVariableDeclaration(fieldDeclaration.fragments());
    }

    private void parserMethodDeclaration(MethodDeclaration methodDeclaration) {
        SimpleName methodName;
        CompilationUnit compilationUnit;
        if (methodDeclaration == null) {
            return;
        }
        this.validateModifiers((BodyDeclaration)methodDeclaration);
        ASTNode parent = methodDeclaration.getParent();
        List typeParameters = methodDeclaration.typeParameters();
        this.parserTypeParameter(typeParameters);
        if (((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer().enableSpec() && (Modifier.isPublic((int)methodDeclaration.getModifiers()) || Modifier.isProtected((int)methodDeclaration.getModifiers()))) {
            this.validateMethodDeclarationTypeParameter(typeParameters.toArray(new TypeParameter[typeParameters.size()]));
        }
        this.parserType(methodDeclaration.getReturnType2());
        if (((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer().enableSpec() && (Modifier.isPublic((int)methodDeclaration.getModifiers()) || Modifier.isProtected((int)methodDeclaration.getModifiers()))) {
            this.validateMethodDeclarationType(methodDeclaration.getReturnType2());
        }
        if (parent instanceof TypeDeclaration && ((TypeDeclaration)parent).isPackageMemberTypeDeclaration() && !((TypeDeclaration)parent).isInterface() && LayerUtil.isTablePackage((compilationUnit = (CompilationUnit)parent.getParent()).getPackage().getName().getFullyQualifiedName()) && ((methodName = methodDeclaration.getName()).getFullyQualifiedName().toLowerCase().startsWith("get") || methodName.getFullyQualifiedName().toLowerCase().startsWith("set") || methodName.getFullyQualifiedName().toLowerCase().startsWith("is") || methodName.getFullyQualifiedName().toLowerCase().startsWith("has"))) {
            MarkUtil.createLayerMark(this.getResource(), methodName.getStartPosition(), methodName.getStartPosition() + methodName.getLength(), this.ast.getLineNumber(methodName.getStartPosition()), "Table\u4e2d\u65b9\u6cd5\u540d\u4e0d\u80fd\u4ee5get\u3001set\u3001is\u3001has\u5f00\u5934");
        }
        List parameters = methodDeclaration.parameters();
        this.parserVariableDeclaration(parameters);
        if (((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer().enableSpec() && (Modifier.isPublic((int)methodDeclaration.getModifiers()) || Modifier.isProtected((int)methodDeclaration.getModifiers()))) {
            for (SingleVariableDeclaration variableDeclaration : parameters) {
                this.validateMethodDeclarationType(variableDeclaration.getType());
            }
        }
        this.parserBlock(methodDeclaration.getBody());
    }

    private void parserBlock(Block block) {
        if (block == null) {
            return;
        }
        this.parserStatements(block.statements());
    }

    private void parserStatements(List<?> statements) {
        for (Object object : statements) {
            if (!(object instanceof Statement)) continue;
            this.parserStatement((Statement)object);
        }
    }

    private void parserStatement(Statement object) {
        if (object == null) {
            return;
        }
        if (object instanceof AssertStatement) {
            this.parserAssertStatement((AssertStatement)object);
        } else if (object instanceof Block) {
            this.parserBlock((Block)object);
        } else if (object instanceof ConstructorInvocation) {
            this.parserConstructorInvocation((ConstructorInvocation)object);
        } else if (object instanceof DoStatement) {
            this.parserDoStatement((DoStatement)object);
        } else if (object instanceof ExpressionStatement) {
            this.parserExpressionStatement((ExpressionStatement)object);
        } else if (object instanceof EnhancedForStatement) {
            this.parserEnhancedForStatement((EnhancedForStatement)object);
        } else if (object instanceof ForStatement) {
            this.parserForStatement((ForStatement)object);
        } else if (object instanceof IfStatement) {
            this.parserIfStatement((IfStatement)object);
        } else if (object instanceof ReturnStatement) {
            this.parserReturnStatement((ReturnStatement)object);
        } else if (object instanceof SuperConstructorInvocation) {
            this.parserSuperConstructorInvocation((SuperConstructorInvocation)object);
        } else if (object instanceof SwitchStatement) {
            this.parserSwitchStatement((SwitchStatement)object);
        } else if (object instanceof SwitchCase) {
            this.parserSwitchCase((SwitchCase)object);
        } else if (object instanceof SynchronizedStatement) {
            this.parserSynchronizedStatement((SynchronizedStatement)object);
        } else if (object instanceof ThrowStatement) {
            this.parserThrowStatement((ThrowStatement)object);
        } else if (object instanceof TryStatement) {
            this.parserTryStatement((TryStatement)object);
        } else if (object instanceof TypeDeclarationStatement) {
            this.parserTypeDeclarationStatement((TypeDeclarationStatement)object);
        } else if (object instanceof VariableDeclarationStatement) {
            this.parserVariableDeclarationStatement((VariableDeclarationStatement)object);
        } else if (object instanceof WhileStatement) {
            this.parserWhileStatement((WhileStatement)object);
        }
    }

    private void parserAssertStatement(AssertStatement assertStatement) {
        if (assertStatement == null) {
            return;
        }
        System.out.println("AssertStatement\u5f85\u5904\u7406\uff1a" + assertStatement);
    }

    private void parserConstructorInvocation(ConstructorInvocation constructorInvocation) {
        if (constructorInvocation == null) {
            return;
        }
        System.out.println("ConstructorInvocation\u5f85\u5904\u7406\uff1a" + constructorInvocation);
    }

    private void parserDoStatement(DoStatement doStatement) {
        if (doStatement == null) {
            return;
        }
        this.parserStatement(doStatement.getBody());
        this.parserExpression(doStatement.getExpression());
    }

    private void parserExpressionStatement(ExpressionStatement expressionStatement) {
        if (expressionStatement == null) {
            return;
        }
        this.parserExpression(expressionStatement.getExpression());
    }

    private void parserEnhancedForStatement(EnhancedForStatement enhancedForStatement) {
        if (enhancedForStatement == null) {
            return;
        }
        this.parserVariableDeclaration((VariableDeclaration)enhancedForStatement.getParameter());
        this.parserExpression(enhancedForStatement.getExpression());
        this.parserStatement(enhancedForStatement.getBody());
    }

    private void parserForStatement(ForStatement forStatement) {
        if (forStatement == null) {
            return;
        }
        this.parserExpression(forStatement.initializers());
        this.parserExpression(forStatement.getExpression());
        this.parserExpression(forStatement.updaters());
        this.parserStatement(forStatement.getBody());
    }

    private void parserIfStatement(IfStatement ifStatement) {
        if (ifStatement == null) {
            return;
        }
        this.parserExpression(ifStatement.getExpression());
        this.parserStatement(ifStatement.getThenStatement());
        this.parserStatement(ifStatement.getElseStatement());
    }

    private void parserReturnStatement(ReturnStatement returnStatement) {
        if (returnStatement == null) {
            return;
        }
        this.parserExpression(returnStatement.getExpression());
    }

    private void parserSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        if (superConstructorInvocation == null) {
            return;
        }
        this.parserExpression(superConstructorInvocation.arguments());
        this.parserExpression(superConstructorInvocation.getExpression());
        this.parserType(superConstructorInvocation.typeArguments());
    }

    private void parserSwitchStatement(SwitchStatement switchStatement) {
        if (switchStatement == null) {
            return;
        }
        this.parserExpression(switchStatement.getExpression());
        this.parserStatements(switchStatement.statements());
    }

    private void parserSwitchCase(SwitchCase switchCase) {
        if (switchCase == null) {
            return;
        }
        this.parserExpression(switchCase.getExpression());
    }

    private void parserSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
        if (synchronizedStatement == null) {
            return;
        }
        this.parserExpression(synchronizedStatement.getExpression());
        this.parserBlock(synchronizedStatement.getBody());
    }

    private void parserThrowStatement(ThrowStatement throwStatement) {
        if (throwStatement == null) {
            return;
        }
        this.parserExpression(throwStatement.getExpression());
    }

    private void parserTryStatement(TryStatement tryStatement) {
        if (tryStatement == null) {
            return;
        }
        this.parserBlock(tryStatement.getBody());
        this.parserCatchClauses(tryStatement.catchClauses());
        this.parserBlock(tryStatement.getFinally());
    }

    private void parserCatchClauses(List<?> catchClauses) {
        for (Object object : catchClauses) {
            if (!(object instanceof CatchClause)) continue;
            this.parserCatchClauses((CatchClause)object);
        }
    }

    private void parserCatchClauses(CatchClause catchClause) {
        if (catchClause == null) {
            return;
        }
        this.parserVariableDeclaration((VariableDeclaration)catchClause.getException());
        this.parserBlock(catchClause.getBody());
    }

    private void parserTypeDeclarationStatement(TypeDeclarationStatement typeDeclarationStatement) {
        if (typeDeclarationStatement == null) {
            return;
        }
        this.parserBodyDeclaration((BodyDeclaration)typeDeclarationStatement.getDeclaration());
    }

    private void parserVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement) {
        if (variableDeclarationStatement == null) {
            return;
        }
        this.parserType(variableDeclarationStatement.getType());
        this.parserVariableDeclaration(variableDeclarationStatement.fragments());
    }

    private void parserWhileStatement(WhileStatement whileStatement) {
        if (whileStatement == null) {
            return;
        }
        this.parserExpression(whileStatement.getExpression());
        this.parserStatement(whileStatement.getBody());
    }

    private void parserVariableDeclaration(List<?> variableDeclarations) {
        for (Object object : variableDeclarations) {
            if (!(object instanceof VariableDeclaration)) continue;
            this.parserVariableDeclaration((VariableDeclaration)object);
        }
    }

    private void parserVariableDeclaration(VariableDeclaration variableDeclaration) {
        if (variableDeclaration == null) {
            return;
        }
        if (variableDeclaration instanceof SingleVariableDeclaration) {
            this.parserSingleVariableDeclaration((SingleVariableDeclaration)variableDeclaration);
        } else if (variableDeclaration instanceof VariableDeclarationFragment) {
            this.parserVariableDeclarationFragment((VariableDeclarationFragment)variableDeclaration);
        }
    }

    private void parserSingleVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration) {
        if (singleVariableDeclaration == null) {
            return;
        }
        this.parserType(singleVariableDeclaration.getType());
        this.parserExpression(singleVariableDeclaration.getInitializer());
    }

    private void parserVariableDeclarationFragment(VariableDeclarationFragment variableDeclarationFragment) {
        if (variableDeclarationFragment == null) {
            return;
        }
        this.parserExpression(variableDeclarationFragment.getInitializer());
    }

    private void parserExpression(List<?> expressions) {
        for (Object object : expressions) {
            if (!(object instanceof Expression)) continue;
            this.parserExpression((Expression)object);
        }
    }

    private void parserExpression(Expression expression) {
        if (expression == null) {
            return;
        }
        if (expression instanceof NormalAnnotation) {
            this.parserNormalAnnotation((NormalAnnotation)expression);
        } else if (expression instanceof SingleMemberAnnotation) {
            this.parserSingleMemberAnnotation((SingleMemberAnnotation)expression);
        } else if (expression instanceof ArrayAccess) {
            this.parserArrayAccess((ArrayAccess)expression);
        } else if (expression instanceof ArrayCreation) {
            this.parserArrayCreation((ArrayCreation)expression);
        } else if (expression instanceof ArrayInitializer) {
            this.parserArrayInitializer((ArrayInitializer)expression);
        } else if (expression instanceof Assignment) {
            this.parserAssignment((Assignment)expression);
        } else if (expression instanceof CastExpression) {
            this.parserCastExpression((CastExpression)expression);
        } else if (expression instanceof ClassInstanceCreation) {
            this.parserClassInstanceCreation((ClassInstanceCreation)expression);
        } else if (expression instanceof ConditionalExpression) {
            this.parserConditionalExpression((ConditionalExpression)expression);
        } else if (expression instanceof FieldAccess) {
            this.parserFieldAccess((FieldAccess)expression);
        } else if (expression instanceof InfixExpression) {
            this.parserInfixExpression((InfixExpression)expression);
        } else if (expression instanceof InstanceofExpression) {
            this.parserInstanceofExpression((InstanceofExpression)expression);
        } else if (expression instanceof MethodInvocation) {
            this.parserMethodInvocation((MethodInvocation)expression);
        } else if (expression instanceof Name) {
            this.parserName((Name)expression);
        } else if (expression instanceof ParenthesizedExpression) {
            this.parserParenthesizedExpression((ParenthesizedExpression)expression);
        } else if (expression instanceof PostfixExpression) {
            this.parserPostfixExpression((PostfixExpression)expression);
        } else if (expression instanceof PrefixExpression) {
            this.parserPrefixExpression((PrefixExpression)expression);
        } else if (expression instanceof SuperFieldAccess) {
            this.parserSuperFieldAccess((SuperFieldAccess)expression);
        } else if (expression instanceof SuperMethodInvocation) {
            this.parserSuperMethodInvocation((SuperMethodInvocation)expression);
        } else if (expression instanceof ThisExpression) {
            this.parserThisExpression((ThisExpression)expression);
        } else if (expression instanceof TypeLiteral) {
            this.parserTypeLiteral((TypeLiteral)expression);
        } else if (expression instanceof VariableDeclarationExpression) {
            this.parserVariableDeclarationExpression((VariableDeclarationExpression)expression);
        }
    }

    private void parserNormalAnnotation(NormalAnnotation normalAnnotation) {
        if (normalAnnotation == null) {
            return;
        }
        System.out.println("NormalAnnotation\u5f85\u5904\u7406\uff1a" + normalAnnotation);
    }

    private void parserSingleMemberAnnotation(SingleMemberAnnotation singleMemberAnnotation) {
        if (singleMemberAnnotation == null) {
            return;
        }
        this.parserExpression(singleMemberAnnotation.getValue());
    }

    private void parserArrayAccess(ArrayAccess arrayAccess) {
        if (arrayAccess == null) {
            return;
        }
        this.parserExpression(arrayAccess.getIndex());
    }

    private void parserAssignment(Assignment assignment) {
        if (assignment == null) {
            return;
        }
        this.parserExpression(assignment.getLeftHandSide());
        this.parserExpression(assignment.getRightHandSide());
    }

    private void parserCastExpression(CastExpression castExpression) {
        if (castExpression == null) {
            return;
        }
        this.parserType(castExpression.getType());
        this.parserExpression(castExpression.getExpression());
    }

    private void parserConditionalExpression(ConditionalExpression conditionalExpression) {
        if (conditionalExpression == null) {
            return;
        }
        this.parserExpression(conditionalExpression.getExpression());
        this.parserExpression(conditionalExpression.getThenExpression());
        this.parserExpression(conditionalExpression.getElseExpression());
    }

    private void parserFieldAccess(FieldAccess fieldAccess) {
        if (fieldAccess == null) {
            return;
        }
        this.parserExpression(fieldAccess.getExpression());
        this.validateFieldAccess(fieldAccess);
    }

    private void parserInfixExpression(InfixExpression infixExpression) {
        if (infixExpression == null) {
            return;
        }
        this.parserExpression(infixExpression.getLeftOperand());
        this.parserExpression(infixExpression.getRightOperand());
    }

    private void parserInstanceofExpression(InstanceofExpression instanceofExpression) {
        if (instanceofExpression == null) {
            return;
        }
        this.parserExpression(instanceofExpression.getLeftOperand());
        this.parserType(instanceofExpression.getRightOperand());
    }

    private void parserMethodInvocation(MethodInvocation methodInvocation) {
        IMethodBinding methodDeclaration;
        if (methodInvocation == null) {
            return;
        }
        if (methodInvocation.resolveMethodBinding() != null && LayerUtil.isFormBase((methodDeclaration = methodInvocation.resolveMethodBinding().getMethodDeclaration()).getDeclaringClass().getPackage().getName()) && Modifier.isStatic((int)methodDeclaration.getModifiers()) && "instance".equals(methodDeclaration.getName()) && methodDeclaration.getParameterTypes().length == 0) {
            MarkUtil.createLayerMark(this.getResource(), methodInvocation.getStartPosition(), methodInvocation.getLength(), this.ast.getLineNumber(methodInvocation.getStartPosition()), "\u4e8c\u6b21\u5f00\u53d1\u65b9\u6cd5\u4e0d\u80fd\u8c03\u7528FormBase\u7c7b\u7684instance\u65b9\u6cd5");
        }
        this.parserExpression(methodInvocation.arguments());
        this.parserExpression(methodInvocation.getExpression());
        this.validateMethodInvocation(methodInvocation);
    }

    private void parserParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        if (parenthesizedExpression == null) {
            return;
        }
        this.parserExpression(parenthesizedExpression.getExpression());
    }

    private void parserPrefixExpression(PrefixExpression prefixExpression) {
        if (prefixExpression == null) {
            return;
        }
        this.parserExpression(prefixExpression.getOperand());
    }

    private void parserSuperFieldAccess(SuperFieldAccess superFieldAccess) {
        if (superFieldAccess == null) {
            return;
        }
        System.out.println("SuperFieldAccess\u6682\u4e0d\u5904\u7406\uff1a" + superFieldAccess);
    }

    private void parserSuperMethodInvocation(SuperMethodInvocation superMethodInvocation) {
        if (superMethodInvocation == null) {
            return;
        }
        this.parserExpression(superMethodInvocation.arguments());
    }

    private void parserThisExpression(ThisExpression thisExpression) {
        MethodDeclaration methodDeclaration;
        if (thisExpression == null) {
            return;
        }
        ASTNode parent = thisExpression.getParent();
        while (parent != null && !(parent instanceof MethodDeclaration) && !(parent instanceof TypeDeclaration)) {
            parent = parent.getParent();
        }
        if (parent instanceof MethodDeclaration && LayerUtil.isUtilMethod((methodDeclaration = (MethodDeclaration)parent).resolveBinding())) {
            MarkUtil.createLayerMark(this.getResource(), thisExpression.getStartPosition(), thisExpression.getLength(), this.ast.getLineNumber(thisExpression.getStartPosition()), "Util\u6ce8\u89e3\u65b9\u6cd5\u5185\u4e0d\u80fd\u4f7f\u7528this\u5173\u952e\u5b57");
        }
    }

    private void parserTypeLiteral(TypeLiteral typeLiteral) {
        String qualifiedName;
        if (typeLiteral == null) {
            return;
        }
        this.parserType(typeLiteral.getType());
        ITypeBinding typeBinding = typeLiteral.resolveTypeBinding();
        if (typeBinding != null && (qualifiedName = typeBinding.getQualifiedName()).startsWith("java.lang.Class<") && qualifiedName.endsWith(">")) {
            qualifiedName.substring("java.lang.Class<".length(), qualifiedName.length() - 1);
            if (LayerUtil.isLayerPackage(typeBinding.getPackage().getName())) {
                MarkUtil.createLayerMark(this.getResource(), typeLiteral.getType().getStartPosition(), typeLiteral.getType().getLength(), this.ast.getLineNumber(typeLiteral.getType().getStartPosition()), "\u65e0\u6548\u5b57\u6bb5class");
            }
        }
    }

    private void parserVariableDeclarationExpression(VariableDeclarationExpression variableDeclarationExpression) {
        if (variableDeclarationExpression == null) {
            return;
        }
        this.parserType(variableDeclarationExpression.getType());
        this.parserVariableDeclaration(variableDeclarationExpression.fragments());
    }

    private void parserPostfixExpression(PostfixExpression postfixExpression) {
        if (postfixExpression == null) {
            return;
        }
        this.parserExpression(postfixExpression.getOperand());
    }

    private void parserClassInstanceCreation(ClassInstanceCreation classInstanceCreation) {
        if (classInstanceCreation == null) {
            return;
        }
        this.parserNewStatement((Expression)classInstanceCreation);
        this.parserType(classInstanceCreation.getType());
        this.parserExpression(classInstanceCreation.arguments());
        this.parserAnonymousClassDeclaration(classInstanceCreation.getAnonymousClassDeclaration());
    }

    private void parserArrayCreation(ArrayCreation arrayCreation) {
        if (arrayCreation == null) {
            return;
        }
        this.parserType((Type)arrayCreation.getType());
        this.parserDimensions(arrayCreation.dimensions());
        this.parserArrayInitializer(arrayCreation.getInitializer());
    }

    private void parserArrayInitializer(ArrayInitializer arrayInitializer) {
        if (arrayInitializer == null) {
            return;
        }
        this.parserExpression(arrayInitializer.expressions());
    }

    private void parserAnonymousClassDeclaration(AnonymousClassDeclaration anonymousClassDeclaration) {
        if (anonymousClassDeclaration == null) {
            return;
        }
        this.parserBodyDeclaration(anonymousClassDeclaration.bodyDeclarations());
    }

    private void parserDimensions(List<?> list) {
        for (Object object : list) {
            if (!(object instanceof Name)) continue;
            this.parserName((Name)object);
        }
    }

    private void parserTypeParameter(List<?> typeParameters) {
        for (Object object : typeParameters) {
            if (!(object instanceof TypeParameter)) continue;
            this.parserTypeParameter((TypeParameter)object);
        }
    }

    private void parserTypeParameter(TypeParameter typeParameter) {
        if (typeParameter == null) {
            return;
        }
        this.parserType(typeParameter.typeBounds());
    }

    private void parserType(List<?> types) {
        for (Object object : types) {
            if (!(object instanceof Type)) continue;
            this.parserType((Type)object);
        }
    }

    private void parserType(Type type) {
        if (type == null) {
            return;
        }
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            this.parserType(arrayType.getComponentType());
        } else if (type.isParameterizedType()) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.parserType(parameterizedType.getType());
            this.parserType(parameterizedType.typeArguments());
        } else if (type.isSimpleType()) {
            SimpleType _type = (SimpleType)type;
            ITypeBinding typeBinding = type.resolveBinding();
            if (_type.getName() instanceof QualifiedName && typeBinding != null && typeBinding.isClass()) {
                if (LayerUtil.isLayerPackage(typeBinding.getPackage().getName()) && !LayerUtil.isHostingHighestLayer(typeBinding.getQualifiedName())) {
                    LayerDefination currentLayer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getCurrentLayer();
                    LayerDefination layerDefination = LayerUtil.getLayerDefination(this.ast.getPackage().getName().getFullyQualifiedName());
                    if (!currentLayer.getLayerName().equals(layerDefination.getLayerName())) {
                        return;
                    }
                    MarkUtil.createLayerMark(this.getResource(), type.getStartPosition(), type.getLength(), this.ast.getLineNumber(type.getStartPosition()), "\u5f53\u524d\u5c42\u63a7\u5236\u7c7b\u4e0d\u662f\u6700\u9ad8\u5c42\u7c7b");
                }
                if (this.upLayerPackage(typeBinding.getPackage().getName())) {
                    MarkUtil.createLayerMark(this.getResource(), type.getStartPosition(), type.getLength(), this.ast.getLineNumber(type.getStartPosition()), "\u4e0d\u5141\u8bb8\u5f15\u7528\u4e0a\u5c42\u7c7b\u578b");
                } else if (this.acrossSolutionRef(typeBinding.getPackage().getName())) {
                    MarkUtil.createLayerMark(this.getResource(), type.getStartPosition(), type.getLength(), this.ast.getLineNumber(type.getStartPosition()), "\u4e0d\u5141\u8bb8\u8de8\u5e94\u7528\u8fdb\u884c\u7c7b\u578b\u5f15\u7528");
                }
            }
        }
    }

    private void parserName(Name name) {
        if (name == null) {
            return;
        }
        if (name.isQualifiedName()) {
            QualifiedName qualifiedName = (QualifiedName)name;
            ITypeBinding typeBinding = qualifiedName.getQualifier().resolveTypeBinding();
            IBinding binding = qualifiedName.getName().resolveBinding();
            if (typeBinding != null) {
                // empty if block
            }
        }
    }

    private void parserNewStatement(Expression expression) {
        if (expression == null) {
            return;
        }
        Type type = null;
        if (expression instanceof ClassInstanceCreation) {
            ITypeBinding resolveBinding;
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
            type = classInstanceCreation.getType();
            if ((type.isSimpleType() || type.isQualifiedType()) && (resolveBinding = type.resolveBinding()) != null && LayerUtil.isLayerPackage(resolveBinding.getPackage().getName())) {
                MarkUtil.createLayerMark(this.getResource(), expression.getStartPosition(), expression.getLength(), this.ast.getLineNumber(expression.getStartPosition()), "\u5c42\u63a7\u5236\u7c7b\u4e0d\u80fd\u4f7f\u7528new\u521b\u5efa\u76f8\u5173\u5b9e\u4f8b");
            }
        } else if (expression instanceof ArrayCreation) {
            ArrayCreation arrayCreation = (ArrayCreation)expression;
            type = arrayCreation.getType();
        }
        this.parserNewType(type);
    }

    private void parserNewType(Type type) {
        if (type == null) {
            return;
        }
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            this.parserNewType(arrayType.getComponentType());
        } else if (type.isParameterizedType()) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.parserNewType(parameterizedType.getType());
            List typeArguments = parameterizedType.typeArguments();
            for (Type _type : typeArguments) {
                this.parserNewType(_type);
            }
        } else {
            this.parserType(type);
        }
    }

    private void cleanLayerMark(CompilationUnit ast) {
        try {
            IResource resource = ast.getJavaElement().getResource();
            resource.deleteMarkers(Gongqi.LAYER_MARKER_ID, false, 2);
        }
        catch (Exception e) {
            log.error((Object)"\u5220\u9664\u5c42\u6807\u8bb0\u5f02\u5e38", (Throwable)e);
        }
    }

    @Deprecated
    private IResource getResource() {
        IJavaElement javaElement = this.ast.getJavaElement();
        if (javaElement instanceof ICompilationUnit) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)javaElement;
            return iCompilationUnit.getResource();
        }
        return null;
    }

    private void validateModifiers(BodyDeclaration declaration) {
        CompilationUnit unit = (CompilationUnit)declaration.getRoot();
        String packageFullyQualifiedName = unit.getPackage().getName().getFullyQualifiedName();
        if (LayerUtil.isBasePackage(packageFullyQualifiedName) || LayerUtil.isEnumsPackage(packageFullyQualifiedName) || LayerUtil.isDataTypePackage(packageFullyQualifiedName)) {
            return;
        }
        if (LayerUtil.isDataArea()) {
            if (!(!Modifier.isStatic((int)declaration.getModifiers()) || Modifier.isPrivate((int)declaration.getModifiers()) && Modifier.isFinal((int)declaration.getModifiers()))) {
                MarkUtil.createLayerMark(this.getResource(), declaration.getStartPosition(), declaration.getLength(), this.getLineNumber(declaration.getStartPosition()), "\u591a\u8d26\u5957\u73af\u5883\u4e0d\u5141\u8bb8\u5b9a\u4e49\u9759\u6001\u6210\u5458");
            }
        } else if (Modifier.isStatic((int)declaration.getModifiers()) && LayerUtil.isLayerPackage(packageFullyQualifiedName) && (!Modifier.isPrivate((int)declaration.getModifiers()) || !Modifier.isFinal((int)declaration.getModifiers()))) {
            MarkUtil.createLayerMark(this.getResource(), declaration.getStartPosition(), declaration.getLength(), this.ast.getLineNumber(declaration.getStartPosition()), "\u5c42\u63a7\u5236\u7c7b\u4e2d\u4e0d\u5141\u8bb8\u5b9a\u4e49\u9759\u6001\u6210\u5458");
        }
    }

    private void validateFieldAccess(FieldAccess fieldAccess) {
        if (fieldAccess == null) {
            return;
        }
        try {
            ParenthesizedExpression parenthesizedExpression;
            Expression expression = fieldAccess.getExpression();
            if (expression instanceof ParenthesizedExpression && (expression = (parenthesizedExpression = (ParenthesizedExpression)expression).getExpression()) instanceof CastExpression) {
                CastExpression castExpression = (CastExpression)expression;
                if (LayerUtil.isLayerPackage(castExpression.getType().resolveBinding().getPackage().getName())) {
                    expression = castExpression.getExpression();
                } else {
                    return;
                }
            }
            if (expression instanceof MethodInvocation) {
                MethodInvocation invocation = (MethodInvocation)expression;
                IMethodBinding methodBinding = invocation.resolveMethodBinding();
                ITypeBinding resolveTypeBinding = invocation.getExpression().resolveTypeBinding();
                if (resolveTypeBinding == null) {
                    return;
                }
                String invocationName = resolveTypeBinding.getBinaryName();
                if (LayerUtil.isLayerPackage(methodBinding.getDeclaringClass().getPackage().getName()) && invocationName.equals(methodBinding.getReturnType().getBinaryName()) && methodBinding.getParameterTypes().length == 0) {
                    if (LayerUtil.getUtilsMethodName().equals(methodBinding.getName())) {
                        IAnnotationBinding[] iAnnotationBindingArray = fieldAccess.resolveFieldBinding().getAnnotations();
                        int n = iAnnotationBindingArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
                            if (LayerUtil.getUtilAnnotationName().equals(annotationBinding.getAnnotationType().getDeclaringClass().getName())) {
                                return;
                            }
                            ++n2;
                        }
                        MarkUtil.createLayerMark(this.getResource(), fieldAccess.getStartPosition(), fieldAccess.getStartPosition() + fieldAccess.getLength(), this.ast.getLineNumber(fieldAccess.getStartPosition()), "\u9759\u6001\u5f15\u7528\u4e0d\u80fd\u8bbf\u95ee\u5b9e\u4f8b\u5b57\u6bb5");
                    } else if (LayerUtil.getInstanceMthodName().equals(methodBinding.getName())) {
                        IAnnotationBinding[] iAnnotationBindingArray = fieldAccess.resolveFieldBinding().getAnnotations();
                        int n = iAnnotationBindingArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IAnnotationBinding annotationBinding = iAnnotationBindingArray[n3];
                            if (LayerUtil.getUtilAnnotationName().equals(annotationBinding.getAnnotationType().getDeclaringClass().getName())) {
                                MarkUtil.createLayerMark(this.getResource(), fieldAccess.getStartPosition(), fieldAccess.getLength(), this.getLineNumber(fieldAccess.getStartPosition()), "\u5b9e\u4f8b\u5f15\u7528\u4e0d\u80fd\u8bbf\u95ee\u9759\u6001\u5b57\u6bb5");
                            }
                            ++n3;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"validateFieldAccess Error", (Throwable)e);
        }
    }

    private void validateMethodInvocation(MethodInvocation methodInvocation) {
        if (methodInvocation == null) {
            return;
        }
        try {
            ITypeBinding typeBinding;
            ParenthesizedExpression parenthesizedExpression;
            IMethodBinding resolveMethodBinding = methodInvocation.resolveMethodBinding();
            if (resolveMethodBinding == null || resolveMethodBinding.getDeclaringClass().getPackage() == null || !LayerUtil.isLayerPackage(resolveMethodBinding.getDeclaringClass().getPackage().getName())) {
                return;
            }
            Expression expression = methodInvocation.getExpression();
            if (expression instanceof ParenthesizedExpression && (expression = (parenthesizedExpression = (ParenthesizedExpression)expression).getExpression()) instanceof CastExpression) {
                CastExpression castExpression = (CastExpression)expression;
                if (LayerUtil.isLayerPackage(castExpression.getType().resolveBinding().getPackage().getName())) {
                    expression = castExpression.getExpression();
                } else {
                    return;
                }
            }
            if (expression instanceof MethodInvocation) {
                MethodInvocation invocation = (MethodInvocation)expression;
                IMethodBinding methodBinding = invocation.resolveMethodBinding();
                if (Modifier.isStatic((int)methodBinding.getModifiers()) && methodBinding.getParameterTypes().length == 0 && LayerUtil.isBasePackage(methodBinding.getDeclaringClass().getPackage().getName()) && LayerUtil.isLayerPackage(methodBinding.getReturnType().getPackage().getName())) {
                    if ("newInstance".equals(methodBinding.getName())) {
                        if (LayerUtil.isUtilMethod(methodInvocation.resolveMethodBinding())) {
                            MarkUtil.createLayerMark(this.getResource(), methodInvocation.getStartPosition(), methodInvocation.getStartPosition() + methodInvocation.getLength(), this.getLineNumber(methodInvocation.getStartPosition()), "\u5b9e\u4f8b\u5f15\u7528\u4e0d\u80fd\u8c03\u7528\u9759\u6001\u65b9\u6cd5");
                        }
                    } else if ("util".equals(methodBinding.getName()) && !LayerUtil.isUtilMethod(methodInvocation.resolveMethodBinding())) {
                        MarkUtil.createLayerMark(this.getResource(), methodInvocation.getStartPosition(), methodInvocation.getLength(), this.getLineNumber(methodInvocation.getStartPosition()), "\u9759\u6001\u5f15\u7528\u4e0d\u80fd\u8c03\u7528\u5b9e\u4f8b\u65b9\u6cd5");
                    }
                }
            } else if (expression instanceof SimpleName && (typeBinding = expression.resolveTypeBinding()) != null && LayerUtil.isLayerPackage(typeBinding.getPackage().getName()) && LayerUtil.isUtilMethod(methodInvocation.resolveMethodBinding())) {
                MarkUtil.createLayerMark(this.getResource(), methodInvocation.getStartPosition(), methodInvocation.getStartPosition() + methodInvocation.getLength(), this.getLineNumber(methodInvocation.getStartPosition()), "\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u80fd\u8bbf\u95eeUtil\u6ce8\u89e3\u65b9\u6cd5");
            }
        }
        catch (Exception e) {
            log.error((Object)("\u6821\u9a8c\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff1a" + methodInvocation), (Throwable)e);
        }
    }

    private void validateMethodDeclarationType(Type ... types) {
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (type == null) {
                return;
            }
            if (type.isSimpleType()) {
                SimpleType simpleType = (SimpleType)type;
                ITypeBinding typeBinding = simpleType.resolveBinding();
                if (typeBinding != null && typeBinding.getPackage() != null && LayerUtil.isLayerPackage(typeBinding.getPackage().getName()) && !LayerUtil.isBasePackage(typeBinding.getPackage().getName()) && !LayerUtil.isDataTypePackage(typeBinding.getPackage().getName())) {
                    MarkUtil.createLayerMark(this.getResource(), type.getStartPosition(), type.getLength(), this.getLineNumber(type.getStartPosition()), "\u5c42\u63a7\u5236\u7c7b\u65b9\u6cd5\u5b9a\u4e49\u4e2d\u5fc5\u987b\u4f7f\u7528\u6cdb\u578b");
                }
            } else if (type.isParameterizedType()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                List arguments = parameterizedType.typeArguments();
                this.validateMethodDeclarationType(arguments.toArray(new Type[arguments.size()]));
            }
            ++n2;
        }
    }

    private void validateMethodDeclarationTypeParameter(TypeParameter ... typeParameters) {
        TypeParameter[] typeParameterArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeParameter typeParameter = typeParameterArray[n2];
            List typeBounds = typeParameter.typeBounds();
            this.validateMethodDeclarationTypeParameterExtend(typeBounds.toArray(new Type[typeBounds.size()]));
            ++n2;
        }
    }

    private void validateMethodDeclarationTypeParameterExtend(Type ... types) {
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (type.isSimpleType()) {
                SimpleType simpleType = (SimpleType)type;
                ITypeBinding typeBinding = simpleType.resolveBinding();
                if (typeBinding != null && typeBinding.getPackage() != null) {
                    if (LayerUtil.isLayerPackage(typeBinding.getPackage().getName()) && !LayerUtil.isDataTypePackage(typeBinding.getPackage().getName())) {
                        MarkUtil.createLayerMark(this.getResource(), type.getStartPosition(), type.getLength(), this.getLineNumber(type.getStartPosition()), "\u65b9\u6cd5\u5b9a\u4e49\u4e2d\u6cdb\u578b\u5b9a\u4e49\u7ee7\u627f\u7684\u5c42\u63a7\u5236\u7c7b\u5fc5\u987b\u662f\u5c42\u63a7\u5236\u7c7b\u521b\u5efa\u5c42\u7684Base\u7c7b");
                    } else if (LayerUtil.isBasePackage(typeBinding.getPackage().getName()) && !LayerUtil.isDataTypePackage(typeBinding.getPackage().getName())) {
                        String qualifiedName = typeBinding.getQualifiedName();
                        LayerDefination layerDefination = LayerUtil.getLayerDefination(qualifiedName);
                        LayerDefination createLayerDefination = LayerUtil.getEntityCreateLayerDefination(LayerUtil.getEntityType(qualifiedName), LayerUtil.getEntityName(qualifiedName));
                        if (createLayerDefination != null && !layerDefination.getLayerName().equals(createLayerDefination.getLayerName())) {
                            MarkUtil.createLayerMark(this.getResource(), type.getStartPosition(), type.getLength(), this.getLineNumber(type.getStartPosition()), "\u65b9\u6cd5\u6cdb\u578b\u5b9a\u4e49\u7ee7\u627f\u5fc5\u987b\u4e3a\u5b9e\u4f53\u521b\u5efa\u5c42Base\u7c7b");
                        }
                    }
                }
            } else if (type.isParameterizedType()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                List arguments = parameterizedType.typeArguments();
                this.validateMethodDeclarationType(arguments.toArray(new Type[arguments.size()]));
            }
            ++n2;
        }
    }

    private int getLineNumber(int position) {
        return this.ast.getLineNumber(position);
    }

    private boolean acrossSolutionRef(String typeBindingPackageName) {
        String packageName = this.ast.getPackage().getName().getFullyQualifiedName();
        return packageName.contains(".layers.") && typeBindingPackageName.contains(".layers.") && !packageName.startsWith("gongqi.erp.layers.") && !typeBindingPackageName.startsWith("gongqi.erp.layers.") && !packageName.substring(0, packageName.indexOf(".layers.")).equals(typeBindingPackageName.substring(0, typeBindingPackageName.indexOf(".layers.")));
    }

    private boolean upLayerPackage(String typeBindingPackageName) {
        String packageName = this.ast.getPackage().getName().getFullyQualifiedName();
        if (packageName.contains(".layers.") && typeBindingPackageName.contains(".layers.")) {
            int typeBindingLevel;
            int level = LayerUtil.getLayerLevel(this.extractLayerName(packageName));
            return level < (typeBindingLevel = LayerUtil.getLayerLevel(this.extractLayerName(typeBindingPackageName)));
        }
        return false;
    }

    private String extractLayerName(String packageName) {
        String temp = packageName.substring(packageName.indexOf(".layers.") + ".layers.".length());
        return temp.substring(0, temp.indexOf("."));
    }
}

