/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.hql.util;

import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.core.GOTLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class Dom4jHelp {
    public static Map<String, List<String>> getField(File file) {
        HashMap<String, List<String>> field = new HashMap<String, List<String>>();
        try {
            SAXReader reader = new SAXReader();
            FileInputStream in = new FileInputStream(file);
            Document doc = reader.read((InputStream)in);
            Element root = doc.getRootElement();
            List childNodes = root.element("TableFields").elements();
            for (Element e : childNodes) {
                if (!"TableField".equals(e.getName())) continue;
                Attribute nameattr = e.attribute("name");
                Attribute typeattr = e.attribute("type");
                if ("Component".equals(typeattr.getValue())) {
                    List nodes = e.element("Properties").elements();
                    ArrayList<String> childfield = new ArrayList<String>();
                    for (Element e2 : nodes) {
                        childfield.add(e2.element("Name").getText());
                    }
                    field.put(nameattr.getValue(), childfield);
                    continue;
                }
                field.put(nameattr.getValue(), null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790" + file.getAbsolutePath() + "\u5931\u8d25", e);
        }
        return field;
    }

    public static Map<String, List<String>> getField(String tablepath, String tableName) {
        File file = Dom4jHelp.isFile(tablepath, tableName);
        if (file != null) {
            return Dom4jHelp.getField(file);
        }
        return null;
    }

    private static File isFile(String tablepath, String tableName) {
        File tableFile = null;
        Collection files = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFiles(EntityType.Table).values();
        while (true) {
            for (File file : files) {
                if (!file.getName().equalsIgnoreCase(tableName.concat(".xml"))) continue;
                tableFile = file;
                break;
            }
            if (tableFile != null || !tableName.contains("_")) break;
            tableName = new StringBuffer(tableName).replace(tableName.indexOf("_"), tableName.indexOf("_") + 1, ".").toString();
        }
        return tableFile;
    }

    public static List<String> getDataTypeFields(String dataTypePath, String filename) {
        File file = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFile(EntityType.DataType, filename);
        ArrayList<String> list = new ArrayList<String>();
        if (file != null) {
            try {
                List childNodes;
                SAXReader reader = new SAXReader();
                FileInputStream in = new FileInputStream(file);
                Document doc = reader.read((InputStream)in);
                Element root = doc.getRootElement();
                Element dataTypeelement = root.element("DataTypeArray");
                if (dataTypeelement != null && (childNodes = dataTypeelement.elements()) != null && !childNodes.isEmpty()) {
                    for (Element e : childNodes) {
                        if (!"DataTypeArrayItem".equals(e.getName())) continue;
                        list.add(e.attribute("name").getValue());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u89e3\u6790" + file.getAbsolutePath() + "\u5931\u8d25", e);
            }
        }
        return list;
    }

    public static String getDataTypeTableName(String tablePath, String tableName, String prefix) {
        File file = Dom4jHelp.isFile(tablePath, tableName);
        String childName = "";
        try {
            SAXReader reader = new SAXReader();
            FileInputStream in = new FileInputStream(file);
            Document doc = reader.read((InputStream)in);
            Element root = doc.getRootElement();
            List childNodes = root.element("TableFields").elements();
            for (Element e : childNodes) {
                Attribute nameattr;
                if (!"TableField".equals(e.getName()) || (nameattr = e.attribute("name")) == null || !nameattr.getValue().equals(prefix)) continue;
                List list = e.element("Properties").elements("Property");
                int i = 0;
                while (i < list.size()) {
                    if ("Extends".equals(((Element)list.get(i)).element("Name").getText())) {
                        childName = ((Element)list.get(i)).element("Value").getText();
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790" + file.getAbsolutePath() + "\u5931\u8d25", e);
        }
        return childName;
    }
}

