/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.hql.util;

import gongqi.gdt.hql.antlr.assist.GongqiHqlParser;
import gongqi.gdt.hql.antlr.check.GongqiHqlLexer;
import gongqi.gdt.hql.antlr.check.GongqiHqlParser;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.ResolvedSourceField;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;

public class ASTHelper {
    private static Logger log = Logger.getLogger(ASTHelper.class);
    public static final int COMMONTREE_TYPE_CHECK = 1;
    public static final int COMMONTREE_TYPE_ASSIST = 2;
    public static final String GQ_ANNOTATION_NAME = "Hql";
    public static final String GQ_ANNOTAITON_CHECK = "checked";

    public static ASTNode getAstNode(String source, int offset, ICompilationUnit junit) {
        CompilationUnit unit = ASTHelper.parseDomCompilationUnit(source);
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(offset, 0), true);
        unit.accept((ASTVisitor)analyzer);
        boolean isHql = false;
        ASTNode node = analyzer.getLastCoveringNode();
        if (node != null && node instanceof StringLiteral) {
            if ((node = node.getParent()) != null && node instanceof ParenthesizedExpression) {
                node = node.getParent();
                while (node instanceof InfixExpression || node instanceof ParenthesizedExpression) {
                    node = node.getParent();
                }
            }
            if (node != null && node instanceof InfixExpression) {
                node = node.getParent();
                while (node instanceof InfixExpression || node instanceof ParenthesizedExpression) {
                    node = node.getParent();
                }
            }
            if (node != null && node instanceof Assignment) {
                Assignment anode = (Assignment)node;
                if (!ASTHelper.getDeclarationNode(anode, junit, 2)) {
                    return null;
                }
                isHql = true;
            }
            if (node != null && node instanceof VariableDeclarationFragment) {
                if ((node = node.getParent()) != null) {
                    FieldDeclaration f_node;
                    VariableDeclarationStatement v_node;
                    if (node instanceof VariableDeclarationStatement && ASTHelper.isContainsHql((v_node = (VariableDeclarationStatement)node).modifiers(), 2)) {
                        isHql = true;
                    }
                    if (node instanceof FieldDeclaration && ASTHelper.isContainsHql((f_node = (FieldDeclaration)node).modifiers(), 2)) {
                        isHql = true;
                    }
                }
            } else if (node != null && node instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)node;
                if (methodInvocation.getName().toString().equals("format") && methodInvocation.getExpression().toString().equals("String")) {
                    isHql = false;
                } else {
                    ASTNode mnode = (ASTNode)((MethodInvocation)node).arguments().get(0);
                    if (offset > mnode.getStartPosition() && offset < mnode.getStartPosition() + mnode.getLength()) {
                        if ((node = node.getParent()) != null && node instanceof VariableDeclarationFragment) {
                            if ((node = node.getParent()) != null) {
                                FieldDeclaration f_node;
                                VariableDeclarationStatement v_node;
                                if (node instanceof VariableDeclarationStatement && ASTHelper.isContainsHql((v_node = (VariableDeclarationStatement)node).modifiers(), 2)) {
                                    isHql = true;
                                }
                                if (node instanceof FieldDeclaration && ASTHelper.isContainsHql((f_node = (FieldDeclaration)node).modifiers(), 2)) {
                                    isHql = true;
                                }
                            }
                        } else if (node != null && node instanceof Assignment) {
                            Assignment anode = (Assignment)node;
                            if (!ASTHelper.getDeclarationNode(anode, junit, 2)) {
                                return null;
                            }
                            isHql = true;
                        }
                    }
                }
            }
        }
        if (isHql) {
            return node;
        }
        return null;
    }

    public static ASTNode getAstNode(ContentAssistInvocationContext context, ICompilationUnit junit) {
        return ASTHelper.getAstNode(context.getDocument().get(), context.getInvocationOffset(), junit);
    }

    private static boolean isContainsHql(List list, int type) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            MarkerAnnotation mark;
            if (list.get(i) instanceof NormalAnnotation) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)list.get(i);
                if (GQ_ANNOTATION_NAME.equals(normalAnnotation.getTypeName().toString())) {
                    if (type == 1) {
                        List values = normalAnnotation.values();
                        int j = 0;
                        while (j < values.size()) {
                            MemberValuePair arg = (MemberValuePair)values.get(j);
                            if (GQ_ANNOTAITON_CHECK.equals(arg.getName().toString()) && "false".equals(arg.getValue().toString())) {
                                return false;
                            }
                            ++j;
                        }
                    }
                    return true;
                }
            } else if (list.get(i) instanceof MarkerAnnotation && GQ_ANNOTATION_NAME.equals((mark = (MarkerAnnotation)list.get(i)).getTypeName().toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isContainsHql(IAnnotation[] annotations, int type) {
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        try {
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (GQ_ANNOTATION_NAME.equals(annotation.getElementName())) {
                    if (1 == type) {
                        IMemberValuePair[] values;
                        IMemberValuePair[] iMemberValuePairArray = values = annotation.getMemberValuePairs();
                        int n3 = values.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair value = iMemberValuePairArray[n4];
                            if (GQ_ANNOTAITON_CHECK.equals(value.getMemberName()) && !"true".equals(value.getValue().toString())) {
                                return false;
                            }
                            ++n4;
                        }
                    }
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static boolean isHql(String source, int offset, ICompilationUnit junit) {
        ASTNode node = ASTHelper.getAstNode(source, offset, junit);
        return node != null && (node instanceof VariableDeclarationStatement || node instanceof FieldDeclaration || node instanceof Assignment);
    }

    public static boolean isHql(ContentAssistInvocationContext context, ICompilationUnit junit) {
        return ASTHelper.isHql(context.getDocument().get(), context.getInvocationOffset(), junit);
    }

    public static boolean getDeclarationNode(Assignment node, ICompilationUnit junit, int type) {
        IJavaElement[] unitElements;
        IJavaElement element;
        block5: {
            element = null;
            unitElements = junit.codeSelect(node.getStartPosition(), node.getLeftHandSide().toString().length());
            if (unitElements != null && unitElements.length != 0) break block5;
            return false;
        }
        try {
            element = unitElements[0];
            if (element instanceof ResolvedSourceField) {
                ResolvedSourceField field = (ResolvedSourceField)element;
                IAnnotation[] annotations = field.getAnnotations();
                return ASTHelper.isContainsHql(annotations, type);
            }
            if (element instanceof LocalVariable) {
                LocalVariable var = (LocalVariable)element;
                IAnnotation[] annotations = var.getAnnotations();
                return ASTHelper.isContainsHql(annotations, type);
            }
        }
        catch (Exception e) {
            JavaPlugin.logErrorMessage("\u67e5\u627eHQL\u5b9a\u4e49\u5931\u8d25\uff1a" + e.getMessage());
        }
        return false;
    }

    public static ASTNode getHqlNode(String source, int offset, ICompilationUnit junit) {
        CompilationUnit unit = ASTHelper.parseDomCompilationUnit(source);
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(offset, 0), true);
        unit.accept((ASTVisitor)analyzer);
        boolean isHql = false;
        ASTNode hqlNode = null;
        ASTNode node = analyzer.getLastCoveringNode();
        if (node != null && node instanceof StringLiteral) {
            hqlNode = node;
            if ((node = node.getParent()) != null && node instanceof ParenthesizedExpression) {
                hqlNode = node;
                node = node.getParent();
                while (node instanceof InfixExpression || node instanceof ParenthesizedExpression) {
                    hqlNode = node;
                    node = node.getParent();
                }
            }
            if (node != null && node instanceof InfixExpression) {
                hqlNode = node;
                node = node.getParent();
                while (node instanceof InfixExpression || node instanceof ParenthesizedExpression) {
                    hqlNode = node;
                    node = node.getParent();
                }
            }
            if (node != null && node instanceof Assignment) {
                return hqlNode;
            }
            if (node != null && node instanceof VariableDeclarationFragment) {
                if ((node = node.getParent()) != null) {
                    FieldDeclaration f_node;
                    VariableDeclarationStatement v_node;
                    if (node instanceof VariableDeclarationStatement && ASTHelper.isContainsHql((v_node = (VariableDeclarationStatement)node).modifiers(), 2)) {
                        isHql = true;
                    }
                    if (node instanceof FieldDeclaration && ASTHelper.isContainsHql((f_node = (FieldDeclaration)node).modifiers(), 2)) {
                        isHql = true;
                    }
                }
            } else if (node != null && node instanceof MethodInvocation) {
                if ((node = node.getParent()) != null && node instanceof VariableDeclarationFragment) {
                    if ((node = node.getParent()) != null) {
                        FieldDeclaration f_node;
                        VariableDeclarationStatement v_node;
                        if (node instanceof VariableDeclarationStatement && ASTHelper.isContainsHql((v_node = (VariableDeclarationStatement)node).modifiers(), 2)) {
                            isHql = true;
                        }
                        if (node instanceof FieldDeclaration && ASTHelper.isContainsHql((f_node = (FieldDeclaration)node).modifiers(), 2)) {
                            isHql = true;
                        }
                    }
                } else if (node != null && node instanceof Assignment) {
                    Assignment anode = (Assignment)node;
                    if (!ASTHelper.getDeclarationNode(anode, junit, 2)) {
                        return null;
                    }
                    isHql = true;
                }
            }
        }
        if (isHql) {
            return hqlNode;
        }
        return null;
    }

    public static ASTNode getHqlNode(ContentAssistInvocationContext context, ICompilationUnit junit) {
        return ASTHelper.getHqlNode(context.getDocument().get(), context.getInvocationOffset(), junit);
    }

    public static String getHql(ContentAssistInvocationContext content, ICompilationUnit junit) {
        ASTNode node = ASTHelper.getHqlNode(content, junit);
        String hql = "";
        if (node instanceof StringLiteral) {
            StringLiteral strNode = (StringLiteral)node;
            hql = strNode.getLiteralValue();
        } else if (node instanceof InfixExpression) {
            InfixExpression infixNode = (InfixExpression)node;
            final ArrayList childNode = new ArrayList();
            infixNode.accept(new ASTVisitor(){

                public boolean visit(StringLiteral node) {
                    childNode.add(node);
                    return false;
                }
            });
            for (StringLiteral strNode : childNode) {
                hql = hql.concat(strNode.getLiteralValue());
            }
        }
        return hql;
    }

    public static int getStartPosition(ContentAssistInvocationContext content, ICompilationUnit junit) {
        ASTNode node = ASTHelper.getHqlNode(content, junit);
        if (node != null) {
            return node.getStartPosition();
        }
        return -1;
    }

    public static String getHql(ASTNode node) {
        String hql = "";
        if (node instanceof StringLiteral) {
            StringLiteral snode = (StringLiteral)node;
            hql = snode.getLiteralValue();
        } else if (node instanceof InfixExpression) {
            final ArrayList childs = new ArrayList();
            node.accept(new ASTVisitor(){

                public boolean visit(StringLiteral node) {
                    childs.add(node);
                    return false;
                }
            });
            for (StringLiteral snode : childs) {
                hql = hql.concat(snode.getLiteralValue());
            }
        }
        return hql;
    }

    public static List<StringLiteral> getAllChildNode(ASTNode node) {
        final ArrayList<StringLiteral> list = new ArrayList<StringLiteral>();
        if (node instanceof StringLiteral) {
            list.add((StringLiteral)node);
        } else if (node instanceof InfixExpression) {
            node.accept(new ASTVisitor(){

                public boolean visit(StringLiteral node) {
                    list.add(node);
                    return false;
                }
            });
        }
        return list;
    }

    public static int getRelativeIndex(ContentAssistInvocationContext content, ICompilationUnit junit) {
        int index = -1;
        CompilationUnit unit = ASTHelper.parseDomCompilationUnit(content.getDocument().get());
        final int position = content.getInvocationOffset();
        ASTNode node = ASTHelper.getHqlNode(content, junit);
        if (node instanceof StringLiteral) {
            try {
                String hql = content.getDocument().get(node.getStartPosition() + 1, content.getInvocationOffset() - node.getStartPosition() - 1);
                index = hql.length() - 1;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (node instanceof InfixExpression) {
            InfixExpression infixNode = (InfixExpression)node;
            final LinkedList childNode = new LinkedList();
            infixNode.accept(new ASTVisitor(){

                public boolean visit(StringLiteral node) {
                    if (position > node.getStartPosition() + node.getLength()) {
                        childNode.add(node);
                    }
                    return false;
                }
            });
            String hql = "";
            for (StringLiteral strNode : childNode) {
                hql = hql.concat(strNode.getLiteralValue());
            }
            SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(position, 0), true);
            unit.accept((ASTVisitor)analyzer);
            ASTNode _node = analyzer.getLastCoveringNode();
            try {
                hql = hql.concat(content.getDocument().get(_node.getStartPosition() + 1, position - _node.getStartPosition() - 1));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            index = hql.length() - 1;
        }
        return index;
    }

    public static List<ASTNode> findCheckHqlNode(final ICompilationUnit junit) {
        final ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        try {
            CompilationUnit domUnit = ASTHelper.parseDomCompilationUnit(junit.getSource());
            domUnit.accept(new ASTVisitor(){

                public boolean visit(VariableDeclarationStatement node) {
                    if (ASTHelper.isContainsHql(node.modifiers(), 1) && node.toString().indexOf("=") != -1) {
                        nodes.add(node);
                    }
                    return false;
                }

                public boolean visit(FieldDeclaration node) {
                    if (ASTHelper.isContainsHql(node.modifiers(), 1) && node.toString().indexOf("=") != -1) {
                        nodes.add(node);
                    }
                    return false;
                }

                public boolean visit(Assignment node) {
                    if (ASTHelper.getDeclarationNode(node, junit, 1)) {
                        nodes.add(node);
                    }
                    return false;
                }
            });
        }
        catch (JavaModelException e) {
            log.debug((Object)"\u641c\u7d22\u8bed\u6cd5\u68c0\u67e5Hql\u8282\u70b9\u5f02\u5e38", (Throwable)e);
        }
        return nodes;
    }

    public static ASTNode findHqlNode(ASTNode var) {
        final ArrayList list = new ArrayList();
        var.accept(new ASTVisitor(){

            public boolean visit(StringLiteral node) {
                if (list.isEmpty() && !(node.getParent() instanceof Annotation)) {
                    list.add(node);
                }
                return false;
            }

            public boolean visit(Assignment node) {
                node.accept(new ASTVisitor(){

                    public boolean visit(InfixExpression node) {
                        if (list.isEmpty()) {
                            list.add(node);
                        }
                        return false;
                    }

                    public boolean visit(StringLiteral node) {
                        if (list.isEmpty() && !(node.getParent() instanceof Annotation)) {
                            list.add(node);
                        }
                        return false;
                    }
                });
                return false;
            }

            public boolean visit(InfixExpression node) {
                if (list.isEmpty()) {
                    list.add(node);
                }
                return false;
            }

            public boolean visit(ParenthesizedExpression node) {
                if (list.isEmpty()) {
                    list.add(node);
                }
                return false;
            }

            public boolean visit(MethodInvocation node) {
                return !node.getName().toString().equals("format") || !node.getExpression().toString().equals("String");
            }
        });
        if (list.isEmpty()) {
            return null;
        }
        return (ASTNode)list.get(list.size() - 1);
    }

    public static CompilationUnit parseDomCompilationUnit(String content) {
        ASTParser p = ASTParser.newParser((int)4);
        p.setKind(8);
        p.setSource(content.toCharArray());
        p.setResolveBindings(true);
        CompilationUnit result = (CompilationUnit)p.createAST(null);
        return result;
    }

    public static CompilationUnit parseDomCompilationUnit(ICompilationUnit compilationUnit) {
        ASTParser p = ASTParser.newParser((int)4);
        p.setKind(8);
        p.setSource(compilationUnit);
        p.setResolveBindings(true);
        CompilationUnit domCompilationUnit = (CompilationUnit)p.createAST(null);
        return domCompilationUnit;
    }

    public static CommonTree getAntlrTree(String hql, int type) throws Exception {
        CommonTree tree = null;
        ANTLRStringStream charStream = new ANTLRStringStream(hql);
        if (type == 1) {
            GongqiHqlLexer lexer = new GongqiHqlLexer((CharStream)charStream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            RecognizerSharedState recognizerSharedState = new RecognizerSharedState();
            gongqi.gdt.hql.antlr.check.GongqiHqlParser parser = new gongqi.gdt.hql.antlr.check.GongqiHqlParser((TokenStream)tokenStream, recognizerSharedState);
            GongqiHqlParser.statement_return ret = null;
            ret = parser.statement();
            if (parser.getNumberOfSyntaxErrors() > 0) {
                throw new RuntimeException("HQL\u8bed\u6cd5\u7ed3\u6784\u9519\u8bef");
            }
            tree = ret.getTree();
        } else if (type == 2) {
            gongqi.gdt.hql.antlr.assist.GongqiHqlLexer lexer = new gongqi.gdt.hql.antlr.assist.GongqiHqlLexer((CharStream)charStream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            GongqiHqlParser parser = new GongqiHqlParser((TokenStream)tokenStream);
            GongqiHqlParser.statement_return ret = null;
            try {
                ret = parser.statement();
                if (parser.getNumberOfSyntaxErrors() > 0) {
                    throw new Exception();
                }
                tree = ret.getTree();
            }
            catch (Exception e) {
                throw new RuntimeException("ANTLR\u89e3\u6790hql\u8bed\u53e5\u51fa\u9519", e);
            }
        }
        return tree;
    }

    public static int getCommonTreeEndIndex(CommonTree tree) {
        int length = 0;
        if (tree.getChildCount() == 0) {
            int temp = tree.getCharPositionInLine() + tree.getText().length();
            length = length > temp ? length : temp;
        } else {
            List list = tree.getChildren();
            int i = 0;
            while (i < list.size()) {
                int temp;
                length = ((CommonTree)list.get(i)).getChildCount() != 0 ? (length > ASTHelper.getCommonTreeEndIndex((CommonTree)list.get(i)) ? length : ASTHelper.getCommonTreeEndIndex((CommonTree)list.get(i))) : (length > (temp = ((CommonTree)list.get(i)).getCharPositionInLine() + ((CommonTree)list.get(i)).getText().length()) ? length : temp);
                ++i;
            }
        }
        return length;
    }

    public static ICompilationUnit getCompilationUnit(IResource resource) {
        if (resource != null && resource.getType() == 1 && "java".equals(resource.getFileExtension()) && resource instanceof File) {
            File file = (File)resource;
            return JavaCore.createCompilationUnitFrom((IFile)file);
        }
        return null;
    }
}

