/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.hql;

import gongqi.gdt.hql.HQLStatement;
import info.gongqi.hql.util.ASTHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class HQLCompletionProposalComputer
extends JavaCompletionProposalComputer {
    private static Logger log = Logger.getLogger(HQLCompletionProposalComputer.class);

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        ArrayList<JavaCompletionProposal> list = new ArrayList<JavaCompletionProposal>();
        if (context instanceof JavaContentAssistInvocationContext) {
            ICompilationUnit unit = this.getCompilationUnit();
            try {
                if (ASTHelper.isHql(context, unit)) {
                    HQLStatement hqlObject = new HQLStatement(context, unit);
                    list.addAll(hqlObject.getContentAssistList(context));
                }
            }
            catch (Exception e) {
                log.error((Object)"HQL\u5efa\u8bae\u5931\u8d25", (Throwable)e);
                JavaCompletionProposal errinfo = new JavaCompletionProposal("", context.getInvocationOffset(), 0, null, "", 1);
                errinfo.setContextInformation((IContextInformation)new ContextInformation("", "\u89e3\u6790\u9519\u8bef: " + e.getMessage()));
                list.add(errinfo);
                JavaPlugin.logErrorMessage("\u63d0\u793a\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return list;
    }

    private ICompilationUnit getCompilationUnit() {
        IEditorPart activeeditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(activeeditor.getEditorInput());
    }
}

