/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.file.monitor;

import info.gongqi.file.monitor.Operate;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class OperateImpl
extends Operate {
    private OperateImpl() {
    }

    public static void openJFile(String projectname, String filepath, final int number) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IJavaModel jModel = JavaCore.create((IWorkspaceRoot)root);
            IJavaProject jProject = jModel.getJavaProject(projectname);
            if (!jProject.exists()) {
                throw new RuntimeException(String.valueOf(projectname) + "\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            if (!jProject.isOpen()) {
                throw new RuntimeException(String.valueOf(projectname) + "\u9879\u76ee\u6ca1\u6709\u6253\u5f00");
            }
            final IJavaElement jElement = jProject.findElement((IPath)new Path(filepath));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IEditorPart jEditorPart = JavaUI.openInEditor(jElement);
                        ITextEditor editor = (ITextEditor)jEditorPart;
                        if (number == 0) {
                            IDocumentProvider provider = editor.getDocumentProvider();
                            IDocument document = provider.getDocument((Object)editor.getEditorInput());
                            editor.selectAndReveal(document.getLength() - 1, 0);
                        } else {
                            editor.selectAndReveal(number, 0);
                        }
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException(e);
                    }
                    catch (JavaModelException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String refresh(String refreshType, String resourcePath, String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            block10: {
                block12: {
                    block11: {
                        try {
                            if ("project".equals(refreshType)) {
                                project.refreshLocal(2, null);
                                break block10;
                            }
                            if (!"package".equals(refreshType) && !"floder".equals(refreshType)) break block11;
                            IFolder floder = project.getFolder(resourcePath);
                            if (floder.exists()) {
                                floder.refreshLocal(2, null);
                                break block10;
                            }
                            if ("package".equals(refreshType)) {
                                return "package";
                            }
                            return "floder";
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (!"packagefile".equals(refreshType) && !"floderfile".equals(refreshType) && !"file".equals(refreshType)) break block10;
                    IFile file = project.getFile(resourcePath);
                    if (file.exists()) {
                        file.refreshLocal(2, null);
                        break block10;
                    }
                    if (!"packagefile".equals(refreshType)) break block12;
                    return "packagefile";
                }
                if ("floderfile".equals(refreshType)) {
                    return "floderfile";
                }
                return "file";
            }
            return "";
        }
        return "project";
    }

    public static void openFile(String projectname, String filepath) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectname);
            final IFile file = project.getFile(filepath);
            if (!project.exists()) {
                throw new RuntimeException(String.valueOf(projectname) + "\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            if (!project.isOpen()) {
                throw new RuntimeException(String.valueOf(projectname) + "\u9879\u76ee\u6ca1\u6709\u6253\u5f00");
            }
            if (!file.exists()) {
                throw new RuntimeException(String.valueOf(filepath) + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void openFile(String filePath) {
        IFileStore fileStore;
        if (filePath == null) {
            new RuntimeException(String.valueOf(filePath) + "\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6");
        }
        if (!(fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(filePath))).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException e) {
                new RuntimeException(e);
            }
        }
    }
}

