/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.file.monitor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class OperateFile {
    public static final String TYPE_FILE = "file";
    public static final String TYPE_FOLDER = "floder";
    public static final String TYPE_PACKAGE = "package";
    public static final String TYPE_PACKAGE_FILE = "packagefile";
    public static final String TYPE_FOLDER_FILE = "floderfile";
    public static final String TYPE_PROJECT = "project";

    public static void open(String projectName, String path, final int index) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IJavaModel jModel = JavaCore.create((IWorkspaceRoot)root);
            IJavaProject jProject = jModel.getJavaProject(projectName);
            final IJavaElement jElement = jProject.findElement((IPath)new Path(path));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IEditorPart jEditorPart = JavaUI.openInEditor(jElement);
                        ITextEditor editor = (ITextEditor)jEditorPart;
                        if (index < 0) {
                            IDocumentProvider provider = editor.getDocumentProvider();
                            IDocument document = provider.getDocument((Object)editor.getEditorInput());
                            editor.selectAndReveal(document.getLength() + index, 0);
                        } else {
                            editor.selectAndReveal(index, 0);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void refresh(String refreshType, String projectName, String path) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectName);
            if (project.exists()) {
                if (TYPE_PROJECT.equals(refreshType)) {
                    project.refreshLocal(2, null);
                } else if (TYPE_PACKAGE.equals(refreshType)) {
                    IFolder floder = project.getFolder("src/" + path);
                    if (floder.exists()) {
                        floder.refreshLocal(2, null);
                    }
                } else if (TYPE_FOLDER.equals(refreshType)) {
                    IFolder floder = project.getFolder(path);
                    if (floder.exists()) {
                        floder.refreshLocal(2, null);
                    }
                } else if (TYPE_PACKAGE_FILE.equals(refreshType)) {
                    IFile file = project.getFile("src/" + path);
                    if (file.exists()) {
                        file.refreshLocal(2, null);
                    }
                } else if (TYPE_FOLDER_FILE.equals(refreshType)) {
                    IFile file = project.getFile(path);
                    if (file.exists()) {
                        file.refreshLocal(2, null);
                    }
                } else {
                    TYPE_FILE.equals(refreshType);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

