/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.file.monitor;

import gongqi.erp.framework.tools.io.FileIOXML;
import info.gongqi.command.Command;
import info.gongqi.command.CommandDispatcher;
import info.gongqi.command.CommandType;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class CommandsListener
extends FileAlterationListenerAdaptor {
    private static Logger log = Logger.getLogger(CommandsListener.class);
    private CommandDispatcher commandDispatcher = new CommandDispatcher();

    public void onFileChange(File file) {
        this.handler(file);
    }

    public void onFileCreate(File file) {
        this.handler(file);
    }

    private void handler(File file) {
        if (file.exists()) {
            Document document = null;
            try {
                try {
                    document = FileIOXML.loadDocument((String)file.getAbsolutePath());
                    Element commandsElement = document.getRootElement();
                    Iterator iterator = commandsElement.elementIterator("Command");
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (!(obj instanceof Element)) continue;
                        Element commandElement = (Element)obj;
                        Command command = new Command(CommandType.getCommandType(commandElement.attributeValue("type")));
                        List argList = commandElement.elements("CommandArg");
                        for (Object arg : argList) {
                            if (!(arg instanceof Element)) continue;
                            Element argElement = (Element)arg;
                            String name = argElement.attributeValue("name");
                            if (CommandType.OverrideMethod == command.getCommandType()) {
                                if ("parameterTypes".equals(name)) {
                                    List elements = argElement.elements("Value");
                                    String[] parameterTypes = new String[elements.size()];
                                    int i = 0;
                                    while (i < elements.size()) {
                                        parameterTypes[i] = ((Element)elements.get(i)).getTextTrim();
                                        ++i;
                                    }
                                    command.addCommandArg(name, parameterTypes);
                                    continue;
                                }
                                command.addCommandArg(name, argElement.getTextTrim());
                                continue;
                            }
                            command.addCommandArg(name, argElement.getTextTrim());
                        }
                        if (!this.commandDispatcher.dispatcher(command)) continue;
                        commandsElement.remove(commandElement);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Command\u5904\u7406\u5f02\u5e38", (Throwable)e);
                    if (document != null) {
                        FileIOXML.saveDocument((String)file.getAbsolutePath(), (Document)document);
                    }
                }
            }
            finally {
                if (document != null) {
                    FileIOXML.saveDocument((String)file.getAbsolutePath(), (Document)document);
                }
            }
        }
    }
}

