/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.command.impl;

import info.gongqi.command.Command;
import info.gongqi.command.impl.AbstractCommandHandler;
import info.gongqi.util.JavaElementHelp;
import java.util.ArrayList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.UserLibrary;
import org.eclipse.jdt.internal.core.UserLibraryManager;

public class DestroyLayerCommandHandlerImpl
extends AbstractCommandHandler {
    @Override
    public boolean handleInternal(Command command) throws Exception {
        this.aggregateLayers();
        this.updateUserLibrary(command.getLayerName());
        return true;
    }

    private void updateUserLibrary(String layerName) {
        String libraryName = "layer_" + layerName;
        UserLibraryManager manager = JavaModelManager.getUserLibraryManager();
        UserLibrary userLibrary = manager.getUserLibrary(libraryName);
        if (userLibrary != null) {
            manager.removeUserLibrary(libraryName);
        }
        JavaProject project = JavaElementHelp.getLayerProject();
        try {
            IClasspathEntry[] rawClasspath = project.getRawClasspath();
            int i = 0;
            while (i < rawClasspath.length) {
                if (rawClasspath[i].getEntryKind() == 5 && rawClasspath[i].getPath().toOSString().equals("org.eclipse.jdt.USER_LIBRARY\\" + libraryName)) {
                    ArrayList<IClasspathEntry> newRawClasspath = new ArrayList<IClasspathEntry>();
                    int j = 0;
                    while (j < rawClasspath.length) {
                        if (j != i) {
                            newRawClasspath.add(rawClasspath[j]);
                        }
                        ++j;
                    }
                    JavaModelManager.PerProjectInfo perProjectInfo = project.getPerProjectInfo();
                    perProjectInfo.writeAndCacheClasspath(project, newRawClasspath.toArray(new IClasspathEntry[newRawClasspath.size()]), perProjectInfo.outputLocation);
                    break;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            log.error((Object)("\u9500\u6bc1\u5c42" + layerName + "\u66f4\u65b0\u7528\u6237\u5e93\u5f02\u5e38"), (Throwable)e);
        }
    }
}

