/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;

public abstract class ZipUtils {
    public static void zipFiles(File zip, Collection<File> srcFiles) throws IOException {
        HashMap<String, Collection<File>> files = new HashMap<String, Collection<File>>();
        files.put("", srcFiles);
        ZipUtils.zipFiles(zip, files);
    }

    public static void zipFiles(File zip, Map<String, Collection<File>> srcFiles) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));
        for (Map.Entry<String, Collection<File>> entry : srcFiles.entrySet()) {
            String path = entry.getKey();
            Collection<File> files = entry.getValue();
            ZipUtils.zipFiles(out, path, files.toArray(new File[files.size()]));
        }
        out.close();
    }

    private static void zipFiles(ZipOutputStream out, String path, File ... srcFiles) throws IOException {
        if (path == null) {
            path = "";
        }
        if (!"".equals(path) && !(path = path.replace('\\', '/')).endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        byte[] buf = new byte[1024];
        int i = 0;
        while (i < srcFiles.length) {
            if (srcFiles[i].isDirectory()) {
                File[] files = srcFiles[i].listFiles();
                String srcPath = srcFiles[i].getName();
                if (!(srcPath = srcPath.replace('\\', '/')).endsWith("/")) {
                    srcPath = String.valueOf(srcPath) + "/";
                }
                out.putNextEntry(new ZipEntry(String.valueOf(path) + srcPath));
                ZipUtils.zipFiles(out, String.valueOf(path) + srcPath, files);
            } else {
                int len;
                FileInputStream in = new FileInputStream(srcFiles[i]);
                out.putNextEntry(new ZipEntry(String.valueOf(path) + srcFiles[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            ++i;
        }
    }

    public static void unZipFiles(File zipPath, File descDir) throws IOException {
        ZipUtils.unZipFiles(zipPath, null, descDir);
    }

    public static void unZipFiles(File zipPath, String relativePath, File descDir) throws IOException {
        ZipUtils.unZipFiles(zipPath, relativePath, descDir.getAbsolutePath());
    }

    private static void unZipFiles(File zipFile, String entryName, String descDir) throws IOException {
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            int len;
            String outPath;
            File file;
            ZipEntry entry = entries.nextElement();
            String zipEntryName = entry.getName();
            if (StringUtils.isNotBlank((String)entryName) && !zipEntryName.startsWith(entryName)) continue;
            InputStream in = zip.getInputStream(entry);
            if (!(descDir = descDir.replace('\\', '/')).endsWith("/")) {
                descDir = String.valueOf(descDir) + "/";
            }
            if (!(file = new File((outPath = (String.valueOf(descDir) + zipEntryName).replace('\\', '/')).substring(0, outPath.lastIndexOf(47)))).exists()) {
                file.mkdirs();
            }
            if (new File(outPath).isDirectory()) continue;
            FileOutputStream out = new FileOutputStream(outPath);
            byte[] buf1 = new byte[1024];
            while ((len = in.read(buf1)) > 0) {
                ((OutputStream)out).write(buf1, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        zip.close();
    }
}

