/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.services;

import gongqi.gdt.services.ServiceDispatcher;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import org.apache.log4j.Logger;

public class PluginServer {
    private static Logger log = Logger.getLogger(PluginServer.class);
    private String host = "127.0.0.1";
    private int port;
    private EventLoopGroup eventLoopGroup;
    private ServiceDispatcher serviceDispatcher = new ServiceDispatcher();

    public PluginServer(int port) {
        this.port = port;
        this.eventLoopGroup = new NioEventLoopGroup();
    }

    public void start() {
        if (this.eventLoopGroup != null) {
            log.warn((Object)"Plugin Server\u5df2\u542f\u52a8\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u542f\u52a8");
            return;
        }
        this.eventLoopGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)Math.min(Runtime.getRuntime().availableProcessors(), 8))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    ChannelPipeline pipeline = channel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4)});
                    pipeline.addLast(new ChannelHandler[]{PluginServer.this.serviceDispatcher});
                    pipeline.addLast(new ChannelHandler[]{new LengthFieldPrepender(4)});
                }
            });
            serverBootstrap.bind(this.host, this.port).sync();
        }
        catch (Exception e) {
            throw new RuntimeException("Plugin Server\u542f\u52a8\u9519\u8bef", e);
        }
    }

    public void stop() {
        if (this.eventLoopGroup != null && !this.eventLoopGroup.isShutdown()) {
            try {
                this.eventLoopGroup.shutdownGracefully().sync();
            }
            catch (Throwable e) {
                log.warn((Object)"Plugin Server\u5173\u95ed\u9519\u8bef", e);
            }
        }
        this.eventLoopGroup = null;
    }
}

