/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.layer.upgrade.node;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gongqi.erp.framework.exception.ERPException;
import gongqi.gdt.layer.upgrade.node.GOTNode;
import gongqi.gdt.util.VTDUtils;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GOTProperty {
    public static final String ATTRIBUTE_INNERID = "innerid";
    public static final String ATTRIBUTE_REFENTITYID = "refentityid";
    public static final String ATTRIBUTE_REFINNERID = "refinnerid";
    private GOTNode node;
    private int propertyIndex;

    public GOTProperty(GOTNode node, int propertyIndex) throws NavException {
        this.node = node;
        this.propertyIndex = propertyIndex;
    }

    public String getName() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            if (VTDUtils.toFirstChildElement(entityNav, "Name")) {
                return entityNav.toString(entityNav.getText());
            }
            throw new ERPException("\u89e3\u6790Proper\u5931\u8d25!");
        }
    }

    public String getValue() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            if (VTDUtils.toFirstChildElement(entityNav, "Value")) {
                String value = null;
                int valueIndex = entityNav.getText();
                if (valueIndex != -1) {
                    value = entityNav.toString(valueIndex);
                }
                return value;
            }
            throw new ERPException("\u89e3\u6790Proper\u5931\u8d25!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValue(String value) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.node.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (StringUtils.isNotBlank((String)value)) {
                    value = VTDUtils.escapeChar(value);
                }
                if (VTDUtils.toFirstChildElement(entityNav, "Value")) {
                    int textIndex = entityNav.getText();
                    if (textIndex != -1) {
                        if (StringUtils.isNotBlank((String)value)) {
                            modifier.updateToken(textIndex, value);
                        } else {
                            modifier.removeToken(textIndex);
                        }
                    } else if (StringUtils.isNotBlank((String)value)) {
                        modifier.insertAfterHead(value);
                    }
                } else {
                    throw new ERPException("Property\u7ed3\u6784\u9519\u8bef\uff0c\u7f3a\u5c11Value\u8282\u70b9");
                }
            }
        }
    }

    public GOTNode getGOTNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerId() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.getAttributeValue(entityNav, ATTRIBUTE_INNERID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInnerId(String innerId) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.node.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (entityNav.hasAttr(ATTRIBUTE_INNERID)) {
                    if (StringUtils.isNotBlank((String)innerId)) {
                        modifier.updateToken(entityNav.getAttrVal(ATTRIBUTE_INNERID), innerId);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr(ATTRIBUTE_INNERID);
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)innerId)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\" ", ATTRIBUTE_INNERID, innerId));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRefEntityId() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.getAttributeValue(entityNav, ATTRIBUTE_REFENTITYID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRefEntityId(String entityId) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.node.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (entityNav.hasAttr(ATTRIBUTE_REFENTITYID)) {
                    if (StringUtils.isNotBlank((String)entityId)) {
                        modifier.updateToken(entityNav.getAttrVal(ATTRIBUTE_REFENTITYID), entityId);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr(ATTRIBUTE_REFENTITYID);
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)entityId)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\" ", ATTRIBUTE_REFENTITYID, entityId));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRefInnerId() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.getAttributeValue(entityNav, ATTRIBUTE_REFINNERID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRefInnerId(String innerId) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.node.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (entityNav.hasAttr(ATTRIBUTE_REFINNERID)) {
                    if (StringUtils.isNotBlank((String)innerId)) {
                        modifier.updateToken(entityNav.getAttrVal(ATTRIBUTE_REFINNERID), innerId);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr(ATTRIBUTE_REFINNERID);
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)innerId)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\" ", ATTRIBUTE_REFINNERID, innerId));
                }
            }
        }
    }

    public synchronized void setAttribute(String innerId, String refEntityId, String refInnerId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String name) throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.hasAttribute(entityNav, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeValue(String name) throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.getAttributeValue(entityNav, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeValue(String name, String defaultValue) throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            String value = VTDUtils.getAttributeValue(entityNav, name);
            return value == null ? defaultValue : value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValue(String name, String value) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier = this.node.getEntity().getEntityModifier();
            this.recoverNode();
            XMLModifier xMLModifier = modifier;
            synchronized (xMLModifier) {
                if (VTDUtils.hasAttribute(entityNav, name)) {
                    if (StringUtils.isNotBlank((String)value)) {
                        modifier.updateToken(entityNav.getAttrVal(name), value);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr(ATTRIBUTE_INNERID);
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)value)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\"", name, value));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAttributes() throws PilotException, NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.getAttributes(entityNav);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverNode() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            entityNav.recoverNode(this.propertyIndex);
        }
    }

    public String dumpFragment() {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.node.getEntity().getEntityNav();
        synchronized (vTDNav) {
            try {
                this.recoverNode();
                return VTDUtils.dumpFragment(entityNav);
            }
            catch (NavException | IOException throwable) {
                throw new ERPException("GOTNode\u83b7\u53d6XML\u6bb5\u5931\u8d25!");
            }
        }
    }

    public String toString() {
        return this.dumpFragment();
    }
}

