/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.layer.upgrade.node;

import com.ximpleware.AutoPilot;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gongqi.erp.framework.exception.ERPException;
import gongqi.gdt.layer.upgrade.node.GOTEntity;
import gongqi.gdt.layer.upgrade.node.GOTProperty;
import gongqi.gdt.util.VTDUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GOTNode {
    private volatile GOTEntity entity;
    private int nodeIndex;
    private boolean rename = false;
    private String origName;
    private String nodeType;

    GOTNode() {
    }

    protected GOTNode(GOTEntity entity, int nodeIndex) throws NavException {
        this.entity = entity;
        this.nodeIndex = nodeIndex;
        this.nodeType = this.getNodeType();
    }

    public GOTEntity getEntity() {
        return this.entity;
    }

    void setEntity(GOTEntity entity) {
        this.entity = entity;
    }

    void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public boolean isRename() {
        return this.rename;
    }

    public String getOrigName() {
        return this.origName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeType() {
        block5: {
            try {
                VTDNav entityNav;
                if (this.nodeType != null) break block5;
                VTDNav vTDNav = entityNav = this.entity.getEntityNav();
                synchronized (vTDNav) {
                    this.recoverNode();
                    this.nodeType = entityNav.toString(this.nodeIndex);
                }
            }
            catch (NavException e) {
                throw new RuntimeException("\u83b7\u53d6\u8282\u70b9\u7c7b\u578b\u5f02\u5e38", e);
            }
        }
        return this.nodeType;
    }

    public boolean isEntityNode() throws NavException {
        return this.getNodeType().equals(this.getEntity().getNodeType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        try {
            VTDNav entityNav;
            VTDNav vTDNav = entityNav = this.entity.getEntityNav();
            synchronized (vTDNav) {
                this.recoverNode();
                return this.getAttributeValue("id");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u8282\u70b9\u7f16\u53f7\u9519\u8bef", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        try {
            VTDNav entityNav;
            VTDNav vTDNav = entityNav = this.entity.getEntityNav();
            synchronized (vTDNav) {
                this.recoverNode();
                return this.getAttributeValue("name");
            }
        }
        catch (NavException e) {
            throw new RuntimeException("\u83b7\u53d6\u8282\u70b9\u540d\u79f0\u9519\u8bef", e);
        }
    }

    public void setName(String name) throws VTDException, IOException {
        if (!this.getName().equals(name)) {
            this.rename = true;
            this.origName = this.getName();
        }
        this.setAttributeValue("name", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCreatedLayer() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return this.getAttributeValue("createdLayer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModifiedLayer() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return this.getAttributeValue("modifiedLayer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GOTNode getParent() throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            if (VTDUtils.toParent(entityNav)) {
                return new GOTNode(this.entity, entityNav.getCurrentIndex());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GOTNode getPrevSiblingNode() throws VTDException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            if (VTDUtils.toPrevSiblingElement(entityNav, this.getNodeType())) {
                return new GOTNode(this.entity, entityNav.getCurrentIndex());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GOTNode getNextSiblingNode() throws VTDException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            if (VTDUtils.toNextSiblingElement(entityNav, this.getNodeType())) {
                return new GOTNode(this.entity, entityNav.getCurrentIndex());
            }
            return null;
        }
    }

    public List<GOTNode> getChildNodeBFS(boolean recursive) throws VTDException {
        return this.getChildNodeBFS(this, recursive);
    }

    private List<GOTNode> getChildNodeBFS(GOTNode node, boolean recursive) throws VTDException {
        ArrayList<GOTNode> nodeList = new ArrayList<GOTNode>();
        node.recoverNode();
        VTDNav entityNav = node.getEntity().getEntityNav();
        if (VTDUtils.toFirstChildElement(entityNav)) {
            if ("Properties".equals(VTDUtils.getName(entityNav)) && !VTDUtils.toNextSiblingElement(entityNav)) {
                return nodeList;
            }
            do {
                if ("Properties".equals(VTDUtils.getName(entityNav))) continue;
                GOTNode childNode = new GOTNode(this.getEntity(), entityNav.getCurrentIndex());
                nodeList.add(childNode);
            } while (VTDUtils.toNextSiblingElement(entityNav));
        }
        int count = nodeList.size();
        int i = 0;
        while (i < count) {
            block9: {
                block8: {
                    GOTNode childNode = (GOTNode)nodeList.get(i);
                    childNode.recoverNode();
                    if (!VTDUtils.toFirstChildElement(entityNav)) break block8;
                    if ("Properties".equals(VTDUtils.getName(entityNav)) && !VTDUtils.toNextSiblingElement(entityNav)) break block9;
                    do {
                        if ("Properties".equals(VTDUtils.getName(entityNav))) continue;
                        childNode = new GOTNode(this.getEntity(), entityNav.getCurrentIndex());
                        nodeList.add(childNode);
                    } while (VTDUtils.toNextSiblingElement(entityNav));
                }
                count = nodeList.size();
            }
            ++i;
        }
        return nodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String name) throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.hasAttribute(entityNav, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeValue(String name) throws NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.getAttributeValue(entityNav, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValue(String name, String value) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier = this.entity.getEntityModifier();
            this.recoverNode();
            XMLModifier xMLModifier = modifier;
            synchronized (xMLModifier) {
                if (VTDUtils.hasAttribute(entityNav, name)) {
                    if (StringUtils.isNotBlank((String)value)) {
                        modifier.updateToken(entityNav.getAttrVal(name), value);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr("innerid");
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)value)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\"", name, value));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAttributes() throws PilotException, NavException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.getAttributes(entityNav);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProperty(String propertyName) throws VTDException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return VTDUtils.toXPathElement(entityNav, String.format("Properties/Property/Name[text()='%s']", propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GOTProperty> getPropertys() throws VTDException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
            this.recoverNode();
            if (VTDUtils.toXPathElement(entityNav, "Properties/Property")) {
                do {
                    GOTProperty property = new GOTProperty(this, entityNav.getCurrentIndex());
                    propertys.add(property);
                } while (VTDUtils.toNextSiblingElement(entityNav));
            }
            return propertys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GOTProperty getProperty(String propertyName) throws VTDException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            GOTProperty property = null;
            this.recoverNode();
            if (VTDUtils.toXPathElement(entityNav, String.format("Properties/Property/Name[text()='%s']/..", propertyName))) {
                property = new GOTProperty(this, entityNav.getCurrentIndex());
            }
            return property;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GOTNode selectSingleNode(String xpath) throws VTDException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            List<GOTNode> selectNodes = this.selectNodes(xpath);
            if (selectNodes.size() > 1) {
                throw new ERPException(String.format("xpath\u8868\u8fbe\u5f0f\u3010%s\u3011\u9009\u62e9\u7684\u8282\u70b9\u4e0d\u552f\u4e00", xpath));
            }
            return selectNodes.isEmpty() ? null : selectNodes.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GOTNode> selectNodes(String xpath) throws VTDException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            ArrayList<GOTNode> nodes = new ArrayList<GOTNode>();
            this.recoverNode();
            AutoPilot pilot = new AutoPilot(entityNav);
            pilot.selectXPath(xpath);
            int index = -1;
            while ((index = pilot.evalXPath()) != -1) {
                nodes.add(new GOTNode(this.entity, index));
            }
            pilot.resetXPath();
            return nodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAfterElement(String element) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                modifier.insertAfterElement(element.getBytes("UTF-8"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBeforeElement(String element) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                modifier.insertBeforeElement(element.getBytes("UTF-8"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAfterHead(String element) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (VTDUtils.toFirstChildElement(entityNav, "Properties")) {
                    modifier.insertAfterElement(element.getBytes("UTF-8"));
                } else {
                    modifier.insertAfterHead(element.getBytes("UTF-8"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBeforeTail(String element) throws VTDException, IOException {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                modifier.insertBeforeTail(element.getBytes("UTF-8"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws NavException, ModifyException {
        VTDNav entityNav;
        if (this.isEntityNode()) {
            return;
        }
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            XMLModifier modifier;
            XMLModifier xMLModifier = modifier = this.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                modifier.remove(entityNav.getElementFragment());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntityXPath() throws NavException {
        VTDNav entityNav;
        if (this.isEntityNode()) {
            return ".";
        }
        VTDNav vTDNav = entityNav = this.getEntity().getEntityNav();
        synchronized (vTDNav) {
            this.recoverNode();
            return this.getXPath(entityNav);
        }
    }

    private synchronized String getXPath(VTDNav nav) throws NavException {
        StringBuffer pathBuf = new StringBuffer();
        String elementName = VTDUtils.getName(nav);
        String id = VTDUtils.getAttributeValue(nav, "id");
        String name = VTDUtils.getAttributeValue(nav, "name");
        if (VTDUtils.toParent(nav)) {
            pathBuf.append(this.getXPath(nav));
        }
        pathBuf.append("/").append(elementName);
        if (StringUtils.isNotBlank((String)id)) {
            pathBuf.append("[@id='").append(id).append("']");
        } else if (StringUtils.isNotBlank((String)name)) {
            pathBuf.append("[@name='").append(name).append("']");
        }
        return pathBuf.toString();
    }

    public String asXML() {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            try {
                this.recoverNode();
                return VTDUtils.asXML(entityNav);
            }
            catch (Exception e) {
                throw new RuntimeException("GOTNode\u8f6c\u6362\u4e3aXML\u6587\u672c\u5931\u8d25", e);
            }
        }
    }

    public String dumpFragment() {
        VTDNav entityNav;
        VTDNav vTDNav = entityNav = this.entity.getEntityNav();
        synchronized (vTDNav) {
            try {
                this.recoverNode();
                return VTDUtils.dumpFragment(entityNav);
            }
            catch (NavException | IOException throwable) {
                throw new ERPException("GOTNode\u83b7\u53d6XML\u6bb5\u5931\u8d25!");
            }
        }
    }

    public synchronized String getNodeContent() throws VTDException, IOException {
        this.recoverNode();
        String nodeType = this.getNodeType();
        StringBuilder nodeBuilder = new StringBuilder();
        nodeBuilder.append(String.format("<%s", nodeType));
        StringBuilder attrBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            attrBuilder.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        nodeBuilder.append((CharSequence)attrBuilder).append(">");
        StringBuilder propertiesBuilder = new StringBuilder();
        List<GOTProperty> propertys = this.getPropertys();
        if (propertys.size() > 0) {
            propertiesBuilder.append("<Properties>");
            for (GOTProperty property : propertys) {
                propertiesBuilder.append("<Property ");
                for (Map.Entry<String, String> entry : property.getAttributes().entrySet()) {
                    propertiesBuilder.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
                }
                propertiesBuilder.append(">");
                propertiesBuilder.append(String.format("<Name>%s</Name>", VTDUtils.escapeChar(property.getName())));
                if (property.getValue() != null) {
                    propertiesBuilder.append(String.format("<Value>%s</Value>", VTDUtils.escapeChar(property.getValue())));
                } else {
                    propertiesBuilder.append("<Value />");
                }
                propertiesBuilder.append("</Property>");
            }
            propertiesBuilder.append("</Properties>");
        }
        nodeBuilder.append((CharSequence)propertiesBuilder);
        nodeBuilder.append(String.format("</%s>", nodeType));
        return nodeBuilder.toString();
    }

    protected synchronized void recoverNode() throws NavException {
        VTDNav entityNav = this.entity.getEntityNav();
        entityNav.recoverNode(this.nodeIndex);
    }

    public String toString() {
        return this.dumpFragment();
    }
}

