/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.layer.upgrade.node;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerResolver;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionResolver;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginResolver;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionResolver;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.layer.upgrade.node.GOTEntity;
import gongqi.gdt.layer.upgrade.node.GOTNode;
import gongqi.gdt.layer.upgrade.node.GOTProperty;
import gongqi.gdt.util.VTDUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class GOTModel {
    private List<LayerDefination> layerDefinations = new ArrayList<LayerDefination>();
    private List<SolutionDefinition> solutionDefinitions = new ArrayList<SolutionDefinition>();
    private List<SolutionPluginDefinition> solutionPluginDefinitions = new ArrayList<SolutionPluginDefinition>();
    private List<SolutionExtensionDefinition> solutionExtensionDefinitions = new ArrayList<SolutionExtensionDefinition>();
    private Map<EntityType, Map<String, GOTEntity>> entityIdMaps = new ConcurrentHashMap<EntityType, Map<String, GOTEntity>>();
    private List<GOTEntity> removeEntitys = new ArrayList<GOTEntity>();
    private Map<String, List<GOTProperty>> catchRefInnerIdMap = new HashMap<String, List<GOTProperty>>();
    private boolean catchRefInnerId = false;

    public GOTModel(File layersRootDir) {
        try {
            List layerDefinations = ((LayerResolver)ObjectContainer.getInstance(LayerResolver.class)).resolveLayers(layersRootDir.getAbsolutePath());
            List solutionDefinitions = Collections.EMPTY_LIST;
            File solutionsRootDir = new File(layersRootDir, "app");
            if (solutionsRootDir.exists()) {
                solutionDefinitions = ((SolutionResolver)ObjectContainer.getInstance(SolutionResolver.class)).resolveSolutions(solutionsRootDir.getAbsolutePath());
            }
            List solutionPluginDefinitions = Collections.EMPTY_LIST;
            File solutionPluginsRootDir = new File(layersRootDir, "plg");
            if (solutionPluginsRootDir.exists()) {
                solutionPluginDefinitions = ((SolutionPluginResolver)ObjectContainer.getInstance(SolutionPluginResolver.class)).resolveSolutionPlugins(solutionPluginsRootDir.getAbsolutePath());
            }
            List solutionExtensionDefinitions = Collections.EMPTY_LIST;
            File solutionExtensionsRootDir = new File(layersRootDir, "ext");
            if (solutionExtensionsRootDir.exists()) {
                solutionExtensionDefinitions = ((SolutionExtensionResolver)ObjectContainer.getInstance(SolutionExtensionResolver.class)).resolveSolutionExtensions(solutionExtensionsRootDir.getAbsolutePath());
            }
            if (layerDefinations == null || layerDefinations.isEmpty()) {
                throw new ERPException("\u65e0\u6548\u7684\u5c42\u5b9a\u4e49\u5217\u8868");
            }
            this.layerDefinations = layerDefinations;
            if (solutionDefinitions != null) {
                this.solutionDefinitions = solutionDefinitions;
            }
            if (solutionPluginDefinitions != null) {
                this.solutionPluginDefinitions = solutionPluginDefinitions;
            }
            if (solutionExtensionDefinitions != null) {
                this.solutionExtensionDefinitions = solutionExtensionDefinitions;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5c42\u6a21\u578b\u89e3\u6790\u9519\u8bef\uff1a" + layersRootDir.getAbsolutePath(), e);
        }
        this.initModelEntitys();
    }

    private void initModelEntitys() {
        HashMap entityFiles = new HashMap();
        entityFiles.put(EntityType.Enum, new TreeMap());
        entityFiles.put(EntityType.DataType, new TreeMap());
        entityFiles.put(EntityType.Table, new TreeMap());
        entityFiles.put(EntityType.Form, new TreeMap());
        entityFiles.put(EntityType.MenuItem, new TreeMap());
        entityFiles.put(EntityType.Menu, new TreeMap());
        entityFiles.put(EntityType.Class, new TreeMap());
        entityFiles.put(EntityType.Report, new TreeMap());
        int i = this.layerDefinations.size();
        while (i > 0) {
            LayerDefination layerDefination = this.layerDefinations.get(i - 1);
            if ("app".equals(layerDefination.getLayerName())) {
                for (SolutionDefinition solutionDefinition : this.solutionDefinitions) {
                    ((Map)entityFiles.get(EntityType.Enum)).putAll(solutionDefinition.getEntityFiles(EntityType.Enum));
                    ((Map)entityFiles.get(EntityType.DataType)).putAll(solutionDefinition.getEntityFiles(EntityType.DataType));
                    ((Map)entityFiles.get(EntityType.Table)).putAll(solutionDefinition.getEntityFiles(EntityType.Table));
                    ((Map)entityFiles.get(EntityType.Form)).putAll(solutionDefinition.getEntityFiles(EntityType.Form));
                    ((Map)entityFiles.get(EntityType.MenuItem)).putAll(solutionDefinition.getEntityFiles(EntityType.MenuItem));
                    ((Map)entityFiles.get(EntityType.Menu)).putAll(solutionDefinition.getEntityFiles(EntityType.Menu));
                    ((Map)entityFiles.get(EntityType.Class)).putAll(solutionDefinition.getEntityFiles(EntityType.Class));
                    ((Map)entityFiles.get(EntityType.Report)).putAll(solutionDefinition.getEntityFiles(EntityType.Report));
                }
            } else if ("plg".equals(layerDefination.getLayerName())) {
                for (SolutionPluginDefinition solutionPluginDefinition : this.solutionPluginDefinitions) {
                    ((Map)entityFiles.get(EntityType.Enum)).putAll(solutionPluginDefinition.getEntityFiles(EntityType.Enum));
                    ((Map)entityFiles.get(EntityType.DataType)).putAll(solutionPluginDefinition.getEntityFiles(EntityType.DataType));
                    ((Map)entityFiles.get(EntityType.Table)).putAll(solutionPluginDefinition.getEntityFiles(EntityType.Table));
                    ((Map)entityFiles.get(EntityType.Form)).putAll(solutionPluginDefinition.getEntityFiles(EntityType.Form));
                    ((Map)entityFiles.get(EntityType.MenuItem)).putAll(solutionPluginDefinition.getEntityFiles(EntityType.MenuItem));
                    ((Map)entityFiles.get(EntityType.Menu)).putAll(solutionPluginDefinition.getEntityFiles(EntityType.Menu));
                    ((Map)entityFiles.get(EntityType.Class)).putAll(solutionPluginDefinition.getEntityFiles(EntityType.Class));
                    ((Map)entityFiles.get(EntityType.Report)).putAll(solutionPluginDefinition.getEntityFiles(EntityType.Report));
                }
            } else if ("ext".equals(layerDefination.getLayerName())) {
                for (SolutionExtensionDefinition solutionExtensionDefinition : this.solutionExtensionDefinitions) {
                    ((Map)entityFiles.get(EntityType.Enum)).putAll(solutionExtensionDefinition.getEntityFiles(EntityType.Enum));
                    ((Map)entityFiles.get(EntityType.DataType)).putAll(solutionExtensionDefinition.getEntityFiles(EntityType.DataType));
                    ((Map)entityFiles.get(EntityType.Table)).putAll(solutionExtensionDefinition.getEntityFiles(EntityType.Table));
                    ((Map)entityFiles.get(EntityType.Form)).putAll(solutionExtensionDefinition.getEntityFiles(EntityType.Form));
                    ((Map)entityFiles.get(EntityType.MenuItem)).putAll(solutionExtensionDefinition.getEntityFiles(EntityType.MenuItem));
                    ((Map)entityFiles.get(EntityType.Menu)).putAll(solutionExtensionDefinition.getEntityFiles(EntityType.Menu));
                    ((Map)entityFiles.get(EntityType.Class)).putAll(solutionExtensionDefinition.getEntityFiles(EntityType.Class));
                    ((Map)entityFiles.get(EntityType.Report)).putAll(solutionExtensionDefinition.getEntityFiles(EntityType.Report));
                }
            } else {
                ((Map)entityFiles.get(EntityType.Enum)).putAll(layerDefination.getEntityFiles(EntityType.Enum));
                ((Map)entityFiles.get(EntityType.DataType)).putAll(layerDefination.getEntityFiles(EntityType.DataType));
                ((Map)entityFiles.get(EntityType.Table)).putAll(layerDefination.getEntityFiles(EntityType.Table));
                ((Map)entityFiles.get(EntityType.Form)).putAll(layerDefination.getEntityFiles(EntityType.Form));
                ((Map)entityFiles.get(EntityType.MenuItem)).putAll(layerDefination.getEntityFiles(EntityType.MenuItem));
                ((Map)entityFiles.get(EntityType.Menu)).putAll(layerDefination.getEntityFiles(EntityType.Menu));
                ((Map)entityFiles.get(EntityType.Class)).putAll(layerDefination.getEntityFiles(EntityType.Class));
                ((Map)entityFiles.get(EntityType.Report)).putAll(layerDefination.getEntityFiles(EntityType.Report));
            }
            --i;
        }
        for (Map.Entry entry : entityFiles.entrySet()) {
            for (File entityFile : ((Map)entry.getValue()).values()) {
                try {
                    GOTEntity entity = new GOTEntity(VTDUtils.parseXML(Paths.get(entityFile.toURI())));
                    this.getEntityIdMap(entity.getEntityType()).put(entity.getId(), entity);
                }
                catch (VTDException | IOException e) {
                    throw new RuntimeException(String.format("\u89e3\u6790%s\u5b9e\u4f53\u6587\u4ef6%s\u9519\u8bef", ((EntityType)entry.getKey()).name(), entityFile.getName()), e);
                }
            }
        }
    }

    public File getLayersRootDir() {
        LayerDefination systemLayerDefination = this.getLayerDefination("sys");
        File systemLayerDir = new File(systemLayerDefination.getLayerDir());
        return systemLayerDir.getParentFile();
    }

    public List<SolutionDefinition> getSolutionDefinitions() {
        return Collections.unmodifiableList(this.solutionDefinitions);
    }

    public SolutionDefinition getSolutionDefinition(String solutionName) {
        for (SolutionDefinition solutionDefinition : this.solutionDefinitions) {
            if (!solutionDefinition.getSolutionName().equals(solutionName)) continue;
            return solutionDefinition;
        }
        return null;
    }

    public List<SolutionPluginDefinition> getSolutionPluginDefinitions() {
        return Collections.unmodifiableList(this.solutionPluginDefinitions);
    }

    public SolutionPluginDefinition getSolutionPluginDefinition(String solutionPluginName) {
        for (SolutionPluginDefinition solutionPluginDefinition : this.solutionPluginDefinitions) {
            if (!solutionPluginDefinition.getName().equals(solutionPluginName)) continue;
            return solutionPluginDefinition;
        }
        return null;
    }

    public List<SolutionExtensionDefinition> getSolutionExtensionDefinitions() {
        return Collections.unmodifiableList(this.solutionExtensionDefinitions);
    }

    public SolutionExtensionDefinition getSolutionExtensionDefinition(String solutionName) {
        for (SolutionExtensionDefinition solutionExtensionDefinition : this.solutionExtensionDefinitions) {
            if (!solutionExtensionDefinition.getSolutionName().equals(solutionName)) continue;
            return solutionExtensionDefinition;
        }
        return null;
    }

    public LayerDefination getTopLayerDefination() {
        return this.layerDefinations.get(0);
    }

    public LayerDefination getLayerDefination(String layerName) {
        for (LayerDefination layerDefination : this.layerDefinations) {
            if (!layerDefination.getLayerName().equals(layerName)) continue;
            return layerDefination;
        }
        return null;
    }

    public int getLayerLevel(String layerName) {
        LayerDefination layerDefination = this.getLayerDefination(layerName);
        if (layerDefination == null) {
            throw new IllegalArgumentException(String.format("\u83b7\u53d6\u5c42\u7ea7\u4fe1\u606f\u9519\u8bef\uff0c%s\u5c42\u5728\u5c42\u94fe\u4e2d\u4e0d\u5b58\u5728", layerName));
        }
        return this.layerDefinations.size() - this.layerDefinations.indexOf(layerDefination);
    }

    public int getTopLayerLevel() {
        LayerDefination topLayerDefination = this.getTopLayerDefination();
        return this.getLayerLevel(topLayerDefination.getLayerName());
    }

    public List<LayerDefination> getLayerDefinations() {
        return Collections.unmodifiableList(this.layerDefinations);
    }

    private Map<String, GOTEntity> getEntityIdMap(EntityType entityType) {
        Map<String, GOTEntity> entityIdMap = this.entityIdMaps.get(entityType);
        if (entityIdMap == null) {
            entityIdMap = new LinkedHashMap<String, GOTEntity>();
            this.entityIdMaps.put(entityType, entityIdMap);
        }
        return entityIdMap;
    }

    public Map<String, GOTEntity> getEntitys(EntityType entityType) {
        Map<String, GOTEntity> entityMap = this.entityIdMaps.get(entityType);
        return entityMap != null ? Collections.unmodifiableMap(entityMap) : Collections.EMPTY_MAP;
    }

    public GOTEntity getEntityById(EntityType entityType, String entityId) {
        return this.getEntityIdMap(entityType).get(entityId);
    }

    public GOTEntity getEntityByName(EntityType entityType, String entityName) throws NavException {
        for (GOTEntity entity : this.getEntityIdMap(entityType).values()) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        return null;
    }

    public List<GOTProperty> getRefEntityPropertys(String entityId) throws VTDException {
        Objects.requireNonNull(entityId, "\u67e5\u627e\u8282\u70b9\u5f15\u7528\u5217\u8868entityId\u4e3anull");
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        String xpath = String.format(".//Property[@refentityid='%s']", entityId);
        AutoPilot pilot = new AutoPilot();
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                VTDNav entityNav = entity.getEntityNav();
                entityNav.recoverNode(entityNav.getRootIndex());
                pilot.bind(entityNav);
                pilot.selectXPath(xpath);
                int index = -1;
                while ((index = pilot.evalXPath()) != -1) {
                    if (!entityNav.toElement(1) || !entityNav.toElement(1)) {
                        throw new ERPException("Property\u7ed3\u6784\u9519\u8bef\uff01");
                    }
                    GOTNode node = new GOTNode(entity, entityNav.getCurrentIndex());
                    propertys.add(new GOTProperty(node, index));
                    entityNav.recoverNode(index);
                }
                pilot.resetXPath();
            }
        }
        return propertys;
    }

    public List<GOTProperty> getRefInnerPropertys(String entityId, String innerId) throws VTDException {
        Objects.requireNonNull(entityId, "\u67e5\u627e\u8282\u70b9\u5f15\u7528\u5217\u8868entityId\u4e3anull");
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        if (this.catchRefInnerId) {
            List<GOTProperty> list = this.catchRefInnerIdMap.get(String.valueOf(entityId) + "-" + innerId);
            if (list != null) {
                propertys.addAll(list);
            }
            return propertys;
        }
        String xpath = String.format(".//Property[@%s='%s' and @%s='%s']", "refentityid", entityId, "refinnerid", innerId);
        AutoPilot pilot = new AutoPilot();
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                VTDNav entityNav = entity.getEntityNav();
                entityNav.recoverNode(entityNav.getRootIndex());
                pilot.bind(entityNav);
                pilot.selectXPath(xpath);
                int index = -1;
                while ((index = pilot.evalXPath()) != -1) {
                    if (!entityNav.toElement(1) || !entityNav.toElement(1)) {
                        throw new ERPException("Property\u7ed3\u6784\u9519\u8bef\uff01");
                    }
                    GOTNode node = new GOTNode(entity, entityNav.getCurrentIndex());
                    propertys.add(new GOTProperty(node, index));
                    entityNav.recoverNode(index);
                }
                pilot.resetXPath();
            }
        }
        return propertys;
    }

    public void removeEntity(GOTEntity entity) throws VTDException {
        this.getEntityIdMap(entity.getEntityType()).remove(entity.getId());
        this.removeEntitys.add(entity);
    }

    public List<GOTEntity> getRemoveEntitys() {
        return Collections.unmodifiableList(this.removeEntitys);
    }

    public void catchRefInnerId() throws VTDException {
        this.clearCatchRefInnerId();
        String xpath = String.format(".//Property[@%s and @%s]", "refentityid", "refinnerid");
        AutoPilot pilot = new AutoPilot();
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                VTDNav entityNav = entity.getEntityNav();
                entityNav.recoverNode(entityNav.getRootIndex());
                pilot.bind(entityNav);
                pilot.selectXPath(xpath);
                int index = -1;
                while ((index = pilot.evalXPath()) != -1) {
                    List<GOTProperty> refList;
                    GOTProperty property;
                    if (entityNav.toElement(1) && entityNav.toElement(1)) {
                        GOTNode node = new GOTNode(entity, entityNav.getCurrentIndex());
                        property = new GOTProperty(node, index);
                        refList = this.catchRefInnerIdMap.get(String.format("%s-%s", property.getRefEntityId(), property.getRefInnerId()));
                        if (refList == null) {
                            refList = new ArrayList<GOTProperty>();
                            this.catchRefInnerIdMap.put(String.format("%s-%s", property.getRefEntityId(), property.getRefInnerId()), refList);
                        }
                    } else {
                        throw new ERPException("Property\u7ed3\u6784\u9519\u8bef\uff01");
                    }
                    refList.add(property);
                    entityNav.recoverNode(index);
                }
                pilot.resetXPath();
            }
        }
        this.catchRefInnerId = true;
    }

    public void clearCatchRefInnerId() {
        this.catchRefInnerIdMap.clear();
        this.catchRefInnerId = false;
    }
}

