/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.layer.upgrade.modify;

import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.layer.upgrade.ProgressMonitor;
import gongqi.gdt.layer.upgrade.modify.Modify;
import gongqi.gdt.layer.upgrade.modify.ModifyLevel;
import gongqi.gdt.layer.upgrade.modify.ModifyType;
import gongqi.gdt.layer.upgrade.node.GOTEntity;
import gongqi.gdt.layer.upgrade.node.GOTModel;
import gongqi.gdt.layer.upgrade.node.GOTNode;
import gongqi.gdt.layer.upgrade.node.GOTProperty;
import gongqi.gdt.util.GOTUtils;
import gongqi.gdt.util.LayerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public abstract class BaseModify
implements Modify {
    protected Logger log = Logger.getLogger(this.getClass());
    protected GOTModel sourceGOT;
    protected GOTModel targetGOT;
    protected GOTModel originalTargetGOT;

    public BaseModify(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalTargetGOT) {
        this.sourceGOT = sourceGOT;
        this.targetGOT = targetGOT;
        this.originalTargetGOT = originalTargetGOT;
    }

    @Override
    public final void modify(Element entitysModify, ProgressMonitor monitor) {
        List elements = entitysModify.elements();
        for (Element entityModify : elements) {
            String entityId = entityModify.attributeValue("id");
            EntityType entityType = EntityType.valueOf((String)entityModify.getName());
            monitor.worked(0, String.format("\u6b63\u5728\u4fdd\u5b58%s\u3010%s\u3011\u4fee\u6539", entityType.name(), entityId));
            List modifyItems = entityModify.elements("Item");
            for (Element modifyItem : modifyItems) {
                if (ModifyLevel.valueOf(modifyItem.attributeValue("modifyLevel")) == ModifyLevel.Notify) continue;
                this.doModifyItem(entityId, entityType, modifyItem);
            }
        }
    }

    protected void doModifyItem(String entityId, EntityType entityType, Element modifyItem) {
        ModifyType modifyType = ModifyType.valueOf(modifyItem.attributeValue("modifyType"));
        try {
            if (modifyType != ModifyType.Entity_Add) {
                if (modifyType == ModifyType.Entity_Delete) {
                    this.applyEntityDeleteModify(entityId, entityType, modifyItem);
                } else if (modifyType == ModifyType.Entity_Rename) {
                    this.applyEntityRenameModify(entityId, entityType, modifyItem);
                } else if (modifyType == ModifyType.Entity_Property_Value) {
                    this.applyEntityPropertyValueModify(entityId, entityType, modifyItem);
                } else if (modifyType == ModifyType.InnerNode_Add) {
                    this.applyInnerNodeAddModify(entityId, entityType, modifyItem);
                } else if (modifyType == ModifyType.InnerNode_Delete) {
                    this.applyInnerNodeDeleteModify(entityId, entityType, modifyItem);
                } else if (modifyType == ModifyType.InnerNode_Rename) {
                    this.applyInnerNodeRenameModify(entityId, entityType, modifyItem);
                } else if (modifyType == ModifyType.InnerNode_Order) {
                    this.applyInnerNodeOrderModify(entityId, entityType, modifyItem);
                } else if (modifyType == ModifyType.InnerNode_Property_Value) {
                    this.applyInnerNodePropertyValueModify(entityId, entityType, modifyItem);
                } else if (modifyType != ModifyType.InnerNode_Property_Add && modifyType != ModifyType.InnerNode_Property_Delete) {
                    throw new RuntimeException(String.format("%s\u7c7b\u578b\u8282\u70b9%s\u8fdb\u884c\u5347\u7ea7\u8c03\u6574\u3010%s\u3011\u4e0d\u652f\u6301\uff1a%s", entityId, entityType.name(), modifyType.name(), modifyItem.attributeValue("description")));
                }
            }
        }
        catch (VTDException | IOException e) {
            throw new RuntimeException(String.format("%s\u7c7b\u578b\u8282\u70b9%s\u8fdb\u884c\u5347\u7ea7\u8c03\u6574\u9519\u8bef\uff1a%s", entityId, entityType.name(), modifyItem.attributeValue("description")), e);
        }
    }

    protected void applyEntityDeleteModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException {
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        List<GOTProperty> propertys = this.sourceGOT.getRefEntityPropertys(sourceEntity.getId());
        for (GOTProperty property : propertys) {
            GOTNode node = property.getGOTNode();
            GOTEntity entity = node.getEntity();
            if (!this.isModifiedLayerSource(this.sourceGOT, entity)) continue;
            if (node.getCreatedLayer().equals(this.sourceGOT.getTopLayerDefination().getLayerName())) {
                throw new ERPException(String.format("%s\u3010%s\u3011\u5728\u5f53\u524d\u5c42\u5b58\u5728\u521b\u5efa\u5c42\u4e3a\u5f53\u524d\u5c42\u7684\u8282\u70b9\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName()));
            }
            if (this.sourceGOT.getLayerLevel(node.getCreatedLayer()) <= this.targetGOT.getTopLayerLevel() || this.sourceGOT.getLayerDefination(node.getCreatedLayer()).getDeploymentMode() != LayerDeploymentMode.Package) continue;
            throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5b58\u5728\u4e0b\u5c42\u521b\u5efa\u7684\u8282\u70b9\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), node.getCreatedLayer()));
        }
        this.sourceGOT.removeEntity(sourceEntity);
    }

    protected void applyEntityRenameModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        List<GOTProperty> refPropertys = this.sourceGOT.getRefEntityPropertys(sourceEntity.getId());
        HashSet<GOTEntity> modifyEntitys = new HashSet<GOTEntity>();
        for (GOTProperty refProperty : refPropertys) {
            GOTNode refNode = refProperty.getGOTNode();
            GOTEntity refEntity = refNode.getEntity();
            if (!StringUtils.isBlank((String)refProperty.getRefInnerId())) continue;
            if (this.isModifiedLayerSource(this.sourceGOT, refEntity)) {
                refProperty.setValue(targetEntity.getName());
                modifyEntitys.add(refEntity);
                continue;
            }
            if (this.existModifiedLayer(this.targetGOT, sourceEntity)) continue;
            throw new ERPException(String.format("%s\u3010%s\u3011\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", refEntity.getNodeType(), refEntity.getName(), sourceEntity.getModifiedLayer()));
        }
        for (GOTEntity entity : modifyEntitys) {
            entity.applyModifier();
        }
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            sourceEntity.setName(targetEntity.getName());
            sourceEntity.applyModifier();
        }
    }

    protected void applyEntityPropertyValueModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        String propertyName = modifyItem.attributeValue("propertyName");
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTProperty targetProperty = targetEntity.getProperty(propertyName);
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        if (EntityType.DataType == targetEntity.getEntityType() && ("StringSize".equals(propertyName) || "NumOfDecimals".equals(propertyName))) {
            Set<GOTEntity> modifyEntitys = this.applyDataTypeSizeOrDecimalModify(targetEntity);
            for (GOTEntity modifyEntity : modifyEntitys) {
                modifyEntity.applyModifier();
            }
        }
        if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() != LayerDeploymentMode.Source) {
            throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
        GOTProperty sourceProperty = sourceEntity.getProperty(propertyName);
        sourceProperty.setValue(targetProperty.getValue());
        sourceProperty.setInnerId(targetProperty.getInnerId());
        sourceProperty.setRefEntityId(targetProperty.getRefEntityId());
        sourceProperty.setRefInnerId(targetProperty.getRefInnerId());
        sourceEntity.applyModifier();
    }

    private Set<GOTEntity> applyDataTypeSizeOrDecimalModify(GOTEntity targetEntity) throws VTDException, IOException {
        HashSet<GOTEntity> modifyEntitys = new HashSet<GOTEntity>();
        if (EntityType.DataType != targetEntity.getEntityType()) {
            return modifyEntitys;
        }
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        if (sourceEntity == null) {
            return modifyEntitys;
        }
        List<GOTProperty> refPropertys = this.sourceGOT.getRefEntityPropertys(targetEntity.getId());
        for (GOTProperty refProperty : refPropertys) {
            GOTProperty sourceProperty;
            GOTNode refNode = refProperty.getGOTNode();
            GOTEntity refEntity = refNode.getEntity();
            if (this.sourceGOT.getLayerLevel(refEntity.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel() || this.sourceGOT.getLayerDefination(refEntity.getModifiedLayer()).getDeploymentMode() != LayerDeploymentMode.Source || this.sourceGOT.getLayerDefination(refNode.getModifiedLayer()).getDeploymentMode() != LayerDeploymentMode.Source) continue;
            GOTProperty targetProperty = targetEntity.getProperty("StringSize");
            if (targetProperty != null) {
                sourceProperty = refNode.getProperty(targetProperty.getName());
                if (targetProperty != null && sourceProperty != null && Integer.parseInt(targetProperty.getValue()) > Integer.parseInt(sourceProperty.getValue())) {
                    sourceProperty.setValue(targetProperty.getValue());
                    modifyEntitys.add(refEntity);
                }
            }
            if ((targetProperty = targetEntity.getProperty("NumOfDecimals")) != null) {
                sourceProperty = refNode.getProperty(targetProperty.getName());
                if (targetProperty != null && sourceProperty != null && Integer.parseInt(targetProperty.getValue()) > Integer.parseInt(sourceProperty.getValue())) {
                    sourceProperty.setValue(targetProperty.getValue());
                    modifyEntitys.add(refEntity);
                }
            }
            if (refEntity.getEntityType() != EntityType.DataType) continue;
            modifyEntitys.addAll(this.applyDataTypeSizeOrDecimalModify(refEntity));
        }
        return modifyEntitys;
    }

    /*
     * Unable to fully structure code
     */
    protected void applyInnerNodeAddModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        block25: {
            block22: {
                block24: {
                    targetEntity = this.targetGOT.getEntityById(entityType, entityId);
                    targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
                    if (targetNode == null) {
                        nodeType = modifyItem.attributeValue("nodeType");
                        targetNode = targetEntity.selectSingleNode(nodeType);
                    }
                    if (!this.isModifiedLayerSource(this.sourceGOT, sourceEntity = this.sourceGOT.getEntityById(entityType, entityId))) break block24;
                    prevSiblingNode = targetNode.getPrevSiblingNode();
                    if (prevSiblingNode != null) ** GOTO lbl25
                    sourceParent = sourceEntity.getChildNode(targetNode.getParent().getId());
                    if (sourceParent == null) {
                        sourceParent = sourceEntity.selectSingleNode(targetNode.getParent().getEntityXPath());
                    }
                    sourceParent.insertAfterHead(targetNode.dumpFragment());
                    sourceEntity.applyModifier();
                    break block22;
lbl-1000:
                    // 1 sources

                    {
                        sourcePrevSiblingNode = sourceEntity.getChildNode(prevSiblingNode.getId());
                        if (sourcePrevSiblingNode != null) {
                            sourcePrevSiblingNode.insertAfterElement(targetNode.dumpFragment());
                            sourceEntity.applyModifier();
                        } else {
                            if ((prevSiblingNode = prevSiblingNode.getPrevSiblingNode()) != null) continue;
                            sourceParent = sourceEntity.getChildNode(targetNode.getParent().getId());
                            sourceParent.insertAfterHead(targetNode.dumpFragment());
                            sourceEntity.applyModifier();
                        }
                        break block22;
lbl25:
                        // 2 sources

                        ** while (prevSiblingNode != null)
                    }
lbl26:
                    // 1 sources

                    break block22;
                }
                if (!this.existModifiedLayer(this.targetGOT, sourceEntity)) {
                    throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", new Object[]{sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()}));
                }
            }
            if (!targetNode.getNodeType().equals("TableField")) break block25;
            refPropertys = this.sourceGOT.getRefEntityPropertys(targetEntity.getId());
            for (GOTProperty refProperty : refPropertys) {
                block26: {
                    block27: {
                        block23: {
                            refNode = refProperty.getGOTNode();
                            if (!"FormDataSource".equals(refNode.getNodeType()) || !"Table".equals(refProperty.getName()) || !this.isCreatedLayerSource(this.sourceGOT, refNode) || !this.isModifiedLayerSource(this.sourceGOT, sourceFormEntity = refNode.getEntity())) continue;
                            if (!sourceFormEntity.getModifiedLayer().equals(this.sourceGOT.getTopLayerDefination().getLayerName())) break block26;
                            if (!this.isModifiedLayerSource(this.sourceGOT, refNode)) break block27;
                            nextInnerId = Integer.parseInt(sourceFormEntity.getAttributeValue("nextInnerId"));
                            formDataSourceFieldBuf = new StringBuffer();
                            if (targetNode.getAttributeValue("type").equals("Component")) {
                                exttendEntityId = targetNode.getProperty("Extends").getAttributeValue("refentityid");
                                componentDataType = this.sourceGOT.getEntityById(EntityType.DataType, exttendEntityId);
                                dataTypeArrayItems = componentDataType.selectNodes("DataTypeArray/DataTypeArrayItem");
                                for (GOTNode dataTypeArrayItem : dataTypeArrayItems) {
                                    layerName = this.sourceGOT.getLayerLevel(dataTypeArrayItem.getCreatedLayer()) > this.sourceGOT.getLayerLevel(refNode.getCreatedLayer()) ? dataTypeArrayItem.getCreatedLayer() : refNode.getCreatedLayer();
                                    formDataSourceField = GOTUtils.createFormDataSourceField(String.valueOf(targetNode.getName()) + "." + dataTypeArrayItem.getName(), String.valueOf(nextInnerId++), layerName, "String", targetEntity.getId(), targetNode.getId(), String.valueOf(targetNode.getName()) + "." + dataTypeArrayItem.getName());
                                    formDataSourceFieldBuf.append(System.getProperty("line.separator")).append(formDataSourceField);
                                }
                            }
                            layerName = this.sourceGOT.getLayerLevel(targetNode.getCreatedLayer()) > this.sourceGOT.getLayerLevel(refNode.getCreatedLayer()) ? targetNode.getCreatedLayer() : refNode.getCreatedLayer();
                            formDataSourceField = GOTUtils.createFormDataSourceField(targetNode.getName(), String.valueOf(nextInnerId++), layerName, targetNode.getAttributeValue("type"), targetEntity.getId(), targetNode.getId(), targetNode.getName());
                            formDataSourceFieldBuf.append(System.getProperty("line.separator")).append(formDataSourceField);
                            targetPrevSiblingNode = targetNode.getPrevSiblingNode();
                            formDataSourceFields = refNode.selectSingleNode("FormDataSourceFields");
                            if (targetPrevSiblingNode != null) ** GOTO lbl98
                            targetNextSiblingNode = targetNode.getNextSiblingNode();
                            if (targetNextSiblingNode == null) {
                                formDataSourceFields.insertAfterHead(formDataSourceFieldBuf.toString());
                            } else {
                                do {
                                    if ("Component".equals(targetNextSiblingNode.getAttributeValue("type"))) {
                                        nodes = formDataSourceFields.selectNodes(String.format("FormDataSourceFields/FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetNextSiblingNode.getEntity().getId(), targetNextSiblingNode.getId()}));
                                        sourceFormDataSourceField = nodes.get(0);
                                    } else {
                                        sourceFormDataSourceField = formDataSourceFields.selectSingleNode(String.format("FormDataSourceFields/FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetNextSiblingNode.getEntity().getId(), targetNextSiblingNode.getId()}));
                                    }
                                    if (sourceFormDataSourceField == null) continue;
                                    sourceFormDataSourceField.insertBeforeElement(formDataSourceFieldBuf.toString());
                                    break block23;
                                } while ((targetNextSiblingNode = targetNextSiblingNode.getNextSiblingNode()) != null);
                                formDataSourceFields.insertAfterHead(formDataSourceFieldBuf.toString());
                            }
                            break block23;
lbl-1000:
                            // 1 sources

                            {
                                if ("Component".equals(targetPrevSiblingNode.getAttributeValue("type"))) {
                                    nodes = formDataSourceFields.selectNodes(String.format("./FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetPrevSiblingNode.getEntity().getId(), targetPrevSiblingNode.getId()}));
                                    sourceFormDataSourceField = nodes.get(nodes.size() - 1);
                                } else {
                                    sourceFormDataSourceField = formDataSourceFields.selectSingleNode(String.format("./FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetPrevSiblingNode.getEntity().getId(), targetPrevSiblingNode.getId()}));
                                }
                                if (sourceFormDataSourceField != null) {
                                    sourceFormDataSourceField.insertAfterElement(formDataSourceFieldBuf.toString());
                                    break;
                                }
                                if ((targetPrevSiblingNode = targetPrevSiblingNode.getPrevSiblingNode()) != null) continue;
                                targetNextSiblingNode = targetNode.getNextSiblingNode();
                                if (targetNextSiblingNode == null) {
                                    formDataSourceFields.insertAfterHead(formDataSourceFieldBuf.toString());
                                    break;
                                }
                                do {
                                    if ("Component".equals(targetNextSiblingNode.getAttributeValue("type"))) {
                                        nodes = formDataSourceFields.selectNodes(String.format("./FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetNextSiblingNode.getEntity().getId(), targetNextSiblingNode.getId()}));
                                        sourceFormDataSourceField = nodes.get(0);
                                    } else {
                                        sourceFormDataSourceField = formDataSourceFields.selectSingleNode(String.format("./FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetNextSiblingNode.getEntity().getId(), targetNextSiblingNode.getId()}));
                                    }
                                    if (sourceFormDataSourceField == null) continue;
                                    sourceFormDataSourceField.insertBeforeElement(formDataSourceFieldBuf.toString());
                                    break block4;
                                } while ((targetNextSiblingNode = targetNextSiblingNode.getNextSiblingNode()) != null);
                                formDataSourceFields.insertAfterHead(formDataSourceFieldBuf.toString());
                                break;
lbl98:
                                // 2 sources

                                ** while (targetPrevSiblingNode != null)
                            }
                        }
                        sourceFormEntity.setAttributeValue("nextInnerId", String.valueOf(nextInnerId));
                        sourceFormEntity.applyModifier();
                        continue;
                    }
                    throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011\u5f15\u7528\u8282\u70b9%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", new Object[]{targetEntity.getNodeType(), targetEntity.getName(), targetNode.getNodeType(), targetNode.getName(), sourceFormEntity.getNodeType(), sourceFormEntity.getName(), refNode.getNodeType(), refNode.getName(), refNode.getModifiedLayer()}));
                }
                throw new ERPException(String.format("%s\u3010%s\u3011\u5f15\u7528\u8282\u70b9%s\u3010%s\u3011\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", new Object[]{sourceEntity.getNodeType(), sourceEntity.getName(), sourceFormEntity.getNodeType(), sourceFormEntity.getName(), sourceFormEntity.getModifiedLayer()}));
            }
        }
    }

    protected void applyInnerNodeDeleteModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        String innerId;
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        GOTNode innerNode = sourceEntity.getChildNode(innerId = modifyItem.attributeValue("innerId"));
        if (innerNode == null && StringUtils.isNotBlank((String)innerId)) {
            return;
        }
        if (innerNode == null) {
            String nodeType = modifyItem.attributeValue("nodeType");
            innerNode = sourceEntity.selectSingleNode(nodeType);
        }
        String innerNodeType = innerNode.getNodeType();
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            innerNode.remove();
            sourceEntity.applyModifier();
        } else if (!this.existModifiedLayer(this.targetGOT, sourceEntity)) {
            throw new ERPException(String.format("%s\u3010%s\u3011\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
        if ("TableField".equals(innerNodeType)) {
            HashSet<GOTEntity> modifyEntitys = new HashSet<GOTEntity>();
            List<GOTProperty> refPropertys = this.sourceGOT.getRefInnerPropertys(sourceEntity.getId(), innerId);
            int i = 0;
            int size = refPropertys.size();
            while (i < size) {
                GOTProperty refProperty = refPropertys.get(i);
                GOTNode refNode = refProperty.getGOTNode();
                if ("FormDataSourceField".equals(refNode.getNodeType()) && this.sourceGOT.getLayerDefination(refNode.getEntity().getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                    refNode.remove();
                    modifyEntitys.add(refNode.getEntity());
                }
                ++i;
            }
            for (GOTEntity modifyEntity : modifyEntitys) {
                modifyEntity.applyModifier();
            }
        }
    }

    protected void applyInnerNodeRenameModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTNode targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        GOTNode sourceNode = sourceEntity.getChildNode(targetNode.getId());
        List<GOTProperty> refPropertys = this.sourceGOT.getRefEntityPropertys(sourceEntity.getId());
        HashSet<GOTEntity> modifyEntitys = new HashSet<GOTEntity>();
        for (GOTProperty refProperty : refPropertys) {
            GOTNode refNode = refProperty.getGOTNode();
            GOTEntity refEntity = refNode.getEntity();
            if (!targetNode.getId().equals(refProperty.getRefInnerId())) continue;
            if (this.isModifiedLayerSource(this.sourceGOT, refEntity)) {
                if (this.isModifiedLayerSource(this.sourceGOT, refNode)) {
                    refProperty.setValue(targetNode.getName());
                    if ("FormDataSourceField".equals(refNode.getNodeType())) {
                        refNode.setName(targetNode.getName());
                    }
                    modifyEntitys.add(refEntity);
                    continue;
                }
                if (this.existModifiedLayer(this.targetGOT, refNode)) continue;
                throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u5b58\u5728\u4fee\u6539\u7684\u8282\u70b9\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType()));
            }
            if (this.existModifiedLayer(this.targetGOT, refEntity)) continue;
            throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", refEntity.getNodeType(), refEntity.getName(), sourceEntity.getModifiedLayer()));
        }
        for (GOTEntity modifyEntity : modifyEntitys) {
            modifyEntity.applyModifier();
        }
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            boolean modify = false;
            List<GOTNode> refInnerNodes = sourceEntity.selectNodes(String.format(".//Properties/Property[@innerid='%s']/../..", targetNode.getId()));
            for (GOTNode refInnerNode : refInnerNodes) {
                if (this.isModifiedLayerSource(this.sourceGOT, sourceNode)) {
                    if ("TableIndexItem".equals(refInnerNode.getNodeType())) {
                        refInnerNode.setName(targetNode.getName());
                        modify = true;
                    }
                    for (GOTProperty property : refInnerNode.getPropertys()) {
                        if (!targetNode.getId().equals(property.getInnerId())) continue;
                        property.setValue(targetNode.getName());
                        modify = true;
                    }
                    continue;
                }
                if (this.existModifiedLayer(this.targetGOT, sourceNode)) continue;
                throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5728%s\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceNode.getModifiedLayer()));
            }
            if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
                sourceNode.setName(targetNode.getName());
                modify = true;
            } else if (!this.existModifiedLayer(this.targetGOT, sourceEntity)) {
                throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5728%s\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceNode.getModifiedLayer()));
            }
            if (modify) {
                sourceEntity.applyModifier();
            }
        } else if (!this.existModifiedLayer(this.targetGOT, sourceEntity)) {
            throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
    }

    protected void applyInnerNodePropertyValueModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        String propertyName = modifyItem.attributeValue("propertyName");
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTNode targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
        if (targetNode == null) {
            String nodeType = modifyItem.attributeValue("nodeType");
            targetNode = targetEntity.selectSingleNode(nodeType);
        }
        GOTProperty targetProperty = targetNode.getProperty(propertyName);
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            GOTNode sourceNode = sourceEntity.getChildNode(targetNode.getId());
            if (sourceNode == null) {
                String nodeType = modifyItem.attributeValue("nodeType");
                sourceNode = sourceEntity.selectSingleNode(nodeType);
            }
            GOTProperty sourceProperty = sourceNode.getProperty(propertyName);
            sourceProperty.setValue(targetProperty.getValue());
            sourceEntity.applyModifier();
            sourceProperty = sourceEntity.selectSingleNode(sourceNode.getEntityXPath()).getProperty(sourceProperty.getName());
            sourceProperty.setInnerId(targetProperty.getInnerId());
            sourceEntity.applyModifier();
            sourceProperty = sourceEntity.selectSingleNode(sourceNode.getEntityXPath()).getProperty(sourceProperty.getName());
            sourceProperty.setRefEntityId(targetProperty.getRefEntityId());
            sourceEntity.applyModifier();
            sourceProperty = sourceEntity.selectSingleNode(sourceNode.getEntityXPath()).getProperty(sourceProperty.getName());
            sourceProperty.setRefInnerId(targetProperty.getRefInnerId());
            sourceEntity.applyModifier();
        } else if (!this.existModifiedLayer(this.targetGOT, sourceEntity)) {
            throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
    }

    protected void applyInnerNodeOrderModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTNode targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
        if (targetNode == null) {
            String nodeType = modifyItem.attributeValue("nodeType");
            targetNode = targetEntity.selectSingleNode(nodeType);
        }
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        GOTNode sourceNode = sourceEntity.selectSingleNode(targetNode.getEntityXPath());
        GOTNode targetPrevSiblingNode = targetNode.getPrevSiblingNode();
        sourceNode.remove();
        if (targetPrevSiblingNode == null) {
            GOTNode targetNextSiblingNode = targetNode.getNextSiblingNode();
            if (targetNextSiblingNode == null) {
                sourceNode.getParent().insertAfterHead(sourceNode.dumpFragment());
            } else {
                GOTNode sourceNextSiblingNode = sourceEntity.selectSingleNode(targetNextSiblingNode.getEntityXPath());
                sourceNextSiblingNode.insertBeforeElement(sourceNode.dumpFragment());
            }
        } else {
            GOTNode sourcePrevSiblingNode = sourceEntity.selectSingleNode(targetPrevSiblingNode.getEntityXPath());
            if (sourcePrevSiblingNode == null) {
                GOTNode targetNextSiblingNode = targetNode.getNextSiblingNode();
                if (targetNextSiblingNode == null) {
                    sourceNode.getParent().insertAfterHead(sourceNode.dumpFragment());
                } else {
                    GOTNode sourceNextSiblingNode = sourceEntity.selectSingleNode(targetNextSiblingNode.getEntityXPath());
                    if (sourceNextSiblingNode != null) {
                        sourceNextSiblingNode.insertBeforeElement(sourceNode.dumpFragment());
                    } else {
                        sourceNode.getParent().insertAfterElement(sourceNode.dumpFragment());
                    }
                }
            } else {
                sourcePrevSiblingNode.insertAfterElement(sourceNode.dumpFragment());
            }
        }
        sourceEntity.applyModifier();
    }

    protected void applyMergeNodeModify(GOTNode sourceNode, GOTNode targetNode) throws VTDException, IOException {
        GOTNode sourceNextSiblingNode;
        GOTEntity sourceEntity = sourceNode.getEntity();
        GOTEntity entityClone = sourceEntity.clone();
        String nodeXPath = sourceNode.getEntityXPath();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (GOTNode child : sourceNode.getChildNodeBFS(true)) {
            nodeIds.add(child.getId());
        }
        for (String nodeId : nodeIds) {
            GOTNode node;
            String xpath = String.format(".//*[@id='%s']", nodeId);
            if (targetNode.selectSingleNode(xpath) != null || (node = sourceEntity.selectSingleNode(nodeXPath).selectSingleNode(xpath)) == null) continue;
            node.remove();
            sourceEntity.applyModifier();
        }
        for (GOTNode child : targetNode.getChildNodeBFS(true)) {
            GOTNode targetNextSiblingNode;
            GOTNode sourceNextSiblingNode2;
            GOTNode targetNextSiblingNode2;
            GOTNode sourcePrevSiblingNode;
            GOTNode targetPrevSiblingNode;
            String format = ".//%s[@id='%s']";
            sourceNode = sourceEntity.selectSingleNode(nodeXPath);
            if (sourceNode.selectSingleNode(String.format(format, child.getNodeType(), child.getId())) != null) continue;
            String nodeXML = child.getNodeContent();
            GOTNode targetParent = child.getParent();
            GOTNode sourceParent = sourceEntity.getChildNode(targetParent.getId());
            if (sourceParent != null) {
                targetPrevSiblingNode = child.getPrevSiblingNode();
                if (targetPrevSiblingNode != null) {
                    sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, targetPrevSiblingNode.getNodeType(), targetPrevSiblingNode.getId()));
                    if (sourcePrevSiblingNode != null && targetParent.getId().equals(sourcePrevSiblingNode.getParent().getId())) {
                        sourcePrevSiblingNode.insertAfterElement(nodeXML);
                    } else {
                        targetNextSiblingNode2 = child.getNextSiblingNode();
                        if (targetNextSiblingNode2 != null) {
                            sourceNextSiblingNode2 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode2.getNodeType(), targetNextSiblingNode2.getId()));
                            if (sourceNextSiblingNode2 != null && targetParent.getId().equals(sourceNextSiblingNode2.getParent().getId())) {
                                sourceNextSiblingNode2.insertBeforeElement(nodeXML);
                            } else {
                                sourceParent.insertBeforeTail(nodeXML);
                            }
                        } else {
                            sourceParent.insertBeforeTail(nodeXML);
                        }
                    }
                } else {
                    targetNextSiblingNode = child.getNextSiblingNode();
                    if (targetNextSiblingNode != null) {
                        sourceNextSiblingNode = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode.getNodeType(), targetNextSiblingNode.getId()));
                        if (sourceNextSiblingNode != null && targetParent.getId().equals(sourceNextSiblingNode.getParent().getId())) {
                            sourceNextSiblingNode.insertBeforeElement(nodeXML);
                        } else {
                            sourceParent.insertBeforeTail(nodeXML);
                        }
                    } else {
                        sourceParent.insertBeforeTail(nodeXML);
                    }
                }
            } else {
                targetPrevSiblingNode = child.getPrevSiblingNode();
                if (targetPrevSiblingNode != null) {
                    sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, targetPrevSiblingNode.getNodeType(), targetPrevSiblingNode.getId()));
                    if (sourcePrevSiblingNode != null) {
                        sourcePrevSiblingNode.insertAfterElement(nodeXML);
                    } else {
                        targetNextSiblingNode2 = child.getNextSiblingNode();
                        if (targetNextSiblingNode2 != null) {
                            sourceNextSiblingNode2 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode2.getNodeType(), targetNextSiblingNode2.getId()));
                            if (sourceNextSiblingNode2 != null) {
                                sourceNextSiblingNode2.insertBeforeElement(nodeXML);
                            } else {
                                sourceNode.insertBeforeTail(nodeXML);
                            }
                        } else {
                            sourceNode.insertBeforeTail(nodeXML);
                        }
                    }
                } else {
                    targetNextSiblingNode = child.getNextSiblingNode();
                    if (targetNextSiblingNode != null) {
                        sourceNextSiblingNode = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode.getNodeType(), targetNextSiblingNode.getId()));
                        if (sourceNextSiblingNode != null) {
                            sourceNextSiblingNode.insertBeforeElement(nodeXML);
                        } else {
                            sourceNode.insertBeforeTail(nodeXML);
                        }
                    } else {
                        sourceNode.insertBeforeTail(nodeXML);
                    }
                }
            }
            sourceEntity.applyModifier();
        }
        GOTNode nodeClone = entityClone.selectSingleNode(nodeXPath);
        String format = ".//*[@id='%s']";
        for (String nodeId : nodeIds) {
            GOTNode node = nodeClone.selectSingleNode(String.format(format, nodeId));
            if (!LayerUtils.isUpperLayer(this.targetGOT.getTopLayerDefination().getLayerName(), node.getCreatedLayer(), true, false) || sourceEntity.selectSingleNode(String.format(format, nodeId)) != null) continue;
            sourceNode = sourceEntity.selectSingleNode(nodeXPath);
            GOTNode prevSiblingNode = node.getPrevSiblingNode();
            GOTNode nextSiblingNode = node.getNextSiblingNode();
            GOTNode parentNode = node.getParent();
            if (prevSiblingNode != null && sourceNode.selectSingleNode(String.format(format, prevSiblingNode.getId())) != null) {
                GOTNode sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, prevSiblingNode.getId()));
                sourcePrevSiblingNode.insertAfterElement(node.getNodeContent());
            } else if (nextSiblingNode != null && sourceNode.selectSingleNode(String.format(format, nextSiblingNode.getId())) != null) {
                sourceNextSiblingNode = sourceNode.selectSingleNode(String.format(format, nextSiblingNode.getId()));
                sourceNextSiblingNode.insertBeforeElement(node.getNodeContent());
            } else if (parentNode != null && sourceNode.selectSingleNode(String.format(format, parentNode.getId())) != null) {
                GOTNode sourceParentNode = sourceNode.selectSingleNode(String.format(format, parentNode.getId()));
                sourceParentNode.insertBeforeTail(node.getNodeContent());
            } else {
                sourceNode.insertBeforeTail(node.getNodeContent());
            }
            sourceEntity.applyModifier();
        }
        nodeClone = sourceEntity.clone();
        List<GOTNode> childNodes = nodeClone.getChildNodeBFS(true);
        Iterator<GOTNode> iterator = childNodes.iterator();
        while (iterator.hasNext()) {
            format = ".//%s[@id='%s']";
            GOTNode child = iterator.next();
            GOTNode targetChild = targetNode.selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
            if (targetChild == null || child.getEntityXPath().equals(targetChild.getEntityXPath())) continue;
            String nodeXML = child.getNodeContent();
            GOTEntity transitionEntity = this.originalTargetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
            GOTNode transitionChild = transitionEntity.getChildNode(child.getId());
            if (transitionChild == null || !child.getEntityXPath().equals(transitionChild.getEntityXPath())) continue;
            sourceNode = sourceEntity.selectSingleNode(nodeXPath);
            GOTNode sourceChild = sourceNode.selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
            if (sourceChild != null) {
                sourceChild.remove();
            }
            GOTNode targetParent = targetChild.getParent();
            GOTNode sourceParent = sourceEntity.getChildNode(targetParent.getId());
            GOTNode targetPrevSiblingNode = targetChild.getPrevSiblingNode();
            if (targetPrevSiblingNode != null) {
                GOTNode sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, targetPrevSiblingNode.getNodeType(), targetPrevSiblingNode.getId()));
                if (sourcePrevSiblingNode != null && targetParent.getId().equals(sourcePrevSiblingNode.getParent().getId())) {
                    sourcePrevSiblingNode.insertAfterElement(nodeXML);
                } else {
                    GOTNode targetNextSiblingNode = targetChild.getNextSiblingNode();
                    if (targetNextSiblingNode != null) {
                        GOTNode sourceNextSiblingNode3 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode.getNodeType(), targetNextSiblingNode.getId()));
                        if (sourceNextSiblingNode3 != null && targetParent.getId().equals(sourceNextSiblingNode3.getParent().getId())) {
                            sourceNextSiblingNode3.insertBeforeElement(nodeXML);
                        } else {
                            sourceParent.insertBeforeTail(nodeXML);
                        }
                    } else {
                        sourceParent.insertBeforeTail(nodeXML);
                    }
                }
            } else {
                GOTNode targetNextSiblingNode = targetChild.getNextSiblingNode();
                if (targetNextSiblingNode != null) {
                    GOTNode sourceNextSiblingNode4 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode.getNodeType(), targetNextSiblingNode.getId()));
                    if (sourceNextSiblingNode4 != null && targetParent.getId().equals(sourceNextSiblingNode4.getParent().getId())) {
                        sourceNextSiblingNode4.insertBeforeElement(nodeXML);
                    } else {
                        sourceParent.insertBeforeTail(nodeXML);
                    }
                } else {
                    sourceParent.insertBeforeTail(nodeXML);
                }
            }
            sourceEntity.applyModifier();
        }
    }

    private boolean isCreatedLayerSource(GOTModel got, GOTNode node) throws VTDException {
        String modifiedLayer = node.getCreatedLayer();
        GOTEntity entity = node.getEntity();
        if ("app".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionDefinition solutionDefinition = got.getSolutionDefinition(solutionName);
            return solutionDefinition != null && solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source;
        }
        if ("plg".equals(modifiedLayer)) {
            String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionPluginDefinition solutionPluginDefinition = got.getSolutionPluginDefinition(solutionPluginName);
            return solutionPluginDefinition != null && solutionPluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source;
        }
        if ("ext".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionExtensionDefinition solutionExtensionDefinition = got.getSolutionExtensionDefinition(solutionName);
            return solutionExtensionDefinition != null && solutionExtensionDefinition.getDeploymentMode() == SolutionExtensionDeploymentMode.Source;
        }
        LayerDefination layerDefination = got.getLayerDefination(modifiedLayer);
        return layerDefination != null && layerDefination.getDeploymentMode() == LayerDeploymentMode.Source;
    }

    private boolean isModifiedLayerSource(GOTModel got, GOTNode node) throws VTDException {
        String modifiedLayer = node.getModifiedLayer();
        GOTEntity entity = node.getEntity();
        if ("app".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionDefinition solutionDefinition = got.getSolutionDefinition(solutionName);
            return solutionDefinition != null && solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source;
        }
        if ("plg".equals(modifiedLayer)) {
            String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionPluginDefinition solutionPluginDefinition = got.getSolutionPluginDefinition(solutionPluginName);
            return solutionPluginDefinition != null && solutionPluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source;
        }
        if ("ext".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionExtensionDefinition solutionExtensionDefinition = got.getSolutionExtensionDefinition(solutionName);
            return solutionExtensionDefinition != null && solutionExtensionDefinition.getDeploymentMode() == SolutionExtensionDeploymentMode.Source;
        }
        LayerDefination layerDefination = got.getLayerDefination(modifiedLayer);
        return layerDefination != null && layerDefination.getDeploymentMode() == LayerDeploymentMode.Source;
    }

    private boolean existModifiedLayer(GOTModel got, GOTNode node) throws VTDException {
        String modifiedLayer = node.getModifiedLayer();
        GOTEntity entity = node.getEntity();
        if ("app".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionDefinition solutionDefinition = got.getSolutionDefinition(solutionName);
            return solutionDefinition != null;
        }
        if ("plg".equals(modifiedLayer)) {
            String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionPluginDefinition solutionPluginDefinition = got.getSolutionPluginDefinition(solutionPluginName);
            return solutionPluginDefinition != null;
        }
        if ("ext".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionExtensionDefinition solutionExtensionDefinition = got.getSolutionExtensionDefinition(solutionName);
            return solutionExtensionDefinition != null;
        }
        LayerDefination layerDefination = got.getLayerDefination(modifiedLayer);
        return layerDefination != null;
    }
}

