/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.hql;

import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinitionManager;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.core.GOTLocator;
import gongqi.gdt.hql.AbstractHQL;
import gongqi.gdt.hql.statement.BaseStatement;
import gongqi.gdt.hql.statement.DeleteStatement;
import gongqi.gdt.hql.statement.FromStatement;
import gongqi.gdt.hql.statement.GroupByStatement;
import gongqi.gdt.hql.statement.InsertStatement;
import gongqi.gdt.hql.statement.OrderByStatement;
import gongqi.gdt.hql.statement.SelectStatement;
import gongqi.gdt.hql.statement.SetStatement;
import gongqi.gdt.hql.statement.UpdateStatement;
import gongqi.gdt.hql.statement.WhereStatement;
import gongqi.gdt.hql.statement.unit.BaseUnitdStatement;
import gongqi.gdt.hql.statement.unit.DeleteUnitStatement;
import gongqi.gdt.hql.statement.unit.FieldUnitStatement;
import gongqi.gdt.hql.statement.unit.FromUnitStatement;
import gongqi.gdt.hql.statement.unit.GroupByUnitStatement;
import gongqi.gdt.hql.statement.unit.InsertIntoUnitStatement;
import gongqi.gdt.hql.statement.unit.InsertTableUnitStatement;
import gongqi.gdt.hql.statement.unit.OrderByUnitStatement;
import gongqi.gdt.hql.statement.unit.SelectUnitStatement;
import gongqi.gdt.hql.statement.unit.SetUnitStatement;
import gongqi.gdt.hql.statement.unit.UpdateUnitStatement;
import info.gongqi.hql.util.ASTHelper;
import info.gongqi.hql.util.TableHelper;
import info.gongqi.util.Gongqi;
import info.gongqi.util.LayerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.antlr.runtime.tree.CommonTree;
import org.dom4j.Element;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class HQLStatement
extends AbstractHQL {
    public static final int ASSIST = 0;
    public static final int CHECK = 1;
    public static int operate;
    public ICompilationUnit unit;
    private boolean root = true;
    public int docIndex;
    private int cursorposition;
    private int hqlType;
    private static List<StringLiteral> childNode;
    private SelectStatement select = null;
    private FromStatement from = null;
    private WhereStatement where = null;
    private OrderByStatement orderBy = null;
    private GroupByStatement groupBy = null;
    private UpdateStatement update = null;
    private SetStatement set = null;
    private DeleteStatement delete = null;
    private InsertStatement insert = null;

    public HQLStatement(ContentAssistInvocationContext content, ICompilationUnit unit) throws Exception {
        this.unit = unit;
        this.setContent(ASTHelper.getHql(content, unit));
        this.setEnd(this.getContent().length());
        this.cursorposition = ASTHelper.getRelativeIndex(content, unit);
        this.setDocIndex(ASTHelper.getHqlNode(content, unit).getStartPosition());
        this.parserHql(ASTHelper.getAntlrTree(this.getContent(), 2), this.getContent());
    }

    public HQLStatement(ICompilationUnit unit, ASTNode node) throws Exception {
        this.unit = unit;
        this.setHqlStatement(this);
        this.setContent(ASTHelper.getHql(node));
        this.setDocIndex(node.getStartPosition());
        childNode = ASTHelper.getAllChildNode(node);
        this.parserHql(ASTHelper.getAntlrTree(this.getContent(), 1), this.getContent());
        operate = 1;
    }

    public HQLStatement(CommonTree tree, String hql, int startIndex, int endIndex, HQLStatement hqlStatement) {
        this.setStart(startIndex);
        this.setEnd(endIndex);
        this.setContent(hql);
        this.parserHql(tree, hql);
        this.setHqlStatement(hqlStatement);
    }

    public void syntaxCheck() {
        if (this.from != null) {
            this.checkFrom();
        }
        if (this.select != null) {
            this.checkSelect();
        }
        if (this.orderBy != null) {
            this.checkOrderBy();
        }
        if (this.groupBy != null) {
            this.checkGroupBy();
        }
        if (this.update != null) {
            this.checkUpdate();
        }
        if (this.delete != null) {
            this.checkDelete();
        }
        if (this.set != null) {
            this.checkSet();
        }
        if (this.where != null) {
            this.checkWhere();
        }
        if (this.insert != null) {
            this.checkInsert();
        }
    }

    private void checkFrom() {
        List<String> tableNames = TableHelper.getTableName();
        List<FromUnitStatement> fromFields = this.from.getFromFieldList();
        for (FromUnitStatement fromField : fromFields) {
            File tableXml;
            if (fromField.getTableName() == null) continue;
            if (!tableNames.contains(fromField.getTableName().getContent())) {
                String errinfo = String.valueOf(this.from.getFlag()) + "\u9519\u8bef\uff1a" + fromField.getTableName() + "\u8868\u4e0d\u5b58\u5728";
                int startIndex = this.getFieldInASTNodeIndex(fromField.getStart());
                Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + fromField.getLength() - 1, errinfo);
                continue;
            }
            boolean hasSolutionTable = false;
            List solutions = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolutions();
            for (SolutionDefinition solutionDefinition : solutions) {
                if (!fromField.getTableName().getContent().startsWith(solutionDefinition.getSolutionName().replace(".", "_"))) continue;
                hasSolutionTable = true;
                try {
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (workbenchWindow == null || workbenchWindow.getActivePage() == null) continue;
                    IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
                    ICompilationUnit unit = (ICompilationUnit)EditorUtility.getEditorInputJavaElement(activeEditor, false);
                    String packageName = unit.getPackageDeclarations()[0].getElementName();
                    if (((SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class)).solutionExtensionExists(solutionDefinition.getSolutionName())) {
                        if (LayerUtil.getLayerLevel(this.extractLayerName(packageName)) < 6) {
                            int startIndex = this.getFieldInASTNodeIndex(fromField.getStart());
                            Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + fromField.getLength() - 1, "\u4e0d\u5141\u8bb8\u5f15\u7528\u4e0a\u5c42\u8868");
                            break;
                        }
                    } else if (LayerUtil.getLayerLevel(this.extractLayerName(packageName)) < 4) {
                        int startIndex = this.getFieldInASTNodeIndex(fromField.getStart());
                        Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + fromField.getLength() - 1, "\u4e0d\u5141\u8bb8\u5f15\u7528\u4e0a\u5c42\u8868");
                        break;
                    }
                    if (!packageName.contains(".layers.") || packageName.startsWith("gongqi.erp.layers.")) continue;
                    packageName.substring(packageName.indexOf(".layers.") + 8, packageName.indexOf(".layers.") + 11);
                    String namePrefix = packageName.substring(0, packageName.indexOf(".layers."));
                    if (namePrefix.equals(solutionDefinition.getSolutionName())) continue;
                    int startIndex = this.getFieldInASTNodeIndex(fromField.getStart());
                    Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + fromField.getLength() - 1, "\u4e0d\u5141\u8bb8\u8de8\u5e94\u7528\u8fdb\u884c\u8868\u5f15\u7528");
                    break;
                }
                catch (JavaModelException javaModelException) {}
            }
            List solutionPluginDefinitions = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugins();
            for (SolutionPluginDefinition solutionPluginDefinition : solutionPluginDefinitions) {
                if (!fromField.getTableName().getContent().startsWith(solutionPluginDefinition.getName().replace(".", "_"))) continue;
                hasSolutionTable = true;
                try {
                    IEditorPart activeEditor;
                    ICompilationUnit unit;
                    String packageName;
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (workbenchWindow == null || workbenchWindow.getActivePage() == null || !(packageName = (unit = (ICompilationUnit)EditorUtility.getEditorInputJavaElement(activeEditor = workbenchWindow.getActivePage().getActiveEditor(), false)).getPackageDeclarations()[0].getElementName()).contains(".layers.") || packageName.startsWith("gongqi.erp.layers.")) continue;
                    packageName.substring(packageName.indexOf(".layers.") + 8, packageName.indexOf(".layers.") + 11);
                    String namePrefix = packageName.substring(0, packageName.indexOf(".layers."));
                    if (namePrefix.equals(solutionPluginDefinition.getName())) continue;
                    int startIndex = this.getFieldInASTNodeIndex(fromField.getStart());
                    Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + fromField.getLength() - 1, "\u4e0d\u5141\u8bb8\u8de8\u5e94\u7528\u8fdb\u884c\u8868\u5f15\u7528");
                    break;
                }
                catch (JavaModelException javaModelException) {}
            }
            if (hasSolutionTable || !(tableXml = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFile(EntityType.Table, fromField.getTableName().getContent())).exists()) continue;
            try {
                IEditorPart activeEditor;
                ICompilationUnit unit;
                String packageName;
                int level;
                Element tableElement = FileUtils.readFileToDocument((File)tableXml).getRootElement();
                String createdLayer = tableElement.attributeValue("createdLayer");
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow == null || workbenchWindow.getActivePage() == null || (level = LayerUtil.getLayerLevel(this.extractLayerName(packageName = (unit = (ICompilationUnit)EditorUtility.getEditorInputJavaElement(activeEditor = workbenchWindow.getActivePage().getActiveEditor(), false)).getPackageDeclarations()[0].getElementName()))) >= LayerUtil.getLayerLevel(createdLayer)) continue;
                int startIndex = this.getFieldInASTNodeIndex(fromField.getStart());
                Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + fromField.getLength() - 1, "\u4e0d\u5141\u8bb8\u5f15\u7528\u4e0a\u5c42\u8868");
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void checkWhere() {
        List<FieldUnitStatement> fields = this.where.getFields();
        List<HQLStatement> subquerys = this.where.getSubquerys();
        int i = 0;
        while (i < fields.size()) {
            this.checkTableAliasAndField(fields.get(i), "WHERE");
            ++i;
        }
        i = 0;
        while (i < subquerys.size()) {
            subquerys.get(i).syntaxCheck();
            ++i;
        }
    }

    private void checkUpdate() {
        List<String> tableNames = TableHelper.getTableName();
        List<UpdateUnitStatement> updateFields = this.update.getUpdateFieldList();
        for (UpdateUnitStatement field : updateFields) {
            int startIndex;
            String errinfo;
            if (field.getTableName() != null && !tableNames.contains(field.getTableName().getContent())) {
                errinfo = String.valueOf(this.update.getFlag()) + "\u9519\u8bef\uff1a" + field.getTableName() + "\u8868\u4e0d\u5b58\u5728";
                startIndex = this.getFieldInASTNodeIndex(field.getStart());
                Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + field.getLength() - 1, errinfo);
                continue;
            }
            if (!"".equals(field.getTableAlias().getContent())) continue;
            errinfo = String.valueOf(this.update.getFlag()) + "\u9519\u8bef\uff1a" + field.getTableName() + "\u8868\u4e0d\u5b58\u5728\u8868\u522b\u540d";
            startIndex = this.getFieldInASTNodeIndex(field.getStart());
            Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + field.getLength() - 1, errinfo);
        }
    }

    private void checkDelete() {
        List<String> tableNames = TableHelper.getTableName();
        List<DeleteUnitStatement> deleteFields = this.delete.getDeleteFieldList();
        for (DeleteUnitStatement field : deleteFields) {
            if (field.getTableName() == null || tableNames.contains(field.getTableName().getContent())) continue;
            String errinfo = String.valueOf(this.delete.getFlag()) + "\u9519\u8bef\uff1a" + field.getTableName() + "\u8868\u4e0d\u5b58\u5728";
            int startIndex = this.getFieldInASTNodeIndex(field.getStart());
            Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + field.getLength() - 1, errinfo);
        }
    }

    private void checkSelect() {
        for (SelectUnitStatement selectField : this.select.getSelectFieldList()) {
            if (selectField.isFunction()) {
                for (FieldUnitStatement fieldUnitStatement : selectField.getFunctionObject().getFieldList()) {
                    this.checkTableAliasAndField(fieldUnitStatement, this.select.getFlag());
                }
                continue;
            }
            this.checkTableAliasAndField(selectField, this.select.getFlag());
        }
    }

    private void checkOrderBy() {
        for (OrderByUnitStatement orderByField : this.orderBy.getOrderByFieldList()) {
            this.checkTableAliasAndField(orderByField, this.orderBy.getFlag());
        }
    }

    private void checkGroupBy() {
        for (GroupByUnitStatement groupByField : this.groupBy.getGroupByFieldList()) {
            this.checkTableAliasAndField(groupByField, this.groupBy.getFlag());
        }
    }

    private void checkSet() {
        for (SetUnitStatement setField : this.set.getSetFieldList()) {
            if (setField.getField() != null) {
                this.checkTableAliasAndField(setField.getField(), this.set.getFlag());
            }
            if (!setField.isSubQuery()) continue;
            setField.getSubQueryObj().syntaxCheck();
        }
    }

    private void checkInsert() {
        InsertTableUnitStatement insertTable = this.insert.getInsertTable();
        if (insertTable == null) {
            String errinfo = String.valueOf(this.insert.getFlag()) + "\u9519\u8bef\uff1a\u6ca1\u6709\u8868\u540d";
            int startIndex = this.getFieldInASTNodeIndex(this.insert.getStart());
            Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + this.insert.getLength() - 1, errinfo);
            return;
        }
        List<String> tableName = TableHelper.getTableName();
        if (!tableName.contains(insertTable.getTableName().getContent())) {
            String errinfo = String.valueOf(this.insert.getFlag()) + "\u9519\u8bef\uff1a" + insertTable.getTableName() + "\u8868\u4e0d\u5b58\u5728";
            int startIndex = this.getFieldInASTNodeIndex(insertTable.getStart());
            Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + insertTable.getLength() - 1, errinfo);
            return;
        }
        InsertIntoUnitStatement field = this.insert.getFields();
        if (field == null) {
            String errinfo = String.valueOf(this.insert.getFlag()) + "\u9519\u8bef\uff1a\u6ca1\u6709\u5b57\u6bb5";
            int startIndex = this.getFieldInASTNodeIndex(this.insert.getStart());
            Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + this.insert.getLength(), errinfo);
            return;
        }
        List<String> fields = TableHelper.getFields(insertTable.getTableName().getContent());
        int i = 0;
        while (i < field.getFields().size()) {
            if (!fields.contains(field.getFields().get(i).getFieldName().getContent())) {
                String errinfo = String.valueOf(this.insert.getFlag()) + "\u9519\u8bef\uff1a" + field.getFields().get(i).getFieldName() + "\u5b57\u6bb5\u4e0d\u5b58\u5728";
                int startIndex = this.getFieldInASTNodeIndex(field.getFields().get(i).getStart());
                Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + field.getFields().get(i).getLength() - 1, errinfo);
            }
            ++i;
        }
    }

    private void checkTableAliasAndField(BaseUnitdStatement field, String regionName) {
        List<Object> fields = new ArrayList();
        List<Object> tableAlias = new ArrayList();
        List<Object> child = new ArrayList();
        String errinfo = "";
        try {
            String tableName;
            if (this.from != null && this.hqlType == 1 || this.hqlType == 4) {
                if (field.getTableAlias() != null) {
                    fields = this.from.getFields(field.getTableAlias().getContent());
                    if (field.getChildTableName() != null) {
                        tableName = this.from.getTableName(field.getTableAlias().getContent());
                        child = TableHelper.findDataTypeFields(tableName, field.getChildTableName().getContent());
                    }
                } else {
                    fields = this.from.getFields();
                }
                tableAlias = this.from.getTableAlias();
            } else if (this.update != null && this.hqlType == 2) {
                if (field.getTableAlias() != null) {
                    fields = this.update.getTableFields(field.getTableAlias().getContent());
                    if (field.getChildTableName() != null) {
                        tableName = this.update.getTableName(field.getTableAlias().getContent());
                        child = TableHelper.findDataTypeFields(tableName, field.getChildTableName().getContent());
                    }
                } else {
                    fields = this.update.getUpdateAllFields();
                }
                tableAlias = this.update.getTableAlias();
            } else if (this.delete != null && this.hqlType == 3) {
                if (field.getTableAlias() != null) {
                    fields = this.delete.getTableFields(field.getTableAlias().getContent());
                    if (field.getChildTableName() != null) {
                        tableName = this.delete.getTableName(field.getTableAlias().getContent());
                        child = TableHelper.findDataTypeFields(tableName, field.getChildTableName().getContent());
                    }
                } else {
                    fields = this.delete.getDeleteAllFields();
                }
                tableAlias = this.delete.getTableAlias();
            }
        }
        catch (Exception e) {
            JavaPlugin.log(e);
        }
        if (field.getTableAlias() != null && !tableAlias.contains(field.getTableAlias().getContent())) {
            errinfo = String.valueOf(regionName) + "\u9519\u8bef\uff1a\u8868\u522b\u540d" + field.getTableAlias() + "\u4e0d\u5b58\u5728";
            int startIndex = this.getFieldInASTNodeIndex(field.getStart());
            Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + field.getLength() - 1, errinfo);
            return;
        }
        if (field.getChildTableName() != null) {
            int startIndex = this.getFieldInASTNodeIndex(field.getStart());
            if (!fields.contains(field.getChildTableName().getContent())) {
                errinfo = String.valueOf(regionName) + "\u9519\u8bef\uff1a\u5b57\u6bb5" + field.getChildTableName() + "\u4e0d\u5b58\u5728";
                Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + field.getLength() - 1, errinfo);
            }
            if (!child.contains(field.getFieldName().getContent())) {
                errinfo = String.valueOf(regionName) + "\u9519\u8bef\uff1a\u5b57\u6bb5" + field.getFieldName() + "\u4e0d\u5b58\u5728";
                Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + field.getLength() - 1, errinfo);
            }
        } else if (field.getFieldName() != null && !fields.contains(field.getFieldName().getContent())) {
            errinfo = String.valueOf(regionName) + "\u9519\u8bef\uff1a\u5b57\u6bb5" + field.getFieldName() + "\u4e0d\u5b58\u5728";
            int startIndex = this.getFieldInASTNodeIndex(field.getStart());
            Gongqi.createMarker(this.getResource(), Gongqi.HQL_MARKER_ID, startIndex, startIndex + field.getLength() - 1, errinfo);
        }
    }

    public List<JavaCompletionProposal> getContentAssistList(ContentAssistInvocationContext content) throws Exception {
        return this.getAssistList(this.getSubQuery(this.cursorposition), this.cursorposition, content.getInvocationOffset());
    }

    private List<JavaCompletionProposal> getAssistList(HQLStatement hqlObj, int index, int invocationOffset) throws Exception {
        ArrayList<JavaCompletionProposal> contextAssistList;
        block65: {
            int j;
            JavaCompletionProposal javacompletionprosal;
            String fieldName;
            String tableAlias_prefix;
            String tableAlias;
            String tableName;
            String prefix;
            block66: {
                prefix = null;
                String prefix2 = null;
                tableName = null;
                tableAlias = null;
                tableAlias_prefix = null;
                fieldName = null;
                javacompletionprosal = null;
                contextAssistList = new ArrayList<JavaCompletionProposal>();
                String regionName = hqlObj.getRegion(hqlObj, index);
                BaseStatement basicObject = hqlObj.getBasicObject(regionName);
                if (regionName == null || !basicObject.checkCondition(index)) break block65;
                int i = index - hqlObj.getStart();
                block4: while (i > basicObject.getStart() + basicObject.getFlag().length() - 1 - hqlObj.getStart()) {
                    char c = hqlObj.getContent().charAt(i);
                    if (c == '.') {
                        char ch3;
                        int k;
                        char ch2;
                        if (i != index - hqlObj.getStart()) {
                            prefix = hqlObj.getContent().substring(i + 1, index + 1 - hqlObj.getStart());
                            j = i - 1;
                            while (j > basicObject.getStart() - hqlObj.getStart()) {
                                ch2 = this.getContent().charAt(j);
                                if (ch2 == ' ' || ch2 == ',' || ch2 == '(' || c == '=' || ch2 == '=') {
                                    tableAlias = hqlObj.getContent().substring(j + 1, i);
                                    break block4;
                                }
                                if (ch2 == '.') {
                                    fieldName = hqlObj.getContent().substring(j + 1, i);
                                    k = j - 1;
                                    while (k > basicObject.getStart() - hqlObj.getStart()) {
                                        ch3 = hqlObj.getContent().charAt(k);
                                        if (ch3 == ' ' || ch3 == ',' || ch3 == '(' || ch3 == '=') {
                                            tableAlias = hqlObj.getContent().substring(k + 1, j);
                                        }
                                        --k;
                                    }
                                    break block4;
                                }
                                --j;
                            }
                            break;
                        }
                        j = i - 1;
                        while (j > basicObject.getStart() - hqlObj.getStart()) {
                            ch2 = hqlObj.getContent().charAt(j);
                            if (ch2 == ' ' || ch2 == ',' || ch2 == '(' || ch2 == '=') {
                                tableAlias = hqlObj.getContent().substring(j + 1, i);
                                break block4;
                            }
                            if (ch2 == '.') {
                                fieldName = hqlObj.getContent().substring(j + 1, i);
                                k = j - 1;
                                while (k > basicObject.getStart() - hqlObj.getStart()) {
                                    ch3 = hqlObj.getContent().charAt(k);
                                    if (ch3 == ' ' || ch3 == ',' || ch3 == '(' || ch3 == '=') {
                                        tableAlias = hqlObj.getContent().substring(k + 1, j);
                                        break block4;
                                    }
                                    --k;
                                }
                                break block4;
                            }
                            --j;
                        }
                        break;
                    }
                    if (c == ' ' || c == ',' || c == '(' || c == '=') {
                        if ("FROM".equals(regionName) || "UPDATE".equals(regionName) || "DELETE".equals(regionName)) {
                            tableName = hqlObj.getContent().substring(i + 1, index + 1 - hqlObj.getStart());
                            break;
                        }
                        if ("INSERT".equals(regionName)) {
                            int asssitType = ((InsertStatement)basicObject).getAssistType(index);
                            if (asssitType == 2) {
                                prefix = hqlObj.getContent().substring(i + 1, index + 1 - hqlObj.getStart());
                                tableAlias = ((InsertStatement)basicObject).getInsertTable().getTableName().getContent();
                                break;
                            }
                            if (asssitType == 1) {
                                tableName = hqlObj.getContent().substring(i + 1, index + 1 - hqlObj.getStart());
                                break;
                            }
                            return contextAssistList;
                        }
                        tableAlias_prefix = hqlObj.getContent().substring(i + 1, index + 1 - hqlObj.getStart());
                        break;
                    }
                    --i;
                }
                i = index - hqlObj.getStart();
                while (i > basicObject.getStart() + basicObject.getFlag().length() - 1 - hqlObj.getStart()) {
                    char c = hqlObj.getContent().charAt(i);
                    if (c == ' ' || c == ',') {
                        if (prefix2 == null) {
                            prefix2 = this.getContent().substring(i + 1, this.cursorposition + 1);
                            break;
                        }
                    } else if (c == '.' || c == '(' || c == '>' || c == '<' || c == '=' || c == '-' || c == '+' || c == '*' || c == '/') break;
                    --i;
                }
                if (tableName != null || fieldName != null || tableAlias == null) break block66;
                if (this.hqlType == 0) {
                    return contextAssistList;
                }
                if (this.hqlType == 1) {
                    FromStatement fromObject = hqlObj.from;
                    if (this.from == null) {
                        return contextAssistList;
                    }
                    tableName = fromObject.getTableName(tableAlias);
                } else if (this.hqlType == 2) {
                    UpdateStatement updateObject = hqlObj.update;
                    if (updateObject == null) {
                        return contextAssistList;
                    }
                    tableName = updateObject.getTableName(tableAlias);
                } else if (this.hqlType == 3) {
                    DeleteStatement deleteObject = hqlObj.delete;
                    if (deleteObject == null) {
                        return contextAssistList;
                    }
                    tableName = deleteObject.getTableName(tableAlias);
                } else if (this.hqlType == 4) {
                    if (this.cursorposition >= hqlObj.insert.getStart() && this.cursorposition <= hqlObj.insert.getEnd()) {
                        tableName = tableAlias;
                    } else {
                        FromStatement fromObject = hqlObj.from;
                        if (this.from == null) {
                            return contextAssistList;
                        }
                        tableName = fromObject.getTableName(tableAlias);
                    }
                }
                List<String> fields = TableHelper.getFields(tableName, prefix);
                if (fields == null) break block65;
                for (String string : fields) {
                    javacompletionprosal = prefix != null && !"".equals(prefix) ? new JavaCompletionProposal(string, invocationOffset - prefix.length(), prefix.length(), null, string, 1) : new JavaCompletionProposal(string, invocationOffset, string.length(), null, string, 1);
                    contextAssistList.add(javacompletionprosal);
                }
                break block65;
            }
            if (tableName == null && fieldName != null && tableAlias != null) {
                String _tableName = null;
                if (this.hqlType == 1 || this.hqlType == 3) {
                    _tableName = hqlObj.from.getTableName(tableAlias);
                } else if (this.hqlType == 2) {
                    _tableName = hqlObj.update.getTableName(tableAlias);
                }
                List<String> list = TableHelper.getDataTypeFields(TableHelper.getDataTypeTableName(_tableName, fieldName), prefix);
                j = 0;
                while (j < list.size()) {
                    String childField = list.get(j);
                    javacompletionprosal = prefix != null ? new JavaCompletionProposal(childField, invocationOffset - prefix.length(), childField.length(), null, childField, 1) : new JavaCompletionProposal(childField, invocationOffset, childField.length(), null, childField, 1);
                    contextAssistList.add(javacompletionprosal);
                    ++j;
                }
            } else if (fieldName == null && tableAlias == null && tableName != null) {
                List<String> tableNames = TableHelper.getTableName(tableName);
                try {
                    IEditorPart activeEditor;
                    ICompilationUnit unit;
                    String packageName;
                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null && iWorkbenchWindow.getActivePage() != null && (packageName = (unit = (ICompilationUnit)EditorUtility.getEditorInputJavaElement(activeEditor = iWorkbenchWindow.getActivePage().getActiveEditor(), false)).getPackageDeclarations()[0].getElementName()).contains(".layers.")) {
                        if (!packageName.startsWith("gongqi.erp.layers.")) {
                            String layerName = packageName.substring(packageName.indexOf(".layers.") + 8, packageName.indexOf(".layers.") + 11);
                            String namePrefix = packageName.substring(0, packageName.indexOf(".layers."));
                            ListIterator<String> iterator = tableNames.listIterator();
                            List solutions = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolutions();
                            block12: while (iterator.hasNext()) {
                                SolutionPluginDefinition solutionPluginDefinition;
                                String _tableName = iterator.next();
                                for (SolutionDefinition solutionDefinition : solutions) {
                                    if (!_tableName.startsWith(solutionDefinition.getSolutionName().replace(".", "_"))) continue;
                                    if ("plg".equals(layerName)) {
                                        solutionPluginDefinition = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(namePrefix);
                                        if (solutionPluginDefinition.getSolutionName().equals(solutionDefinition.getSolutionName())) break;
                                        iterator.remove();
                                        break;
                                    }
                                    if (namePrefix.equals(solutionDefinition.getSolutionName())) break;
                                    iterator.remove();
                                    break;
                                }
                                List solutionPlugins = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugins();
                                solutionPluginDefinition = solutionPlugins.iterator();
                                while (solutionPluginDefinition.hasNext()) {
                                    SolutionPluginDefinition solutionPluginDefinition2 = (SolutionPluginDefinition)solutionPluginDefinition.next();
                                    if (!_tableName.startsWith(solutionPluginDefinition2.getName().replace(".", "_"))) continue;
                                    if (namePrefix.equals(solutionPluginDefinition2.getName())) continue block12;
                                    iterator.remove();
                                    continue block12;
                                }
                            }
                        }
                        List solutionDefinitions = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolutions();
                        ListIterator<String> iterator = tableNames.listIterator();
                        while (iterator.hasNext()) {
                            File tableXml;
                            String _tableName = iterator.next();
                            String tableEntityName = null;
                            for (SolutionDefinition solutionDefinition : solutionDefinitions) {
                                if (!_tableName.startsWith(solutionDefinition.getSolutionName().replace(".", "_"))) continue;
                                String tableEntitySimpleName = _tableName.substring(solutionDefinition.getSolutionName().length() + 1);
                                tableEntityName = String.valueOf(solutionDefinition.getSolutionName()) + "." + tableEntitySimpleName;
                                break;
                            }
                            if (tableEntityName == null) {
                                tableEntityName = _tableName;
                            }
                            if ((tableXml = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityFile(EntityType.Table, tableEntityName)) == null || !tableXml.exists()) continue;
                            Element tableElement = FileUtils.readFileToDocument((File)tableXml).getRootElement();
                            String createdLayer = tableElement.attributeValue("createdLayer");
                            int level = LayerUtil.getLayerLevel(this.extractLayerName(packageName));
                            if (level >= LayerUtil.getLayerLevel(createdLayer)) continue;
                            iterator.remove();
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
                for (String string : tableNames) {
                    javacompletionprosal = new JavaCompletionProposal(string, invocationOffset - tableName.length(), tableName.length(), null, string, 1);
                    contextAssistList.add(javacompletionprosal);
                }
            } else if (fieldName == null && tableAlias == null && tableName == null) {
                List<Object> tableAliasList;
                block64: {
                    tableAliasList = new ArrayList();
                    try {
                        if (this.hqlType == 2) {
                            tableAliasList = hqlObj.update.findTableAlias(tableAlias_prefix);
                            break block64;
                        }
                        if (this.hqlType == 1 || this.hqlType == 4) {
                            tableAliasList = hqlObj.from.findTableAlias(tableAlias_prefix);
                            break block64;
                        }
                        if (this.hqlType == 3) {
                            tableAliasList = hqlObj.delete.findTableAlias(tableAlias_prefix);
                            break block64;
                        }
                        throw new Exception("\u83b7\u53d6\u8868\u522b\u540d\u5931\u8d25");
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new Exception("\u83b7\u53d6\u8868\u522b\u540d\u5931\u8d25", nullPointerException);
                    }
                }
                for (String string : tableAliasList) {
                    javacompletionprosal = tableAlias_prefix == null || "".equals(tableAlias_prefix) ? new JavaCompletionProposal(string, invocationOffset, 0, null, string, 1) : new JavaCompletionProposal(string, invocationOffset - tableAlias_prefix.length(), tableAlias_prefix.length(), null, string, 1);
                    contextAssistList.add(javacompletionprosal);
                }
            }
        }
        return contextAssistList;
    }

    private BaseStatement getBasicObject(String regionName) {
        if ("SELECT".equals(regionName)) {
            return this.select;
        }
        if ("FROM".equals(regionName)) {
            return this.from;
        }
        if ("WHERE".equals(regionName)) {
            return this.where;
        }
        if ("ORDER BY".equals(regionName)) {
            return this.orderBy;
        }
        if ("GROUP BY".equals(regionName)) {
            return this.groupBy;
        }
        if ("UPDATE".equals(regionName)) {
            return this.update;
        }
        if ("SET".equals(regionName)) {
            return this.set;
        }
        if ("DELETE".equals(regionName)) {
            return this.delete;
        }
        if ("INSERT".equals(regionName)) {
            return this.insert;
        }
        return null;
    }

    private String getRegion(HQLStatement hqlObj, int index) {
        if (index <= 0) {
            return null;
        }
        if (hqlObj.select != null && hqlObj.select.getStart() <= index && hqlObj.select.getEnd() >= index) {
            return "SELECT";
        }
        if (hqlObj.from != null && hqlObj.from.getStart() <= index && hqlObj.from.getEnd() >= index) {
            return "FROM";
        }
        if (hqlObj.where != null && hqlObj.where.getStart() <= index && hqlObj.where.getEnd() >= index) {
            return "WHERE";
        }
        if (hqlObj.groupBy != null && hqlObj.groupBy.getStart() <= index && hqlObj.groupBy.getEnd() >= index) {
            return "GROUP BY";
        }
        if (hqlObj.orderBy != null && hqlObj.orderBy.getStart() <= index && hqlObj.orderBy.getEnd() >= index) {
            return "ORDER BY";
        }
        if (hqlObj.update != null && hqlObj.update.getStart() <= index && hqlObj.update.getEnd() >= index) {
            return "UPDATE";
        }
        if (hqlObj.set != null && hqlObj.set.getStart() <= index && hqlObj.set.getEnd() >= index) {
            return "SET";
        }
        if (hqlObj.delete != null && hqlObj.delete.getStart() <= index && hqlObj.delete.getEnd() >= index) {
            return "DELETE";
        }
        if (hqlObj.insert != null && hqlObj.insert.getStart() <= index && hqlObj.insert.getEnd() >= index) {
            return "INSERT";
        }
        return null;
    }

    private int getFieldInASTNodeIndex(int position) {
        String str = "";
        int i = 0;
        while (i < childNode.size()) {
            if (position >= str.length() && position < str.length() + childNode.get(i).getLiteralValue().length()) {
                return childNode.get(i).getStartPosition() + position - str.length() + 1;
            }
            str = str.concat(childNode.get(i).getLiteralValue());
            ++i;
        }
        return -1;
    }

    private void parserHql(CommonTree tree, String hql) {
        if (("HQL".equals(tree.getText()) || "SUBQUERYCLAUSE".equals(tree.getText())) && tree.getChildCount() != 0) {
            List child = tree.getChildren();
            int i = 0;
            while (i < child.size()) {
                CommonTree s_tree = (CommonTree)child.get(i);
                if ("QUERYCLAUSE".equals(s_tree.getText())) {
                    this.parserQueryClause(s_tree, hql);
                    this.hqlType = 1;
                } else if ("UPDATESTATEMENT".equals(s_tree.getText())) {
                    this.parserUpdateClause(s_tree, hql);
                    this.hqlType = 2;
                } else if ("DELETECLAUSE".equals(s_tree.getText())) {
                    this.parserDeleteClause(s_tree, hql);
                    this.hqlType = 3;
                } else if ("INSERTCLAUSE".equals(s_tree.getText())) {
                    this.parserInsertClause(s_tree, hql);
                    this.hqlType = 4;
                } else {
                    throw new RuntimeException("\u89e3\u6790\u9519\u8bef");
                }
                ++i;
            }
        }
    }

    private void parserQueryClause(CommonTree tree, String hql) {
        List child = tree.getChildren();
        int i = 0;
        while (i < child.size()) {
            CommonTree s_tree = (CommonTree)child.get(i);
            if ("SELECTCLAUSE".equals(s_tree.getText())) {
                this.select = i < child.size() - 1 ? new SelectStatement(s_tree, ((CommonTree)child.get(i + 1)).getCharPositionInLine() - 1, this) : new SelectStatement(s_tree, hql.length() + this.getStart(), this);
            } else if ("FROMCLAUSE".equals(s_tree.getText())) {
                this.from = i < child.size() - 1 ? new FromStatement(s_tree, ((CommonTree)child.get(i + 1)).getCharPositionInLine() - 1, this) : new FromStatement(s_tree, hql.length() + this.getStart(), this);
            } else if ("WHERECLAUSE".equals(s_tree.getText())) {
                this.where = i < child.size() - 1 ? new WhereStatement(s_tree, ((CommonTree)child.get(i + 1)).getCharPositionInLine() - 1, this.getContent(), this) : new WhereStatement(s_tree, hql.length() + this.getStart(), this.getContent(), this);
            } else if ("GROUPCLAUSE".equals(s_tree.getText())) {
                this.groupBy = i < child.size() - 1 ? new GroupByStatement(s_tree, ((CommonTree)child.get(i + 1)).getCharPositionInLine() - 1, this.getContent(), this) : new GroupByStatement(s_tree, hql.length() + this.getStart(), this.getContent(), this);
            } else if ("ORDERCLAUSE".equals(s_tree.getText())) {
                this.orderBy = i < child.size() - 1 ? new OrderByStatement(s_tree, ((CommonTree)child.get(i + 1)).getCharPositionInLine() - 1, this) : new OrderByStatement(s_tree, hql.length() + this.getStart(), this);
            }
            ++i;
        }
    }

    private void parserUpdateClause(CommonTree tree, String hql) {
        List list = tree.getChildren();
        int i = 0;
        while (i < list.size()) {
            if (((CommonTree)list.get(i)).getType() == 86) {
                this.update = i < list.size() - 1 ? new UpdateStatement((CommonTree)list.get(i), ((CommonTree)list.get(i + 1)).getCharPositionInLine(), this) : new UpdateStatement((CommonTree)list.get(i), hql.length() + this.getStart(), this);
            } else if (((CommonTree)list.get(i)).getType() == 77) {
                this.set = i < list.size() - 1 ? new SetStatement((CommonTree)list.get(i), ((CommonTree)list.get(i + 1)).getCharPositionInLine(), this.getContent(), this) : new SetStatement((CommonTree)list.get(i), hql.length() + this.getStart(), this.getContent(), this);
            } else if (((CommonTree)list.get(i)).getType() == 89) {
                this.where = i < list.size() - 1 ? new WhereStatement((CommonTree)list.get(i), ((CommonTree)list.get(i)).getCharPositionInLine(), this.getContent(), this) : new WhereStatement((CommonTree)list.get(i), hql.length() + this.getStart(), this.getContent(), this);
            }
            ++i;
        }
    }

    private void parserDeleteClause(CommonTree tree, String hql) {
        List list = tree.getChildren();
        int i = 0;
        while (i < list.size()) {
            if (((CommonTree)list.get(i)).getType() == 18) {
                this.delete = i < list.size() - 1 ? new DeleteStatement((CommonTree)list.get(i), ((CommonTree)list.get(i + 1)).getCharPositionInLine() - 1, this) : new DeleteStatement((CommonTree)list.get(i), hql.length() + this.getStart(), this);
            } else if (((CommonTree)list.get(i)).getType() == 89) {
                this.where = i < list.size() - 1 ? new WhereStatement((CommonTree)list.get(i), ((CommonTree)list.get(i + 1)).getCharPositionInLine() - 1, this.getContent(), this) : new WhereStatement((CommonTree)list.get(i), hql.length() + this.getStart(), this.getContent(), this);
            }
            ++i;
        }
    }

    private void parserInsertClause(CommonTree tree, String hql) {
        List list = tree.getChildren();
        int i = 0;
        while (i < list.size()) {
            if (((CommonTree)list.get(i)).getType() == 43) {
                this.insert = i < list.size() - 1 ? new InsertStatement((CommonTree)list.get(i), ((CommonTree)list.get(i + 1)).getCharPositionInLine() - 1, this) : new InsertStatement((CommonTree)list.get(i), hql.length() + this.getStart(), this);
            } else if (((CommonTree)list.get(i)).getType() == 72) {
                this.parserQueryClause((CommonTree)list.get(i), hql);
            }
            ++i;
        }
    }

    private HQLStatement getSubQuery(int index) {
        BaseStatement basicObject = this.getBasicObject(this.getRegion(this, index));
        if (basicObject != null && basicObject.inSubQuery(index)) {
            return basicObject.getSubQuery(index);
        }
        return this;
    }

    public void instialize() {
        if (this.select != null) {
            this.select.instialize();
        }
        if (this.from != null) {
            this.from.instialize();
        }
        if (this.where != null) {
            this.where.instialize();
        }
        if (this.orderBy != null) {
            this.orderBy.instialize();
        }
        if (this.groupBy != null) {
            this.groupBy.instialize();
        }
        if (this.update != null) {
            this.update.instialize();
        }
        if (this.set != null) {
            this.set.instialize();
        }
        if (this.delete != null) {
            this.delete.instialize();
        }
        if (this.insert != null) {
            this.insert.instialize();
        }
    }

    public IResource getResource() {
        if (this.unit == null) {
            return null;
        }
        return this.getRoot().unit.getResource();
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public int getDocIndex() {
        return this.docIndex;
    }

    public void setDocIndex(int docIndex) {
        this.docIndex = docIndex;
    }

    public List<BaseUnitdStatement> getBaseUnitdStatements() {
        ArrayList<BaseUnitdStatement> list = new ArrayList<BaseUnitdStatement>();
        if (this.select != null) {
            list.addAll(this.select.getSelectFieldList());
        }
        if (this.from != null) {
            list.addAll(this.from.getFromFieldList());
        }
        if (this.where != null) {
            list.addAll(this.where.getFields());
            if (this.where.isSubQuery()) {
                for (HQLStatement hqlStatement : this.where.getSubquerys()) {
                    list.addAll(hqlStatement.getBaseUnitdStatements());
                }
            }
        }
        if (this.orderBy != null) {
            list.addAll(this.orderBy.getOrderByFieldList());
        }
        if (this.groupBy != null) {
            list.addAll(this.groupBy.getGroupByFieldList());
        }
        if (this.update != null) {
            list.addAll(this.update.getUpdateFieldList());
        }
        if (this.set != null) {
            list.addAll(this.set.getSetFieldList());
        }
        if (this.delete != null) {
            list.addAll(this.delete.getDeleteFieldList());
        }
        if (this.insert != null) {
            list.add(this.insert.getInsertTable());
            list.add(this.insert.getFields());
        }
        return list;
    }

    private String extractLayerName(String packageName) {
        String temp = packageName.substring(packageName.indexOf(".layers.") + ".layers.".length());
        return temp.substring(0, temp.indexOf("."));
    }
}

