/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.core;

import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionLocator;
import gongqi.erp.framework.core.plugin.SolutionPluginLocator;
import gongqi.erp.framework.core.solution.SolutionLocator;
import gongqi.erp.framework.util.FileUtils;
import gongqi.gdt.core.IDEProjectManager;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.UserLibraryManager;

public class EclipseProjectManagerImpl
implements IDEProjectManager {
    @Override
    public void createLayer(String layerName) {
        ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).resolveLayers();
        String layerUserLibraryName = String.format("layer_%s", layerName);
        this.createUserLibraryReference(layerUserLibraryName, true);
        String linkName = String.format("layer_%s_classes", layerName);
        String locationURI = String.format("/Project/Server/GongqiERP/WEB-INF/layers/%s/binary/classes", layerName);
        this.addProjectLinkedResource(linkName, locationURI);
        File layerSourceRootDir = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayerSourceRootDir(layerName);
        String srcPath = layerSourceRootDir.getName();
        this.makeSourceEntry(srcPath, linkName);
        this.refreshLayerProject("LayerProject", "GongqiERP");
    }

    @Override
    public void createSolution(String solutionName) {
        ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).resolveLayers();
        String solutionUserLibraryName = String.format("app_%s", solutionName);
        this.createUserLibraryReference(solutionUserLibraryName, true);
        String linkName = String.format("app_%s_classes", solutionName);
        String locationURI = String.format("/Project/Server/GongqiERP/WEB-INF/layers/%s/%s/binary/classes", "app", solutionName);
        this.addProjectLinkedResource(linkName, locationURI);
        String srcPath = ((SolutionLocator)ObjectContainer.getInstance(SolutionLocator.class)).getSolutionSourceRootDir(solutionName).getName();
        this.makeSourceEntry(srcPath, linkName);
        this.refreshLayerProject("LayerProject", "GongqiERP");
    }

    @Override
    public void createSolutionPlugin(String solutionName, String solutionPluginName) {
        ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).resolveLayers();
        String solutionPluginUserLibraryName = String.format("plg_%s", solutionPluginName);
        this.createUserLibraryReference(solutionPluginUserLibraryName, true);
        String linkName = String.format("plg_%s_classes", solutionName);
        String locationURI = String.format("/Project/Server/GongqiERP/WEB-INF/layers/%s/%s/%s/binary/classes", "plg", solutionName, solutionPluginName);
        this.addProjectLinkedResource(linkName, locationURI);
        String srcPath = ((SolutionPluginLocator)ObjectContainer.getInstance(SolutionPluginLocator.class)).getSolutionPluginSourceRootDir(solutionName, solutionPluginName).getName();
        this.makeSourceEntry(srcPath, linkName);
        this.refreshLayerProject("LayerProject", "GongqiERP");
    }

    @Override
    public void createExtension(String solutionName) {
        ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).resolveLayers();
        String solutionUserLibraryName = String.format("ext_%s", solutionName);
        this.createUserLibraryReference(solutionUserLibraryName, true);
        String linkName = String.format("ext_%s_classes", solutionName);
        String locationURI = String.format("/Project/Server/GongqiERP/WEB-INF/layers/%s/%s/binary/classes", "ext", solutionName);
        this.addProjectLinkedResource(linkName, locationURI);
        this.makeSourceEntry(((SolutionExtensionLocator)ObjectContainer.getInstance(SolutionExtensionLocator.class)).getSolutionExtensionSourceRootDir(solutionName).getName(), linkName);
        this.refreshLayerProject("LayerProject", "GongqiERP");
    }

    private void refreshLayerProject(String ... projectNames) {
        if (projectNames != null) {
            String[] stringArray = projectNames;
            int n = projectNames.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName = stringArray[n2];
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IProject project = root.getProject(projectName);
                    project.refreshLocal(2, null);
                }
                catch (Throwable throwable) {}
                ++n2;
            }
        }
    }

    private void addProjectLinkedResource(String linkName, String locationURI) {
        Element linkElement;
        File layersSourceRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersSourceRoot();
        File _projectFile = new File(layersSourceRoot, ".project");
        Document document = FileUtils.readFileToDocument((File)_projectFile);
        Element linkedResources = document.getRootElement().element("linkedResources");
        if (linkedResources == null) {
            linkedResources = document.getRootElement().addElement("linkedResources");
        }
        if ((linkElement = (Element)linkedResources.selectSingleNode(String.format("./link/name[text()='%s']/..", linkName))) != null) {
            linkedResources.remove(linkElement);
        }
        linkElement = linkedResources.addElement("link");
        linkElement.addElement("name").setText(linkName);
        linkElement.addElement("type").setText("2");
        linkElement.addElement("locationURI").setText("GongqiDir" + locationURI);
        FileUtils.writeDocumentToFile((File)_projectFile, (Document)document);
    }

    private void makeSourceEntry(String path, String output) {
        File layersSourceRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersSourceRoot();
        File _classpathFile = new File(layersSourceRoot, ".classpath");
        Document document = FileUtils.readFileToDocument((File)_classpathFile);
        List srcClasspathentrys = document.getRootElement().selectNodes("./classpathentry[@kind='src']");
        ListIterator iterator = srcClasspathentrys.listIterator();
        while (iterator.hasNext()) {
            Element srcClasspathentry = (Element)iterator.next();
            if (!path.equals(srcClasspathentry.attributeValue("path"))) continue;
            iterator.remove();
        }
        Element classpathentry = DocumentHelper.createElement((String)"classpathentry");
        classpathentry.addAttribute("kind", "src");
        classpathentry.addAttribute("path", path);
        classpathentry.addAttribute("output", output);
        document.getRootElement().elements().add(0, classpathentry);
        FileUtils.writeDocumentToFile((File)_classpathFile, (Document)document);
    }

    private void createUserLibraryReference(String userLibraryName, boolean addReference) {
        UserLibraryManager manager = JavaModelManager.getUserLibraryManager();
        manager.setUserLibrary(userLibraryName, new IClasspathEntry[0], false);
        if (addReference) {
            File layersSourceRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersSourceRoot();
            File _classpathFile = new File(layersSourceRoot, ".classpath");
            Document document = FileUtils.readFileToDocument((File)_classpathFile);
            String path = String.format("./classpathentry[@kind='con' and path='org.eclipse.jdt.USER_LIBRARY/%s']", userLibraryName);
            Element layerUserLibraryRef = (Element)document.getRootElement().selectSingleNode(path);
            if (layerUserLibraryRef != null) {
                document.getRootElement().remove(layerUserLibraryRef);
            }
            layerUserLibraryRef = document.getRootElement().addElement("classpathentry");
            layerUserLibraryRef.addAttribute("kind", "con");
            layerUserLibraryRef.addAttribute("path", "org.eclipse.jdt.USER_LIBRARY/" + userLibraryName);
            FileUtils.writeDocumentToFile((File)_classpathFile, (Document)document);
        }
    }
}

