/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.core;

import gongqi.designer.core.solution.SolutionSerializer;
import gongqi.erp.framework.core.FrameworkEnvironment;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.tools.ZipUtil;
import gongqi.erp.framework.util.FileUtils;
import gongqi.gdt.core.ApplicationSerializer;
import gongqi.gdt.util.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ApplicationSerializerImpl
implements ApplicationSerializer {
    @Override
    public void packApplication(String appId, String appVersion) {
        File tmpDir = FileUtils.getTempDirectory();
        tmpDir.mkdirs();
        File applicationPack = new File(tmpDir, String.valueOf(appId) + ".gpk");
        File solutionPack = new File(tmpDir, String.valueOf(appId) + ".app");
        SolutionSerializer solutionSerializer = (SolutionSerializer)ObjectContainer.getInstance(SolutionSerializer.class);
        solutionSerializer.packSolution(appId, tmpDir);
        if (!solutionPack.exists()) {
            throw new ERPException(String.format("\u5e94\u7528%s\u65b9\u6848\u6253\u5305\u5f02\u5e38", appId));
        }
        File webpage = new File(tmpDir, "webpage.zip");
        try {
            File webResourceDir = new File(FrameworkEnvironment.getGongqiDir(), "Project/Client/GongqiERP/apps/" + appId);
            File[] files = webResourceDir.listFiles();
            ZipUtils.zipFiles(webpage, Arrays.asList(files == null ? new File[]{} : files));
        }
        catch (Exception e) {
            throw new ERPException(String.format("\u5e94\u7528%s\u524d\u7aef\u8d44\u6e90\u6253\u5305\u9519\u8bef", appId), (Throwable)e);
        }
        File appDescriptor = new File(tmpDir, "Application.xml");
        try {
            Document appDocument = DocumentHelper.createDocument();
            Element appElement = appDocument.addElement("application");
            appElement.addElement("id").setText(appId);
            appElement.addElement("version").setText(appVersion);
            FileUtils.write((File)appDescriptor, (CharSequence)appDocument.asXML(), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new ERPException(String.format("\u751f\u6210\u5e94\u7528%s\u63cf\u8ff0\u6587\u4ef6\u5f02\u5e38", appId), (Throwable)e);
        }
        try {
            ZipUtil.zipFiles((File)applicationPack, (String)"", (File[])new File[]{solutionPack, webpage, appDescriptor});
            File targetFile = new File(FrameworkEnvironment.getGongqiDir(), "BakProject/" + applicationPack.getName());
            if (targetFile.exists()) {
                targetFile.delete();
            }
            FileUtils.moveFile((File)applicationPack, (File)targetFile);
        }
        catch (IOException e) {
            throw new ERPException(String.format("\u5e94\u7528%s\u6574\u4f53\u6253\u5305\u65f6\u51fa\u73b0\u5f02\u5e38", appId), (Throwable)e);
        }
    }
}

