/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.actions.layer.solution;

import com.ibm.icu.text.SimpleDateFormat;
import gongqi.designer.services.SolutionService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.gdt.actions.WorkbenchWindowActionDelegateAdapter;
import gongqi.gdt.util.SWTUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PackSolutionAction
extends WorkbenchWindowActionDelegateAdapter {
    private Shell shell;
    private Button button_Confirm;
    private Combo solutionNameInput;
    private Text versionInput;

    public void run(IAction action) {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText("\u6253\u5305\u65b9\u6848");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(220), SWTUtils.zoom(180));
        Label solutionNameLabel = new Label((Composite)this.shell, 32);
        solutionNameLabel.setText("\u65b9\u6848\u540d\u79f0");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(15));
        formData.left = new FormAttachment(0, SWTUtils.zoom(20));
        solutionNameLabel.setLayoutData((Object)formData);
        this.solutionNameInput = new Combo((Composite)this.shell, 8);
        ArrayList<String> sourceSolutions = new ArrayList<String>();
        List solutions = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolutions();
        for (SolutionDefinition solutionDefinition : solutions) {
            if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Source) continue;
            sourceSolutions.add(solutionDefinition.getSolutionName());
        }
        this.solutionNameInput.setItems(sourceSolutions.toArray(new String[sourceSolutions.size()]));
        if (this.solutionNameInput.getItemCount() > 0) {
            this.solutionNameInput.select(0);
        }
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(-5), 128);
        formData.left = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(8), 131072);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        this.solutionNameInput.setLayoutData((Object)formData);
        Label versionLabel = new Label((Composite)this.shell, 32);
        versionLabel.setText("\u7248\u672c\u53f7");
        formData = new FormData();
        formData.top = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(20), 1024);
        formData.right = new FormAttachment((Control)solutionNameLabel, 0, 131072);
        versionLabel.setLayoutData((Object)formData);
        this.versionInput = new Text((Composite)this.shell, 2052);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        this.versionInput.setText(dateFormat.format(new Date()));
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)versionLabel, SWTUtils.zoom(-3), 128);
        formData.left = new FormAttachment((Control)this.solutionNameInput, 0, 16384);
        formData.right = new FormAttachment((Control)this.solutionNameInput, 0, 131072);
        this.versionInput.setLayoutData((Object)formData);
        this.button_Confirm = new Button((Composite)this.shell, 8);
        this.button_Confirm.setText("\u786e\u5b9a");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.left = new FormAttachment(0, SWTUtils.zoom(15));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        this.button_Confirm.setLayoutData((Object)formData);
        this.button_Confirm.addSelectionListener((SelectionListener)this);
        Button button_Cancel = new Button((Composite)this.shell, 8);
        button_Cancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-15));
        formData.bottom = new FormAttachment((Control)this.button_Confirm, 0, 1024);
        button_Cancel.setLayoutData((Object)formData);
        button_Cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackSolutionAction.this.shell.close();
            }
        });
        this.showInScreenCenter(this.shell);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (this.solutionNameInput.getSelectionIndex() == -1) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5305\u7684\u65b9\u6848");
            return;
        }
        String solutionName = this.solutionNameInput.getItem(this.solutionNameInput.getSelectionIndex());
        if (StringUtils.isBlank((String)solutionName)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5305\u7684\u65b9\u6848");
            return;
        }
        String version = this.versionInput.getText();
        if (StringUtils.isBlank((String)version)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u7248\u672c\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        try {
            ((SolutionService)ObjectContainer.getInstance(SolutionService.class)).packSolution(solutionName, version);
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)String.format("\u6253\u5305%s\u65b9\u6848\u6210\u529f", solutionName));
            this.shell.close();
        }
        catch (Throwable ex) {
            this.log.error((Object)String.format("\u6253\u5305%s\u65b9\u6848\u9519\u8bef", solutionName), ex);
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)ex.getMessage());
        }
    }
}

