/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.actions.layer.plugin;

import com.ibm.icu.text.SimpleDateFormat;
import gongqi.designer.core.plugin.SolutionPluginSerializer;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.gdt.actions.WorkbenchWindowActionDelegateAdapter;
import gongqi.gdt.util.SWTUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PackSolutionPluginAction
extends WorkbenchWindowActionDelegateAdapter {
    private Shell shell;
    private Combo solutionNameInput;
    private Combo solutionPluginNameInput;
    private Text versionInput;

    public void run(IAction action) {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText("\u6253\u5305\u65b9\u6848\u63d2\u4ef6");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(260), SWTUtils.zoom(200));
        Label solutionNameLabel = new Label((Composite)this.shell, 32);
        solutionNameLabel.setText("\u65b9\u6848\u540d\u79f0");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(15));
        formData.left = new FormAttachment(0, SWTUtils.zoom(20));
        solutionNameLabel.setLayoutData((Object)formData);
        this.solutionNameInput = new Combo((Composite)this.shell, 8);
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(-5), 128);
        formData.left = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(8), 131072);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        this.solutionNameInput.setLayoutData((Object)formData);
        ArrayList<String> sourceSolutionPluginSolutions = new ArrayList<String>();
        List solutionPlugins = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugins();
        for (SolutionPluginDefinition solutionPluginDefinition : solutionPlugins) {
            if (solutionPluginDefinition.getDeploymentMode() != SolutionPluginDeploymentMode.Source || sourceSolutionPluginSolutions.contains(solutionPluginDefinition.getSolutionName())) continue;
            sourceSolutionPluginSolutions.add(solutionPluginDefinition.getSolutionName());
        }
        this.solutionNameInput.setItems(sourceSolutionPluginSolutions.toArray(new String[sourceSolutionPluginSolutions.size()]));
        this.solutionNameInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String solutionName = PackSolutionPluginAction.this.solutionNameInput.getText();
                if (StringUtils.isBlank((String)solutionName)) {
                    PackSolutionPluginAction.this.solutionNameInput.setItems(new String[0]);
                    PackSolutionPluginAction.this.solutionNameInput.setText("");
                } else {
                    ArrayList<String> sourceSolutionPlugins = new ArrayList<String>();
                    List solutionPlugins = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugins();
                    for (SolutionPluginDefinition solutionPluginDefinition : solutionPlugins) {
                        if (solutionPluginDefinition.getDeploymentMode() != SolutionPluginDeploymentMode.Source || sourceSolutionPlugins.contains(solutionPluginDefinition.getName())) continue;
                        sourceSolutionPlugins.add(solutionPluginDefinition.getName());
                    }
                    PackSolutionPluginAction.this.solutionPluginNameInput.setItems(sourceSolutionPlugins.toArray(new String[sourceSolutionPlugins.size()]));
                    if (sourceSolutionPlugins.size() > 0) {
                        PackSolutionPluginAction.this.solutionPluginNameInput.select(0);
                    }
                }
            }
        });
        Label solutionPluginNameLabel = new Label((Composite)this.shell, 32);
        solutionPluginNameLabel.setText("\u63d2\u4ef6\u540d\u79f0");
        formData = new FormData();
        formData.top = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(20), 1024);
        formData.left = new FormAttachment((Control)solutionNameLabel, 0, 16384);
        solutionPluginNameLabel.setLayoutData((Object)formData);
        this.solutionPluginNameInput = new Combo((Composite)this.shell, 8);
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)solutionPluginNameLabel, SWTUtils.zoom(-5), 128);
        formData.left = new FormAttachment((Control)solutionPluginNameLabel, SWTUtils.zoom(8), 131072);
        formData.right = new FormAttachment((Control)this.solutionNameInput, 0, 131072);
        this.solutionPluginNameInput.setLayoutData((Object)formData);
        Label versionLabel = new Label((Composite)this.shell, 32);
        versionLabel.setText("\u7248\u672c\u53f7");
        formData = new FormData();
        formData.top = new FormAttachment((Control)solutionPluginNameLabel, SWTUtils.zoom(20), 1024);
        formData.right = new FormAttachment((Control)solutionPluginNameLabel, 0, 131072);
        versionLabel.setLayoutData((Object)formData);
        this.versionInput = new Text((Composite)this.shell, 2052);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        this.versionInput.setText(dateFormat.format(new Date()));
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)versionLabel, -3, 128);
        formData.left = new FormAttachment((Control)this.solutionPluginNameInput, 0, 16384);
        formData.right = new FormAttachment((Control)this.solutionPluginNameInput, 0, 131072);
        this.versionInput.setLayoutData((Object)formData);
        Button buttonConfirm = new Button((Composite)this.shell, 8);
        buttonConfirm.setText("\u786e\u5b9a");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.right = new FormAttachment(45);
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        buttonConfirm.setLayoutData((Object)formData);
        buttonConfirm.addSelectionListener((SelectionListener)this);
        Button button_Cancel = new Button((Composite)this.shell, 8);
        button_Cancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.left = new FormAttachment(55);
        formData.bottom = new FormAttachment((Control)buttonConfirm, 0, 1024);
        button_Cancel.setLayoutData((Object)formData);
        button_Cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackSolutionPluginAction.this.shell.close();
            }
        });
        this.showInScreenCenter(this.shell);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        String solutionName = this.solutionNameInput.getText();
        if (StringUtils.isBlank((String)solutionName)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5305\u7684\u65b9\u6848");
            return;
        }
        String solutionPluginName = this.solutionPluginNameInput.getText();
        if (StringUtils.isBlank((String)solutionPluginName)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5305\u7684\u63d2\u4ef6");
            return;
        }
        String version = this.versionInput.getText();
        if (StringUtils.isBlank((String)version)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u7248\u672c\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        try {
            ((SolutionPluginSerializer)ObjectContainer.getInstance(SolutionPluginSerializer.class)).packSolutionPlugin(solutionName, solutionPluginName);
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)String.format("\u6253\u5305%s\u63d2\u4ef6\u6210\u529f", solutionPluginName));
            this.shell.close();
        }
        catch (Throwable ex) {
            this.log.error((Object)String.format("\u6253\u5305%s\u6269\u5c55\u9519\u8bef", solutionName), ex);
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)ex.getMessage());
        }
    }
}

