/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.actions.layer.plugin;

import gongqi.designer.core.plugin.SolutionPluginFactory;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.gdt.actions.WorkbenchWindowActionDelegateAdapter;
import gongqi.gdt.core.IDEProjectManager;
import gongqi.gdt.util.SWTUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateSolutionPluginAction
extends WorkbenchWindowActionDelegateAdapter {
    private Shell shell;
    private Button buttonConfirm;
    private Combo solutionNameInput;
    private Text solutionPluginNameInput;

    public void run(IAction action) {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText("\u521b\u5efa\u65b9\u6848\u63d2\u4ef6");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(260), SWTUtils.zoom(155));
        Label solutionNameLabel = new Label((Composite)this.shell, 32);
        solutionNameLabel.setText("\u65b9\u6848\u540d\u79f0");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(20));
        formData.left = new FormAttachment(0, SWTUtils.zoom(15));
        solutionNameLabel.setLayoutData((Object)formData);
        this.solutionNameInput = new Combo((Composite)this.shell, 8);
        ArrayList<String> packageSolutions = new ArrayList<String>();
        List solutions = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolutions();
        for (SolutionDefinition solutionDefinition : solutions) {
            if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Package) continue;
            packageSolutions.add(solutionDefinition.getSolutionName());
        }
        this.solutionNameInput.setItems(packageSolutions.toArray(new String[packageSolutions.size()]));
        if (this.solutionNameInput.getItemCount() > 0) {
            this.solutionNameInput.select(0);
        }
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(-5), 128);
        formData.left = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(8), 131072);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-15));
        this.solutionNameInput.setLayoutData((Object)formData);
        Label solutionPluginNameLabel = new Label((Composite)this.shell, 32);
        solutionPluginNameLabel.setText("\u63d2\u4ef6\u540d\u79f0");
        formData = new FormData();
        formData.top = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(20), 1024);
        formData.left = new FormAttachment((Control)solutionNameLabel, 0, 16384);
        solutionPluginNameLabel.setLayoutData((Object)formData);
        this.solutionPluginNameInput = new Text((Composite)this.shell, 2052);
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)solutionPluginNameLabel, -5, 128);
        formData.left = new FormAttachment((Control)solutionPluginNameLabel, 8, 131072);
        formData.right = new FormAttachment((Control)this.solutionNameInput, 0, 131072);
        this.solutionPluginNameInput.setLayoutData((Object)formData);
        this.buttonConfirm = new Button((Composite)this.shell, 8);
        this.buttonConfirm.setText("\u786e\u5b9a");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.right = new FormAttachment(45);
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        this.buttonConfirm.setLayoutData((Object)formData);
        this.buttonConfirm.addSelectionListener((SelectionListener)this);
        Button buttonCancel = new Button((Composite)this.shell, 8);
        buttonCancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.left = new FormAttachment(55);
        formData.bottom = new FormAttachment((Control)this.buttonConfirm, 0, 1024);
        buttonCancel.setLayoutData((Object)formData);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateSolutionPluginAction.this.shell.close();
            }
        });
        this.showInScreenCenter(this.shell);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        String solutionName = this.solutionNameInput.getText();
        if (StringUtils.isBlank((String)solutionName)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u65b9\u6848\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        String solutionPluginName = this.solutionPluginNameInput.getText();
        if (StringUtils.isBlank((String)solutionPluginName)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u63d2\u4ef6\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        SolutionPluginDefinitionManager solutionPluginDefinitionManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
        if (solutionPluginDefinitionManager.solutionPluginExists(solutionPluginName)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u63d2\u4ef6\u540d\u79f0\u4e0e\u73b0\u6709\u63d2\u4ef6\u540d\u79f0\u51b2\u7a81");
            return;
        }
        try {
            SolutionPluginFactory solutionPluginFactory = (SolutionPluginFactory)ObjectContainer.getInstance(SolutionPluginFactory.class);
            solutionPluginFactory.createSolutionPlugin(solutionName, solutionPluginName, "");
            IDEProjectManager ideProjectManager = (IDEProjectManager)ObjectContainer.getInstance(IDEProjectManager.class);
            ideProjectManager.createSolutionPlugin(solutionName, solutionPluginName);
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)String.format("%s\u65b9\u6848\u63d2\u4ef6\u521b\u5efa\u6210\u529f", solutionPluginName));
            this.shell.close();
        }
        catch (Throwable ex) {
            this.log.error((Object)String.format("\u521b\u5efa%s\u65b9\u6848\u63d2\u4ef6\u9519\u8bef", solutionPluginName), ex);
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)ex.getMessage());
        }
    }
}

