/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.actions.layer.extension;

import gongqi.designer.services.SolutionService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.gdt.actions.WorkbenchWindowActionDelegateAdapter;
import gongqi.gdt.core.IDEProjectManager;
import gongqi.gdt.util.SWTUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CreateExtensionAction
extends WorkbenchWindowActionDelegateAdapter {
    private Shell shell;
    private Button buttonConfirm;
    private Combo solutionNameInput;

    public void run(IAction action) {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText("\u521b\u5efa\u6269\u5c55");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(260), SWTUtils.zoom(120));
        Label solutionNameLabel = new Label((Composite)this.shell, 32);
        solutionNameLabel.setText("\u65b9\u6848\u540d\u79f0");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(20));
        formData.left = new FormAttachment(0, SWTUtils.zoom(15));
        solutionNameLabel.setLayoutData((Object)formData);
        this.solutionNameInput = new Combo((Composite)this.shell, 8);
        ArrayList<String> packageSolutions = new ArrayList<String>();
        List solutions = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolutions();
        for (SolutionDefinition solutionDefinition : solutions) {
            if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Package) continue;
            packageSolutions.add(solutionDefinition.getSolutionName());
        }
        this.solutionNameInput.setItems(packageSolutions.toArray(new String[packageSolutions.size()]));
        if (this.solutionNameInput.getItemCount() > 0) {
            this.solutionNameInput.select(0);
        }
        formData = new FormData();
        formData.height = SWTUtils.zoom(18);
        formData.top = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(-5), 128);
        formData.left = new FormAttachment((Control)solutionNameLabel, SWTUtils.zoom(8), 131072);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        this.solutionNameInput.setLayoutData((Object)formData);
        this.buttonConfirm = new Button((Composite)this.shell, 8);
        this.buttonConfirm.setText("\u786e\u5b9a");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.right = new FormAttachment(45);
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        this.buttonConfirm.setLayoutData((Object)formData);
        this.buttonConfirm.addSelectionListener((SelectionListener)this);
        Button buttonCancel = new Button((Composite)this.shell, 8);
        buttonCancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(28));
        formData.left = new FormAttachment(55);
        formData.bottom = new FormAttachment((Control)this.buttonConfirm, 0, 1024);
        buttonCancel.setLayoutData((Object)formData);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateExtensionAction.this.shell.close();
            }
        });
        this.showInScreenCenter(this.shell);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        String solutionName = this.solutionNameInput.getText();
        if (StringUtils.isBlank((String)solutionName)) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u65b9\u6848\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        try {
            ((SolutionService)ObjectContainer.getInstance(SolutionService.class)).createSolutionExtension(solutionName);
            ((IDEProjectManager)ObjectContainer.getInstance(IDEProjectManager.class)).createExtension(solutionName);
            MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)String.format("%s\u6269\u5c55\u521b\u5efa\u6210\u529f", solutionName));
            this.shell.close();
        }
        catch (Throwable ex) {
            this.log.error((Object)String.format("\u521b\u5efa%s\u6269\u5c55\u9519\u8bef", solutionName), ex);
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)ex.getMessage());
        }
    }
}

