/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.actions.layer;

import core.util.Dom4jUtil;
import core.util.ZipUtil;
import gongqi.erp.framework.core.FrameworkEnvironment;
import gongqi.gdt.actions.WorkbenchWindowActionDelegateAdapter;
import gongqi.gdt.util.SWTUtils;
import info.gongqi.util.JavaElementHelp;
import info.gongqi.widgets.StringEditor;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeployLayerAction
extends WorkbenchWindowActionDelegateAdapter {
    private static Logger log = Logger.getLogger(DeployLayerAction.class);
    private Shell shell;
    private StringEditor layerFileEditor;
    private StringEditor layerNameEditor;
    private Button button_got;
    private Button button_class;
    private Button button_Source;
    private Button button_JavaDoc;
    private String layerName;
    private static String prefix = "layer_";
    private static String suffix = ".lyr";

    public void run(IAction action) {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText("\u5c42\u90e8\u7f72");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(390), SWTUtils.zoom(280));
        Group group_layerInfo = new Group((Composite)this.shell, 0);
        group_layerInfo.setText("\u5c42\u90e8\u7f72\u4fe1\u606f");
        group_layerInfo.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        group_layerInfo.setLayoutData((Object)formData);
        this.layerFileEditor = new StringEditor((Composite)group_layerInfo, "\u5c42\u6587\u4ef6");
        this.layerFileEditor.setWidth(SWTUtils.zoom(200));
        this.layerFileEditor.setEditable(false);
        formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(10));
        formData.left = new FormAttachment(0, SWTUtils.zoom(10));
        this.layerFileEditor.setLayoutData(formData);
        this.layerFileEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                block18: {
                    try {
                        File layerFile = new File(DeployLayerAction.this.layerFileEditor.getText());
                        String fileName = layerFile.getName();
                        if (!layerFile.isFile() || !fileName.startsWith(prefix) || !fileName.endsWith(suffix)) break block18;
                        int firstIndex = fileName.indexOf(95);
                        if (firstIndex == -1) {
                            return;
                        }
                        int lastIndex = fileName.indexOf(95, firstIndex + 1);
                        if (lastIndex != -1) {
                            DeployLayerAction.this.layerName = fileName.substring(firstIndex + 1, lastIndex);
                        } else {
                            DeployLayerAction.this.layerName = fileName.substring(firstIndex + 1, fileName.length() - 4);
                        }
                        DeployLayerAction.this.layerNameEditor.setText(DeployLayerAction.this.layerName);
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try (ZipFile zipFile = new ZipFile(layerFile);){
                            ZipEntry javadocEntry;
                            ZipEntry sourceEntry;
                            ZipEntry classEntry;
                            ZipEntry gotEntry = zipFile.getEntry(String.format("layer_%s.got", DeployLayerAction.this.layerName));
                            if (gotEntry != null) {
                                DeployLayerAction.this.button_got.setSelection(true);
                            }
                            if ((classEntry = zipFile.getEntry(String.format("layer_%s/layer_%s.jar", DeployLayerAction.this.layerName, DeployLayerAction.this.layerName))) != null) {
                                DeployLayerAction.this.button_class.setSelection(true);
                            }
                            if ((sourceEntry = zipFile.getEntry(String.format("layer_%s/layer_%s-source.jar", DeployLayerAction.this.layerName, DeployLayerAction.this.layerName))) != null) {
                                DeployLayerAction.this.button_Source.setSelection(true);
                            }
                            if ((javadocEntry = zipFile.getEntry(String.format("layer_%s/layer_%s-javadoc.jar", DeployLayerAction.this.layerName, DeployLayerAction.this.layerName))) != null) {
                                DeployLayerAction.this.button_JavaDoc.setSelection(true);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"\u5c42\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                        MessageDialog.openError((Shell)DeployLayerAction.this.shell, (String)"\u63d0\u793a", (String)"\u5c42\u6587\u4ef6\u5f02\u5e38");
                    }
                }
            }
        });
        Button browse = new Button((Composite)group_layerInfo, 8);
        browse.setText("\u6d4f\u89c8...");
        browse.setFocus();
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(DeployLayerAction.this.shell);
                dialog.setFilterExtensions(new String[]{"*.lyr", "*.lyrs"});
                dialog.setText("\u5c42\u6587\u4ef6");
                String path = dialog.open();
                if (StringUtils.isNotBlank((String)path)) {
                    File layerFile = new File(path);
                    if (layerFile.exists() && layerFile.isFile()) {
                        DeployLayerAction.this.layerFileEditor.setText(path);
                    } else {
                        MessageDialog.openInformation((Shell)DeployLayerAction.this.shell, (String)"\u63d0\u793a", (String)"\u65e0\u6548\u7684\u5c42\u6587\u4ef6");
                    }
                }
            }
        });
        formData = new FormData();
        formData.width = SWTUtils.zoom(70);
        formData.top = new FormAttachment((Control)this.layerFileEditor, SWTUtils.zoom(-3), 128);
        formData.left = new FormAttachment((Control)this.layerFileEditor, SWTUtils.zoom(10));
        browse.setLayoutData((Object)formData);
        this.layerNameEditor = new StringEditor((Composite)group_layerInfo, "\u5c42\u540d\u79f0");
        this.layerNameEditor.setEditable(false);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.layerFileEditor, 0, 16384);
        formData.top = new FormAttachment((Control)this.layerFileEditor, SWTUtils.zoom(10));
        this.layerNameEditor.setLayoutData(formData);
        Label laber_got = new Label((Composite)group_layerInfo, 0x1000000);
        laber_got.setText("GOT");
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.layerNameEditor, SWTUtils.zoom(10), 16384);
        formData.top = new FormAttachment((Control)this.layerNameEditor, SWTUtils.zoom(10));
        laber_got.setLayoutData((Object)formData);
        this.button_got = new Button((Composite)group_layerInfo, 32);
        this.button_got.setEnabled(false);
        formData = new FormData();
        formData.top = new FormAttachment((Control)laber_got, 0, 128);
        formData.left = new FormAttachment((Control)laber_got, SWTUtils.zoom(10));
        this.button_got.setLayoutData((Object)formData);
        Label laber_Class = new Label((Composite)group_layerInfo, 0x1000000);
        laber_Class.setText("Class");
        formData = new FormData();
        formData.left = new FormAttachment((Control)laber_got, SWTUtils.zoom(-8), 16384);
        formData.top = new FormAttachment((Control)laber_got, SWTUtils.zoom(10));
        laber_Class.setLayoutData((Object)formData);
        this.button_class = new Button((Composite)group_layerInfo, 32);
        this.button_class.setEnabled(false);
        formData = new FormData();
        formData.top = new FormAttachment((Control)laber_Class, 0, 128);
        formData.left = new FormAttachment((Control)laber_Class, SWTUtils.zoom(15));
        this.button_class.setLayoutData((Object)formData);
        Label laber_Source = new Label((Composite)group_layerInfo, 0x1000000);
        laber_Source.setText("Source");
        formData = new FormData();
        formData.left = new FormAttachment((Control)laber_Class, SWTUtils.zoom(-6), 16384);
        formData.top = new FormAttachment((Control)laber_Class, SWTUtils.zoom(10));
        laber_Source.setLayoutData((Object)formData);
        this.button_Source = new Button((Composite)group_layerInfo, 32);
        this.button_Source.setEnabled(false);
        formData = new FormData();
        formData.top = new FormAttachment((Control)laber_Source, 0, 128);
        formData.left = new FormAttachment((Control)laber_Source, SWTUtils.zoom(11));
        this.button_Source.setLayoutData((Object)formData);
        Label laber_JavaDoc = new Label((Composite)group_layerInfo, 0x1000000);
        laber_JavaDoc.setText("JavaDoc");
        formData = new FormData();
        formData.left = new FormAttachment((Control)laber_Source, SWTUtils.zoom(-3), 16384);
        formData.top = new FormAttachment((Control)laber_Source, SWTUtils.zoom(10));
        laber_JavaDoc.setLayoutData((Object)formData);
        this.button_JavaDoc = new Button((Composite)group_layerInfo, 32);
        this.button_JavaDoc.setEnabled(false);
        formData = new FormData();
        formData.top = new FormAttachment((Control)laber_JavaDoc, 0, 128);
        formData.left = new FormAttachment((Control)laber_JavaDoc, SWTUtils.zoom(7));
        this.button_JavaDoc.setLayoutData((Object)formData);
        Button button_deploy = new Button((Composite)this.shell, 8);
        button_deploy.setText("\u786e\u5b9a");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(35));
        formData.top = new FormAttachment((Control)group_layerInfo, SWTUtils.zoom(10));
        formData.left = new FormAttachment(SWTUtils.zoom(25));
        button_deploy.setLayoutData((Object)formData);
        button_deploy.addSelectionListener((SelectionListener)this);
        Button button_cancel = new Button((Composite)this.shell, 8);
        button_cancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(35));
        formData.top = new FormAttachment((Control)button_deploy, 0, 128);
        formData.left = new FormAttachment((Control)button_deploy, SWTUtils.zoom(40));
        button_cancel.setLayoutData((Object)formData);
        button_cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployLayerAction.this.shell.close();
            }
        });
        this.showInScreenCenter(this.shell);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void widgetSelected(SelectionEvent event) {
        try {
            block16: {
                if (!StringUtils.isNotBlank((String)this.layerFileEditor.getText())) ** GOTO lbl-1000
                layerFile = new File(this.layerFileEditor.getText());
                if (!FilenameUtils.getExtension((String)layerFile.getName()).equalsIgnoreCase("lyr")) break block16;
                this.doDeployLayer(layerFile);
                ** GOTO lbl25
            }
            if (!FilenameUtils.getExtension((String)layerFile.getName()).equalsIgnoreCase("lyrs")) {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u65e0\u6548\u7684\u5c42\u90e8\u7f72\u6587\u4ef6");
                return;
            }
            temp = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
            ZipUtil.extractAllFiles((File)layerFile, (File)temp);
            var8_6 = files = temp.listFiles();
            var7_7 = files.length;
            var6_8 = 0;
            if (true) ** GOTO lbl23
lbl-1000:
            // 1 sources

            {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u672a\u9009\u62e9\u5c42\u6587\u4ef6");
                return;
                do {
                    file = var8_6[var6_8];
                    this.doDeployLayer(file);
                    ++var6_8;
lbl23:
                    // 2 sources

                } while (var6_8 < var7_7);
                FileUtils.deleteDirectory((File)temp);
lbl25:
                // 2 sources

                ** try [egrp 3[TRYBLOCK] [2 : 189->228)] { 
lbl26:
                // 1 sources

                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u5c42\u90e8\u7f72\u6210\u529f");
                this.shell.close();
                return;
            }
        }
lbl29:
        // 2 sources

        catch (Exception e) {
            DeployLayerAction.log.error((Object)"\u90e8\u7f72\u5c42\u5f02\u5e38", (Throwable)e);
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)("\u90e8\u7f72\u5c42\u5f02\u5e38\uff1a" + e.getMessage()));
            return;
        }
        finally {
            try {
                project = JavaElementHelp.getLayerProject();
                project.getProject().refreshLocal(2, null);
            }
            catch (CoreException e) {
                DeployLayerAction.log.error((Object)"\u5237\u65b0\u9879\u76ee\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void doDeployLayer(File layerFile) throws Exception {
        if (layerFile.exists()) {
            IClasspathAttribute[] iClasspathAttributeArray;
            File temp = new File(gongqi.erp.framework.util.FileUtils.getTempDirectory(), UUID.randomUUID().toString());
            ZipUtil.extractAllFiles((File)layerFile, (File)temp);
            File gotFile = new File(temp, "model").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return "got".equals(FilenameUtils.getExtension((String)name));
                }
            })[0];
            String layerName = gotFile.getName().substring(6, gotFile.getName().length() - 4);
            File layerDir = new File(FrameworkEnvironment.getBaseDir(), "/layers/" + layerName);
            FileUtils.copyFile((File)new File(temp, "/model/layer_" + layerName + ".got"), (File)new File(layerDir, "/model/layer_" + layerName + ".got"));
            File layerLibraryPath = new File(layerDir, "/binary");
            FileUtils.copyDirectory((File)new File(temp, "binary"), (File)layerLibraryPath);
            FileUtils.deleteDirectory((File)temp);
            String layerUserLibraryName = "layer_" + layerName;
            ArrayList<IClasspathEntry> classPathEntrys = new ArrayList<IClasspathEntry>();
            IPath sourcePath = null;
            if (this.button_Source.getSelection()) {
                sourcePath = Path.fromOSString((String)new File(layerLibraryPath, String.format("layer_%s-source.jar", layerName)).getAbsolutePath());
            }
            File javadocPath = null;
            if (this.button_JavaDoc.getSelection()) {
                javadocPath = new File(layerLibraryPath, String.format("layer_%s-javadoc.jar", layerName));
            }
            IPath iPath = Path.fromOSString((String)new File(layerLibraryPath, "layer_" + layerName + ".jar").getAbsolutePath());
            if (javadocPath == null) {
                iClasspathAttributeArray = null;
            } else {
                IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
                iClasspathAttributeArray = iClasspathAttributeArray2;
                iClasspathAttributeArray2[0] = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)("jar:" + javadocPath.toURI().toString()));
            }
            IClasspathEntry layerEntry = JavaCore.newLibraryEntry((IPath)iPath, (IPath)sourcePath, null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)false);
            classPathEntrys.add(layerEntry);
            File[] jars = new File(layerLibraryPath, "lib").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (jars != null) {
                File[] fileArray = jars;
                int n = jars.length;
                int n2 = 0;
                while (n2 < n) {
                    File jar = fileArray[n2];
                    IClasspathEntry libraryEntry = JavaCore.newLibraryEntry((IPath)Path.fromOSString((String)String.format("/GongqiERP/WEB-INF/layers/%s/binary/lib/%s", layerName, jar.getName())), null, null);
                    classPathEntrys.add(libraryEntry);
                    ++n2;
                }
            }
            UserLibraryManager manager = JavaModelManager.getUserLibraryManager();
            manager.setUserLibrary(layerUserLibraryName, classPathEntrys.toArray(new IClasspathEntry[classPathEntrys.size()]), false);
            File classPath = new File(FrameworkEnvironment.getGongqiDir(), "Project\\Server\\LayerProject\\.classpath");
            if (classPath.exists()) {
                Document document = Dom4jUtil.loadDocument((File)classPath);
                Element root = document.getRootElement();
                Element classpathentry = (Element)root.selectSingleNode("classpathentry[@kind='con' and @path='org.eclipse.jdt.USER_LIBRARY/" + layerUserLibraryName + "']");
                if (classpathentry == null) {
                    classpathentry = root.addElement("classpathentry");
                    classpathentry.addAttribute("kind", "con");
                    classpathentry.addAttribute("path", "org.eclipse.jdt.USER_LIBRARY/" + layerUserLibraryName);
                }
                Dom4jUtil.saveDocument((String)classPath.getAbsolutePath(), (Document)document);
            }
        }
    }
}

