/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;

public class NewJavaProjectWizardPageOne
extends WizardPage {
    private static final String PAGE_NAME = "NewJavaProjectWizardPageOne";
    private final NameGroup fNameGroup;
    private final LocationGroup fLocationGroup;
    private final LayoutGroup fLayoutGroup;
    private final JREGroup fJREGroup;
    private final DetectGroup fDetectGroup;
    private final Validator fValidator;
    private final WorkingSetGroup fWorkingSetGroup;
    private static final IWorkingSet[] EMPTY_WORKING_SET_ARRAY = new IWorkingSet[0];

    public NewJavaProjectWizardPageOne() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.NewJavaProjectWizardPageOne_page_title);
        this.setDescription(NewWizardMessages.NewJavaProjectWizardPageOne_page_description);
        this.fNameGroup = new NameGroup();
        this.fLocationGroup = new LocationGroup();
        this.fJREGroup = new JREGroup();
        this.fLayoutGroup = new LayoutGroup();
        this.fWorkingSetGroup = new WorkingSetGroup();
        this.fDetectGroup = new DetectGroup();
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fDetectGroup.addObserver(this.fJREGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setProjectName("");
        this.setProjectLocationURI(null);
        this.setWorkingSets(new IWorkingSet[0]);
        this.initializeDefaultVM();
    }

    public void init(IStructuredSelection selection, IWorkbenchPart activePart) {
        this.setWorkingSets(this.getSelectedWorkingSet(selection, activePart));
    }

    private void initializeDefaultVM() {
        JavaRuntime.getDefaultVMInstall();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        Control nameControl = this.createNameControl(composite);
        nameControl.setLayoutData((Object)new GridData(768));
        Control locationControl = this.createLocationControl(composite);
        locationControl.setLayoutData((Object)new GridData(768));
        Control jreControl = this.createJRESelectionControl(composite);
        jreControl.setLayoutData((Object)new GridData(768));
        Control layoutControl = this.createProjectLayoutControl(composite);
        layoutControl.setLayoutData((Object)new GridData(768));
        Control workingSetControl = this.createWorkingSetControl(composite);
        workingSetControl.setLayoutData((Object)new GridData(768));
        Control infoControl = this.createInfoControl(composite);
        infoControl.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite);
    }

    protected void setControl(Control newControl) {
        Dialog.applyDialogFont((Control)newControl);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(newControl, "org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
        super.setControl(newControl);
    }

    protected Control createNameControl(Composite composite) {
        return this.fNameGroup.createControl(composite);
    }

    protected Control createLocationControl(Composite composite) {
        return this.fLocationGroup.createControl(composite);
    }

    protected Control createJRESelectionControl(Composite composite) {
        return this.fJREGroup.createControl(composite);
    }

    protected Control createProjectLayoutControl(Composite composite) {
        return this.fLayoutGroup.createContent(composite);
    }

    protected Control createWorkingSetControl(Composite composite) {
        return this.fWorkingSetGroup.createControl(composite);
    }

    protected Control createInfoControl(Composite composite) {
        return this.fDetectGroup.createControl(composite);
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public void setProjectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.fNameGroup.setName(name);
    }

    public URI getProjectLocationURI() {
        if (this.fLocationGroup.isUseDefaultSelected()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fLocationGroup.getLocation());
    }

    public void setProjectLocationURI(URI uri) {
        IPath path = uri != null ? URIUtil.toPath((URI)uri) : null;
        this.fLocationGroup.setLocation(path);
    }

    public String getCompilerCompliance() {
        return this.fJREGroup.getSelectedCompilerCompliance();
    }

    public IClasspathEntry[] getDefaultClasspathEntries() {
        IPath newPath = this.fJREGroup.getJREContainerPath();
        if (newPath != null) {
            return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)newPath)};
        }
        return PreferenceConstants.getDefaultJRELibrary();
    }

    public IClasspathEntry[] getSourceClasspathEntries() {
        Path srcPath;
        IPath sourceFolderPath = new Path(this.getProjectName()).makeAbsolute();
        if (this.fLayoutGroup.isSrcBin() && (srcPath = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"))).segmentCount() > 0) {
            sourceFolderPath = sourceFolderPath.append((IPath)srcPath);
        }
        return new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)sourceFolderPath)};
    }

    public IPath getOutputLocation() {
        Path binPath;
        IPath outputLocationPath = new Path(this.getProjectName()).makeAbsolute();
        if (this.fLayoutGroup.isSrcBin() && (binPath = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"))).segmentCount() > 0) {
            outputLocationPath = outputLocationPath.append((IPath)binPath);
        }
        return outputLocationPath;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSetGroup.getSelectedWorkingSets();
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingSetGroup.setWorkingSets(workingSets);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    private GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    private IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection, IWorkbenchPart activePart) {
        IWorkingSet[] selected = this.getSelectedWorkingSet(selection);
        if (selected != null && selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (!NewJavaProjectWizardPageOne.isValidWorkingSet(selected[i])) {
                    return EMPTY_WORKING_SET_ARRAY;
                }
                ++i;
            }
            return selected;
        }
        if (!(activePart instanceof PackageExplorerPart)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        PackageExplorerPart explorerPart = (PackageExplorerPart)activePart;
        if (explorerPart.getRootMode() == 1) {
            IWorkingSet filterWorkingSet = explorerPart.getFilterWorkingSet();
            if (filterWorkingSet == null) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            if (!NewJavaProjectWizardPageOne.isValidWorkingSet(filterWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            return new IWorkingSet[]{filterWorkingSet};
        }
        Object input = explorerPart.getViewPartInput();
        if (!(input instanceof IWorkingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        IWorkingSet workingSet = (IWorkingSet)input;
        if (!NewJavaProjectWizardPageOne.isValidWorkingSet(workingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        return new IWorkingSet[]{workingSet};
    }

    private IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection) {
        if (!(selection instanceof ITreeSelection)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        List elements = treeSelection.toList();
        if (elements.size() == 1) {
            Object element = elements.get(0);
            TreePath[] paths = treeSelection.getPathsFor(element);
            if (paths.length != 1) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            TreePath path = paths[0];
            if (path.getSegmentCount() == 0) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            Object candidate = path.getSegment(0);
            if (!(candidate instanceof IWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            IWorkingSet workingSetCandidate = (IWorkingSet)candidate;
            if (NewJavaProjectWizardPageOne.isValidWorkingSet(workingSetCandidate)) {
                return new IWorkingSet[]{workingSetCandidate};
            }
            return EMPTY_WORKING_SET_ARRAY;
        }
        ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
        for (Object element : elements) {
            if (!(element instanceof IWorkingSet) || !NewJavaProjectWizardPageOne.isValidWorkingSet((IWorkingSet)element)) continue;
            result.add((IWorkingSet)element);
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    private static boolean isValidWorkingSet(IWorkingSet workingSet) {
        String id = workingSet.getId();
        if (!"org.eclipse.jdt.ui.JavaWorkingSetPage".equals(id) && !"org.eclipse.ui.resourceWorkingSetPage".equals(id)) {
            return false;
        }
        return !workingSet.isAggregateWorkingSet();
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private Link fHintText;
        private Label fIcon;
        private boolean fDetect = false;

        public Control createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            this.fIcon = new Label(composite, 16384);
            this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            GridData gridData = new GridData(16384, 128, false, false);
            this.fIcon.setLayoutData((Object)gridData);
            this.fHintText = new Link(composite, 64);
            this.fHintText.setFont(composite.getFont());
            this.fHintText.addSelectionListener((SelectionListener)this);
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = NewJavaProjectWizardPageOne.this.convertWidthInCharsToPixels(50);
            gridData.heightHint = NewJavaProjectWizardPageOne.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gridData);
            this.handlePossibleJVMChange();
            return composite;
        }

        public void handlePossibleJVMChange() {
            if (JavaRuntime.getDefaultVMInstall() == null) {
                this.fHintText.setText(NewWizardMessages.NewJavaProjectWizardPageOne_NoJREFound_link);
                this.fHintText.setVisible(true);
                this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.fIcon.setVisible(true);
                return;
            }
            String selectedCompliance = NewJavaProjectWizardPageOne.this.fJREGroup.getSelectedCompilerCompliance();
            if (selectedCompliance != null) {
                String defaultCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                if (selectedCompliance.equals(defaultCompliance)) {
                    this.fHintText.setVisible(false);
                    this.fIcon.setVisible(false);
                } else {
                    this.fHintText.setText(Messages.format(NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_differendWorkspaceCC_message, new String[]{BasicElementLabels.getVersionName(defaultCompliance), BasicElementLabels.getVersionName(selectedCompliance)}));
                    this.fHintText.setVisible(true);
                    this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                    this.fIcon.setVisible(true);
                }
                return;
            }
            selectedCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
            IVMInstall selectedJVM = NewJavaProjectWizardPageOne.this.fJREGroup.getSelectedJVM();
            if (selectedJVM == null) {
                selectedJVM = JavaRuntime.getDefaultVMInstall();
            }
            String jvmCompliance = "1.4";
            if (selectedJVM instanceof IVMInstall2) {
                jvmCompliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)selectedJVM, "1.4");
            }
            if (!selectedCompliance.equals(jvmCompliance) && (JavaModelUtil.is50OrHigher(selectedCompliance) || JavaModelUtil.is50OrHigher(jvmCompliance))) {
                this.fHintText.setText(Messages.format(NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_jre_message, new String[]{BasicElementLabels.getVersionName(selectedCompliance), BasicElementLabels.getVersionName(jvmCompliance)}));
                this.fHintText.setVisible(true);
                this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.fIcon.setVisible(true);
            } else {
                this.fHintText.setVisible(false);
                this.fIcon.setVisible(false);
            }
        }

        private boolean computeDetectState() {
            if (NewJavaProjectWizardPageOne.this.fLocationGroup.isUseDefaultSelected()) {
                String name = NewJavaProjectWizardPageOne.this.fNameGroup.getName();
                if (name.length() == 0 || JavaPlugin.getWorkspace().getRoot().findMember(name) != null) {
                    return false;
                }
                File directory = NewJavaProjectWizardPageOne.this.fLocationGroup.getLocation().append(name).toFile();
                return directory.isDirectory();
            }
            File directory = NewJavaProjectWizardPageOne.this.fLocationGroup.getLocation().toFile();
            return directory.isDirectory();
        }

        @Override
        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                this.fDetect = this.computeDetectState();
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.NewJavaProjectWizardPageOne_DetectGroup_message);
                        this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                        this.fIcon.setVisible(true);
                    } else {
                        this.handlePossibleJVMChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String eeID = "org.eclipse.jdt.debug.ui.jreProfiles";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            String id = "JRE".equals(e.text) ? jreID : complianceId;
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaProjectWizardPageOne.this.getShell(), (String)id, (String[])new String[]{jreID, complianceId, eeID}, data).open();
            NewJavaProjectWizardPageOne.this.fJREGroup.handlePossibleJVMChange();
            this.handlePossibleJVMChange();
        }
    }

    private final class JREGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private static final String LAST_SELECTED_EE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.execution.enviroment";
        private static final String LAST_SELECTED_JRE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.project.jre";
        private static final String LAST_SELECTED_JRE_KIND2 = "org.eclipse.jdt.ui.last.selected.jre.kind2";
        private static final int DEFAULT_JRE = 0;
        private static final int PROJECT_JRE = 1;
        private static final int EE_JRE = 2;
        private final SelectionButtonDialogField fUseDefaultJRE = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField fUseProjectJRE;
        private final SelectionButtonDialogField fUseEEJRE;
        private final ComboDialogField fJRECombo;
        private final ComboDialogField fEECombo;
        private Group fGroup;
        private Link fPreferenceLink;
        private IVMInstall[] fInstalledJVMs;
        private String[] fJRECompliance;
        private IExecutionEnvironment[] fInstalledEEs;
        private String[] fEECompliance;

        public JREGroup() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fUseProjectJRE = new SelectionButtonDialogField(16);
            this.fUseProjectJRE.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_specific_compliance);
            this.fJRECombo = new ComboDialogField(8);
            this.fillInstalledJREs(this.fJRECombo);
            this.fJRECombo.setDialogFieldListener(this);
            this.fUseEEJRE = new SelectionButtonDialogField(16);
            this.fUseEEJRE.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_specific_EE);
            this.fEECombo = new ComboDialogField(8);
            this.fillExecutionEnvironments(this.fEECombo);
            this.fEECombo.setDialogFieldListener(this);
            switch (this.getLastSelectedJREKind()) {
                case 0: {
                    this.fUseDefaultJRE.setSelection(true);
                    break;
                }
                case 1: {
                    this.fUseProjectJRE.setSelection(true);
                    break;
                }
                case 2: {
                    this.fUseEEJRE.setSelection(true);
                }
            }
            this.fJRECombo.setEnabled(this.fUseProjectJRE.isSelected());
            this.fEECombo.setEnabled(this.fUseEEJRE.isSelected());
            this.fUseDefaultJRE.setDialogFieldListener(this);
            this.fUseProjectJRE.setDialogFieldListener(this);
            this.fUseEEJRE.setDialogFieldListener(this);
        }

        public Control createControl(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayout((Layout)NewJavaProjectWizardPageOne.this.initGridLayout(new GridLayout(2, false), true));
            this.fGroup.setText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_title);
            this.fUseEEJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            Combo eeComboControl = this.fEECombo.getComboControl((Composite)this.fGroup);
            eeComboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            this.fUseProjectJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            Combo comboControl = this.fJRECombo.getComboControl((Composite)this.fGroup);
            comboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            this.fUseDefaultJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.updateEnableState();
            return this.fGroup;
        }

        private void fillInstalledJREs(ComboDialogField comboField) {
            String selectedItem = this.getLastSelectedJRE();
            int selectionIndex = -1;
            if (this.fUseProjectJRE.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledJVMs = this.getWorkspaceJREs();
            Arrays.sort(this.fInstalledJVMs, new Comparator<IVMInstall>(){

                @Override
                public int compare(IVMInstall i0, IVMInstall i1) {
                    if (i1 instanceof IVMInstall2 && i0 instanceof IVMInstall2) {
                        String cc0 = JavaModelUtil.getCompilerCompliance((IVMInstall2)i0, "1.4");
                        String cc1 = JavaModelUtil.getCompilerCompliance((IVMInstall2)i1, "1.4");
                        int result = cc1.compareTo(cc0);
                        if (result != 0) {
                            return result;
                        }
                    }
                    return Policy.getComparator().compare(i0.getName(), i1.getName());
                }
            });
            selectionIndex = -1;
            String[] jreLabels = new String[this.fInstalledJVMs.length];
            this.fJRECompliance = new String[this.fInstalledJVMs.length];
            int i = 0;
            while (i < this.fInstalledJVMs.length) {
                jreLabels[i] = this.fInstalledJVMs[i].getName();
                if (selectedItem != null && jreLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.fJRECompliance[i] = this.fInstalledJVMs[i] instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)this.fInstalledJVMs[i], "1.4") : "1.4";
                ++i;
            }
            comboField.setItems(jreLabels);
            if (selectionIndex == -1) {
                comboField.selectItem(this.getDefaultJVMName());
            } else {
                comboField.selectItem(selectedItem);
            }
        }

        private void fillExecutionEnvironments(ComboDialogField comboField) {
            String selectedItem = this.getLastSelectedEE();
            int selectionIndex = -1;
            if (this.fUseEEJRE.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            Arrays.sort(this.fInstalledEEs, new Comparator<IExecutionEnvironment>(){

                @Override
                public int compare(IExecutionEnvironment arg0, IExecutionEnvironment arg1) {
                    return Policy.getComparator().compare(arg0.getId(), arg1.getId());
                }
            });
            selectionIndex = -1;
            String[] eeLabels = new String[this.fInstalledEEs.length];
            this.fEECompliance = new String[this.fInstalledEEs.length];
            int i = 0;
            while (i < this.fInstalledEEs.length) {
                eeLabels[i] = this.fInstalledEEs[i].getId();
                if (selectedItem != null && eeLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.fEECompliance[i] = JavaModelUtil.getExecutionEnvironmentCompliance(this.fInstalledEEs[i]);
                ++i;
            }
            comboField.setItems(eeLabels);
            if (selectionIndex == -1) {
                comboField.selectItem(this.getDefaultEEName());
            } else {
                comboField.selectItem(selectedItem);
            }
        }

        private IVMInstall[] getWorkspaceJREs() {
            ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    IVMInstall install = installs[j];
                    standins.add(new VMStandin(install));
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IVMInstall[standins.size()]);
        }

        private String getDefaultJVMName() {
            IVMInstall install = JavaRuntime.getDefaultVMInstall();
            if (install != null) {
                return install.getName();
            }
            return NewWizardMessages.NewJavaProjectWizardPageOne_UnknownDefaultJRE_name;
        }

        private String getDefaultEEName() {
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            if (defaultVM != null) {
                int i = 0;
                while (i < environments.length) {
                    IVMInstall eeDefaultVM = environments[i].getDefaultVM();
                    if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                        return environments[i].getId();
                    }
                    ++i;
                }
            }
            String defaultCC = defaultVM instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)defaultVM, "1.4") : "1.4";
            int i = 0;
            while (i < environments.length) {
                String eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance(environments[i]);
                if (defaultCC.endsWith(eeCompliance)) {
                    return environments[i].getId();
                }
                ++i;
            }
            return "JavaSE-1.6";
        }

        private String getDefaultJVMLabel() {
            return Messages.format(NewWizardMessages.NewJavaProjectWizardPageOne_JREGroup_default_compliance, this.getDefaultJVMName());
        }

        @Override
        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean detect = NewJavaProjectWizardPageOne.this.fDetectGroup.mustDetect();
            this.fUseDefaultJRE.setEnabled(!detect);
            this.fUseProjectJRE.setEnabled(!detect);
            this.fUseEEJRE.setEnabled(!detect);
            this.fJRECombo.setEnabled(!detect && this.fUseProjectJRE.isSelected());
            this.fEECombo.setEnabled(!detect && this.fUseEEJRE.isSelected());
            if (this.fPreferenceLink != null) {
                this.fPreferenceLink.setEnabled(!detect);
            }
            if (this.fGroup != null) {
                this.fGroup.setEnabled(!detect);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String eeID = "org.eclipse.jdt.debug.ui.jreProfiles";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaProjectWizardPageOne.this.getShell(), (String)jreID, (String[])new String[]{jreID, complianceId, eeID}, data).open();
            this.handlePossibleJVMChange();
            NewJavaProjectWizardPageOne.this.fDetectGroup.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fillInstalledJREs(this.fJRECombo);
            this.fillExecutionEnvironments(this.fEECombo);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
            NewJavaProjectWizardPageOne.this.fDetectGroup.handlePossibleJVMChange();
            if (field == this.fJRECombo) {
                if (this.fUseProjectJRE.isSelected()) {
                    this.storeSelectionValue(this.fJRECombo, LAST_SELECTED_JRE_SETTINGS_KEY);
                }
            } else if (field == this.fEECombo) {
                if (this.fUseEEJRE.isSelected()) {
                    this.storeSelectionValue(this.fEECombo, LAST_SELECTED_EE_SETTINGS_KEY);
                }
            } else if (field == this.fUseDefaultJRE) {
                if (this.fUseDefaultJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND2, 0);
                    this.fUseProjectJRE.setSelection(false);
                    this.fUseEEJRE.setSelection(false);
                }
            } else if (field == this.fUseProjectJRE) {
                if (this.fUseProjectJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND2, 1);
                    this.fUseDefaultJRE.setSelection(false);
                    this.fUseEEJRE.setSelection(false);
                }
            } else if (field == this.fUseEEJRE && this.fUseEEJRE.isSelected()) {
                JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND2, 2);
                this.fUseDefaultJRE.setSelection(false);
                this.fUseProjectJRE.setSelection(false);
            }
        }

        private void storeSelectionValue(ComboDialogField combo, String preferenceKey) {
            int index = combo.getSelectionIndex();
            if (index == -1) {
                return;
            }
            String item = combo.getItems()[index];
            JavaPlugin.getDefault().getDialogSettings().put(preferenceKey, item);
        }

        private int getLastSelectedJREKind() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            if (settings.get(LAST_SELECTED_JRE_KIND2) == null) {
                return 2;
            }
            return settings.getInt(LAST_SELECTED_JRE_KIND2);
        }

        private String getLastSelectedEE() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            return settings.get(LAST_SELECTED_EE_SETTINGS_KEY);
        }

        private String getLastSelectedJRE() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            return settings.get(LAST_SELECTED_JRE_SETTINGS_KEY);
        }

        public IVMInstall getSelectedJVM() {
            if (this.fUseProjectJRE.isSelected()) {
                int index = this.fJRECombo.getSelectionIndex();
                if (index >= 0 && index < this.fInstalledJVMs.length) {
                    return this.fInstalledJVMs[index];
                }
            } else {
                this.fUseEEJRE.isSelected();
            }
            return null;
        }

        public IPath getJREContainerPath() {
            int index;
            if (this.fUseProjectJRE.isSelected()) {
                int index2 = this.fJRECombo.getSelectionIndex();
                if (index2 >= 0 && index2 < this.fInstalledJVMs.length) {
                    return JavaRuntime.newJREContainerPath((IVMInstall)this.fInstalledJVMs[index2]);
                }
            } else if (this.fUseEEJRE.isSelected() && (index = this.fEECombo.getSelectionIndex()) >= 0 && index < this.fInstalledEEs.length) {
                return JavaRuntime.newJREContainerPath((IExecutionEnvironment)this.fInstalledEEs[index]);
            }
            return null;
        }

        public String getSelectedCompilerCompliance() {
            int index;
            if (this.fUseProjectJRE.isSelected()) {
                int index2 = this.fJRECombo.getSelectionIndex();
                if (index2 >= 0 && index2 < this.fJRECompliance.length) {
                    return this.fJRECompliance[index2];
                }
            } else if (this.fUseEEJRE.isSelected() && (index = this.fEECombo.getSelectionIndex()) >= 0 && index < this.fEECompliance.length) {
                return this.fEECompliance[index];
            }
            return null;
        }
    }

    private final class LayoutGroup
    implements Observer,
    SelectionListener {
        private final SelectionButtonDialogField fStdRadio = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField fSrcBinRadio;
        private Group fGroup;
        private Link fPreferenceLink;

        public LayoutGroup() {
            this.fStdRadio.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LayoutGroup_option_oneFolder);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LayoutGroup_option_separateFolders);
            boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
        }

        public Control createContent(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayout((Layout)NewJavaProjectWizardPageOne.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.NewJavaProjectWizardPageOne_LayoutGroup_title);
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(NewWizardMessages.NewJavaProjectWizardPageOne_LayoutGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.updateEnableState();
            return this.fGroup;
        }

        @Override
        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            if (NewJavaProjectWizardPageOne.this.fDetectGroup == null) {
                return;
            }
            boolean detect = NewJavaProjectWizardPageOne.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!detect);
            this.fSrcBinRadio.setEnabled(!detect);
            if (this.fPreferenceLink != null) {
                this.fPreferenceLink.setEnabled(!detect);
            }
            if (this.fGroup != null) {
                this.fGroup.setEnabled(!detect);
            }
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String id = "org.eclipse.jdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaProjectWizardPageOne.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
            NewJavaProjectWizardPageOne.this.fDetectGroup.handlePossibleJVMChange();
            NewJavaProjectWizardPageOne.this.fJREGroup.handlePossibleJVMChange();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fUseDefaults = new SelectionButtonDialogField(32);
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

        public LocationGroup() {
            this.fUseDefaults.setDialogFieldListener(this);
            this.fUseDefaults.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_location_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_browseButton_desc);
            this.fUseDefaults.setSelection(true);
            this.fPreviousExternalLocation = "";
        }

        public Control createControl(Composite composite) {
            Composite locationComposite = new Composite(composite, 0);
            locationComposite.setLayout((Layout)new GridLayout(4, false));
            this.fUseDefaults.doFillIntoGrid(locationComposite, 4);
            this.fLocation.doFillIntoGrid(locationComposite, 4);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
            BidiUtils.applyBidiProcessing((Text)this.fLocation.getTextControl(null), (String)"file");
            return locationComposite;
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        @Override
        public void update(Observable o, Object arg) {
            if (this.isUseDefaultSelected()) {
                this.fLocation.setText(this.getDefaultPath(NewJavaProjectWizardPageOne.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isUseDefaultSelected()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isUseDefaultSelected() {
            return this.fUseDefaults.isSelected();
        }

        public void setLocation(IPath path) {
            this.fUseDefaults.setSelection(path == null);
            if (path != null) {
                this.fLocation.setText(path.toOSString());
            } else {
                this.fLocation.setText(this.getDefaultPath(NewJavaProjectWizardPageOne.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        @Override
        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(NewJavaProjectWizardPageOne.this.getShell());
            dialog.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_directory_message);
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                String oldDirectory = new Path(this.fLocation.getText().trim()).lastSegment();
                this.fLocation.setText(selectedDirectory);
                String lastSegment = new Path(selectedDirectory).lastSegment();
                if (lastSegment != null && (NewJavaProjectWizardPageOne.this.fNameGroup.getName().length() == 0 || NewJavaProjectWizardPageOne.this.fNameGroup.getName().equals(oldDirectory))) {
                    NewJavaProjectWizardPageOne.this.fNameGroup.setName(lastSegment);
                }
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == this.fUseDefaults) {
                boolean checked = this.fUseDefaults.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(NewJavaProjectWizardPageOne.this.fNameGroup.getName()));
                    this.fLocation.setEnabled(false);
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                    this.fLocation.setEnabled(true);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField = new StringDialogField();

        public NameGroup() {
            this.fNameField.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
        }

        public Control createControl(Composite composite) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)new GridLayout(2, false));
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
            return nameComposite;
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(NewJavaProjectWizardPageOne.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        @Override
        public void update(Observable o, Object arg) {
            String location;
            IWorkspace workspace = JavaPlugin.getWorkspace();
            String name = NewJavaProjectWizardPageOne.this.fNameGroup.getName();
            if (name.length() == 0) {
                NewJavaProjectWizardPageOne.this.setErrorMessage(null);
                NewJavaProjectWizardPageOne.this.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterProjectName);
                NewJavaProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                NewJavaProjectWizardPageOne.this.setErrorMessage(nameStatus.getMessage());
                NewJavaProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IProject handle = workspace.getRoot().getProject(name);
            if (handle.exists()) {
                NewJavaProjectWizardPageOne.this.setErrorMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_projectAlreadyExists);
                NewJavaProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(name);
            if (projectLocation.toFile().exists()) {
                try {
                    String canonicalPath = projectLocation.toFile().getCanonicalPath();
                    projectLocation = new Path(canonicalPath);
                }
                catch (IOException e) {
                    JavaPlugin.log(e);
                }
                String existingName = projectLocation.lastSegment();
                if (!existingName.equals(NewJavaProjectWizardPageOne.this.fNameGroup.getName())) {
                    NewJavaProjectWizardPageOne.this.setErrorMessage(Messages.format(NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidProjectNameForWorkspaceRoot, BasicElementLabels.getResourceName(existingName)));
                    NewJavaProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
            }
            if ((location = NewJavaProjectWizardPageOne.this.fLocationGroup.getLocation().toOSString()).length() == 0) {
                NewJavaProjectWizardPageOne.this.setErrorMessage(null);
                NewJavaProjectWizardPageOne.this.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterLocation);
                NewJavaProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                NewJavaProjectWizardPageOne.this.setErrorMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidDirectory);
                NewJavaProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IPath projectPath = null;
            if (!(NewJavaProjectWizardPageOne.this.fLocationGroup.isUseDefaultSelected() || (projectPath = Path.fromOSString((String)location)).toFile().exists() || this.canCreate(projectPath.toFile()))) {
                NewJavaProjectWizardPageOne.this.setErrorMessage(NewWizardMessages.NewJavaProjectWizardPageOne_Message_cannotCreateAtExternalLocation);
                NewJavaProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
            if (!locationStatus.isOK()) {
                NewJavaProjectWizardPageOne.this.setErrorMessage(locationStatus.getMessage());
                NewJavaProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            NewJavaProjectWizardPageOne.this.setPageComplete(true);
            NewJavaProjectWizardPageOne.this.setErrorMessage(null);
            NewJavaProjectWizardPageOne.this.setMessage(null);
        }

        private boolean canCreate(File file) {
            while (!file.exists()) {
                if ((file = file.getParentFile()) != null) continue;
                return false;
            }
            return file.canWrite();
        }
    }

    private final class WorkingSetGroup {
        private WorkingSetConfigurationBlock fWorkingSetBlock;

        public WorkingSetGroup() {
            String[] workingSetIds = new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
            this.fWorkingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, JavaPlugin.getDefault().getDialogSettings());
        }

        public Control createControl(Composite composite) {
            Group workingSetGroup = new Group(composite, 0);
            workingSetGroup.setFont(composite.getFont());
            workingSetGroup.setText(NewWizardMessages.NewJavaProjectWizardPageOne_WorkingSets_group);
            workingSetGroup.setLayout((Layout)new GridLayout(1, false));
            this.fWorkingSetBlock.createContent((Composite)workingSetGroup);
            return workingSetGroup;
        }

        public void setWorkingSets(IWorkingSet[] workingSets) {
            this.fWorkingSetBlock.setWorkingSets(workingSets);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
    }
}

