/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class OutputLocationDialog
extends StatusDialog {
    private StringButtonDialogField fContainerDialogField;
    private SelectionButtonDialogField fUseDefault;
    private SelectionButtonDialogField fUseSpecific;
    private IStatus fContainerFieldStatus;
    private IPath fOutputLocation;
    private final IProject fCurrProject;
    private final CPListElement fEntryToEdit;
    private final boolean fAllowInvalidClasspath;
    private CPJavaProject fCPJavaProject;

    public OutputLocationDialog(Shell parent, CPListElement entryToEdit, List<CPListElement> classPathList, IPath defaultOutputFolder, boolean allowInvalidClasspath) {
        super(parent);
        this.fEntryToEdit = entryToEdit;
        this.fAllowInvalidClasspath = allowInvalidClasspath;
        this.setTitle(NewWizardMessages.OutputLocationDialog_title);
        this.fContainerFieldStatus = new StatusInfo();
        OutputLocationAdapter adapter = new OutputLocationAdapter();
        this.fUseDefault = new SelectionButtonDialogField(16);
        this.fUseDefault.setLabelText(Messages.format(NewWizardMessages.OutputLocationDialog_usedefault_label, BasicElementLabels.getPathLabel(defaultOutputFolder, false)));
        this.fUseDefault.setDialogFieldListener(adapter);
        String label = Messages.format(NewWizardMessages.OutputLocationDialog_usespecific_label, BasicElementLabels.getResourceName(entryToEdit.getPath().segment(0)));
        this.fUseSpecific = new SelectionButtonDialogField(16);
        this.fUseSpecific.setLabelText(label);
        this.fUseSpecific.setDialogFieldListener(adapter);
        this.fContainerDialogField = new StringButtonDialogField(adapter);
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.OutputLocationDialog_location_button);
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fUseSpecific.attachDialogField(this.fContainerDialogField);
        IJavaProject javaProject = entryToEdit.getJavaProject();
        this.fCurrProject = javaProject.getProject();
        this.fCPJavaProject = new CPJavaProject(javaProject, classPathList, defaultOutputFolder);
        IPath outputLocation = (IPath)entryToEdit.getAttribute("output");
        if (outputLocation == null) {
            this.fUseDefault.setSelection(true);
        } else {
            this.fUseSpecific.setSelection(true);
            this.fContainerDialogField.setText(outputLocation.removeFirstSegments(1).makeRelative().toString());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int widthHint = this.convertWidthInCharsToPixels(70);
        int indent = this.convertWidthInCharsToPixels(4);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fUseDefault.doFillIntoGrid(inner, 2);
        this.fUseSpecific.doFillIntoGrid(inner, 2);
        Text textControl = this.fContainerDialogField.getTextControl(inner);
        GridData textData = new GridData();
        textData.widthHint = widthHint;
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalIndent = indent;
        textControl.setLayoutData((Object)textData);
        Button buttonControl = this.fContainerDialogField.getChangeControl(inner);
        GridData buttonData = new GridData();
        buttonData.widthHint = SWTUtil.getButtonWidthHint(buttonControl);
        buttonControl.setLayoutData((Object)buttonData);
        OutputLocationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doChangeControlPressed() {
        IContainer container = this.chooseOutputLocation();
        if (container != null) {
            this.fContainerDialogField.setText(container.getProjectRelativePath().toString());
        }
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.updateStatus(this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fOutputLocation = null;
        this.fContainerFieldStatus = StatusInfo.OK_STATUS;
        if (this.fUseDefault.isSelected()) {
            return;
        }
        String pathStr = this.fContainerDialogField.getText();
        if (pathStr.length() == 0) {
            this.fContainerFieldStatus = new StatusInfo(4, "");
            return;
        }
        IPath projectPath = this.fCPJavaProject.getJavaProject().getProject().getFullPath();
        IPath outputPath = projectPath.append(pathStr);
        try {
            this.fContainerFieldStatus = ClasspathModifier.checkSetOutputLocationPrecondition(this.fEntryToEdit, outputPath, this.fAllowInvalidClasspath, this.fCPJavaProject);
            if (this.fContainerFieldStatus.getSeverity() != 4) {
                this.fOutputLocation = outputPath;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    public IPath getOutputLocation() {
        return this.fOutputLocation;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.output_location_dialog_context");
    }

    private IContainer chooseOutputLocation() {
        IWorkspaceRoot root = this.fCurrProject.getWorkspace().getRoot();
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        IProject[] allProjects = root.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)this.fCurrProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSelection = null;
        if (this.fOutputLocation != null) {
            initSelection = root.findMember(this.fOutputLocation);
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(NewWizardMessages.OutputLocationDialog_ChooseOutputFolder_title);
        dialog.setValidator(new ISelectionStatusValidator(acceptedClasses){
            ISelectionStatusValidator validator;
            {
                this.validator = new TypedElementSelectionValidator(classArray, false);
            }

            public IStatus validate(Object[] selection) {
                IStatus typedStatus = this.validator.validate(selection);
                if (!typedStatus.isOK()) {
                    return typedStatus;
                }
                if (selection[0] instanceof IFolder) {
                    IFolder folder = (IFolder)selection[0];
                    try {
                        IStatus result = ClasspathModifier.checkSetOutputLocationPrecondition(OutputLocationDialog.this.fEntryToEdit, folder.getFullPath(), OutputLocationDialog.this.fAllowInvalidClasspath, OutputLocationDialog.this.fCPJavaProject);
                        if (result.getSeverity() == 4) {
                            return result;
                        }
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e);
                    }
                    return new StatusInfo();
                }
                return new StatusInfo(4, "");
            }
        });
        dialog.setMessage(NewWizardMessages.OutputLocationDialog_ChooseOutputFolder_description);
        dialog.addFilter(filter);
        dialog.setInput(root);
        dialog.setInitialSelection(initSelection);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            return (IContainer)dialog.getFirstResult();
        }
        return null;
    }

    private class OutputLocationAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private OutputLocationAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            OutputLocationDialog.this.doStatusLineUpdate();
        }

        @Override
        public void changeControlPressed(DialogField field) {
            OutputLocationDialog.this.doChangeControlPressed();
        }
    }
}

