/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.JavaPairMatcher;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.internal.ui.text.java.hover.SourceViewerInformationControl;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public class JavaSourceHover
extends AbstractJavaEditorTextHover {
    private int fUpwardShiftInLines;
    private String fBracketHoverStatus;

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        IJavaElement[] result = this.getJavaElementsAt(textViewer, region);
        this.fUpwardShiftInLines = 0;
        this.fBracketHoverStatus = null;
        if (result == null || result.length == 0) {
            return this.getBracketHoverInfo(textViewer, region);
        }
        if (result.length > 1) {
            return null;
        }
        IJavaElement curr = result[0];
        if ((curr instanceof IMember || curr instanceof ILocalVariable || curr instanceof ITypeParameter) && curr instanceof ISourceReference) {
            String[] sourceLines;
            String source;
            block6: {
                try {
                    source = ((ISourceReference)curr).getSource();
                    sourceLines = this.getTrimmedSource(source, curr);
                    if (sourceLines != null) break block6;
                    return null;
                }
                catch (JavaModelException javaModelException) {}
            }
            String delim = StubUtility.getLineDelimiterUsed(curr);
            source = Strings.concatenate(sourceLines, delim);
            return source;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBracketHoverInfo(final ITextViewer textViewer, IRegion region) {
        boolean isElseBracket = false;
        IEditorPart editor = this.getEditor();
        ITypeRoot editorInput = this.getEditorInputJavaElement();
        if (!(editor instanceof JavaEditor) || editorInput == null) {
            return null;
        }
        int offset = region.getOffset();
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        try {
            IRegion endLine;
            int noOfSourceLines;
            Display display;
            int nodeLength;
            int nodeStart;
            ASTNode node;
            char c = document.getChar(offset);
            if (c != '}') {
                return null;
            }
            JavaPairMatcher matcher = ((JavaEditor)editor).getBracketMatcher();
            if (matcher == null) {
                return null;
            }
            IRegion match = matcher.match(document, offset);
            if (match == null) {
                return null;
            }
            String delim = StubUtility.getLineDelimiterUsed((IJavaElement)editorInput);
            CompilationUnit ast = SharedASTProvider.getAST(editorInput, SharedASTProvider.WAIT_NO, null);
            if (ast == null) {
                return null;
            }
            ASTNode bracketNode = NodeFinder.perform((ASTNode)ast, (int)match.getOffset(), (int)match.getLength());
            if (bracketNode == null) {
                return null;
            }
            ASTNode parent = bracketNode.getParent();
            if (parent instanceof IfStatement && ((IfStatement)parent).getElseStatement() != null && ASTNodes.getInclusiveEnd((ASTNode)((IfStatement)parent).getElseStatement()) == offset) {
                isElseBracket = true;
                while (parent.getParent() instanceof IfStatement) {
                    parent = parent.getParent();
                }
            }
            if ((node = bracketNode instanceof Block && !(parent instanceof Block) && !(parent instanceof SwitchStatement) ? parent : bracketNode) instanceof BodyDeclaration) {
                BodyDeclaration declaration = (BodyDeclaration)node;
                Javadoc javadoc = declaration.getJavadoc();
                int lengthOfJavadoc = javadoc == null ? 0 : javadoc.getLength() + delim.length();
                nodeStart = node.getStartPosition() + lengthOfJavadoc;
                nodeLength = node.getLength() - lengthOfJavadoc;
            } else {
                nodeStart = node.getStartPosition();
                nodeLength = ASTNodes.getExclusiveEnd(bracketNode) - nodeStart;
            }
            int line1 = document.getLineOfOffset(nodeStart);
            int sourceOffset = document.getLineOffset(line1);
            int line2 = document.getLineOfOffset(nodeStart + nodeLength);
            int hoveredLine = document.getLineOfOffset(offset);
            if (line2 > hoveredLine) {
                line2 = hoveredLine;
            }
            final int[] topIndex = new int[1];
            StyledText textWidget = textViewer.getTextWidget();
            if (textWidget == null) {
                return null;
            }
            try {
                display = textWidget.getDisplay();
            }
            catch (SWTException ex) {
                if (ex.code == 24) {
                    return null;
                }
                throw ex;
            }
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    topIndex[0] = textViewer.getTopIndex();
                }
            });
            int topLine = topIndex[0];
            if (topLine == -1) {
                return null;
            }
            int skippedLines = 0;
            int wLine1 = ((JavaSourceViewer)textViewer).modelLine2WidgetLine(line1);
            int wLine2 = ((JavaSourceViewer)textViewer).modelLine2WidgetLine(line2);
            if (line1 < topLine || wLine1 != -1 && wLine2 - wLine1 != line2 - line1) {
                if (isElseBracket) {
                    return this.getBracketHoverInfoForElse((IfStatement)node, document, editorInput, delim);
                }
                noOfSourceLines = 3;
                if (line2 - line1 < noOfSourceLines) {
                    noOfSourceLines = line2 - line1;
                }
                if ((skippedLines = Math.abs(line2 - line1 - noOfSourceLines)) == 1) {
                    ++noOfSourceLines;
                    skippedLines = 0;
                }
                endLine = document.getLineInformation(line1 + noOfSourceLines);
                this.fUpwardShiftInLines = noOfSourceLines;
                if (skippedLines > 0) {
                    this.fBracketHoverStatus = Messages.format(JavaHoverMessages.JavaSourceHover_skippedLines, new Integer(skippedLines));
                }
            } else {
                noOfSourceLines = line2 - line1;
                endLine = document.getLineInformation(line2);
                this.fUpwardShiftInLines = line2 - line1;
            }
            if (this.fUpwardShiftInLines == 0) {
                return null;
            }
            int sourceLength = endLine.getOffset() + endLine.getLength() - sourceOffset;
            String source = document.get(sourceOffset, sourceLength);
            String[] sourceLines = this.getTrimmedSource(source, (IJavaElement)editorInput);
            if (sourceLines == null) {
                return null;
            }
            String[] str = new String[noOfSourceLines];
            System.arraycopy(sourceLines, 0, str, 0, noOfSourceLines);
            source = Strings.concatenate(str, delim);
            if (skippedLines > 0) {
                source = source.concat(delim).concat(JavaHoverMessages.JavaSourceHover_skippedLinesSymbol);
                ++this.fUpwardShiftInLines;
            }
            return source;
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private String getBracketHoverInfoForElse(IfStatement ifNode, IDocument document, ITypeRoot editorInput, String delim) throws BadLocationException {
        int totalSkippedLines = 0;
        String hoverText = null;
        Statement currentStatement = ifNode.getThenStatement();
        int nodeStart = ifNode.getStartPosition();
        while (currentStatement != null) {
            int noOfSkippedLines;
            int noOfSourceLines;
            int noOfTotalLines;
            int elseStartOffset;
            int line2;
            int nodeLength = ASTNodes.getExclusiveEnd((ASTNode)currentStatement) - nodeStart;
            int line1 = document.getLineOfOffset(nodeStart);
            int sourceOffset = document.getLineOffset(line1);
            int line3 = line2 = document.getLineOfOffset(nodeStart + nodeLength);
            if (ifNode != null && ifNode.getElseStatement() != null && (elseStartOffset = this.getNextElseOffset(ifNode.getThenStatement(), editorInput)) != -1) {
                line3 = document.getLineOfOffset(elseStartOffset);
            }
            if ((noOfTotalLines = line2 == line3 ? line2 - line1 : line2 - line1 + 1) < (noOfSourceLines = 3)) {
                noOfSourceLines = noOfTotalLines;
            }
            if ((noOfSkippedLines = noOfTotalLines - noOfSourceLines) == 1) {
                ++noOfSourceLines;
                noOfSkippedLines = 0;
            }
            if (noOfSourceLines > 0) {
                IRegion endLine = document.getLineInformation(line1 + noOfSourceLines - 1);
                int sourceLength = endLine.getOffset() + endLine.getLength() - sourceOffset;
                String source = document.get(sourceOffset, sourceLength);
                String[] sourceLines = this.getTrimmedSource(source, (IJavaElement)editorInput);
                if (sourceLines == null) {
                    return null;
                }
                source = Strings.concatenate(sourceLines, delim);
                if (noOfSkippedLines > 0) {
                    source = source.concat(delim).concat(JavaHoverMessages.JavaSourceHover_skippedLinesSymbol);
                    ++this.fUpwardShiftInLines;
                }
                this.fUpwardShiftInLines += noOfSourceLines;
                totalSkippedLines += noOfSkippedLines;
                hoverText = hoverText == null ? source : hoverText.concat(delim).concat(source);
            }
            if (ifNode != null && ifNode.getElseStatement() != null) {
                Statement thenStatement = ifNode.getThenStatement();
                Statement nextStatement = ifNode.getElseStatement();
                if (nextStatement instanceof IfStatement) {
                    currentStatement = ((IfStatement)nextStatement).getThenStatement();
                    ifNode = (IfStatement)nextStatement;
                } else {
                    currentStatement = nextStatement;
                    ifNode = null;
                }
                int nextStartOffset = this.getNextElseOffset(thenStatement, editorInput);
                if (nextStartOffset != -1) {
                    nodeStart = nextStartOffset;
                    continue;
                }
                nodeStart = nextStatement.getStartPosition();
                continue;
            }
            currentStatement = null;
        }
        if (this.fUpwardShiftInLines == 0) {
            return null;
        }
        if (totalSkippedLines > 0) {
            this.fBracketHoverStatus = Messages.format(JavaHoverMessages.JavaSourceHover_skippedLines, new Integer(totalSkippedLines));
        }
        return hoverText;
    }

    private int getNextElseOffset(Statement then, ITypeRoot editorInput) {
        int thenEnd = ASTNodes.getExclusiveEnd((ASTNode)then);
        try {
            TokenScanner scanner = new TokenScanner(editorInput);
            return scanner.getNextStartOffset(thenEnd, true);
        }
        catch (CoreException coreException) {
            return -1;
        }
    }

    private String[] getTrimmedSource(String source, IJavaElement javaElement) {
        if (source == null) {
            return null;
        }
        source = this.removeLeadingComments(source);
        String[] sourceLines = Strings.convertIntoLines(source);
        Strings.trimIndentation(sourceLines, javaElement.getJavaProject());
        return sourceLines;
    }

    private String removeLeadingComments(String source) {
        int i;
        block13: {
            JavaCodeReader reader = new JavaCodeReader();
            Document document = new Document(source);
            try {
                try {
                    reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                    int c = reader.read();
                    while (c != -1 && (c == 13 || c == 10)) {
                        c = reader.read();
                    }
                    i = reader.getOffset();
                    reader.close();
                }
                catch (IOException iOException) {
                    i = 0;
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        JavaPlugin.log(ex);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    JavaPlugin.log(ex);
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
        }
        if (i < 0) {
            return source;
        }
        return source.substring(i);
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fUpwardShiftInLines > 0) {
            return this.createInformationControlCreator(false, this.fBracketHoverStatus, true);
        }
        return this.createInformationControlCreator(false, EditorsUI.getTooltipAffordanceString(), true);
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fUpwardShiftInLines > 0) {
            return this.createInformationControlCreator(false, this.fBracketHoverStatus, true);
        }
        return this.createInformationControlCreator(true, EditorsUI.getTooltipAffordanceString(), true);
    }

    private IInformationControlCreator createInformationControlCreator(final boolean isResizable, final String statusFieldText, final boolean doShiftUp) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                IEditorPart editor = JavaSourceHover.this.getEditor();
                int orientation = 0;
                if (editor instanceof IWorkbenchPartOrientation) {
                    orientation = ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, isResizable, orientation, statusFieldText){

                    @Override
                    public void setLocation(Point location) {
                        Point loc = location;
                        if (doShiftUp && JavaSourceHover.this.fUpwardShiftInLines > 0) {
                            Point size = super.computeSizeConstraints(0, JavaSourceHover.this.fUpwardShiftInLines + 1);
                            int y = location.y - size.y - 5;
                            Rectangle trim = this.computeTrim();
                            loc = new Point(location.x + trim.x - this.getViewer().getTextWidget().getLeftMargin(), y - trim.height - trim.y);
                        }
                        super.setLocation(loc);
                    }

                    @Override
                    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
                        if (doShiftUp && JavaSourceHover.this.fUpwardShiftInLines > 0) {
                            Point sizeConstraints = super.computeSizeConstraints(widthInChars, heightInChars);
                            return new Point(sizeConstraints.x, 0);
                        }
                        return super.computeSizeConstraints(widthInChars, heightInChars);
                    }

                    @Override
                    public void setSize(int width, int height) {
                        if (doShiftUp && JavaSourceHover.this.fUpwardShiftInLines != 0) {
                            Point size = super.computeSizeConstraints(0, JavaSourceHover.this.fUpwardShiftInLines);
                            Rectangle trim = this.computeTrim();
                            super.setSize(width, size.y + trim.height - trim.y);
                        } else {
                            super.setSize(width, height);
                        }
                    }

                    @Override
                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        if (doShiftUp && JavaSourceHover.this.fUpwardShiftInLines > 0) {
                            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                            int n = stackTraceElementArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                StackTraceElement element = stackTraceElementArray[n2];
                                if ("canMoveIntoInformationControl".equals(element.getMethodName()) && "org.eclipse.jface.text.AbstractHoverInformationControlManager".equals(element.getClassName())) {
                                    return null;
                                }
                                ++n2;
                            }
                            return JavaSourceHover.this.createInformationControlCreator(isResizable && !isResizable, statusFieldText, false);
                        }
                        return super.getInformationPresenterControlCreator();
                    }
                };
            }
        };
    }
}

