/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;

public class MethodExitsFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String ID = "MethodExitsFinder";
    private MethodDeclaration fMethodDeclaration;
    private List<IOccurrencesFinder.OccurrenceLocation> fResult;
    private List<ITypeBinding> fCaughtExceptions;
    private String fExitDescription;
    private CompilationUnit fASTRoot;

    @Override
    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
    }

    @Override
    public String initialize(CompilationUnit root, ASTNode node) {
        Name name;
        this.fASTRoot = root;
        if (node instanceof ReturnStatement) {
            this.fMethodDeclaration = (MethodDeclaration)ASTNodes.getParent(node, 31);
            if (this.fMethodDeclaration == null) {
                return SearchMessages.MethodExitsFinder_no_return_type_selected;
            }
            return null;
        }
        Type type = null;
        if (node instanceof Type) {
            type = (Type)node;
        } else if (node instanceof Name && (name = ASTNodes.getTopMostName((Name)node)).getParent() instanceof Type) {
            type = (Type)name.getParent();
        }
        if (type == null) {
            return SearchMessages.MethodExitsFinder_no_return_type_selected;
        }
        if (!((type = ASTNodes.getTopMostType(type)).getParent() instanceof MethodDeclaration)) {
            return SearchMessages.MethodExitsFinder_no_return_type_selected;
        }
        this.fMethodDeclaration = (MethodDeclaration)type.getParent();
        this.fExitDescription = Messages.format(SearchMessages.MethodExitsFinder_occurrence_exit_description, BasicElementLabels.getJavaElementName(this.fMethodDeclaration.getName().toString()));
        return null;
    }

    private void performSearch() {
        Type returnType;
        this.fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        this.markReferences();
        if (!this.fResult.isEmpty() && (returnType = this.fMethodDeclaration.getReturnType2()) != null) {
            String desc = Messages.format(SearchMessages.MethodExitsFinder_occurrence_return_description, BasicElementLabels.getJavaElementName(this.fMethodDeclaration.getName().toString()));
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(returnType.getStartPosition(), returnType.getLength(), 0, desc));
        }
    }

    @Override
    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.performSearch();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    private void markReferences() {
        this.fCaughtExceptions = new ArrayList<ITypeBinding>();
        boolean isVoid = true;
        Type returnType = this.fMethodDeclaration.getReturnType2();
        if (returnType != null) {
            ITypeBinding returnTypeBinding = returnType.resolveBinding();
            isVoid = returnTypeBinding != null && Bindings.isVoidType(returnTypeBinding);
        }
        this.fMethodDeclaration.accept((ASTVisitor)this);
        Block block = this.fMethodDeclaration.getBody();
        if (block != null) {
            List statements = block.statements();
            if (statements.size() > 0) {
                Statement last = (Statement)statements.get(statements.size() - 1);
                int maxVariableId = LocalVariableIndex.perform((BodyDeclaration)this.fMethodDeclaration);
                FlowContext flowContext = new FlowContext(0, maxVariableId + 1);
                flowContext.setConsiderAccessMode(false);
                flowContext.setComputeMode(FlowContext.ARGUMENTS);
                InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(flowContext);
                FlowInfo info = flowAnalyzer.perform(new ASTNode[]{last});
                if (!(info.isNoReturn() || isVoid || info.isPartialReturn())) {
                    return;
                }
            }
            int offset = this.fMethodDeclaration.getStartPosition() + this.fMethodDeclaration.getLength() - 1;
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, 1, 0, this.fExitDescription));
        }
    }

    public boolean visit(TypeDeclaration node) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), node.getLength(), 0, this.fExitDescription));
        return super.visit(node);
    }

    public boolean visit(TryStatement node) {
        int toRemove;
        int currentSize = this.fCaughtExceptions.size();
        List catchClauses = node.catchClauses();
        Iterator iter = catchClauses.iterator();
        while (iter.hasNext()) {
            Type type = ((CatchClause)iter.next()).getException().getType();
            if (type instanceof UnionType) {
                List types = ((UnionType)type).types();
                Iterator iterator = types.iterator();
                while (iterator.hasNext()) {
                    this.addCaughtException((Type)iterator.next());
                }
                continue;
            }
            this.addCaughtException(type);
        }
        node.getBody().accept((ASTVisitor)this);
        if (node.getAST().apiLevel() >= 4) {
            List resources = node.resources();
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                ((VariableDeclarationExpression)iterator.next()).accept((ASTVisitor)this);
            }
            boolean exitMarked = false;
            for (VariableDeclarationExpression variable : resources) {
                Type type = variable.getType();
                IMethodBinding methodBinding = Bindings.findMethodInHierarchy(type.resolveBinding(), "close", new ITypeBinding[0]);
                if (methodBinding == null) continue;
                ITypeBinding[] exceptionTypes = methodBinding.getExceptionTypes();
                int j = 0;
                while (j < exceptionTypes.length) {
                    if (this.isExitPoint(exceptionTypes[j])) {
                        for (VariableDeclarationFragment fragment : variable.fragments()) {
                            SimpleName name = fragment.getName();
                            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fExitDescription));
                        }
                        if (!exitMarked) {
                            exitMarked = true;
                            Block body = node.getBody();
                            int offset = body.getStartPosition() + body.getLength() - 1;
                            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, 1, 0, Messages.format(SearchMessages.MethodExitsFinder_occurrence_exit_impclict_close_description, BasicElementLabels.getJavaElementName(this.fMethodDeclaration.getName().toString()))));
                        }
                    }
                    ++j;
                }
            }
        }
        int i = toRemove = this.fCaughtExceptions.size() - currentSize;
        while (i > 0) {
            this.fCaughtExceptions.remove(currentSize);
            --i;
        }
        Iterator iter2 = catchClauses.iterator();
        while (iter2.hasNext()) {
            ((CatchClause)iter2.next()).accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    private void addCaughtException(Type type) {
        ITypeBinding typeBinding = type.resolveBinding();
        if (typeBinding != null) {
            this.fCaughtExceptions.add(typeBinding);
        }
    }

    public boolean visit(ThrowStatement node) {
        ITypeBinding exception = node.getExpression().resolveTypeBinding();
        if (this.isExitPoint(exception)) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 5, 0, this.fExitDescription));
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (this.isExitPoint(node.resolveMethodBinding())) {
            SimpleName name = node.getName();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fExitDescription));
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.isExitPoint(node.resolveMethodBinding())) {
            SimpleName name = node.getName();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fExitDescription));
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            Type name = node.getType();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fExitDescription));
        }
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 4, 0, this.fExitDescription));
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 5, 0, this.fExitDescription));
        }
        return true;
    }

    private boolean isExitPoint(ITypeBinding binding) {
        if (binding == null) {
            return false;
        }
        return !this.isCaught(binding);
    }

    private boolean isExitPoint(IMethodBinding binding) {
        if (binding == null) {
            return false;
        }
        ITypeBinding[] exceptions = binding.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            if (!this.isCaught(exceptions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isCaught(ITypeBinding binding) {
        for (ITypeBinding catchException : this.fCaughtExceptions) {
            if (!this.catches(catchException, binding)) continue;
            return true;
        }
        return false;
    }

    private boolean catches(ITypeBinding catchTypeBinding, ITypeBinding throwTypeBinding) {
        while (throwTypeBinding != null) {
            if (throwTypeBinding == catchTypeBinding) {
                return true;
            }
            throwTypeBinding = throwTypeBinding.getSuperclass();
        }
        return false;
    }

    @Override
    public CompilationUnit getASTRoot() {
        return this.fASTRoot;
    }

    @Override
    public String getElementName() {
        return this.fMethodDeclaration.getName().getIdentifier();
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getJobLabel() {
        return SearchMessages.MethodExitsFinder_job_label;
    }

    @Override
    public int getSearchKind() {
        return 9;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return SearchMessages.MethodExitsFinder_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        return SearchMessages.MethodExitsFinder_label_singular;
    }
}

