/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.BundleDefaultsScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.BuildPathsPropertyPage;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.osgi.service.prefs.Preferences;

public class ComplianceConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key INTR_COMPLIANCE_FOLLOWS_EE = ComplianceConfigurationBlock.getLocalKey("internal.compliance.follows.ee");
    private static final OptionsConfigurationBlock.Key INTR_DEFAULT_COMPLIANCE = ComplianceConfigurationBlock.getLocalKey("internal.default.compliance");
    private static final OptionsConfigurationBlock.Key PREF_PB_ASSERT_AS_IDENTIFIER = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.assertIdentifier");
    private static final OptionsConfigurationBlock.Key PREF_PB_ENUM_AS_IDENTIFIER = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.problem.enumIdentifier");
    private static final OptionsConfigurationBlock.Key PREF_SOURCE_COMPATIBILITY = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.source");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_TARGET_PLATFORM = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
    private static final OptionsConfigurationBlock.Key PREF_COMPLIANCE = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.compliance");
    private static final OptionsConfigurationBlock.Key[] PREFS_COMPLIANCE = new OptionsConfigurationBlock.Key[]{PREF_COMPLIANCE, PREF_PB_ASSERT_AS_IDENTIFIER, PREF_PB_ENUM_AS_IDENTIFIER, PREF_SOURCE_COMPATIBILITY, PREF_CODEGEN_TARGET_PLATFORM};
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_INLINE_JSR_BYTECODE = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode");
    private static final OptionsConfigurationBlock.Key PREF_LOCAL_VARIABLE_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.debug.localVariable");
    private static final OptionsConfigurationBlock.Key PREF_LINE_NUMBER_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.debug.lineNumber");
    private static final OptionsConfigurationBlock.Key PREF_SOURCE_FILE_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.debug.sourceFile");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_UNUSED_LOCAL = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.compiler.codegen.unusedLocal");
    private static final String GENERATE = "generate";
    private static final String DO_NOT_GENERATE = "do not generate";
    private static final String PRESERVE = "preserve";
    private static final String OPTIMIZE_OUT = "optimize out";
    private static final String VERSION_CLDC_1_1 = "cldc1.1";
    private static final String VERSION_1_1 = "1.1";
    private static final String VERSION_1_2 = "1.2";
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String VERSION_1_5 = "1.5";
    private static final String VERSION_1_6 = "1.6";
    private static final String VERSION_1_7 = "1.7";
    private static final String VERSION_JSR14 = "jsr14";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String DEFAULT_CONF = "default";
    private static final String USER_CONF = "user";
    private ArrayList<Control> fComplianceFollowsEEControls;
    private ArrayList<Control> fComplianceControls;
    private ArrayList<Control> fComplianceChildControls;
    private PixelConverter fPixelConverter;
    private String[] fRememberedUserCompliance;
    private String[] fOriginalStoredCompliance;
    private static final int IDX_ASSERT_AS_IDENTIFIER = 0;
    private static final int IDX_ENUM_AS_IDENTIFIER = 1;
    private static final int IDX_SOURCE_COMPATIBILITY = 2;
    private static final int IDX_CODEGEN_TARGET_PLATFORM = 3;
    private static final int IDX_COMPLIANCE = 4;
    private static final int IDX_INLINE_JSR_BYTECODE = 5;
    private IStatus fComplianceStatus;
    private Link fJRE50InfoText;
    private Label fJRE50InfoImage;
    private Composite fControlsComposite;
    private ControlEnableState fBlockEnableState;

    public ComplianceConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ComplianceConfigurationBlock.getKeys(project != null), container);
        this.setDefaultCompilerComplianceValues();
        this.fBlockEnableState = null;
        this.fComplianceFollowsEEControls = new ArrayList();
        this.fComplianceControls = new ArrayList();
        this.fComplianceChildControls = new ArrayList();
        this.fComplianceStatus = new StatusInfo();
        this.fRememberedUserCompliance = new String[]{this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER), this.getValue(PREF_PB_ENUM_AS_IDENTIFIER), this.getValue(PREF_SOURCE_COMPATIBILITY), this.getValue(PREF_CODEGEN_TARGET_PLATFORM), this.getValue(PREF_COMPLIANCE), this.getValue(PREF_CODEGEN_INLINE_JSR_BYTECODE)};
    }

    private static OptionsConfigurationBlock.Key[] getKeys(boolean projectSpecific) {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{PREF_LOCAL_VARIABLE_ATTR, PREF_LINE_NUMBER_ATTR, PREF_SOURCE_FILE_ATTR, PREF_CODEGEN_UNUSED_LOCAL, PREF_CODEGEN_INLINE_JSR_BYTECODE, INTR_DEFAULT_COMPLIANCE, PREF_COMPLIANCE, PREF_SOURCE_COMPATIBILITY, PREF_CODEGEN_TARGET_PLATFORM, PREF_PB_ASSERT_AS_IDENTIFIER, PREF_PB_ENUM_AS_IDENTIFIER};
        if (projectSpecific) {
            OptionsConfigurationBlock.Key[] allKeys = new OptionsConfigurationBlock.Key[keys.length + 1];
            System.arraycopy(keys, 0, allKeys, 0, keys.length);
            allKeys[keys.length] = INTR_COMPLIANCE_FOLLOWS_EE;
            return allKeys;
        }
        return keys;
    }

    @Override
    protected void settingsUpdated() {
        this.setValue(INTR_DEFAULT_COMPLIANCE, this.getCurrentCompliance());
        this.updateComplianceFollowsEE();
        super.settingsUpdated();
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite complianceComposite = this.createComplianceTabContent(parent);
        this.validateSettings(null, null, null);
        return complianceComposite;
    }

    public void enablePreferenceContent(boolean enable) {
        if (this.fControlsComposite != null && !this.fControlsComposite.isDisposed()) {
            if (enable) {
                if (this.fBlockEnableState != null) {
                    this.fBlockEnableState.restore();
                    this.fBlockEnableState = null;
                }
            } else if (this.fBlockEnableState == null) {
                this.fBlockEnableState = ControlEnableState.disable((Control)this.fControlsComposite);
            }
        }
    }

    private Composite createComplianceTabContent(Composite folder) {
        String[] values3456 = new String[]{VERSION_1_3, VERSION_1_4, VERSION_1_5, VERSION_1_6, VERSION_1_7};
        String[] values3456Labels = new String[]{PreferencesMessages.ComplianceConfigurationBlock_version13, PreferencesMessages.ComplianceConfigurationBlock_version14, PreferencesMessages.ComplianceConfigurationBlock_version15, PreferencesMessages.ComplianceConfigurationBlock_version16, PreferencesMessages.ComplianceConfigurationBlock_version17};
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fControlsComposite = new Composite(composite, 0);
        this.fControlsComposite.setFont(composite.getFont());
        this.fControlsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this.fControlsComposite.setLayout((Layout)layout);
        int nColumns = 3;
        layout = new GridLayout();
        layout.numColumns = nColumns;
        Group group = new Group(this.fControlsComposite, 0);
        group.setFont(this.fControlsComposite.getFont());
        group.setText(PreferencesMessages.ComplianceConfigurationBlock_compliance_group_label);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)layout);
        String[] defaultUserValues = new String[]{DEFAULT_CONF, USER_CONF};
        Control[] otherChildren = group.getChildren();
        if (this.fProject != null) {
            String label = PreferencesMessages.ComplianceConfigurationBlock_compliance_follows_EE_label;
            int widthHint = this.fPixelConverter.convertWidthInCharsToPixels(40);
            this.addCheckBoxWithLink((Composite)group, label, INTR_COMPLIANCE_FOLLOWS_EE, defaultUserValues, 0, widthHint, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComplianceConfigurationBlock.this.openBuildPathPropertyPage();
                }
            });
        }
        Control[] allChildren = group.getChildren();
        this.fComplianceFollowsEEControls.addAll(Arrays.asList(allChildren));
        this.fComplianceFollowsEEControls.removeAll(Arrays.asList(otherChildren));
        otherChildren = allChildren;
        String label = PreferencesMessages.ComplianceConfigurationBlock_compiler_compliance_label;
        this.addComboBox((Composite)group, label, PREF_COMPLIANCE, values3456, values3456Labels, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_default_settings_label;
        this.addCheckBox((Composite)group, label, INTR_DEFAULT_COMPLIANCE, defaultUserValues, 0);
        allChildren = group.getChildren();
        this.fComplianceControls.addAll(Arrays.asList(allChildren));
        this.fComplianceControls.removeAll(Arrays.asList(otherChildren));
        otherChildren = allChildren;
        int indent = LayoutUtil.getIndent();
        String[] versions = new String[]{VERSION_CLDC_1_1, VERSION_1_1, VERSION_1_2, VERSION_1_3, VERSION_1_4, VERSION_1_5, VERSION_1_6, VERSION_1_7};
        String[] versionsLabels = new String[]{PreferencesMessages.ComplianceConfigurationBlock_versionCLDC11, PreferencesMessages.ComplianceConfigurationBlock_version11, PreferencesMessages.ComplianceConfigurationBlock_version12, PreferencesMessages.ComplianceConfigurationBlock_version13, PreferencesMessages.ComplianceConfigurationBlock_version14, PreferencesMessages.ComplianceConfigurationBlock_version15, PreferencesMessages.ComplianceConfigurationBlock_version16, PreferencesMessages.ComplianceConfigurationBlock_version17};
        boolean showJsr14 = VERSION_JSR14.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM));
        if (showJsr14) {
            versions = ComplianceConfigurationBlock.append(versions, VERSION_JSR14);
            versionsLabels = ComplianceConfigurationBlock.append(versionsLabels, VERSION_JSR14);
        }
        label = PreferencesMessages.ComplianceConfigurationBlock_codegen_targetplatform_label;
        this.addComboBox((Composite)group, label, PREF_CODEGEN_TARGET_PLATFORM, versions, versionsLabels, indent);
        label = PreferencesMessages.ComplianceConfigurationBlock_source_compatibility_label;
        this.addComboBox((Composite)group, label, PREF_SOURCE_COMPATIBILITY, values3456, values3456Labels, indent);
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.ComplianceConfigurationBlock_error, PreferencesMessages.ComplianceConfigurationBlock_warning, PreferencesMessages.ComplianceConfigurationBlock_ignore};
        label = PreferencesMessages.ComplianceConfigurationBlock_pb_assert_as_identifier_label;
        this.addComboBox((Composite)group, label, PREF_PB_ASSERT_AS_IDENTIFIER, errorWarningIgnore, errorWarningIgnoreLabels, indent);
        label = PreferencesMessages.ComplianceConfigurationBlock_pb_enum_as_identifier_label;
        this.addComboBox((Composite)group, label, PREF_PB_ENUM_AS_IDENTIFIER, errorWarningIgnore, errorWarningIgnoreLabels, indent);
        allChildren = group.getChildren();
        this.fComplianceChildControls.addAll(Arrays.asList(allChildren));
        this.fComplianceChildControls.removeAll(Arrays.asList(otherChildren));
        layout = new GridLayout();
        layout.numColumns = nColumns;
        group = new Group(this.fControlsComposite, 0);
        group.setFont(this.fControlsComposite.getFont());
        group.setText(PreferencesMessages.ComplianceConfigurationBlock_classfiles_group_label);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)layout);
        String[] generateValues = new String[]{GENERATE, DO_NOT_GENERATE};
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        label = PreferencesMessages.ComplianceConfigurationBlock_variable_attr_label;
        this.addCheckBox((Composite)group, label, PREF_LOCAL_VARIABLE_ATTR, generateValues, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_line_number_attr_label;
        this.addCheckBox((Composite)group, label, PREF_LINE_NUMBER_ATTR, generateValues, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_source_file_attr_label;
        this.addCheckBox((Composite)group, label, PREF_SOURCE_FILE_ATTR, generateValues, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_codegen_unused_local_label;
        this.addCheckBox((Composite)group, label, PREF_CODEGEN_UNUSED_LOCAL, new String[]{PRESERVE, OPTIMIZE_OUT}, 0);
        label = PreferencesMessages.ComplianceConfigurationBlock_codegen_inline_jsr_bytecode_label;
        this.addCheckBox((Composite)group, label, PREF_CODEGEN_INLINE_JSR_BYTECODE, enableDisableValues, 0);
        Composite infoComposite = new Composite(this.fControlsComposite, 0);
        infoComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        infoComposite.setLayout((Layout)new GridLayout(2, false));
        this.fJRE50InfoImage = new Label(infoComposite, 0);
        this.fJRE50InfoImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        GridData gd = new GridData(1, 1, false, false);
        this.fJRE50InfoImage.setLayoutData((Object)gd);
        this.fJRE50InfoText = new Link(infoComposite, 64);
        this.fJRE50InfoText.setFont(composite.getFont());
        this.fJRE50InfoText.setText(Messages.format(PreferencesMessages.ComplianceConfigurationBlock_jrecompliance_info_project, new String[]{this.getVersionLabel(VERSION_1_3), this.getVersionLabel(VERSION_1_3)}));
        this.fJRE50InfoText.setVisible(false);
        this.fJRE50InfoText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if ("1".equals(e.text)) {
                    ComplianceConfigurationBlock.this.openJREInstallPreferencePage(false);
                } else if ("2".equals(e.text)) {
                    ComplianceConfigurationBlock.this.openJREInstallPreferencePage(true);
                } else {
                    ComplianceConfigurationBlock.this.openBuildPathPropertyPage();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        gd = new GridData(4, 4, true, true);
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(50);
        this.fJRE50InfoText.setLayoutData((Object)gd);
        this.validateComplianceStatus();
        return sc1;
    }

    private static String[] append(String[] versions, String version) {
        String[] result = new String[versions.length + 1];
        System.arraycopy(versions, 0, result, 0, versions.length);
        result[versions.length] = version;
        return result;
    }

    protected final void openBuildPathPropertyPage() {
        if (this.getPreferenceContainer() != null) {
            HashMap<Object, IClasspathEntry> data = new HashMap<Object, IClasspathEntry>();
            data.put(BuildPathsPropertyPage.DATA_REVEAL_ENTRY, JavaRuntime.getDefaultJREContainerEntry());
            this.getPreferenceContainer().openPage("org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", data);
        }
        this.validateComplianceStatus();
    }

    protected final void openJREInstallPreferencePage(boolean openEE) {
        String pageId;
        String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
        String eeID = "org.eclipse.jdt.debug.ui.jreProfiles";
        String string = pageId = openEE ? eeID : jreID;
        if (this.fProject == null && this.getPreferenceContainer() != null) {
            this.getPreferenceContainer().openPage(pageId, null);
        } else {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)pageId, (String[])new String[]{jreID, eeID}, null).open();
        }
        this.validateComplianceStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            if (INTR_DEFAULT_COMPLIANCE.equals(changedKey)) {
                this.updateComplianceEnableState();
                this.updateComplianceDefaultSettings(true, null);
                this.fComplianceStatus = this.validateCompliance();
            } else if (INTR_COMPLIANCE_FOLLOWS_EE.equals(changedKey)) {
                this.setValue(INTR_DEFAULT_COMPLIANCE, DEFAULT_CONF);
                this.updateComplianceEnableState();
                this.updateComplianceDefaultSettings(true, null);
                this.updateControls();
                this.fComplianceStatus = this.validateCompliance();
                this.validateComplianceStatus();
            } else if (PREF_COMPLIANCE.equals(changedKey)) {
                String oldDefault = this.getValue(INTR_DEFAULT_COMPLIANCE);
                boolean rememberOld = USER_CONF.equals(oldDefault);
                this.updateComplianceDefaultSettings(rememberOld, oldValue);
                this.fComplianceStatus = this.validateCompliance();
                this.validateComplianceStatus();
            } else if (PREF_SOURCE_COMPATIBILITY.equals(changedKey)) {
                this.updateAssertEnumAsIdentifierEnableState();
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_CODEGEN_TARGET_PLATFORM.equals(changedKey)) {
                if (VERSION_CLDC_1_1.equals(newValue) && !oldValue.equals(newValue)) {
                    String compliance = this.getValue(PREF_COMPLIANCE);
                    String source = this.getValue(PREF_SOURCE_COMPATIBILITY);
                    if (!JavaModelUtil.isVersionLessThan(compliance, VERSION_1_5)) {
                        this.setValue(PREF_COMPLIANCE, VERSION_1_4);
                    }
                    if (!VERSION_1_3.equals(source)) {
                        this.setValue(PREF_SOURCE_COMPATIBILITY, VERSION_1_3);
                    }
                }
                this.updateControls();
                this.updateInlineJSREnableState();
                this.updateAssertEnumAsIdentifierEnableState();
                this.fComplianceStatus = this.validateCompliance();
            } else {
                if (!PREF_PB_ENUM_AS_IDENTIFIER.equals(changedKey) && !PREF_PB_ASSERT_AS_IDENTIFIER.equals(changedKey)) return;
                this.fComplianceStatus = this.validateCompliance();
            }
        } else {
            this.updateComplianceFollowsEE();
            this.updateControls();
            this.updateComplianceEnableState();
            this.updateAssertEnumAsIdentifierEnableState();
            this.updateInlineJSREnableState();
            this.fComplianceStatus = this.validateCompliance();
            this.validateComplianceStatus();
        }
        this.fContext.statusChanged(this.fComplianceStatus);
    }

    public void refreshComplianceSettings() {
        if (this.fProject != null) {
            if (this.fOriginalStoredCompliance == null) {
                this.fOriginalStoredCompliance = new String[]{this.getOriginalStoredValue(PREF_PB_ASSERT_AS_IDENTIFIER), this.getOriginalStoredValue(PREF_PB_ENUM_AS_IDENTIFIER), this.getOriginalStoredValue(PREF_SOURCE_COMPATIBILITY), this.getOriginalStoredValue(PREF_CODEGEN_TARGET_PLATFORM), this.getOriginalStoredValue(PREF_COMPLIANCE), this.getOriginalStoredValue(PREF_CODEGEN_INLINE_JSR_BYTECODE)};
            } else {
                Object[] storedCompliance = new String[]{this.getOriginalStoredValue(PREF_PB_ASSERT_AS_IDENTIFIER), this.getOriginalStoredValue(PREF_PB_ENUM_AS_IDENTIFIER), this.getOriginalStoredValue(PREF_SOURCE_COMPATIBILITY), this.getOriginalStoredValue(PREF_CODEGEN_TARGET_PLATFORM), this.getOriginalStoredValue(PREF_COMPLIANCE), this.getOriginalStoredValue(PREF_CODEGEN_INLINE_JSR_BYTECODE)};
                if (!Arrays.equals(this.fOriginalStoredCompliance, storedCompliance)) {
                    this.fOriginalStoredCompliance = storedCompliance;
                    this.setValue(PREF_PB_ASSERT_AS_IDENTIFIER, (String)storedCompliance[0]);
                    this.setValue(PREF_PB_ENUM_AS_IDENTIFIER, (String)storedCompliance[1]);
                    this.setValue(PREF_SOURCE_COMPATIBILITY, (String)storedCompliance[2]);
                    this.setValue(PREF_CODEGEN_TARGET_PLATFORM, (String)storedCompliance[3]);
                    this.setValue(PREF_COMPLIANCE, (String)storedCompliance[4]);
                    this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, (String)storedCompliance[5]);
                }
                this.updateComplianceFollowsEE();
                this.updateControls();
                this.updateComplianceEnableState();
                this.validateComplianceStatus();
            }
        }
    }

    private void validateComplianceStatus() {
        if (this.fJRE50InfoText != null && !this.fJRE50InfoText.isDisposed()) {
            String compilerCompliance;
            boolean isVisible = false;
            String compliance = this.getStoredValue(PREF_COMPLIANCE);
            IVMInstall install = null;
            if (this.fProject != null) {
                try {
                    install = JavaRuntime.getVMInstall((IJavaProject)JavaCore.create((IProject)this.fProject));
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            } else {
                install = JavaRuntime.getDefaultVMInstall();
            }
            if (install instanceof IVMInstall2 && !(compilerCompliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)install, compliance)).equals(compliance)) {
                Object[] args = new String[]{this.getVersionLabel(compliance), this.getVersionLabel(compilerCompliance)};
                if (this.fProject == null) {
                    this.fJRE50InfoText.setText(Messages.format(PreferencesMessages.ComplianceConfigurationBlock_jrecompliance_info, args));
                } else {
                    this.fJRE50InfoText.setText(Messages.format(PreferencesMessages.ComplianceConfigurationBlock_jrecompliance_info_project, args));
                }
                isVisible = true;
            }
            this.fJRE50InfoText.setVisible(isVisible);
            this.fJRE50InfoImage.setImage(isVisible ? JFaceResources.getImage((String)"dialog_messasge_warning_image") : null);
            this.fJRE50InfoImage.getParent().layout();
        }
    }

    private String getVersionLabel(String version) {
        return BasicElementLabels.getVersionName(version);
    }

    private IStatus validateCompliance() {
        StatusInfo status = new StatusInfo();
        String compliance = this.getValue(PREF_COMPLIANCE);
        String source = this.getValue(PREF_SOURCE_COMPATIBILITY);
        String target = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
        if (VERSION_JSR14.equals(target)) {
            target = source;
        }
        if (JavaModelUtil.isVersionLessThan(compliance, source)) {
            status.setError(PreferencesMessages.ComplianceConfigurationBlock_src_greater_compliance);
            return status;
        }
        if (JavaModelUtil.isVersionLessThan(compliance, target)) {
            status.setError(PreferencesMessages.ComplianceConfigurationBlock_classfile_greater_compliance);
            return status;
        }
        if (!(!VERSION_CLDC_1_1.equals(target) || VERSION_1_3.equals(source) && JavaModelUtil.isVersionLessThan(compliance, VERSION_1_5))) {
            status.setError(PreferencesMessages.ComplianceConfigurationBlock_cldc11_requires_source13_compliance_se14);
            return status;
        }
        if (!VERSION_1_3.equals(source) && JavaModelUtil.isVersionLessThan(target, source)) {
            status.setError(PreferencesMessages.ComplianceConfigurationBlock_classfile_greater_source);
            return status;
        }
        return status;
    }

    @Override
    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
        this.validateComplianceStatus();
    }

    private void updateComplianceFollowsEE() {
        if (this.fProject != null) {
            String label;
            String complianceFollowsEE = DISABLED;
            IExecutionEnvironment ee = this.getEE();
            if (ee != null) {
                complianceFollowsEE = this.getComplianceFollowsEE(ee);
                label = Messages.format(PreferencesMessages.ComplianceConfigurationBlock_compliance_follows_EE_with_EE_label, ee.getId());
            } else {
                label = PreferencesMessages.ComplianceConfigurationBlock_compliance_follows_EE_label;
            }
            Link checkBoxLink = this.getCheckBoxLink(INTR_COMPLIANCE_FOLLOWS_EE);
            if (checkBoxLink != null) {
                checkBoxLink.setText(label);
            }
            this.setValue(INTR_COMPLIANCE_FOLLOWS_EE, complianceFollowsEE);
        }
    }

    private void updateComplianceEnableState() {
        boolean enableComplianceControls = true;
        if (this.fProject != null) {
            boolean hasProjectSpecificOptions = this.hasProjectSpecificOptions(this.fProject);
            String complianceFollowsEE = this.getValue(INTR_COMPLIANCE_FOLLOWS_EE);
            this.updateCheckBox(this.getCheckBox(INTR_COMPLIANCE_FOLLOWS_EE));
            boolean enableComplianceFollowsEE = hasProjectSpecificOptions && !DISABLED.equals(complianceFollowsEE);
            this.updateControlsEnableState(this.fComplianceFollowsEEControls, enableComplianceFollowsEE);
            enableComplianceControls = hasProjectSpecificOptions && !DEFAULT_CONF.equals(complianceFollowsEE);
            this.updateControlsEnableState(this.fComplianceControls, enableComplianceControls);
        }
        boolean enableComplianceChildren = enableComplianceControls && this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF);
        this.updateControlsEnableState(this.fComplianceChildControls, enableComplianceChildren);
    }

    private void updateControlsEnableState(List<Control> controls, boolean enable) {
        int i = controls.size() - 1;
        while (i >= 0) {
            Control curr = controls.get(i);
            if (curr instanceof Composite) {
                this.updateControlsEnableState(Arrays.asList(((Composite)curr).getChildren()), enable);
            }
            curr.setEnabled(enable);
            --i;
        }
    }

    private void updateAssertEnumAsIdentifierEnableState() {
        if (this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF)) {
            String compatibility = this.getValue(PREF_SOURCE_COMPATIBILITY);
            boolean isLessThan14 = VERSION_1_3.equals(compatibility);
            this.updateRememberedComplianceOption(PREF_PB_ASSERT_AS_IDENTIFIER, 0, isLessThan14);
            boolean isLessThan15 = isLessThan14 || VERSION_1_4.equals(compatibility);
            this.updateRememberedComplianceOption(PREF_PB_ENUM_AS_IDENTIFIER, 1, isLessThan15);
        }
    }

    private void updateRememberedComplianceOption(OptionsConfigurationBlock.Key prefKey, int idx, boolean enabled) {
        Combo combo = this.getComboBox(prefKey);
        combo.setEnabled(enabled);
        if (!enabled) {
            String val = this.getValue(prefKey);
            if (!ERROR.equals(val)) {
                this.setValue(prefKey, ERROR);
                this.updateCombo(combo);
                this.fRememberedUserCompliance[idx] = val;
            }
        } else {
            String val = this.fRememberedUserCompliance[idx];
            if (!ERROR.equals(val)) {
                this.setValue(prefKey, val);
                this.updateCombo(combo);
            }
        }
    }

    private void updateInlineJSREnableState() {
        String target = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
        boolean enabled = JavaModelUtil.isVersionLessThan(target, VERSION_1_5);
        Button checkBox = this.getCheckBox(PREF_CODEGEN_INLINE_JSR_BYTECODE);
        checkBox.setEnabled(enabled);
        if (!enabled) {
            String val;
            this.fRememberedUserCompliance[5] = val = this.getValue(PREF_CODEGEN_INLINE_JSR_BYTECODE);
            if (!ENABLED.equals(val)) {
                this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, ENABLED);
                this.updateCheckBox(checkBox);
            }
        } else {
            String val = this.fRememberedUserCompliance[5];
            if (!ENABLED.equals(val)) {
                this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, val);
                this.updateCheckBox(checkBox);
            }
        }
    }

    private void updateComplianceDefaultSettings(boolean rememberOld, String oldComplianceLevel) {
        String target;
        String source;
        String enumAsId;
        String assertAsId;
        boolean isDefault = this.checkValue(INTR_DEFAULT_COMPLIANCE, DEFAULT_CONF);
        boolean isFollowEE = this.checkValue(INTR_COMPLIANCE_FOLLOWS_EE, DEFAULT_CONF);
        String complianceLevel = this.getValue(PREF_COMPLIANCE);
        if (isDefault || isFollowEE) {
            if (rememberOld) {
                if (oldComplianceLevel == null) {
                    oldComplianceLevel = complianceLevel;
                }
                this.fRememberedUserCompliance[0] = this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER);
                this.fRememberedUserCompliance[1] = this.getValue(PREF_PB_ENUM_AS_IDENTIFIER);
                this.fRememberedUserCompliance[2] = this.getValue(PREF_SOURCE_COMPATIBILITY);
                this.fRememberedUserCompliance[3] = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
                this.fRememberedUserCompliance[4] = oldComplianceLevel;
            }
            if (isFollowEE) {
                IExecutionEnvironment ee = this.getEE();
                Map<String, String> eeOptions = BuildPathSupport.getEEOptions(ee);
                if (eeOptions == null) {
                    return;
                }
                assertAsId = eeOptions.get(PREF_PB_ASSERT_AS_IDENTIFIER.getName());
                enumAsId = eeOptions.get(PREF_PB_ENUM_AS_IDENTIFIER.getName());
                source = eeOptions.get(PREF_SOURCE_COMPATIBILITY.getName());
                target = eeOptions.get(PREF_CODEGEN_TARGET_PLATFORM.getName());
                this.setValue(PREF_COMPLIANCE, eeOptions.get(PREF_COMPLIANCE.getName()));
                String inlineJSR = eeOptions.get(PREF_CODEGEN_INLINE_JSR_BYTECODE.getName());
                if (inlineJSR != null) {
                    this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, inlineJSR);
                }
            } else if (VERSION_1_4.equals(complianceLevel)) {
                assertAsId = WARNING;
                enumAsId = WARNING;
                source = VERSION_1_3;
                target = VERSION_1_2;
            } else if (VERSION_1_5.equals(complianceLevel)) {
                assertAsId = ERROR;
                enumAsId = ERROR;
                source = VERSION_1_5;
                target = VERSION_1_5;
            } else if (VERSION_1_6.equals(complianceLevel)) {
                assertAsId = ERROR;
                enumAsId = ERROR;
                source = VERSION_1_6;
                target = VERSION_1_6;
            } else if (VERSION_1_7.equals(complianceLevel)) {
                assertAsId = ERROR;
                enumAsId = ERROR;
                source = VERSION_1_7;
                target = VERSION_1_7;
            } else {
                assertAsId = IGNORE;
                enumAsId = IGNORE;
                source = VERSION_1_3;
                target = VERSION_1_1;
            }
        } else if (rememberOld && complianceLevel.equals(this.fRememberedUserCompliance[4])) {
            assertAsId = this.fRememberedUserCompliance[0];
            enumAsId = this.fRememberedUserCompliance[1];
            source = this.fRememberedUserCompliance[2];
            target = this.fRememberedUserCompliance[3];
        } else {
            this.updateInlineJSREnableState();
            this.updateAssertEnumAsIdentifierEnableState();
            return;
        }
        this.setValue(PREF_PB_ASSERT_AS_IDENTIFIER, assertAsId);
        this.setValue(PREF_PB_ENUM_AS_IDENTIFIER, enumAsId);
        this.setValue(PREF_SOURCE_COMPATIBILITY, source);
        this.setValue(PREF_CODEGEN_TARGET_PLATFORM, target);
        this.updateControls();
        this.updateInlineJSREnableState();
        this.updateAssertEnumAsIdentifierEnableState();
    }

    private String getCurrentCompliance() {
        String complianceLevel = this.getValue(PREF_COMPLIANCE);
        if (VERSION_1_3.equals(complianceLevel) && IGNORE.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && IGNORE.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_3.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_1.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_4.equals(complianceLevel) && WARNING.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && WARNING.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_3.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_2.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_5.equals(complianceLevel) && ERROR.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && ERROR.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_5.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_5.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_6.equals(complianceLevel) && ERROR.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && ERROR.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_6.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_6.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_7.equals(complianceLevel) && ERROR.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && ERROR.equals(this.getValue(PREF_PB_ENUM_AS_IDENTIFIER)) && VERSION_1_7.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_7.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM))) {
            return DEFAULT_CONF;
        }
        return USER_CONF;
    }

    private IExecutionEnvironment getEE() {
        if (this.fProject == null) {
            return null;
        }
        try {
            IClasspathEntry[] entries = JavaCore.create((IProject)this.fProject).getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                String eeId;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 5 && (eeId = JavaRuntime.getExecutionEnvironmentId((IPath)entry.getPath())) != null) {
                    return JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(eeId);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private String getComplianceFollowsEE(IExecutionEnvironment ee) {
        Map<String, String> options = BuildPathSupport.getEEOptions(ee);
        if (options == null) {
            return DISABLED;
        }
        return this.checkDefaults(PREFS_COMPLIANCE, options);
    }

    private String checkDefaults(OptionsConfigurationBlock.Key[] keys, Map<String, String> options) {
        int i = 0;
        while (i < keys.length) {
            OptionsConfigurationBlock.Key key = keys[i];
            String option = options.get(key.getName());
            if (!this.checkValue(key, option)) {
                return USER_CONF;
            }
            ++i;
        }
        return DEFAULT_CONF;
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.ComplianceConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PreferencesMessages.ComplianceConfigurationBlock_needsfullbuild_message : PreferencesMessages.ComplianceConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    private void setDefaultCompilerComplianceValues() {
        IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        if (defaultVMInstall instanceof IVMInstall2 && ComplianceConfigurationBlock.isOriginalDefaultCompliance()) {
            String complianceLevel = JavaModelUtil.getCompilerCompliance((IVMInstall2)defaultVMInstall, VERSION_1_4);
            HashMap<String, String> complianceOptions = new HashMap<String, String>();
            JavaModelUtil.setComplianceOptions(complianceOptions, complianceLevel);
            this.setDefaultValue(PREF_COMPLIANCE, (String)complianceOptions.get(PREF_COMPLIANCE.getName()));
            this.setDefaultValue(PREF_PB_ASSERT_AS_IDENTIFIER, (String)complianceOptions.get(PREF_PB_ASSERT_AS_IDENTIFIER.getName()));
            this.setDefaultValue(PREF_PB_ENUM_AS_IDENTIFIER, (String)complianceOptions.get(PREF_PB_ENUM_AS_IDENTIFIER.getName()));
            this.setDefaultValue(PREF_SOURCE_COMPATIBILITY, (String)complianceOptions.get(PREF_SOURCE_COMPATIBILITY.getName()));
            this.setDefaultValue(PREF_CODEGEN_TARGET_PLATFORM, (String)complianceOptions.get(PREF_CODEGEN_TARGET_PLATFORM.getName()));
        }
    }

    private static final boolean isOriginalDefaultCompliance() {
        Hashtable options = JavaCore.getDefaultOptions();
        IEclipsePreferences bundleDefaults = BundleDefaultsScope.INSTANCE.getNode("org.eclipse.jdt.core");
        return ComplianceConfigurationBlock.equals("org.eclipse.jdt.core.compiler.compliance", (Preferences)bundleDefaults, options) && ComplianceConfigurationBlock.equals("org.eclipse.jdt.core.compiler.source", (Preferences)bundleDefaults, options) && ComplianceConfigurationBlock.equals("org.eclipse.jdt.core.compiler.codegen.targetPlatform", (Preferences)bundleDefaults, options) && ComplianceConfigurationBlock.equals("org.eclipse.jdt.core.compiler.problem.assertIdentifier", (Preferences)bundleDefaults, options) && ComplianceConfigurationBlock.equals("org.eclipse.jdt.core.compiler.problem.enumIdentifier", (Preferences)bundleDefaults, options);
    }

    private static boolean equals(String key, Preferences preferences, Map<String, String> map) {
        String dummy = new String();
        String defaultValue = preferences.get(key, dummy);
        return defaultValue != null && defaultValue != dummy ? map.containsKey(key) && ComplianceConfigurationBlock.equals(defaultValue, map.get(key)) : !map.containsKey(key);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

